@extends('mosque::layouts.app')
@section('title', __('mosque::mosque.mosque') . ' | ' . __('mosque::mosque.menu_members_reports'))

@section('content')
<section class="content-header">
    <h1 class="tw-text-xl md:tw-text-3xl tw-font-bold tw-text-black">@lang('mosque::mosque.menu_members_reports')</h1>
</section>

<section class="content">
    @component('components.widget', ['class' => 'box-primary'])
        <ul class="nav nav-tabs" role="tablist">
            <li role="presentation" class="active">
                <a href="#mmr_status" aria-controls="mmr_status" role="tab" data-toggle="tab">Status Summary</a>
            </li>
            <li role="presentation">
                <a href="#mmr_inactive" aria-controls="mmr_inactive" role="tab" data-toggle="tab">Inactive Members</a>
            </li>
        </ul>

        <div class="tab-content" style="margin-top:15px;">
            <div role="tabpanel" class="tab-pane active" id="mmr_status">
                <div class="table-responsive">
                    <table class="table table-bordered table-striped" id="mosque_member_status_report_table" style="width:100%;">
                        <thead>
                            <tr>
                                <th>@lang('sale.status')</th>
                                <th>Members</th>
                                <th>Last Added</th>
                            </tr>
                        </thead>
                    </table>
                </div>
            </div>

            <div role="tabpanel" class="tab-pane" id="mmr_inactive">
                <div class="row">
                    <div class="col-sm-3">
                        <div class="form-group">
                            <label>@lang('lang_v1.start_date')</label>
                            <input type="date" id="mmr_start_date" class="form-control">
                        </div>
                    </div>
                    <div class="col-sm-3">
                        <div class="form-group">
                            <label>@lang('lang_v1.end_date')</label>
                            <input type="date" id="mmr_end_date" class="form-control">
                        </div>
                    </div>
                </div>

                <div class="table-responsive">
                    <table class="table table-bordered table-striped" id="mosque_member_inactive_report_table" style="width:100%;">
                        <thead>
                            <tr>
                                <th>@lang('user.name')</th>
                                <th>@lang('contact.mobile')</th>
                                <th>@lang('business.email')</th>
                                <th>Added</th>
                                <th>@lang('messages.action')</th>
                            </tr>
                        </thead>
                    </table>
                </div>

                <div class="modal fade mosque_member_modal" tabindex="-1" role="dialog" aria-labelledby="gridSystemModalLabel"></div>
            </div>
        </div>
    @endcomponent
</section>
@endsection

@section('javascript')
<script type="text/javascript">
    $(document).ready(function () {
        var statusTable = $('#mosque_member_status_report_table').DataTable({
            processing: true,
            serverSide: true,
            ajax: {
                url: '{{ route("mosque.members.reports.status") }}'
            },
            dom: 'lBfrtip',
            buttons: [
                { extend: 'csv', text: '<i class="fas fa-file-csv"></i>', className: 'btn btn-success' },
                { extend: 'excel', text: '<i class="fas fa-file-excel"></i>', className: 'btn btn-info' },
                { extend: 'pdf', text: '<i class="fas fa-file-pdf"></i>', className: 'btn btn-danger' },
                { extend: 'print', text: '<i class="fas fa-print"></i>', className: 'btn btn-warning' },
                { extend: 'colvis', text: '<i class="fas fa-eye"></i>', className: 'btn btn-primary' }
            ],
            columns: [
                { data: 'status', name: 'status' },
                { data: 'members_count', name: 'members_count', searchable: false },
                { data: 'last_added_at', name: 'last_added_at', searchable: false },
            ],
        });

        statusTable.on('init.dt', function () {
            $('#mosque_member_status_report_table_wrapper .dt-buttons').addClass('justify-content-center flex-wrap mb-2');
        });

        var inactiveTable = $('#mosque_member_inactive_report_table').DataTable({
            processing: true,
            serverSide: true,
            ajax: {
                url: '{{ route("mosque.members.reports.inactive") }}',
                data: function (d) {
                    d.start_date = $('#mmr_start_date').val();
                    d.end_date = $('#mmr_end_date').val();
                }
            },
            dom: 'lBfrtip',
            buttons: [
                { extend: 'csv', text: '<i class="fas fa-file-csv"></i>', className: 'btn btn-success' },
                { extend: 'excel', text: '<i class="fas fa-file-excel"></i>', className: 'btn btn-info' },
                { extend: 'pdf', text: '<i class="fas fa-file-pdf"></i>', className: 'btn btn-danger' },
                { extend: 'print', text: '<i class="fas fa-print"></i>', className: 'btn btn-warning' },
                { extend: 'colvis', text: '<i class="fas fa-eye"></i>', className: 'btn btn-primary' }
            ],
            columns: [
                { data: 'name', name: 'name' },
                { data: 'phone', name: 'phone' },
                { data: 'email', name: 'email' },
                { data: 'created_at', name: 'created_at', searchable: false },
                { data: 'action', name: 'action', orderable: false, searchable: false }
            ],
        });

        inactiveTable.on('init.dt', function () {
            $('#mosque_member_inactive_report_table_wrapper .dt-buttons').addClass('justify-content-center flex-wrap mb-2');
        });

        $(document).on('change', '#mmr_start_date, #mmr_end_date', function () {
            inactiveTable.ajax.reload();
        });
    });
</script>
@endsection
