@extends('mosque::layouts.app')
@section('title', __('mosque::mosque.mosque') . ' | Cancel History')

@section('content')
<section class="content-header">
    <h1 class="tw-text-xl md:tw-text-3xl tw-font-bold tw-text-black">Cancel History</h1>
</section>

<section class="content mosque-fees-page">
    <style>
        .mosque-fees-page label,
        .mosque-fees-page .form-group label,
        .mosque-fees-page .help-block,
        .mosque_fee_generate_modal label,
        .mosque_fee_generate_modal .help-block,
        .mosque_payment_modal label,
        .mosque_payment_modal .help-block,
        .mosque_fee_generate_modal .nav > li > a,
        .mosque_fee_generate_modal .well,
        .mosque_fee_generate_modal .table,
        .mosque_fee_generate_modal .alert {
            color: #111 !important;
        }
        .mosque-fees-page .table > thead > tr > th,
        .mosque-fees-page .table > tbody > tr > td,
        .mosque-fees-page .dataTables_wrapper,
        .mosque-fees-page .dataTables_wrapper label,
        .mosque-fees-page .dataTables_info,
        .mosque-fees-page .dataTables_paginate {
            color: #111 !important;
        }
        .mosque-fees-page .select2-container--default .select2-selection--single .select2-selection__rendered,
        .mosque-fees-page .select2-container--default .select2-selection--multiple .select2-selection__rendered,
        .mosque_fee_generate_modal .select2-container--default .select2-selection--single .select2-selection__rendered,
        .mosque_fee_generate_modal .select2-container--default .select2-selection--multiple .select2-selection__rendered,
        .mosque_payment_modal .select2-container--default .select2-selection--single .select2-selection__rendered,
        .mosque_payment_modal .select2-container--default .select2-selection--multiple .select2-selection__rendered {
            color: #111 !important;
        }
        .mosque-fees-page .select2-container--default .select2-selection--single .select2-selection__placeholder,
        .mosque_fee_generate_modal .select2-container--default .select2-selection--single .select2-selection__placeholder,
        .mosque_payment_modal .select2-container--default .select2-selection--single .select2-selection__placeholder {
            color: #666 !important;
        }
        .mosque-fees-page .mfee-totals { margin-top: 10px; }
    </style>

    @component('components.widget', ['class' => 'box-primary'])
        <div class="row">
            <div class="col-sm-3">
                <div class="form-group">
                    {!! Form::label('member_id', 'Member:') !!}
                    {!! Form::select('member_id', $members ?? [], null, ['class' => 'form-control', 'id' => 'mfee_member_id', 'placeholder' => __('lang_v1.all'), 'style' => 'width:100%;']) !!}
                </div>
            </div>
            <div class="col-sm-3">
                <div class="form-group">
                    <label>Family Code</label>
                    <select id="mfee_family_code" class="form-control" style="width:100%;"></select>
                </div>
            </div>
            <div class="col-sm-2">
                <div class="form-group">
                    <label>Plan</label>
                    {!! Form::select('plan_id', $plans ?? [], null, ['class' => 'form-control', 'id' => 'mfee_plan_id', 'placeholder' => __('lang_v1.all'), 'style' => 'width:100%;']) !!}
                </div>
            </div>
            <div class="col-sm-2">
                <div class="form-group">
                    <label>Billing Cycle</label>
                    <select id="mfee_cycle" class="form-control">
                        <option value="">All</option>
                        <option value="monthly">Monthly</option>
                        <option value="yearly">Yearly</option>
                    </select>
                </div>
            </div>
            <div class="col-sm-2">
                <div class="form-group">
                    <label>Month</label>
                    <input type="text" id="mfee_month" class="form-control mosque_monthpicker" placeholder="YYYY-MM" autocomplete="off">
                </div>
            </div>
            <div class="col-sm-3">
                <div class="form-group">
                    <label>Date range</label>
                    <input type="text" id="mfee_date_range" class="form-control" placeholder="YYYY-MM-DD - YYYY-MM-DD" autocomplete="off">
                    <input type="hidden" id="mfee_date_start" value="">
                    <input type="hidden" id="mfee_date_end" value="">
                </div>
            </div>
            <div class="col-sm-3">
                <div class="form-group">
                    <label>Bill / Receipt No</label>
                    <input type="text" id="mfee_receipt_no" class="form-control" placeholder="MF-..." autocomplete="off">
                </div>
            </div>
            <div class="col-sm-12 text-right">
                <a href="{{ route('mosque.subscriptions.fees') }}" class="btn btn-default"><i class="fa fa-arrow-left"></i> Back to Fees</a>
                <a href="{{ route('mosque.subscriptions.payments') }}" class="btn btn-default">Payments</a>
                <a href="{{ route('mosque.subscriptions.plans') }}" class="btn btn-default">Plans</a>
            </div>
        </div>
    @endcomponent

    @component('components.widget', ['class' => 'box-primary'])
        <div class="table-responsive">
            <table class="table table-bordered table-striped" id="mosque_cancel_fees_table" style="width:100%;">
                <thead>
                    <tr>
                        <th>Member</th>
                        <th>Plan</th>
                        <th>Period</th>
                        <th>Receipt No</th>
                        <th>Due</th>
                        <th>Paid</th>
                        <th>Cancelled At</th>
                        <th>Reason</th>
                        <th class="no-export">@lang('messages.action')</th>
                    </tr>
                </thead>
            </table>
        </div>
        <div class="mfee-totals well well-sm">
            <strong>Total Due:</strong> <span id="mfee_total_due" class="display_currency" data-currency_symbol="true" data-orig-value="0">0</span>
            &nbsp; | &nbsp;
            <strong>Total Paid:</strong> <span id="mfee_total_paid" class="display_currency" data-currency_symbol="true" data-orig-value="0">0</span>
            &nbsp; | &nbsp;
            <strong>Total Outstanding:</strong> <span id="mfee_total_outstanding" class="display_currency" data-currency_symbol="true" data-orig-value="0">0</span>
        </div>
    @endcomponent

    <div class="modal fade" id="mosque_fee_confirm_delete_modal" tabindex="-1" role="dialog" aria-labelledby="mosque_fee_confirm_delete_modal_label">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                    <h4 class="modal-title" id="mosque_fee_confirm_delete_modal_label">@lang('messages.delete')</h4>
                </div>
                <div class="modal-body">
                    <p class="text-danger" style="margin-bottom:6px;">Permanent delete: removes fee, payments, and all related Finance entries. This will not remain in any reports or dashboard (only audit logs remain).</p>
                    <p>Type <strong>Confirm</strong> (case-sensitive) to permanently delete this cancelled fee.</p>
                    <div class="form-group">
                        <input type="text" class="form-control" id="mosque_fee_confirm_delete_input" placeholder="Confirm" autocomplete="off">
                        <input type="hidden" id="mosque_fee_confirm_delete_url" value="">
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-danger" id="mosque_fee_confirm_delete_btn">@lang('messages.delete')</button>
                    <button type="button" class="btn btn-default" data-dismiss="modal">@lang('messages.close')</button>
                </div>
            </div>
        </div>
    </div>
</section>
@endsection

@section('javascript')
<script type="text/javascript">
    $(document).ready(function () {
        var SOMETHING_WENT_WRONG = @json(__('messages.something_went_wrong'));

        function hasDatepicker() { return typeof $.fn.datepicker === 'function'; }
        function hasDateRangePicker() { return typeof $.fn.daterangepicker === 'function'; }
        function initMonthpicker($el) {
            if (!hasDatepicker() || !$el || !$el.length) { return; }
            $el.datepicker({ autoclose: true, format: 'yyyy-mm', minViewMode: 1, startView: 1 });
        }

        initMonthpicker($('.mosque_monthpicker'));

        function normalizeDateRangeInput() {
            var raw = ($('#mfee_date_range').val() || '').trim();
            if (raw === '') {
                $('#mfee_date_start').val('');
                $('#mfee_date_end').val('');
                return;
            }
            var parts = raw.split(' - ');
            if (parts.length === 2) {
                $('#mfee_date_start').val(parts[0].trim());
                $('#mfee_date_end').val(parts[1].trim());
            }
        }

        if (hasDateRangePicker()) {
            try {
                $('#mfee_date_range').daterangepicker({
                    autoUpdateInput: false,
                    locale: { format: 'YYYY-MM-DD', cancelLabel: '@lang("messages.clear")' }
                });
                $('#mfee_date_range').on('apply.daterangepicker', function (ev, picker) {
                    var v = picker.startDate.format('YYYY-MM-DD') + ' - ' + picker.endDate.format('YYYY-MM-DD');
                    $(this).val(v);
                    normalizeDateRangeInput();
                    table && table.ajax && table.ajax.reload();
                });
                $('#mfee_date_range').on('cancel.daterangepicker', function () {
                    $(this).val('');
                    normalizeDateRangeInput();
                    table && table.ajax && table.ajax.reload();
                });
            } catch (e) {
                $('#mfee_date_range').on('change', function () { normalizeDateRangeInput(); });
            }
        } else {
            $('#mfee_date_range').on('change', function () { normalizeDateRangeInput(); });
        }

        $('#mfee_family_code').select2({
            width: '100%',
            tags: true,
            allowClear: true,
            placeholder: 'Search or type family code',
            minimumInputLength: 0,
            minimumResultsForSearch: 0,
            ajax: {
                url: '{{ route("mosque.subscriptions.fees.family_codes.search") }}',
                dataType: 'json',
                delay: 250,
                data: function (params) { return { q: params.term || '' }; },
                processResults: function (data) { return { results: (data && data.results) ? data.results : [] }; },
                cache: true
            }
        });

        if ($('#mfee_member_id').hasClass('select2-hidden-accessible')) { try { $('#mfee_member_id').select2('destroy'); } catch (e) {} }
        $('#mfee_member_id').select2({
            width: '100%',
            allowClear: true,
            placeholder: 'Search member',
            minimumInputLength: 0,
            minimumResultsForSearch: 0,
            ajax: {
                url: '{{ route("mosque.subscriptions.fees.members.search") }}',
                dataType: 'json',
                delay: 250,
                data: function (params) { return { q: params.term || '', family_code: $('#mfee_family_code').val() || '' }; },
                processResults: function (data) { return { results: (data && data.results) ? data.results : [] }; },
                cache: true
            }
        });

        $('#mfee_plan_id').select2({ width: '100%', allowClear: true, placeholder: 'All plans', minimumResultsForSearch: 0 });

        var table = $('#mosque_cancel_fees_table').DataTable({
            processing: true,
            serverSide: true,
            ajax: {
                url: '{{ route("mosque.subscriptions.fees.data") }}',
                data: function (d) {
                    d.member_id = $('#mfee_member_id').val();
                    d.family_code = $('#mfee_family_code').val();
                    d.plan_id = $('#mfee_plan_id').val();
                    d.cycle = $('#mfee_cycle').val();
                    d.status = 'cancelled';
                    d.month = ($('#mfee_month').val() || '').trim();
                    d.date_start = ($('#mfee_date_start').val() || '').trim();
                    d.date_end = ($('#mfee_date_end').val() || '').trim();
                    d.receipt_no = ($('#mfee_receipt_no').val() || '').trim();
                }
            },
            dom: 'lBfrtip',
            buttons: [
                { extend: 'csv', text: '<i class="fas fa-file-csv"></i>', className: 'btn btn-success', exportOptions: { columns: ':visible:not(.no-export)' } },
                { extend: 'excel', text: '<i class="fas fa-file-excel"></i>', className: 'btn btn-info', exportOptions: { columns: ':visible:not(.no-export)' } },
                { extend: 'pdf', text: '<i class="fas fa-file-pdf"></i>', className: 'btn btn-danger', exportOptions: { columns: ':visible:not(.no-export)' } },
                { extend: 'print', text: '<i class="fas fa-print"></i>', className: 'btn btn-warning', exportOptions: { columns: ':visible:not(.no-export)' } },
                { extend: 'colvis', text: '<i class="fas fa-eye"></i>', className: 'btn btn-primary' }
            ],
            columns: [
                { data: 'member_name', name: 'member_name' },
                { data: 'plan_name', name: 'plan_name' },
                { data: 'period_ym', name: 'period_ym' },
                { data: 'receipt_no', name: 'receipt_no', orderable: false, searchable: false },
                { data: 'due_amount', name: 'due_amount', orderable: false, searchable: false },
                { data: 'paid_amount', name: 'paid_amount', orderable: false, searchable: false },
                { data: 'cancelled_at', name: 'cancelled_at', orderable: false, searchable: false },
                { data: 'cancel_reason', name: 'cancel_reason', orderable: false, searchable: false },
                { data: 'action', name: 'action', orderable: false, searchable: false },
            ],
            drawCallback: function () {
                __currency_convert_recursively($('#mosque_cancel_fees_table'));
                try { $('[data-toggle="tooltip"]').tooltip({ container: 'body' }); } catch (e) {}
            }
        });

        $('#mosque_cancel_fees_table').on('xhr.dt', function (e, settings, json) {
            try {
                if (json && json.totals) {
                    var due = parseFloat(json.totals.total_due || 0) || 0;
                    var paid = parseFloat(json.totals.total_paid || 0) || 0;
                    var outstanding = parseFloat(json.totals.total_outstanding || (due - paid)) || 0;
                    $('#mfee_total_due').attr('data-orig-value', due).text(due);
                    $('#mfee_total_paid').attr('data-orig-value', paid).text(paid);
                    $('#mfee_total_outstanding').attr('data-orig-value', outstanding).text(outstanding);
                    __currency_convert_recursively($('.mfee-totals'));
                }
            } catch (err) {}
        });

        $(document).on('change', '#mfee_member_id, #mfee_family_code, #mfee_plan_id, #mfee_cycle, #mfee_month', function () {
            normalizeDateRangeInput();
            table.ajax.reload();
        });
        $(document).on('keyup', '#mfee_receipt_no', function () {
            clearTimeout(window.__mfeeReceiptT);
            window.__mfeeReceiptT = setTimeout(function () { table.ajax.reload(); }, 350);
        });
        $(document).on('blur', '#mfee_date_range', function () {
            normalizeDateRangeInput();
            table.ajax.reload();
        });

        $(document).on('click', '.delete_mosque_fee', function (e) {
            e.preventDefault();
            var href = $(this).data('href');
            $('#mosque_fee_confirm_delete_url').val(href);
            $('#mosque_fee_confirm_delete_input').val('');
            $('#mosque_fee_confirm_delete_modal').modal('show');
        });

        $('#mosque_fee_confirm_delete_btn').on('click', function () {
            var txt = ($('#mosque_fee_confirm_delete_input').val() || '').trim();
            if (txt !== 'Confirm' && txt !== 'CONFIRM') {
                toastr.error('Please type Confirm (case-sensitive).');
                return;
            }
            var href = $('#mosque_fee_confirm_delete_url').val();
            $.ajax({
                method: 'DELETE',
                url: href,
                data: { _token: '{{ csrf_token() }}' },
                success: function (result) {
                    if (result.ok || result.success) {
                        $('#mosque_fee_confirm_delete_modal').modal('hide');
                        toastr.success(result.toast || result.msg || '@lang("lang_v1.success")');
                        table.ajax.reload();
                    } else {
                        toastr.error(result.message || result.toast || result.msg || '@lang("messages.something_went_wrong")');
                    }
                },
                error: function () {
                    toastr.error('@lang("messages.something_went_wrong")');
                }
            });
        });

        $(document).on('click', '.mosque_fee_reactivate', function (e) {
            e.preventDefault();
            var href = $(this).data('href');
            $.ajax({
                method: 'POST',
                url: href,
                data: { _token: '{{ csrf_token() }}' },
                success: function (result) {
                    if (result.ok || result.success) {
                        toastr.success(result.toast || result.msg || '@lang("lang_v1.success")');
                        table.ajax.reload();
                    } else {
                        toastr.error(result.toast || result.msg || '@lang("messages.something_went_wrong")');
                    }
                },
                error: function () {
                    toastr.error('@lang("messages.something_went_wrong")');
                }
            });
        });
    });
</script>
@endsection
