<div class="modal-dialog" role="document">
    <div class="modal-content">
        {!! Form::open(['url' => route('mosque.subscriptions.fees.generate'), 'method' => 'post', 'id' => 'mosque_fee_generate_form']) !!}
        <div class="modal-header">
            <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
            <h4 class="modal-title">Bill Generation</h4>
        </div>
        <div class="modal-body">
            <div id="mfee_billgen_root">
                <div class="alert alert-info" style="margin-bottom:10px;">
                    <strong>Bill Generation</strong> — pick Billing Cycle and Month/Year, then Preview and Generate.
                </div>

                <input type="hidden" name="mode" value="bulk">
                <input type="hidden" name="plan_source" value="assigned">
                <input type="hidden" name="force_cycle" value="1">
                <input type="hidden" name="start_period" id="mfee_bg_start_period" value="">
                <input type="hidden" name="end_period" id="mfee_bg_end_period" value="">
                <div id="mfee_bg_excludes"></div>

                <div class="row">
                    <div class="col-sm-6">
                        <div class="form-group">
                            <label>Billing Cycle</label>
                            <select class="form-control" name="cycle" id="mfee_bg_cycle">
                                <option value="monthly" selected>Monthly</option>
                                <option value="yearly">Yearly</option>
                            </select>
                        </div>
                    </div>
                    <div class="col-sm-6">
                        <div class="form-group">
                            <label id="mfee_bg_period_label">Month (YYYY-MM)</label>
                            <input type="text" class="form-control" id="mfee_bg_period" placeholder="YYYY-MM" autocomplete="off">
                            <p class="help-block">Pick a single billing period.</p>
                        </div>
                    </div>
                </div>

                <div class="row">
                    <div class="col-sm-12 text-right" style="padding-top:10px;">
                        <button type="button" class="btn btn-info" id="mfee_bg_preview_btn"><i class="fa fa-eye"></i> Preview</button>
                        <button type="button" class="btn btn-primary" id="mfee_bg_generate_btn"><i class="fa fa-cogs"></i> Generate</button>
                    </div>
                </div>

                <div style="height:1px;background:#e5e7eb;margin:10px 0;"></div>

                <div class="row">
                    <div class="col-sm-12">
                        <div class="well well-sm" style="margin-bottom:10px;">
                            <strong>Will create:</strong> <span id="mfee_bg_preview_created">0</span>
                            &nbsp; | &nbsp;
                            <strong>Skipped:</strong> <span id="mfee_bg_preview_skipped">0</span>
                            &nbsp; | &nbsp;
                            <strong>No plan:</strong> <span id="mfee_bg_preview_noplan">0</span>
                            &nbsp; | &nbsp;
                            <strong>Total:</strong> <span id="mfee_bg_preview_total" class="display_currency" data-currency_symbol="true" data-orig-value="0">0</span>
                        </div>

                        <div class="table-responsive" style="max-height:260px;overflow:auto;">
                            <table class="table table-bordered table-striped" id="mfee_bg_preview_table">
                                <thead>
                                    <tr>
                                        <th>Member</th>
                                        <th>Plan</th>
                                        <th>Period</th>
                                        <th>Amount</th>
                                        <th>State</th>
                                        <th>Skip</th>
                                    </tr>
                                </thead>
                                <tbody></tbody>
                            </table>
                        </div>
                        <p class="text-muted">Preview shows up to 250 rows.</p>
                    </div>
                </div>
            </div>

            <div class="mfee_legacy_form" style="display:none;">
            <fieldset disabled>
            <div class="row">
                <div class="col-sm-12">
                    <div class="form-group">
                        <label>Mode</label>
                        <div class="row">
                            <div class="col-sm-6">
                                <label class="radio-inline">
                                    <input type="radio" name="mode" value="single" checked> Single member
                                </label>
                            </div>
                            <div class="col-sm-6">
                                <label class="radio-inline">
                                    <input type="radio" name="mode" value="bulk"> Bulk (all filtered members)
                                </label>
                            </div>
                        </div>
                    </div>
                    <hr style="margin-top:0;">
                </div>

                <div class="col-sm-6">
                    <div class="form-group">
                        <label>Family Code (optional)</label>
                        <select id="mfee_gen_family_code" name="family_code" class="form-control" style="width:100%;"></select>
                        <p class="help-block">Use to filter member search and bulk generation.</p>
                    </div>
                </div>
                <div class="col-sm-6">
                    <div class="form-group">
                        {!! Form::label('member_id', 'Member:*') !!}
                        {!! Form::select('member_id', $members ?? [], null, ['class' => 'form-control', 'id' => 'mfee_gen_member_id', 'style' => 'width:100%;']) !!}
                        <p class="help-block mfee_single_only">Search by name/phone/email/family code.</p>
                    </div>
                </div>
                <div class="col-sm-12">
                    <div class="form-group">
                        <label>Plan source</label>
                        <div class="row">
                            <div class="col-sm-6">
                                <label class="radio-inline">
                                    <input type="radio" name="plan_source" value="selected" checked> Select plan
                                </label>
                            </div>
                            <div class="col-sm-6">
                                <label class="radio-inline">
                                    <input type="radio" name="plan_source" value="assigned"> Use assigned plan (per member)
                                </label>
                            </div>
                        </div>
                        <p class="help-block">Assigned plan will skip members without a saved plan.</p>
                    </div>
                </div>
                <div class="col-sm-12 mfee_assigned_help" style="display:none;">
                    <div class="checkbox" style="margin-top:0;">
                        <label>
                            {!! Form::hidden('fallback_plan_enabled', 0) !!}
                            <input type="checkbox" name="fallback_plan_enabled" value="1" checked>
                            If a member has no assigned plan, use the selected plan below (optional)
                        </label>
                    </div>
                </div>
                <div class="col-sm-6">
                    <div class="form-group">
                        {!! Form::label('plan_id', 'Plan:*') !!}
                        {!! Form::select('plan_id', $plans, null, ['class' => 'form-control', 'id' => 'mfee_gen_plan_id']) !!}
                    </div>
                </div>
                <div class="col-sm-6">
                    <div class="form-group">
                        {!! Form::label('start_ym', 'Start (YYYY-MM):*') !!}
                        <input type="text" name="start_ym" class="form-control mosque_monthpicker" required placeholder="YYYY-MM" autocomplete="off">
                    </div>
                </div>
                <div class="col-sm-6">
                    <div class="form-group">
                        {!! Form::label('end_ym', 'End (YYYY-MM):*') !!}
                        <input type="text" name="end_ym" class="form-control mosque_monthpicker" required placeholder="YYYY-MM" autocomplete="off">
                    </div>
                </div>
                <div class="col-sm-12">
                    <p class="text-muted">Existing months will be skipped (idempotent).</p>
                </div>
                <div class="col-sm-12 mfee_plan_selected_only">
                    <div class="checkbox">
                        <label>
                            <input type="checkbox" name="save_default_plan" value="1"> Save selected plan as default for generated member(s)
                        </label>
                    </div>
                </div>
            </div>
            </fieldset>
            </div>

            <fieldset class="mfee_advanced_fieldset" disabled style="display:none;">
            <div class="row" id="mfee_wizard_root" style="display:none;">
                <div class="col-sm-12">
                    <div class="alert alert-info" style="margin-bottom:10px;">
                        <strong>Generate Fees Wizard</strong> — preview before creating fees.
                    </div>
                </div>

                <div class="col-sm-12">
                    <ul class="nav nav-pills nav-justified" id="mfee_wizard_nav" style="margin-bottom:12px;">
                        <li class="active"><a href="#mfee_step_1" data-toggle="tab">1) Mode & Scope</a></li>
                        <li><a href="#mfee_step_2" data-toggle="tab">2) Billing Window</a></li>
                        <li><a href="#mfee_step_3" data-toggle="tab">3) Preview</a></li>
                    </ul>
                </div>

                <div class="col-sm-12">
                    <div class="tab-content">
                        <div class="tab-pane active" id="mfee_step_1">
                            <div class="row">
                                <div class="col-sm-12">
                                    <div class="form-group">
                                        <label>Mode</label>
                                        <div class="row">
                                            <div class="col-sm-6">
                                                <label class="radio-inline">
                                                    <input type="radio" name="mode" value="single" checked> Single (selected members)
                                                </label>
                                            </div>
                                            <div class="col-sm-6">
                                                <label class="radio-inline">
                                                    <input type="radio" name="mode" value="bulk"> Bulk (all filtered members)
                                                </label>
                                            </div>
                                        </div>
                                    </div>
                                    <hr style="margin-top:0;">
                                </div>

                                <div class="col-sm-6">
                                    <div class="form-group">
                                        <label>Members (multi-select)</label>
                                        <select id="mfee_gen_members" name="members[]" class="form-control" multiple style="width:100%;"></select>
                                        <p class="help-block mfee_single_only">Search by name/phone/email/family code.</p>
                                    </div>
                                </div>

                                <div class="col-sm-6">
                                    <div class="form-group">
                                        <label>Family Code(s) (optional)</label>
                                        <select id="mfee_gen_family_codes" name="family_codes[]" class="form-control" multiple style="width:100%;"></select>
                                        <p class="help-block">Used for filtering member search and bulk generation.</p>
                                    </div>
                                </div>

                                <div class="col-sm-12">
                                    <div class="form-group">
                                        <label>Plan source</label>
                                        <div class="row">
                                            <div class="col-sm-6">
                                                <label class="radio-inline">
                                                    <input type="radio" name="plan_source" value="assigned" checked> Use each member’s saved plan
                                                </label>
                                            </div>
                                            <div class="col-sm-6">
                                                <label class="radio-inline">
                                                    <input type="radio" name="plan_source" value="selected"> Override plan for this run
                                                </label>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <div class="col-sm-6">
                                    <div class="form-group">
                                        <label>Override plan</label>
                                        {!! Form::select('plan_id', $plans, null, ['class' => 'form-control', 'id' => 'mfee_gen_plan_id']) !!}
                                    </div>
                                </div>

                                <div class="col-sm-6">
                                    <div class="form-group">
                                        <label>Plan filter (bulk only)</label>
                                        <select id="mfee_gen_filter_plan_id" name="filter_plan_id" class="form-control" style="width:100%;"></select>
                                    </div>
                                </div>

                                <div class="col-sm-12 mfee_assigned_help">
                                    <div class="checkbox" style="margin-top:0;">
                                        <label>
                                            {!! Form::hidden('fallback_plan_enabled', 0) !!}
                                            <input type="checkbox" name="fallback_plan_enabled" value="1" checked>
                                            If a member has no assigned plan, use the override plan (optional)
                                        </label>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="tab-pane" id="mfee_step_2">
                            <div class="row">
                                <div class="col-sm-12">
                                    <div class="form-group">
                                        <label>Cycle (only for override plan)</label>
                                        <div class="row">
                                            <div class="col-sm-6">
                                                <label class="radio-inline">
                                                    <input type="radio" name="cycle" value="monthly" checked> Monthly
                                                </label>
                                            </div>
                                            <div class="col-sm-6">
                                                <label class="radio-inline">
                                                    <input type="radio" name="cycle" value="yearly"> Yearly
                                                </label>
                                            </div>
                                        </div>
                                        <p class="help-block">When using assigned plans, cycle is taken from each plan automatically.</p>
                                    </div>
                                </div>

                                <div class="col-sm-6">
                                    <div class="form-group">
                                        <label>Start</label>
                                        <input type="text" name="start_period" id="mfee_start_period" class="form-control mosque_monthpicker" required placeholder="YYYY-MM" autocomplete="off">
                                    </div>
                                </div>
                                <div class="col-sm-6">
                                    <div class="form-group">
                                        <label>End</label>
                                        <input type="text" name="end_period" id="mfee_end_period" class="form-control mosque_monthpicker" required placeholder="YYYY-MM" autocomplete="off">
                                    </div>
                                </div>

                                <div class="col-sm-12 mfee_plan_selected_only">
                                    <div class="checkbox">
                                        <label>
                                            <input type="checkbox" name="save_default_plan" value="1"> Save override plan as default for generated member(s)
                                        </label>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="tab-pane" id="mfee_step_3">
                            <div class="row">
                                <div class="col-sm-12">
                                    <div class="well well-sm" style="margin-bottom:10px;">
                                        <div class="row">
                                            <div class="col-sm-3"><strong>Will create:</strong> <span id="mfee_preview_created">0</span></div>
                                            <div class="col-sm-3"><strong>Skipped:</strong> <span id="mfee_preview_skipped">0</span></div>
                                            <div class="col-sm-3"><strong>No plan:</strong> <span id="mfee_preview_noplan">0</span></div>
                                            <div class="col-sm-3"><strong>Total:</strong> <span id="mfee_preview_total" class="display_currency" data-currency_symbol="true" data-orig-value="0">0</span></div>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-sm-12">
                                    <div class="table-responsive" style="max-height:280px;overflow:auto;">
                                        <table class="table table-bordered table-striped" id="mfee_preview_table">
                                            <thead>
                                                <tr>
                                                    <th>Member</th>
                                                    <th>Period</th>
                                                    <th>Plan</th>
                                                    <th>Amount</th>
                                                    <th>State</th>
                                                </tr>
                                            </thead>
                                            <tbody></tbody>
                                        </table>
                                    </div>
                                    <p class="text-muted">Preview shows up to 250 rows.</p>
                                </div>

                                <div class="col-sm-12 text-right">
                                    <button type="button" class="btn btn-default" id="mfee_preview_btn"><i class="fa fa-eye"></i> Preview</button>
                                    <button type="button" class="btn btn-primary" id="mfee_generate_submit_btn"><i class="fa fa-save"></i> Generate</button>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            </fieldset>
        </div>
        <div class="modal-footer">
            <button type="submit" class="btn btn-primary mfee_legacy_submit" style="display:none;">@lang('messages.save')</button>
            <button type="button" class="btn btn-default" data-dismiss="modal">@lang('messages.close')</button>
        </div>
        {!! Form::close() !!}
    </div>
</div>
