@extends('mosque::layouts.app')
@section('title', __('mosque::mosque.mosque') . ' | Member Fees')

@section('content')
<section class="content-header">
    <h1 class="tw-text-xl md:tw-text-3xl tw-font-bold tw-text-black">Member Fees</h1>
</section>

<section class="content mosque-fees-page">
    <style>
        .mosque-fees-page label,
        .mosque-fees-page .form-group label,
        .mosque-fees-page .help-block,
        .mosque_fee_generate_modal label,
        .mosque_fee_generate_modal .help-block,
        .mosque_payment_modal label,
        .mosque_payment_modal .help-block,
        .mosque_fee_generate_modal .nav > li > a,
        .mosque_fee_generate_modal .well,
        .mosque_fee_generate_modal .table,
        .mosque_fee_generate_modal .alert {
            color: #111 !important;
        }
        .mosque-fees-page .table > thead > tr > th,
        .mosque-fees-page .table > tbody > tr > td,
        .mosque-fees-page .dataTables_wrapper,
        .mosque-fees-page .dataTables_wrapper label,
        .mosque-fees-page .dataTables_info,
        .mosque-fees-page .dataTables_paginate {
            color: #111 !important;
        }
        .mosque-fees-page .select2-container--default .select2-selection--single .select2-selection__rendered,
        .mosque-fees-page .select2-container--default .select2-selection--multiple .select2-selection__rendered,
        .mosque_fee_generate_modal .select2-container--default .select2-selection--single .select2-selection__rendered,
        .mosque_fee_generate_modal .select2-container--default .select2-selection--multiple .select2-selection__rendered,
        .mosque_payment_modal .select2-container--default .select2-selection--single .select2-selection__rendered,
        .mosque_payment_modal .select2-container--default .select2-selection--multiple .select2-selection__rendered {
            color: #111 !important;
        }
        .mosque-fees-page .select2-container--default .select2-selection--single .select2-selection__placeholder,
        .mosque_fee_generate_modal .select2-container--default .select2-selection--single .select2-selection__placeholder,
        .mosque_payment_modal .select2-container--default .select2-selection--single .select2-selection__placeholder {
            color: #666 !important;
        }
        .mosque_fee_generate_modal .modal-body .radio-inline,
        .mosque_fee_generate_modal .modal-body .checkbox label {
            color: #111 !important;
        }
        .mfee-bulkbar .btn { margin-right: 6px; }
        .mosque-fees-page .mfee-totals { margin-top: 10px; }
    </style>
    @component('components.widget', ['class' => 'box-primary'])
        <div class="row">
            <div class="col-sm-3">
                <div class="form-group">
                    {!! Form::label('member_id', 'Member:') !!}
                    {!! Form::select('member_id', $members ?? [], null, ['class' => 'form-control', 'id' => 'mfee_member_id', 'placeholder' => __('lang_v1.all'), 'style' => 'width:100%;']) !!}
                </div>
            </div>
            <div class="col-sm-3">
                <div class="form-group">
                    <label>Family Code</label>
                    <select id="mfee_family_code" class="form-control" style="width:100%;"></select>
                </div>
            </div>
            <div class="col-sm-2">
                <div class="form-group">
                    <label>Plan</label>
                    {!! Form::select('plan_id', $plans ?? [], null, ['class' => 'form-control', 'id' => 'mfee_plan_id', 'placeholder' => __('lang_v1.all'), 'style' => 'width:100%;']) !!}
                </div>
            </div>
            <div class="col-sm-2">
                <div class="form-group">
                    <label>Billing Cycle</label>
                    <select id="mfee_cycle" class="form-control">
                        <option value="">All</option>
                        <option value="monthly">Monthly</option>
                        <option value="yearly">Yearly</option>
                    </select>
                </div>
            </div>
            <div class="col-sm-2">
                <div class="form-group">
                    <label>Status</label>
                    <select id="mfee_status" class="form-control">
                        <option value="">@lang('lang_v1.all')</option>
                        <option value="due">Due</option>
                        <option value="paid">Paid</option>
                        <option value="cancelled">Cancelled</option>
                    </select>
                </div>
            </div>
            <div class="col-sm-2">
                <div class="form-group">
                    <label>Month</label>
                    <input type="text" id="mfee_month" class="form-control mosque_monthpicker" placeholder="YYYY-MM" autocomplete="off">
                </div>
            </div>
            <div class="col-sm-3">
                <div class="form-group">
                    <label>Date range</label>
                    <input type="text" id="mfee_date_range" class="form-control" placeholder="YYYY-MM-DD - YYYY-MM-DD" autocomplete="off">
                    <input type="hidden" id="mfee_date_start" value="">
                    <input type="hidden" id="mfee_date_end" value="">
                </div>
            </div>
            <div class="col-sm-3">
                <div class="form-group">
                    <label>Bill / Receipt No</label>
                    <input type="text" id="mfee_receipt_no" class="form-control" placeholder="MF-..." autocomplete="off">
                </div>
            </div>
            <div class="col-sm-12 text-right">
                <button type="button" class="btn btn-primary btn-modal" data-href="{{ route('mosque.subscriptions.fees.generate.form') }}" data-container=".mosque_fee_generate_modal">
                    <i class="fa fa-plus"></i> Bill Generation
                </button>
                <a href="{{ route('mosque.subscriptions.fees.cancel_history') }}" class="btn btn-default">Cancel History</a>
                <a href="{{ route('mosque.subscriptions.payments') }}" class="btn btn-default">Payments</a>
                <a href="{{ route('mosque.subscriptions.plans') }}" class="btn btn-default">Plans</a>
            </div>
        </div>
    @endcomponent

    @component('components.widget', ['class' => 'box-primary'])
        <div class="mfee-bulkbar text-right" style="margin-bottom:8px;">
            <button type="button" class="btn btn-success" id="mfee_bulk_pay_btn" disabled><i class="fa fa-money-bill"></i> Receive Payment (Selected)</button>
        </div>
        <div class="table-responsive">
            <table class="table table-bordered table-striped" id="mosque_fees_table" style="width:100%;">
                <thead>
                    <tr>
                        <th class="no-export" style="width:30px;"><input type="checkbox" id="mfee_select_all"></th>
                        <th>Member</th>
                        <th>Plan</th>
                        <th>Period</th>
                        <th>Receipt No</th>
                        <th>Due</th>
                        <th>Paid</th>
                        <th>Status</th>
                        <th class="no-export">@lang('messages.action')</th>
                    </tr>
                </thead>
            </table>
        </div>
        <div class="mfee-totals well well-sm">
            <strong>Total Due:</strong> <span id="mfee_total_due" class="display_currency" data-currency_symbol="true" data-orig-value="0">0</span>
            &nbsp; | &nbsp;
            <strong>Total Paid:</strong> <span id="mfee_total_paid" class="display_currency" data-currency_symbol="true" data-orig-value="0">0</span>
            &nbsp; | &nbsp;
            <strong>Total Outstanding:</strong> <span id="mfee_total_outstanding" class="display_currency" data-currency_symbol="true" data-orig-value="0">0</span>
        </div>
    @endcomponent

    <div class="modal fade mosque_fee_generate_modal" tabindex="-1" role="dialog" aria-labelledby="gridSystemModalLabel"></div>
    <div class="modal fade mosque_payment_modal" tabindex="-1" role="dialog" aria-labelledby="gridSystemModalLabel"></div>

    <div class="modal fade" id="mosque_fee_confirm_delete_modal" tabindex="-1" role="dialog" aria-labelledby="mosque_fee_confirm_delete_modal_label">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                    <h4 class="modal-title" id="mosque_fee_confirm_delete_modal_label">@lang('messages.delete')</h4>
                </div>
                <div class="modal-body">
                    <p class="text-danger" style="margin-bottom:6px;">Permanent delete: removes fee, payments, and all related Finance entries. This will not remain in any reports or dashboard (only audit logs remain).</p>
                    <p>Type <strong>Confirm</strong> (case-sensitive) to permanently delete this cancelled fee.</p>
                    <div class="form-group">
                        <input type="text" class="form-control" id="mosque_fee_confirm_delete_input" placeholder="Confirm" autocomplete="off">
                        <input type="hidden" id="mosque_fee_confirm_delete_url" value="">
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-danger" id="mosque_fee_confirm_delete_btn">@lang('messages.delete')</button>
                    <button type="button" class="btn btn-default" data-dismiss="modal">@lang('messages.close')</button>
                </div>
            </div>
        </div>
    </div>

    <div class="modal fade" id="mosque_fee_cancel_modal" tabindex="-1" role="dialog" aria-labelledby="mosque_fee_cancel_modal_label">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                    <h4 class="modal-title" id="mosque_fee_cancel_modal_label">Cancel Fee</h4>
                </div>
                <div class="modal-body">
                    <div class="form-group">
                        <label>Reason (required)</label>
                        <textarea class="form-control" id="mosque_fee_cancel_reason" rows="4" placeholder="Write a reason" required></textarea>
                        <input type="hidden" id="mosque_fee_cancel_url" value="">
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-warning" id="mosque_fee_cancel_btn"><i class="fa fa-ban"></i> Cancel</button>
                    <button type="button" class="btn btn-default" data-dismiss="modal">@lang('messages.close')</button>
                </div>
            </div>
        </div>
    </div>

    <div class="modal fade" id="mosque_fee_bulk_pay_modal" tabindex="-1" role="dialog" aria-labelledby="mosque_fee_bulk_pay_modal_label">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                    <h4 class="modal-title" id="mosque_fee_bulk_pay_modal_label">Receive Payment (Bulk)</h4>
                </div>
                <div class="modal-body">
                    <p class="help-block">Pays full outstanding amount for the selected fees.</p>
                    <div class="row">
                        <div class="col-sm-4">
                            <div class="form-group">
                                <label>Paid on</label>
                                <input type="text" class="form-control" id="mfee_bulk_paid_on" placeholder="YYYY-MM-DD" autocomplete="off">
                            </div>
                        </div>
                        <div class="col-sm-4">
                            <div class="form-group">
                                <label>Method</label>
                                <select class="form-control" id="mfee_bulk_method">
                                    @foreach(($payment_types ?? []) as $key => $label)
                                        <option value="{{ $key }}">{{ $label }}</option>
                                    @endforeach
                                </select>
                            </div>
                        </div>
                        <div class="col-sm-12">
                            <div class="form-group">
                                <label>Note (optional)</label>
                                <input type="text" class="form-control" id="mfee_bulk_note" placeholder="Note">
                            </div>
                        </div>
                    </div>
                    <input type="hidden" id="mfee_bulk_fee_ids" value="">
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-success" id="mfee_bulk_pay_confirm_btn"><i class="fa fa-check"></i> Pay Selected</button>
                    <button type="button" class="btn btn-default" data-dismiss="modal">@lang('messages.close')</button>
                </div>
            </div>
        </div>
    </div>
</section>
@endsection

@section('javascript')
<script type="text/javascript">
    $(document).ready(function () {
        var SOMETHING_WENT_WRONG = @json(__('messages.something_went_wrong'));

        function hasDatepicker() {
            return typeof $.fn.datepicker === 'function';
        }
        function hasDateRangePicker() {
            return typeof $.fn.daterangepicker === 'function';
        }
        function initMonthpicker($el) {
            if (!hasDatepicker() || !$el || !$el.length) {
                return;
            }
            $el.datepicker({
                autoclose: true,
                format: 'yyyy-mm',
                minViewMode: 1,
                startView: 1
            });
        }
        function initYearpicker($el) {
            if (!hasDatepicker() || !$el || !$el.length) {
                return;
            }
            $el.datepicker({
                autoclose: true,
                format: 'yyyy',
                minViewMode: 2,
                startView: 2
            });
        }

        initMonthpicker($('.mosque_monthpicker'));
        initYearpicker($('.mosque_yearpicker'));

        function normalizeDateRangeInput() {
            var raw = ($('#mfee_date_range').val() || '').trim();
            if (raw === '') {
                $('#mfee_date_start').val('');
                $('#mfee_date_end').val('');
                return;
            }
            var parts = raw.split(' - ');
            if (parts.length === 2) {
                $('#mfee_date_start').val(parts[0].trim());
                $('#mfee_date_end').val(parts[1].trim());
            }
        }

        if (hasDateRangePicker()) {
            try {
                $('#mfee_date_range').daterangepicker({
                    autoUpdateInput: false,
                    locale: { format: 'YYYY-MM-DD', cancelLabel: '@lang("messages.clear")' }
                });
                $('#mfee_date_range').on('apply.daterangepicker', function (ev, picker) {
                    var v = picker.startDate.format('YYYY-MM-DD') + ' - ' + picker.endDate.format('YYYY-MM-DD');
                    $(this).val(v);
                    normalizeDateRangeInput();
                    table && table.ajax && table.ajax.reload();
                });
                $('#mfee_date_range').on('cancel.daterangepicker', function () {
                    $(this).val('');
                    normalizeDateRangeInput();
                    table && table.ajax && table.ajax.reload();
                });
            } catch (e) {
                // Fallback to manual parsing.
                $('#mfee_date_range').on('change', function () {
                    normalizeDateRangeInput();
                });
            }
        } else {
            $('#mfee_date_range').on('change', function () {
                normalizeDateRangeInput();
            });
        }

        $('#mfee_family_code').select2({
            width: '100%',
            tags: true,
            allowClear: true,
            placeholder: 'Search or type family code',
            minimumInputLength: 0,
            minimumResultsForSearch: 0,
            ajax: {
                url: '{{ route("mosque.subscriptions.fees.family_codes.search") }}',
                dataType: 'json',
                delay: 250,
                data: function (params) {
                    return { q: params.term || '' };
                },
                processResults: function (data) {
                    return { results: (data && data.results) ? data.results : [] };
                },
                cache: true
            }
        });

        $('#mfee_plan_id').select2({
            width: '100%',
            allowClear: true,
            placeholder: 'All plans',
            minimumResultsForSearch: 0
        });

        if ($('#mfee_member_id').hasClass('select2-hidden-accessible')) {
            try { $('#mfee_member_id').select2('destroy'); } catch (e) {}
        }
        $('#mfee_member_id').select2({
            width: '100%',
            allowClear: true,
            placeholder: 'Search member',
            minimumInputLength: 0,
            minimumResultsForSearch: 0,
            ajax: {
                url: '{{ route("mosque.subscriptions.fees.members.search") }}',
                dataType: 'json',
                delay: 250,
                data: function (params) {
                    return { q: params.term || '', family_code: $('#mfee_family_code').val() || '' };
                },
                processResults: function (data) {
                    return { results: (data && data.results) ? data.results : [] };
                },
                cache: true
            }
        });

        function initBillGenerationModal($modal) {
            var $period = $modal.find('#mfee_bg_period');
            var $cycle = $modal.find('#mfee_bg_cycle');
            var $start = $modal.find('#mfee_bg_start_period');
            var $end = $modal.find('#mfee_bg_end_period');
            var $excludesRoot = $modal.find('#mfee_bg_excludes');
            var excludedMemberIds = {};
            var lastPreview = { created: 0, skipped: 0, no_plan: 0, total_amount: 0, rows: [] };

            function applyCycleUi() {
                var cycle = ($cycle.val() || 'monthly').toLowerCase();
                if (cycle === 'yearly') {
                    $modal.find('#mfee_bg_period_label').text('Year (YYYY)');
                    $period.val('');
                    initYearpicker($period);
                    $period.attr('placeholder', 'YYYY');
                } else {
                    $modal.find('#mfee_bg_period_label').text('Month (YYYY-MM)');
                    $period.val('');
                    initMonthpicker($period);
                    $period.attr('placeholder', 'YYYY-MM');
                }
            }

            function syncPeriod() {
                var p = ($period.val() || '').trim();
                $start.val(p);
                $end.val(p);
            }

            function setGenerateEnabled() {
                var p = ($period.val() || '').trim();
                $modal.find('#mfee_bg_generate_btn').prop('disabled', p === '');
            }

            function renderPreview(preview) {
                preview = preview || {};
                var rows = preview.rows || [];

                var effectiveCreated = 0;
                var effectiveSkipped = 0;
                var effectiveNoPlan = (preview.no_plan || 0);
                var effectiveTotal = 0;

                rows.forEach(function (r) {
                    var memberId = parseInt(r.member_id, 10);
                    if (!isNaN(memberId) && excludedMemberIds[memberId]) {
                        return;
                    }
                    if (r.state === 'create') {
                        effectiveCreated++;
                        effectiveTotal += parseFloat(r.amount || 0) || 0;
                    } else {
                        effectiveSkipped++;
                    }
                });

                $('#mfee_bg_preview_created').text(effectiveCreated);
                $('#mfee_bg_preview_skipped').text(effectiveSkipped);
                $('#mfee_bg_preview_noplan').text(effectiveNoPlan);

                $('#mfee_bg_preview_total').attr('data-orig-value', effectiveTotal).text(effectiveTotal);
                __currency_convert_recursively($('#mfee_bg_preview_total').closest('.well'));

                var $tbody = $('#mfee_bg_preview_table tbody');
                $tbody.empty();
                rows.forEach(function (r) {
                    var memberId = parseInt(r.member_id, 10);
                    var isExcluded = (!isNaN(memberId) && excludedMemberIds[memberId]);
                    if (isExcluded) {
                        return;
                    }
                    var state = '<span class="label label-default">Skipped</span>';
                    if (r.state === 'create') {
                        state = '<span class="label label-primary">Will create</span>';
                    } else if (r.state === 'restore_due') {
                        state = '<span class="label label-warning">Restore as Due</span>';
                    }
                    var amount = r.amount || 0;
                    var amountHtml = '<span class="display_currency" data-currency_symbol="true" data-orig-value=\"' + amount + '\">' + amount + '</span>';
                    var actionHtml = '-';
                    if ((r.state === 'create' || r.state === 'restore_due') && !isNaN(memberId) && memberId > 0) {
                        actionHtml = '<button type="button" class="btn btn-xs btn-default mfee_bg_toggle_skip" data-member-id=\"' + memberId + '\">Skip</button>';
                    }
                    $tbody.append('<tr><td>' + (r.member || '') + '</td><td>' + (r.plan || '') + '</td><td>' + (r.period || '') + '</td><td>' + amountHtml + '</td><td>' + state + '</td><td>' + actionHtml + '</td></tr>');
                });
                __currency_convert_recursively($('#mfee_bg_preview_table'));
            }

            function syncExcludeInputs() {
                if (! $excludesRoot.length) {
                    return;
                }
                $excludesRoot.empty();
                Object.keys(excludedMemberIds).forEach(function (k) {
                    if (excludedMemberIds[k]) {
                        $excludesRoot.append('<input type=\"hidden\" name=\"exclude_members[]\" value=\"' + k + '\">');
                    }
                });
            }

            $modal.off('change.mfee_bg_cycle').on('change.mfee_bg_cycle', '#mfee_bg_cycle', function () {
                applyCycleUi();
                syncPeriod();
                setGenerateEnabled();
            });
            $modal.off('change.mfee_bg_period').on('change.mfee_bg_period', '#mfee_bg_period', function () {
                syncPeriod();
                setGenerateEnabled();
            });

            $modal.off('click.mfee_bg_preview').on('click.mfee_bg_preview', '#mfee_bg_preview_btn', function () {
                syncPeriod();
                setGenerateEnabled();
                syncExcludeInputs();
                var $form = $modal.find('form#mosque_fee_generate_form');
                var data = $form.serializeArray();
                data.push({ name: 'preview', value: 1 });

                $.ajax({
                    method: 'POST',
                    url: $form.attr('action'),
                    data: $.param(data),
                    success: function (result) {
                        if (result && result.success) {
                            lastPreview = result.preview || {};
                            renderPreview(lastPreview);
                            toastr.success(result.msg || 'Preview ready.');
                        } else {
                            toastr.error((result && result.msg) ? result.msg : SOMETHING_WENT_WRONG);
                        }
                    },
                    error: function (xhr) {
                        var msg = SOMETHING_WENT_WRONG;
                        try {
                            if (xhr && xhr.responseJSON && xhr.responseJSON.message) {
                                msg = xhr.responseJSON.message;
                            }
                        } catch (e) {}
                        toastr.error(msg);
                    }
                });
            });

            $modal.off('click.mfee_bg_generate').on('click.mfee_bg_generate', '#mfee_bg_generate_btn', function () {
                syncPeriod();
                setGenerateEnabled();
                if (($period.val() || '').trim() === '') {
                    toastr.error('Please select a billing period.');
                    return;
                }
                syncExcludeInputs();
                $modal.find('form#mosque_fee_generate_form').trigger('submit');
            });

            $modal.off('click.mfee_bg_toggle_skip').on('click.mfee_bg_toggle_skip', '.mfee_bg_toggle_skip', function () {
                var memberId = parseInt($(this).data('member-id'), 10);
                if (isNaN(memberId) || memberId <= 0) {
                    return;
                }
                excludedMemberIds[memberId] = true;
                syncExcludeInputs();
                renderPreview(lastPreview);
            });

            applyCycleUi();
            syncPeriod();
            setGenerateEnabled();
            syncExcludeInputs();
            lastPreview = { created: 0, skipped: 0, no_plan: 0, total_amount: 0, rows: [] };
            renderPreview(lastPreview);
        }

        function initGenerateFeesModal($modal) {
            initMonthpicker($modal.find('.mosque_monthpicker'));

            if ($modal.find('#mfee_billgen_root').length) {
                initBillGenerationModal($modal);
                return;
            }

            if ($modal.find('#mfee_wizard_root').length) {
                initGenerateFeesWizard($modal);
                return;
            }

            var $family = $modal.find('#mfee_gen_family_code');
            if ($family.length && ! $family.hasClass('select2-hidden-accessible')) {
                $family.select2({
                    width: '100%',
                    tags: true,
                    allowClear: true,
                    placeholder: 'Search or type family code',
                    minimumInputLength: 0,
                    minimumResultsForSearch: 0,
                    dropdownParent: $modal,
                    ajax: {
                        url: '{{ route("mosque.subscriptions.fees.family_codes.search") }}',
                        dataType: 'json',
                        delay: 250,
                        data: function (params) {
                            return { q: params.term || '' };
                        },
                        processResults: function (data) {
                            return { results: (data && data.results) ? data.results : [] };
                        },
                        cache: true
                    }
                });
            }

            var $member = $modal.find('#mfee_gen_member_id');
            if ($member.length && ! $member.hasClass('select2-hidden-accessible')) {
                $member.select2({
                    width: '100%',
                    allowClear: true,
                    placeholder: 'Search member',
                    dropdownParent: $modal,
                    minimumInputLength: 0,
                    ajax: {
                        url: '{{ route("mosque.subscriptions.fees.members.search") }}',
                        dataType: 'json',
                        delay: 250,
                        data: function (params) {
                            return { q: params.term || '', family_code: ($family.val() || '') };
                        },
                        processResults: function (data) {
                            return { results: (data && data.results) ? data.results : [] };
                        },
                        cache: true
                    }
                });
            }

            function applyModeUi() {
                var mode = $modal.find('input[name="mode"]:checked').val();
                if (mode === 'bulk') {
                    $modal.find('.mfee_single_only').hide();
                    $member.prop('disabled', true).val(null).trigger('change');
                } else {
                    $modal.find('.mfee_single_only').show();
                    $member.prop('disabled', false);
                }
            }

            function applyPlanSourceUi() {
                var planSource = $modal.find('input[name="plan_source"]:checked').val();
                if (planSource === 'assigned') {
                    $modal.find('.mfee_assigned_help').show();
                    $modal.find('#mfee_gen_plan_id').prop('disabled', false);
                    $modal.find('.mfee_plan_selected_only').hide();
                } else {
                    $modal.find('.mfee_assigned_help').hide();
                    $modal.find('#mfee_gen_plan_id').prop('disabled', false);
                    $modal.find('.mfee_plan_selected_only').show();
                }
            }

            $modal.off('change.mfee_mode').on('change.mfee_mode', 'input[name="mode"]', applyModeUi);
            $modal.off('change.mfee_plan_source').on('change.mfee_plan_source', 'input[name="plan_source"]', applyPlanSourceUi);

            $modal.off('change.mfee_member').on('change.mfee_member', '#mfee_gen_member_id', function () {
                var memberId = $(this).val();
                if (!memberId) {
                    return;
                }
                $.ajax({
                    url: '{{ route("mosque.subscriptions.fees.member_plan") }}',
                    dataType: 'json',
                    data: { member_id: memberId },
                    success: function (res) {
                        if (res && res.success && res.plan_id) {
                            $modal.find('#mfee_gen_plan_id').val(res.plan_id).trigger('change');
                        }
                        if (res && res.success && res.start_ym) {
                            $modal.find('input[name="start_ym"]').val(res.start_ym);
                        }
                    }
                });
            });

            applyModeUi();
            applyPlanSourceUi();
        }

        function initGenerateFeesWizard($modal) {
            var $familyCodes = $modal.find('#mfee_gen_family_codes');
            if ($familyCodes.length && ! $familyCodes.hasClass('select2-hidden-accessible')) {
                $familyCodes.select2({
                    width: '100%',
                    tags: true,
                    allowClear: true,
                    placeholder: 'Search or type family code',
                    minimumInputLength: 0,
                    minimumResultsForSearch: 0,
                    dropdownParent: $modal,
                    ajax: {
                        url: '{{ route("mosque.subscriptions.fees.family_codes.search") }}',
                        dataType: 'json',
                        delay: 250,
                        data: function (params) {
                            return { q: params.term || '' };
                        },
                        processResults: function (data) {
                            return { results: (data && data.results) ? data.results : [] };
                        },
                        cache: true
                    }
                });
            }

            var $members = $modal.find('#mfee_gen_members');
            if ($members.length && ! $members.hasClass('select2-hidden-accessible')) {
                $members.select2({
                    width: '100%',
                    allowClear: true,
                    placeholder: 'Search member',
                    dropdownParent: $modal,
                    closeOnSelect: false,
                    minimumInputLength: 0,
                    ajax: {
                        url: '{{ route("mosque.subscriptions.fees.members.search") }}',
                        dataType: 'json',
                        delay: 250,
                        data: function (params) {
                            var codes = ($familyCodes.val() || []);
                            var code = (codes && codes.length) ? codes[0] : '';
                            return { q: params.term || '', family_code: code };
                        },
                        processResults: function (data) {
                            return { results: (data && data.results) ? data.results : [] };
                        },
                        cache: true
                    }
                });
            }

            var $filterPlan = $modal.find('#mfee_gen_filter_plan_id');
            if ($filterPlan.length && ! $filterPlan.hasClass('select2-hidden-accessible')) {
                $filterPlan.select2({
                    width: '100%',
                    allowClear: true,
                    placeholder: 'All plans',
                    dropdownParent: $modal,
                    minimumInputLength: 0,
                    ajax: {
                        url: '{{ route("mosque.subscriptions.plans.data") }}',
                        dataType: 'json',
                        delay: 250,
                        data: function (params) {
                            return { search: { value: params.term || '' } };
                        },
                        processResults: function (data) {
                            var rows = (data && data.data) ? data.data : [];
                            var results = rows.map(function (r) {
                                var label = r.name || '';
                                if (r.type) {
                                    label += ' (' + (String(r.type).charAt(0).toUpperCase() + String(r.type).slice(1)) + ')';
                                }
                                return { id: r.id, text: label };
                            });
                            return { results: results };
                        },
                        cache: false
                    }
                });
            }

            function applyModeUi() {
                var mode = $modal.find('input[name="mode"]:checked').val();
                if (mode === 'bulk') {
                    $modal.find('.mfee_single_only').hide();
                    $members.prop('disabled', true).val(null).trigger('change');
                } else {
                    $modal.find('.mfee_single_only').show();
                    $members.prop('disabled', false);
                }
            }

            function applyPlanSourceUi() {
                var planSource = $modal.find('input[name="plan_source"]:checked').val();
                if (planSource === 'assigned') {
                    $modal.find('.mfee_assigned_help').show();
                    $modal.find('.mfee_plan_selected_only').hide();
                } else {
                    $modal.find('.mfee_assigned_help').hide();
                    $modal.find('.mfee_plan_selected_only').show();
                }
            }

            function applyCycleUi() {
                var planSource = $modal.find('input[name="plan_source"]:checked').val();
                var cycle = $modal.find('input[name="cycle"]:checked').val() || 'monthly';
                var $start = $modal.find('#mfee_start_period');
                var $end = $modal.find('#mfee_end_period');

                if (planSource === 'assigned') {
                    $modal.find('input[name="cycle"]').prop('disabled', true);
                    cycle = 'monthly';
                    $modal.find('input[name="cycle"][value="monthly"]').prop('checked', true);
                    if (hasDatepicker()) {
                        $start.datepicker('remove');
                        $end.datepicker('remove');
                        initMonthpicker($start);
                        initMonthpicker($end);
                    }
                    $start.attr('placeholder', 'YYYY-MM');
                    $end.attr('placeholder', 'YYYY-MM');
                    return;
                }

                $modal.find('input[name="cycle"]').prop('disabled', false);
                if (cycle === 'yearly') {
                    if (hasDatepicker()) {
                        $start.datepicker('remove');
                        $end.datepicker('remove');
                        initYearpicker($start);
                        initYearpicker($end);
                    }
                    $start.attr('placeholder', 'YYYY');
                    $end.attr('placeholder', 'YYYY');
                } else {
                    if (hasDatepicker()) {
                        $start.datepicker('remove');
                        $end.datepicker('remove');
                        initMonthpicker($start);
                        initMonthpicker($end);
                    }
                    $start.attr('placeholder', 'YYYY-MM');
                    $end.attr('placeholder', 'YYYY-MM');
                }
            }

            function renderPreview(preview) {
                preview = preview || {};
                $('#mfee_preview_created').text(preview.created || 0);
                $('#mfee_preview_skipped').text(preview.skipped || 0);
                $('#mfee_preview_noplan').text(preview.no_plan || 0);

                var total = preview.total_amount || 0;
                $('#mfee_preview_total').attr('data-orig-value', total).text(total);
                __currency_convert_recursively($('#mfee_preview_total').closest('.well'));

                var $tbody = $('#mfee_preview_table tbody');
                $tbody.empty();
                var rows = preview.rows || [];
                rows.forEach(function (r) {
                    var state = (r.state === 'create') ? '<span class="label label-primary">Will create</span>' : '<span class="label label-default">Skipped</span>';
                    var amount = r.amount || 0;
                    var amountHtml = '<span class="display_currency" data-currency_symbol="true" data-orig-value=\"' + amount + '\">' + amount + '</span>';
                    $tbody.append('<tr><td>' + (r.member || '') + '</td><td>' + (r.period || '') + '</td><td>' + (r.plan || '') + '</td><td>' + amountHtml + '</td><td>' + state + '</td></tr>');
                });
                __currency_convert_recursively($('#mfee_preview_table'));

                $('#mfee_generate_submit_btn').prop('disabled', (preview.created || 0) <= 0);
            }

            $modal.off('change.mfee_w_mode').on('change.mfee_w_mode', 'input[name="mode"]', applyModeUi);
            $modal.off('change.mfee_w_plan_source').on('change.mfee_w_plan_source', 'input[name="plan_source"]', function () {
                applyPlanSourceUi();
                applyCycleUi();
            });
            $modal.off('change.mfee_w_cycle').on('change.mfee_w_cycle', 'input[name="cycle"]', applyCycleUi);

            $modal.off('click.mfee_preview').on('click.mfee_preview', '#mfee_preview_btn', function () {
                var $form = $modal.find('form#mosque_fee_generate_form');
                var data = $form.serializeArray();
                data.push({ name: 'preview', value: 1 });

                $.ajax({
                    method: 'POST',
                    url: $form.attr('action'),
                    data: $.param(data),
                    success: function (result) {
                        if (result && result.success) {
                            renderPreview(result.preview || {});
                            toastr.success(result.msg || 'Preview ready.');
                            $modal.find('a[href=\"#mfee_step_3\"]').tab('show');
                        } else {
                            toastr.error((result && result.msg) ? result.msg : SOMETHING_WENT_WRONG);
                        }
                    },
                    error: function (xhr) {
                        var msg = SOMETHING_WENT_WRONG;
                        try {
                            if (xhr && xhr.responseJSON && xhr.responseJSON.message) {
                                msg = xhr.responseJSON.message;
                            }
                        } catch (e) {}
                        toastr.error(msg);
                    }
                });
            });

            $modal.off('click.mfee_generate').on('click.mfee_generate', '#mfee_generate_submit_btn', function () {
                $modal.find('form#mosque_fee_generate_form').trigger('submit');
            });

            applyModeUi();
            applyPlanSourceUi();
            applyCycleUi();
            renderPreview({ created: 0, skipped: 0, no_plan: 0, total_amount: 0, rows: [] });
        }

        $(document).on('shown.bs.modal', '.mosque_fee_generate_modal', function () {
            initGenerateFeesModal($(this));
        });
        $(document).on('shown.bs.modal', '.mosque_payment_modal', function () {
            var $modal = $(this);
            try {
                $modal.find('.payment_types_dropdown').select2({ dropdownParent: $modal, width: '100%' });
            } catch (e) {}
        });

        var table = $('#mosque_fees_table').DataTable({
            processing: true,
            serverSide: true,
            ajax: {
                url: '{{ route("mosque.subscriptions.fees.data") }}',
                data: function (d) {
                    d.member_id = $('#mfee_member_id').val();
                    d.family_code = $('#mfee_family_code').val();
                    d.plan_id = $('#mfee_plan_id').val();
                    d.cycle = $('#mfee_cycle').val();
                    d.status = $('#mfee_status').val();
                    d.month = ($('#mfee_month').val() || '').trim();
                    d.date_start = ($('#mfee_date_start').val() || '').trim();
                    d.date_end = ($('#mfee_date_end').val() || '').trim();
                    d.receipt_no = ($('#mfee_receipt_no').val() || '').trim();
                }
            },
            dom: 'lBfrtip',
            buttons: [
                { extend: 'csv', text: '<i class="fas fa-file-csv"></i>', className: 'btn btn-success', exportOptions: { columns: ':visible:not(.no-export)' } },
                { extend: 'excel', text: '<i class="fas fa-file-excel"></i>', className: 'btn btn-info', exportOptions: { columns: ':visible:not(.no-export)' } },
                { extend: 'pdf', text: '<i class="fas fa-file-pdf"></i>', className: 'btn btn-danger', exportOptions: { columns: ':visible:not(.no-export)' } },
                { extend: 'print', text: '<i class="fas fa-print"></i>', className: 'btn btn-warning', exportOptions: { columns: ':visible:not(.no-export)' } },
                { extend: 'colvis', text: '<i class="fas fa-eye"></i>', className: 'btn btn-primary' }
            ],
            columns: [
                { data: 'select', name: 'select', orderable: false, searchable: false },
                { data: 'member_name', name: 'member_name' },
                { data: 'plan_name', name: 'plan_name' },
                { data: 'period_ym', name: 'period_ym' },
                { data: 'receipt_no', name: 'receipt_no', orderable: false, searchable: false },
                { data: 'due_amount', name: 'due_amount', orderable: false, searchable: false },
                { data: 'paid_amount', name: 'paid_amount', orderable: false, searchable: false },
                { data: 'status', name: 'status' },
                { data: 'action', name: 'action', orderable: false, searchable: false },
            ],
            drawCallback: function () {
                __currency_convert_recursively($('#mosque_fees_table'));
                updateBulkPayButton();
                try { $('[data-toggle="tooltip"]').tooltip({ container: 'body' }); } catch (e) {}
            }
        });

        $('#mosque_fees_table').on('xhr.dt', function (e, settings, json) {
            try {
                if (json && json.totals) {
                    var due = parseFloat(json.totals.total_due || 0) || 0;
                    var paid = parseFloat(json.totals.total_paid || 0) || 0;
                    var outstanding = parseFloat(json.totals.total_outstanding || (due - paid)) || 0;
                    $('#mfee_total_due').attr('data-orig-value', due).text(due);
                    $('#mfee_total_paid').attr('data-orig-value', paid).text(paid);
                    $('#mfee_total_outstanding').attr('data-orig-value', outstanding).text(outstanding);
                    __currency_convert_recursively($('.mfee-totals'));
                }
            } catch (err) {}
        });

        $('#mosque_fees_table').on('error.dt', function (e, settings, techNote, message) {
            console.error('Fees table error:', message);
            toastr.error('Table loading error. Please reload. ' + (message || ''));
        });

        table.on('init.dt', function () {
            $('#mosque_fees_table_wrapper .dt-buttons').addClass('justify-content-center flex-wrap mb-2');
        });

        $(document).on('change', '#mfee_member_id, #mfee_family_code, #mfee_plan_id, #mfee_cycle, #mfee_status, #mfee_month', function () {
            normalizeDateRangeInput();
            table.ajax.reload();
        });
        $(document).on('keyup', '#mfee_receipt_no', function () {
            clearTimeout(window.__mfeeReceiptT);
            window.__mfeeReceiptT = setTimeout(function () { table.ajax.reload(); }, 350);
        });
        $(document).on('blur', '#mfee_date_range', function () {
            normalizeDateRangeInput();
            table.ajax.reload();
        });

        function getSelectedFeeIds() {
            var ids = [];
            $('#mosque_fees_table').find('input.mfee_row_select:checked').each(function () {
                var v = parseInt($(this).val(), 10);
                if (!isNaN(v) && v > 0) {
                    ids.push(v);
                }
            });
            return ids;
        }
        function updateBulkPayButton() {
            var ids = getSelectedFeeIds();
            $('#mfee_bulk_pay_btn').prop('disabled', ids.length === 0);
        }
        $(document).on('change', '.mfee_row_select', function () {
            updateBulkPayButton();
        });
        $('#mfee_select_all').on('change', function () {
            var checked = $(this).is(':checked');
            $('#mosque_fees_table').find('input.mfee_row_select').prop('checked', checked);
            updateBulkPayButton();
        });

        $('#mfee_bulk_pay_btn').on('click', function () {
            var ids = getSelectedFeeIds();
            if (ids.length === 0) {
                toastr.error('Select at least one fee.');
                return;
            }
            $('#mfee_bulk_fee_ids').val(ids.join(','));
            $('#mfee_bulk_paid_on').val('');
            $('#mfee_bulk_method').val('cash');
            $('#mfee_bulk_note').val('');
            $('#mosque_fee_bulk_pay_modal').modal('show');
        });
        $('#mfee_bulk_pay_confirm_btn').on('click', function () {
            var ids = ($('#mfee_bulk_fee_ids').val() || '').split(',').map(function (s) { return parseInt(s, 10); }).filter(function (n) { return !isNaN(n) && n > 0; });
            if (ids.length === 0) {
                toastr.error('Select at least one fee.');
                return;
            }
            $.ajax({
                method: 'POST',
                url: '{{ route("mosque.subscriptions.fees.pay_bulk") }}',
                data: {
                    _token: '{{ csrf_token() }}',
                    fee_ids: ids,
                    paid_on: $('#mfee_bulk_paid_on').val(),
                    method: $('#mfee_bulk_method').val(),
                    note: $('#mfee_bulk_note').val()
                },
                success: function (result) {
                    if (result && result.success) {
                        $('#mosque_fee_bulk_pay_modal').modal('hide');
                        toastr.success(result.msg || 'Paid.');
                        $('#mfee_select_all').prop('checked', false);
                        table.ajax.reload();
                        if (result.receipt_urls && result.receipt_urls.length) {
                            try { window.open(result.receipt_urls[0], '_blank'); } catch (e) {}
                        }
                    } else {
                        toastr.error((result && result.msg) ? result.msg : SOMETHING_WENT_WRONG);
                    }
                },
                error: function () {
                    toastr.error(SOMETHING_WENT_WRONG);
                }
            });
        });

        $(document).on('submit', 'form#mosque_fee_generate_form', function (e) {
            e.preventDefault();
            var $form = $(this);
            $.ajax({
                method: $form.attr('method'),
                url: $form.attr('action'),
                data: $form.serialize(),
                success: function (result) {
                    if (result.success) {
                        $('.mosque_fee_generate_modal').modal('hide');
                        toastr.success(result.msg);
                        table.ajax.reload();
                    } else {
                        toastr.error(result.msg);
                    }
                },
                error: function () {
                    toastr.error('@lang("messages.something_went_wrong")');
                }
            });
        });

        $(document).on('submit', 'form#mosque_payment_form', function (e) {
            e.preventDefault();
            var $form = $(this);
            $.ajax({
                method: $form.find('input[name=_method]').val() || $form.attr('method'),
                url: $form.attr('action'),
                data: $form.serialize(),
                success: function (result) {
                    if (result.success) {
                        $('.mosque_payment_modal').modal('hide');
                        toastr.success(result.msg);
                        table.ajax.reload();
                    } else {
                        toastr.error(result.msg);
                    }
                },
                error: function () {
                    toastr.error('@lang("messages.something_went_wrong")');
                }
            });
        });

        $(document).on('click', '.delete_mosque_fee', function (e) {
            e.preventDefault();
            var href = $(this).data('href');
            $('#mosque_fee_confirm_delete_url').val(href);
            $('#mosque_fee_confirm_delete_input').val('');
            $('#mosque_fee_confirm_delete_modal').modal('show');
        });

        $('#mosque_fee_confirm_delete_btn').on('click', function () {
            var txt = ($('#mosque_fee_confirm_delete_input').val() || '').trim();
            if (txt !== 'Confirm' && txt !== 'CONFIRM') {
                toastr.error('Please type Confirm (case-sensitive).');
                return;
            }
            var href = $('#mosque_fee_confirm_delete_url').val();
            $.ajax({
                method: 'DELETE',
                 url: href,
                 data: { _token: '{{ csrf_token() }}' },
                 success: function (result) {
                     if (result.ok || result.success) {
                         $('#mosque_fee_confirm_delete_modal').modal('hide');
                         toastr.success(result.toast || result.msg || '@lang("lang_v1.success")');
                         table.ajax.reload();
                     } else {
                         toastr.error(result.message || result.toast || result.msg || '@lang("messages.something_went_wrong")');
                     }
                 },
                 error: function () {
                     toastr.error('@lang("messages.something_went_wrong")');
                 }
             });
        });

        $(document).on('click', '.mosque_fee_cancel', function (e) {
            e.preventDefault();
            $('#mosque_fee_cancel_reason').val('');
            $('#mosque_fee_cancel_url').val($(this).data('href') || '');
            $('#mosque_fee_cancel_modal').modal('show');
        });

        $('#mosque_fee_cancel_btn').on('click', function () {
            var href = ($('#mosque_fee_cancel_url').val() || '').trim();
            var reason = ($('#mosque_fee_cancel_reason').val() || '').trim();
            if (reason.length < 3) {
                toastr.error('Please enter a reason.');
                return;
            }
            $.ajax({
                method: 'POST',
                url: href,
                data: { _token: '{{ csrf_token() }}', reason: reason },
                success: function (result) {
                    if (result.ok || result.success) {
                        $('#mosque_fee_cancel_modal').modal('hide');
                        toastr.success(result.toast || result.msg || '@lang("lang_v1.success")');
                        table.ajax.reload();
                    } else {
                        toastr.error(result.toast || result.msg || '@lang("messages.something_went_wrong")');
                    }
                },
                error: function (xhr) {
                    var msg = '@lang("messages.something_went_wrong")';
                    try {
                        if (xhr && xhr.responseJSON && xhr.responseJSON.message) {
                            msg = xhr.responseJSON.message;
                        }
                    } catch (e) {}
                    toastr.error(msg);
                }
            });
        });

        $(document).on('click', '.mosque_fee_reactivate', function (e) {
            e.preventDefault();
            var href = $(this).data('href');
            $.ajax({
                method: 'POST',
                url: href,
                data: { _token: '{{ csrf_token() }}' },
                success: function (result) {
                    if (result.ok || result.success) {
                        toastr.success(result.toast || result.msg || '@lang("lang_v1.success")');
                        table.ajax.reload();
                    } else {
                        toastr.error(result.toast || result.msg || '@lang("messages.something_went_wrong")');
                    }
                },
                error: function (xhr) {
                    var msg = '@lang("messages.something_went_wrong")';
                    try {
                        if (xhr && xhr.responseJSON && xhr.responseJSON.message) {
                            msg = xhr.responseJSON.message;
                        }
                    } catch (e) {}
                    toastr.error(msg);
                }
            });
        });

        $(document).on('click', '.mosque_fee_pay_full', function (e) {
            e.preventDefault();
            var href = $(this).data('href');

            swal({
                title: 'Mark as paid?',
                text: 'This will record full payment and generate a receipt.',
                icon: 'warning',
                buttons: true,
                dangerMode: false,
            }).then(function (willPay) {
                if (!willPay) {
                    return;
                }

                $.ajax({
                    method: 'POST',
                    url: href,
                    data: { _token: '{{ csrf_token() }}' },
                    success: function (result) {
                        if (result.success) {
                            toastr.success(result.msg);
                            table.ajax.reload();
                            if (result.receipt_url) {
                                window.open(result.receipt_url, '_blank');
                            }
                        } else {
                            toastr.error(result.msg || '@lang("messages.something_went_wrong")');
                        }
                    },
                    error: function () {
                        toastr.error('@lang("messages.something_went_wrong")');
                    }
                });
            });
        });
    });
</script>
@endsection
