@extends('mosque::layouts.app')
@section('title', __('mosque::mosque.mosque') . ' | Payments')

@section('content')
<section class="content-header">
    <h1 class="tw-text-xl md:tw-text-3xl tw-font-bold tw-text-black">Membership Payments</h1>
</section>

<section class="content">
    @component('components.widget', ['class' => 'box-primary'])
        <div class="row">
            <div class="col-sm-12 text-right">
                <a href="{{ route('mosque.subscriptions.fees') }}" class="btn btn-default">Fees</a>
                <a href="{{ route('mosque.subscriptions.plans') }}" class="btn btn-default">Plans</a>
            </div>
        </div>
    @endcomponent

    @component('components.widget', ['class' => 'box-primary'])
        <div class="table-responsive">
            <table class="table table-bordered table-striped" id="mosque_payments_table" style="width:100%;">
                <thead>
                    <tr>
                        <th>Date</th>
                        <th>Member</th>
                        <th>Period</th>
                        <th>Ref</th>
                        <th>Method</th>
                        <th>Amount</th>
                        <th>@lang('messages.action')</th>
                    </tr>
                </thead>
            </table>
        </div>
    @endcomponent

    <div class="modal fade" id="mosque_payment_confirm_delete_modal" tabindex="-1" role="dialog" aria-labelledby="mosque_payment_confirm_delete_modal_label">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                    <h4 class="modal-title" id="mosque_payment_confirm_delete_modal_label">@lang('messages.delete')</h4>
                </div>
                <div class="modal-body">
                    <p class="text-danger" style="margin-bottom:6px;">Permanent delete: removes this payment and its related Finance entry. This will not remain in any reports or dashboard (only audit logs remain).</p>
                    <p>Type <strong>Confirm</strong> (case-sensitive) to permanently delete this payment.</p>
                    <div class="form-group">
                        <input type="text" class="form-control" id="mosque_payment_confirm_delete_input" placeholder="Confirm" autocomplete="off">
                        <input type="hidden" id="mosque_payment_confirm_delete_url" value="">
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-danger" id="mosque_payment_confirm_delete_btn">@lang('messages.delete')</button>
                    <button type="button" class="btn btn-default" data-dismiss="modal">@lang('messages.close')</button>
                </div>
            </div>
        </div>
    </div>
</section>
@endsection

@section('javascript')
<script type="text/javascript">
    $(document).ready(function () {
        var table = $('#mosque_payments_table').DataTable({
            processing: true,
            serverSide: true,
            ajax: '{{ route("mosque.subscriptions.payments.data") }}',
            dom: 'lBfrtip',
            buttons: [
                { extend: 'csv', text: '<i class="fas fa-file-csv"></i>', className: 'btn btn-success' },
                { extend: 'excel', text: '<i class="fas fa-file-excel"></i>', className: 'btn btn-info' },
                { extend: 'pdf', text: '<i class="fas fa-file-pdf"></i>', className: 'btn btn-danger' },
                { extend: 'print', text: '<i class="fas fa-print"></i>', className: 'btn btn-warning' },
                { extend: 'colvis', text: '<i class="fas fa-eye"></i>', className: 'btn btn-primary' }
            ],
            columns: [
                { data: 'paid_on', name: 'paid_on' },
                { data: 'member_name', name: 'member_name' },
                { data: 'period_ym', name: 'period_ym' },
                { data: 'ref_no', name: 'ref_no' },
                { data: 'method', name: 'method' },
                { data: 'amount', name: 'amount', orderable: false, searchable: false },
                { data: 'action', name: 'action', orderable: false, searchable: false },
            ],
            drawCallback: function () {
                __currency_convert_recursively($('#mosque_payments_table'));
            }
        });

        table.on('init.dt', function () {
            $('#mosque_payments_table_wrapper .dt-buttons').addClass('justify-content-center flex-wrap mb-2');
        });

        $(document).on('click', '.delete_mosque_payment', function (e) {
            e.preventDefault();
            var href = $(this).data('href');
            $('#mosque_payment_confirm_delete_url').val(href);
            $('#mosque_payment_confirm_delete_input').val('');
            $('#mosque_payment_confirm_delete_modal').modal('show');
        });

        $('#mosque_payment_confirm_delete_btn').on('click', function () {
            var txt = ($('#mosque_payment_confirm_delete_input').val() || '').trim();
            if (txt !== 'Confirm' && txt !== 'CONFIRM') {
                toastr.error('Please type Confirm (case-sensitive).');
                return;
            }
            var href = $('#mosque_payment_confirm_delete_url').val();
            $.ajax({
                method: 'DELETE',
                url: href,
                data: { _token: '{{ csrf_token() }}' },
                success: function (result) {
                    if (result.success || result.ok) {
                        $('#mosque_payment_confirm_delete_modal').modal('hide');
                        toastr.success(result.msg || result.toast || '@lang("lang_v1.success")');
                        table.ajax.reload();
                    } else {
                        toastr.error(result.msg || result.toast || '@lang("messages.something_went_wrong")');
                    }
                },
                error: function () {
                    toastr.error('@lang("messages.something_went_wrong")');
                }
            });
        });
    });
</script>
@endsection
