<!DOCTYPE html>
<html lang="{{ app()->getLocale() }}">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Membership Payment Receipt - {{ $payment->ref_no }}</title>
    <style>
        body { font-family: Arial, sans-serif; color: #111; margin: 22px; }
        .no-print { text-align: right; margin-bottom: 10px; }
        .header { border-bottom: 2px solid #111; padding-bottom: 10px; margin-bottom: 14px; }
        .header h1 { margin: 0; font-size: 20px; }
        .muted { color: #666; font-size: 12px; }
        .grid { width: 100%; border-collapse: collapse; margin-top: 10px; }
        .grid td { padding: 7px 6px; vertical-align: top; }
        .label { width: 180px; color: #333; font-weight: bold; }
        .box { border: 1px solid #ddd; padding: 10px; border-radius: 4px; margin-top: 12px; font-size: 12px; }
        .pill { display: inline-block; padding: 3px 10px; border-radius: 999px; font-size: 11px; font-weight: bold; border: 1px solid #ddd; }
        .pill.success { background: #e8f7ee; color: #1b5e20; border-color: #b7e1c3; }
        .pill.warning { background: #fff8e1; color: #6d4c41; border-color: #ffe0b2; }
        .pill.danger { background: #ffebee; color: #b71c1c; border-color: #ffcdd2; }
        .footer { margin-top: 16px; padding-top: 10px; border-top: 1px solid #111; font-size: 12px; }
        .sig { margin-top: 22px; display: flex; justify-content: flex-end; }
        .sig .line { width: 220px; border-top: 1px solid #111; text-align: center; padding-top: 6px; font-weight: bold; }
        .watermark { position: fixed; top: 40%; left: 50%; transform: translate(-50%, -50%) rotate(-18deg); font-size: 64px; font-weight: 900; color: rgba(183, 28, 28, 0.18); letter-spacing: 2px; text-transform: uppercase; pointer-events: none; z-index: 0; }
        .content-wrap { position: relative; z-index: 1; }
        @media print { .no-print { display:none !important; } body { margin: 0; } }
    </style>
</head>
<body>
    @if(!empty($isVoided))
        <div class="watermark">VOID / CANCELLED</div>
    @endif
    <div class="content-wrap">
    <div class="no-print">
        <button type="button" onclick="window.print();">Print</button>
    </div>

    @php
        $businessName = (string) request()->session()->get('business.name') ?: (string) request()->session()->get('business.business_name') ?: 'Business';
        $headerName = !empty($profile) && !empty($profile->name) ? $profile->name : $businessName;
        $logoUrl = null;
        if (!empty($profile) && !empty($profile->logo)) {
            try {
                $logoUrl = \Illuminate\Support\Facades\Storage::url('mosque_logos/'.$profile->logo);
            } catch (\Exception $e) {
                $logoUrl = null;
            }
        }
        $euWording = (string) ($settings['eu_receipt_wording'] ?? '');
        $template = (string) ($settings['template_membership_receipt'] ?? '');
        $amountFormatted = \Modules\Mosque\Utils\MosqueDocumentUtil::formatMoney($payment->amount, $settings ?? []);

        $periodLabelText = (string) ($periodLabel ?? ($fee->period_ym ?? ''));
        $statusTextLocal = (string) ($statusText ?? (((string) ($fee->status ?? '') === 'paid') ? 'Paid' : (((string) ($fee->status ?? '') === 'partial') ? 'Partial' : 'Due')));
        $statusClassLocal = (string) ($statusClass ?? (((string) ($fee->status ?? '') === 'paid') ? 'success' : (((string) ($fee->status ?? '') === 'partial') ? 'warning' : 'danger')));

        $memberPhone = (string) ($member->phone ?? '');
        $memberWhatsapp = (string) ($member->whatsapp_number ?? '');
        if ($memberWhatsapp === '' && !empty($member->whatsapp_same_as_phone) && $memberPhone !== '') {
            $memberWhatsapp = $memberPhone;
        }
        $waDigits = preg_replace('/\\D+/', '', $memberWhatsapp);
        $waUrl = $waDigits !== '' ? ('https://wa.me/'.$waDigits) : null;

        $mosquePhone = !empty($profile) ? (string) ($profile->phone ?? '') : '';
        $mosqueEmail = !empty($profile) ? (string) ($profile->email ?? '') : '';
        $mosqueAddr = !empty($profile) ? (string) ($profile->address ?? '') : '';
        $mosqueReg = !empty($profile) ? (string) ($profile->reg_no ?? '') : '';

        $tokens = [
            '{business}' => $businessName,
            '{ref_no}' => (string) $payment->ref_no,
            '{date}' => !empty($payment->paid_on) ? \Carbon\Carbon::parse($payment->paid_on)->format('Y-m-d') : '',
            '{amount}' => (string) $amountFormatted,
            '{method}' => (string) $payment->method,
            '{member}' => (string) ($member->name ?? ''),
            '{period_ym}' => (string) ($fee->period_ym ?? ''),
        ];
        $templateRendered = trim(strtr($template, $tokens));
    @endphp

    <div class="header">
        <div class="row" style="display:flex;justify-content:space-between;align-items:center;gap:12px;">
            <div>
                <h1 style="margin:0;">Membership Payment Receipt</h1>
                <div class="muted">
                    {{ $headerName }} &nbsp;|&nbsp; Ref: {{ $payment->ref_no }}
                </div>
            </div>
            @if(!empty($logoDataUri) || !empty($logoUrl))
                <div>
                    <img src="{{ $logoDataUri ?? $logoUrl }}" alt="Logo" style="max-height:60px;">
                </div>
            @endif
        </div>
    </div>

    <table class="grid">
        <tr>
            <td class="label">Date</td>
            <td>{{ ! empty($payment->paid_on) ? \Carbon\Carbon::parse($payment->paid_on)->format('Y-m-d') : '-' }}</td>
        </tr>
        <tr>
            <td class="label">Member</td>
            <td>{{ $member->name ?? '-' }}</td>
        </tr>
        <tr>
            <td class="label">Contact</td>
            <td>
                @if($memberPhone !== '')
                    {{ $memberPhone }}
                @else
                    -
                @endif
                @if($memberWhatsapp !== '')
                    &nbsp;|&nbsp; WhatsApp:
                    @if(!empty($waUrl))
                        <a href="{{ $waUrl }}" target="_blank" rel="noopener">{{ $memberWhatsapp }}</a>
                    @else
                        {{ $memberWhatsapp }}
                    @endif
                @endif
            </td>
        </tr>
        <tr>
            <td class="label">Paid for</td>
            <td><strong>{{ $periodLabelText !== '' ? $periodLabelText : '-' }}</strong></td>
        </tr>
        <tr>
            <td class="label">Status</td>
            <td><span class="pill {{ $statusClassLocal }}">{{ strtoupper($statusTextLocal) }}</span></td>
        </tr>
        <tr>
            <td class="label">Method</td>
            <td>{{ strtoupper((string) $payment->method) }}</td>
        </tr>
        <tr>
            <td class="label">Amount</td>
            <td><strong>{{ $amountFormatted }}</strong></td>
        </tr>
    </table>

    @if(!empty($euWording))
        <div class="box">
            {!! nl2br(e($euWording)) !!}
        </div>
    @endif

    @if(!empty($templateRendered))
        <div class="box">
            {!! nl2br(e($templateRendered)) !!}
        </div>
    @endif

    @if(!empty($profile) && !empty($profile->header_text))
        <div class="box">
            {!! nl2br(e($profile->header_text)) !!}
        </div>
    @endif

    <div class="footer">
        <div style="display:flex;justify-content:space-between;gap:12px;align-items:flex-start;">
            <div>
                @if($mosqueAddr !== '')
                    <div>{{ $mosqueAddr }}</div>
                @endif
                <div class="muted">
                    @if($mosquePhone !== '') Contact: {{ $mosquePhone }} @endif
                    @if($mosqueEmail !== '') @if($mosquePhone !== '') | @endif Email: {{ $mosqueEmail }} @endif
                    @if($mosqueReg !== '') @if($mosquePhone !== '' || $mosqueEmail !== '') | @endif Reg#: {{ $mosqueReg }} @endif
                </div>
                <div class="muted">Computer generated receipt.</div>
            </div>
            <div class="sig">
        <div class="line">Authorized Signature</div>
            </div>
        </div>
    </div>
    </div>
</body>
</html>
