@extends('mosque::layouts.app')
@section('title', __('mosque::mosque.mosque') . ' | Plans')

@section('content')
<section class="content-header">
    <h1 class="tw-text-xl md:tw-text-3xl tw-font-bold tw-text-black">Membership Plans</h1>
</section>

<section class="content">
    @component('components.widget', ['class' => 'box-primary'])
        <div class="row">
            <div class="col-sm-12 text-right">
                <button type="button" class="btn btn-primary btn-modal" data-href="{{ route('mosque.subscriptions.plans.create') }}" data-container=".mosque_plan_modal">
                    <i class="fa fa-plus"></i> @lang('messages.add')
                </button>
                <button type="button" class="btn btn-default btn-modal" data-href="{{ route('mosque.subscriptions.plans.import') }}" data-container=".mosque_plan_import_modal">
                    <i class="fa fa-upload"></i> Import
                </button>
                <a href="{{ route('mosque.subscriptions.fees') }}" class="btn btn-default">Fees</a>
                <a href="{{ route('mosque.subscriptions.payments') }}" class="btn btn-default">Payments</a>
            </div>
        </div>

        <div class="table-responsive">
            <table class="table table-bordered table-striped" id="mosque_plans_table" style="width:100%;">
                <thead>
                    <tr>
                        <th>@lang('user.name')</th>
                        <th>@lang('lang_v1.type')</th>
                        <th>@lang('sale.total_amount')</th>
                        <th>@lang('lang_v1.is_active')</th>
                        <th>@lang('messages.action')</th>
                    </tr>
                </thead>
            </table>
        </div>
    @endcomponent

    <div class="modal fade mosque_plan_modal" tabindex="-1" role="dialog" aria-labelledby="gridSystemModalLabel"></div>
    <div class="modal fade mosque_plan_import_modal" tabindex="-1" role="dialog" aria-labelledby="gridSystemModalLabel"></div>
</section>
@endsection

@section('javascript')
<script type="text/javascript">
    $(document).ready(function () {
        var table = $('#mosque_plans_table').DataTable({
            processing: true,
            serverSide: true,
            ajax: '{{ route("mosque.subscriptions.plans.data") }}',
            dom: 'lBfrtip',
            buttons: [
                { extend: 'csv', text: '<i class="fas fa-file-csv"></i>', className: 'btn btn-success' },
                { extend: 'excel', text: '<i class="fas fa-file-excel"></i>', className: 'btn btn-info' },
                { extend: 'pdf', text: '<i class="fas fa-file-pdf"></i>', className: 'btn btn-danger' },
                { extend: 'print', text: '<i class="fas fa-print"></i>', className: 'btn btn-warning' },
                { extend: 'colvis', text: '<i class="fas fa-eye"></i>', className: 'btn btn-primary' }
            ],
            columns: [
                { data: 'name', name: 'name' },
                { data: 'type', name: 'type' },
                { data: 'amount', name: 'amount', orderable: false, searchable: false },
                { data: 'active', name: 'active', orderable: false, searchable: false },
                { data: 'action', name: 'action', orderable: false, searchable: false }
            ],
            drawCallback: function () {
                __currency_convert_recursively($('#mosque_plans_table'));
            }
        });

        table.on('init.dt', function () {
            $('#mosque_plans_table_wrapper .dt-buttons').addClass('justify-content-center flex-wrap mb-2');
        });

        $(document).on('submit', 'form#mosque_plan_form', function (e) {
            e.preventDefault();
            var $form = $(this);
            $.ajax({
                method: $form.find('input[name=_method]').val() || $form.attr('method'),
                url: $form.attr('action'),
                data: $form.serialize(),
                success: function (result) {
                    if (result.success) {
                        $('.mosque_plan_modal').modal('hide');
                        toastr.success(result.msg);
                        table.ajax.reload();
                    } else {
                        toastr.error(result.msg);
                    }
                },
                error: function () {
                    toastr.error('@lang("messages.something_went_wrong")');
                }
            });
        });

        $(document).on('submit', 'form#mosque_plan_import_form', function (e) {
            e.preventDefault();
            var formEl = this;
            var formData = new FormData(formEl);

            $.ajax({
                method: 'POST',
                url: $(formEl).attr('action'),
                data: formData,
                contentType: false,
                processData: false,
                success: function (result) {
                    if (result.success) {
                        $('.mosque_plan_import_modal').modal('hide');
                        toastr.success(result.msg);
                        table.ajax.reload();
                    } else {
                        toastr.error(result.msg || '@lang("messages.something_went_wrong")');
                    }
                },
                error: function () {
                    toastr.error('@lang("messages.something_went_wrong")');
                }
            });
        });

        $(document).on('click', '.delete_mosque_plan', function (e) {
            e.preventDefault();
            var href = $(this).data('href');
            swal({ title: LANG.sure, icon: 'warning', buttons: true, dangerMode: true })
            .then((willDelete) => {
                if (willDelete) {
                    $.ajax({
                        method: 'DELETE',
                        url: href,
                        data: { _token: '{{ csrf_token() }}' },
                        success: function (result) {
                            if (result.success) {
                                toastr.success(result.msg);
                                table.ajax.reload();
                            } else {
                                toastr.error(result.msg);
                            }
                        }
                    });
                }
            });
        });
    });
</script>
@endsection
