@extends('mosque::layouts.app')
@section('title', __('mosque::mosque.mosque') . ' | ' . __('mosque::mosque.menu_membership_reports'))

@section('content')
<section class="content-header">
    <h1 class="tw-text-xl md:tw-text-3xl tw-font-bold tw-text-black">@lang('mosque::mosque.menu_membership_reports')</h1>
</section>

<section class="content">
    @component('components.widget', ['class' => 'box-primary'])
        <div class="row">
            <div class="col-sm-3">
                <div class="form-group">
                    <label>@lang('lang_v1.start_date')</label>
                    <input type="date" id="msr_start_date" class="form-control" value="{{ now()->startOfMonth()->format('Y-m-d') }}">
                </div>
            </div>
            <div class="col-sm-3">
                <div class="form-group">
                    <label>@lang('lang_v1.end_date')</label>
                    <input type="date" id="msr_end_date" class="form-control" value="{{ now()->endOfMonth()->format('Y-m-d') }}">
                </div>
            </div>
            <div class="col-sm-3">
                <div class="form-group">
                    <label>Period (YYYY-MM)</label>
                    <input type="text" id="msr_period_ym" class="form-control" placeholder="2025-01">
                </div>
            </div>
            <div class="col-sm-3">
                <div class="form-group">
                    <label>@lang('sale.status')</label>
                    <select id="msr_status" class="form-control">
                        <option value="">@lang('lang_v1.all')</option>
                        <option value="pending">Pending</option>
                        <option value="partial">Partial</option>
                    </select>
                    <p class="help-block">Used on Outstanding Dues tab.</p>
                </div>
            </div>
        </div>
    @endcomponent

    @component('components.widget', ['class' => 'box-primary'])
        <ul class="nav nav-tabs" role="tablist">
            <li role="presentation" class="active">
                <a href="#tab_monthly" aria-controls="tab_monthly" role="tab" data-toggle="tab">Monthly Collections</a>
            </li>
            <li role="presentation">
                <a href="#tab_outstanding" aria-controls="tab_outstanding" role="tab" data-toggle="tab">Outstanding Dues</a>
            </li>
            <li role="presentation">
                <a href="#tab_history" aria-controls="tab_history" role="tab" data-toggle="tab">Payment History</a>
            </li>
        </ul>

        <div class="tab-content" style="margin-top:15px;">
            <div role="tabpanel" class="tab-pane active" id="tab_monthly">
                <div class="table-responsive">
                    <table class="table table-bordered table-striped" id="mosque_membership_monthly_table" style="width:100%;">
                        <thead>
                            <tr>
                                <th>Month</th>
                                <th>Payments</th>
                                <th>Members</th>
                                <th>Total</th>
                            </tr>
                        </thead>
                    </table>
                </div>
            </div>

            <div role="tabpanel" class="tab-pane" id="tab_outstanding">
                <div class="table-responsive">
                    <table class="table table-bordered table-striped" id="mosque_membership_outstanding_table" style="width:100%;">
                        <thead>
                            <tr>
                                <th>Period</th>
                                <th>Member</th>
                                <th>Phone</th>
                                <th>Plan</th>
                                <th>@lang('sale.status')</th>
                                <th>Due</th>
                                <th>Paid</th>
                                <th>Balance</th>
                            </tr>
                        </thead>
                    </table>
                </div>
            </div>

            <div role="tabpanel" class="tab-pane" id="tab_history">
                <div class="table-responsive">
                    <table class="table table-bordered table-striped" id="mosque_membership_history_table" style="width:100%;">
                        <thead>
                            <tr>
                                <th>Date</th>
                                <th>Period</th>
                                <th>Member</th>
                                <th>Phone</th>
                                <th>Method</th>
                                <th>Ref</th>
                                <th>Amount</th>
                                <th>@lang('messages.action')</th>
                            </tr>
                        </thead>
                    </table>
                </div>
            </div>
        </div>
    @endcomponent
</section>
@endsection

@section('javascript')
<script type="text/javascript">
$(document).ready(function () {
    function getFilters() {
        return {
            start_date: $('#msr_start_date').val(),
            end_date: $('#msr_end_date').val(),
            period_ym: $('#msr_period_ym').val(),
            status: $('#msr_status').val(),
        };
    }

    var monthlyTable = $('#mosque_membership_monthly_table').DataTable({
        processing: true,
        serverSide: true,
        ajax: {
            url: '{{ route("mosque.subscriptions.reports.monthly") }}',
            data: function (d) {
                return $.extend({}, d, getFilters());
            }
        },
        dom: 'lBfrtip',
        buttons: [
            { extend: 'csv', text: '<i class="fas fa-file-csv"></i>', className: 'btn btn-success' },
            { extend: 'excel', text: '<i class="fas fa-file-excel"></i>', className: 'btn btn-info' },
            { extend: 'pdf', text: '<i class="fas fa-file-pdf"></i>', className: 'btn btn-danger' },
            { extend: 'print', text: '<i class="fas fa-print"></i>', className: 'btn btn-warning' },
            { extend: 'colvis', text: '<i class="fas fa-eye"></i>', className: 'btn btn-primary' }
        ],
        columns: [
            { data: 'month_ym', name: 'month_ym' },
            { data: 'payments_count', name: 'payments_count', searchable: false },
            { data: 'members_count', name: 'members_count', searchable: false },
            { data: 'total_amount', name: 'total_amount', orderable: false, searchable: false },
        ],
        drawCallback: function () {
            __currency_convert_recursively($('#mosque_membership_monthly_table'));
        }
    });

    var outstandingTable = $('#mosque_membership_outstanding_table').DataTable({
        processing: true,
        serverSide: true,
        ajax: {
            url: '{{ route("mosque.subscriptions.reports.outstanding") }}',
            data: function (d) {
                return $.extend({}, d, getFilters());
            }
        },
        dom: 'lBfrtip',
        buttons: [
            { extend: 'csv', text: '<i class="fas fa-file-csv"></i>', className: 'btn btn-success' },
            { extend: 'excel', text: '<i class="fas fa-file-excel"></i>', className: 'btn btn-info' },
            { extend: 'pdf', text: '<i class="fas fa-file-pdf"></i>', className: 'btn btn-danger' },
            { extend: 'print', text: '<i class="fas fa-print"></i>', className: 'btn btn-warning' },
            { extend: 'colvis', text: '<i class="fas fa-eye"></i>', className: 'btn btn-primary' }
        ],
        columns: [
            { data: 'period_ym', name: 'period_ym' },
            { data: 'member_name', name: 'member_name' },
            { data: 'member_phone', name: 'member_phone' },
            { data: 'plan_name', name: 'plan_name' },
            { data: 'status', name: 'status' },
            { data: 'due_amount', name: 'due_amount', orderable: false, searchable: false },
            { data: 'paid_amount', name: 'paid_amount', orderable: false, searchable: false },
            { data: 'balance_amount', name: 'balance_amount', orderable: false, searchable: false },
        ],
        drawCallback: function () {
            __currency_convert_recursively($('#mosque_membership_outstanding_table'));
        }
    });

    var historyTable = $('#mosque_membership_history_table').DataTable({
        processing: true,
        serverSide: true,
        ajax: {
            url: '{{ route("mosque.subscriptions.reports.history") }}',
            data: function (d) {
                return $.extend({}, d, getFilters());
            }
        },
        dom: 'lBfrtip',
        buttons: [
            { extend: 'csv', text: '<i class="fas fa-file-csv"></i>', className: 'btn btn-success' },
            { extend: 'excel', text: '<i class="fas fa-file-excel"></i>', className: 'btn btn-info' },
            { extend: 'pdf', text: '<i class="fas fa-file-pdf"></i>', className: 'btn btn-danger' },
            { extend: 'print', text: '<i class="fas fa-print"></i>', className: 'btn btn-warning' },
            { extend: 'colvis', text: '<i class="fas fa-eye"></i>', className: 'btn btn-primary' }
        ],
        columns: [
            { data: 'paid_on', name: 'paid_on' },
            { data: 'period_ym', name: 'period_ym' },
            { data: 'member_name', name: 'member_name' },
            { data: 'member_phone', name: 'member_phone' },
            { data: 'method', name: 'method' },
            { data: 'ref_no', name: 'ref_no' },
            { data: 'amount', name: 'amount', orderable: false, searchable: false },
            { data: 'action', name: 'action', orderable: false, searchable: false },
        ],
        drawCallback: function () {
            __currency_convert_recursively($('#mosque_membership_history_table'));
        }
    });

    monthlyTable.on('init.dt', function () {
        $('#mosque_membership_monthly_table_wrapper .dt-buttons').addClass('justify-content-center flex-wrap mb-2');
    });
    outstandingTable.on('init.dt', function () {
        $('#mosque_membership_outstanding_table_wrapper .dt-buttons').addClass('justify-content-center flex-wrap mb-2');
    });
    historyTable.on('init.dt', function () {
        $('#mosque_membership_history_table_wrapper .dt-buttons').addClass('justify-content-center flex-wrap mb-2');
    });

    $(document).on('change', '#msr_start_date, #msr_end_date, #msr_period_ym, #msr_status', function () {
        monthlyTable.ajax.reload();
        outstandingTable.ajax.reload();
        historyTable.ajax.reload();
    });
});
</script>
@endsection
