<div class="modal-dialog modal-lg" role="document">
    <div class="modal-content">
        {!! Form::open(['url' => route('mosque.pledges.store'), 'method' => 'post', 'id' => 'mosque_pledge_form']) !!}
        <div class="modal-header">
            <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
            <h4 class="modal-title">@lang('mosque::mosque.pledge_add')</h4>
        </div>
        <div class="modal-body">
            <div class="row">
                <div class="col-sm-6">
                    <div class="form-group">
                        <label>@lang('mosque::mosque.pledge_donor_contact')</label>
                        <select id="pledge_donor_contact_id" name="donor_contact_id" class="form-control" style="width:100%;"></select>
                        <p class="help-block">@lang('mosque::mosque.pledge_donor_contact_help')</p>
                    </div>
                </div>
                <div class="col-sm-6">
                    <div class="form-group">
                        <label>@lang('mosque::mosque.pledge_type')*</label>
                        <select name="type" class="form-control" required>
                            <option value="zakat">Zakat</option>
                            <option value="sadaqah">Sadaqah</option>
                            <option value="fitrah">Fitrah</option>
                            <option value="general">General</option>
                            <option value="event">Event</option>
                            <option value="waqf">Waqf</option>
                        </select>
                    </div>
                </div>
            </div>

            <div class="row">
                <div class="col-sm-4">
                    <div class="form-group">
                        <label>@lang('mosque::mosque.pledge_donor_name')</label>
                        <input type="text" name="donor_name" id="pledge_donor_name" class="form-control" placeholder="Donor name">
                    </div>
                </div>
                <div class="col-sm-4">
                    <div class="form-group">
                        <label>@lang('mosque::mosque.pledge_donor_phone')</label>
                        <input type="text" name="donor_phone" id="pledge_donor_phone" class="form-control" placeholder="Phone">
                    </div>
                </div>
                <div class="col-sm-4">
                    <div class="form-group">
                        <label>@lang('mosque::mosque.pledge_donor_email')</label>
                        <input type="email" name="donor_email" id="pledge_donor_email" class="form-control" placeholder="Email">
                    </div>
                </div>
            </div>

            <div class="row">
                <div class="col-sm-4">
                    <div class="form-group">
                        <label>@lang('mosque::mosque.pledge_commitment_date')</label>
                        <input type="text" name="commitment_date" class="form-control datepicker" placeholder="YYYY-MM-DD" value="{{ date('Y-m-d') }}" autocomplete="off">
                    </div>
                </div>
                <div class="col-sm-4">
                    <div class="form-group">
                        <label>@lang('mosque::mosque.pledge_due_date')</label>
                        <input type="text" name="due_date" class="form-control datepicker" placeholder="YYYY-MM-DD" autocomplete="off">
                    </div>
                </div>
            </div>

            <div class="row">
                <div class="col-sm-4">
                    <div class="form-group">
                        <label>@lang('mosque::mosque.pledge_cash_est')</label>
                        <input type="number" step="0.01" min="0" name="cash_amount" class="form-control" placeholder="0.00">
                        <p class="help-block">@lang('mosque::mosque.pledge_cash_help')</p>
                    </div>
                </div>
            </div>

            <hr>
            <div class="row">
                <div class="col-sm-12">
                    <div class="clearfix">
                        <strong>@lang('mosque::mosque.pledge_goods_items')</strong>
                        <button type="button" class="btn btn-xs btn-default pull-right" id="pledge_add_good_line"><i class="fa fa-plus"></i> @lang('lang_v1.add')</button>
                    </div>
                    <table class="table table-bordered" id="pledge_goods_table" style="margin-top:10px;">
                        <thead>
                            <tr>
                                <th>@lang('mosque::mosque.pledge_goods_name')</th>
                                <th>@lang('mosque::mosque.pledge_goods_unit')</th>
                                <th>@lang('mosque::mosque.pledge_goods_qty')</th>
                                <th>@lang('mosque::mosque.pledge_goods_est_unit_value')</th>
                                <th></th>
                            </tr>
                        </thead>
                        <tbody></tbody>
                    </table>
                </div>
            </div>

            <div class="row">
                <div class="col-sm-12">
                    <div class="form-group">
                        <label>@lang('mosque::mosque.pledge_notes')</label>
                        <textarea name="notes" class="form-control" rows="3"></textarea>
                    </div>
                </div>
            </div>
        </div>
        <div class="modal-footer">
            <button type="submit" class="btn btn-primary">@lang('messages.save')</button>
            <button type="button" class="btn btn-default" data-dismiss="modal">@lang('messages.close')</button>
        </div>
        {!! Form::close() !!}
    </div>
</div>

<script>
    (function () {
        var $modal = $('.mosque_pledge_modal');
        $modal.find('.datepicker').datepicker({ autoclose: true, format: 'yyyy-mm-dd' });

        $('#pledge_donor_contact_id').select2({
            width: '100%',
            allowClear: true,
            placeholder: 'Search member',
            dropdownParent: $modal,
            ajax: {
                url: '{{ route("mosque.pledges.contacts.search") }}',
                dataType: 'json',
                delay: 250,
                data: function (params) { return { q: params.term || '' }; },
                processResults: function (data) { return { results: (data && data.results) ? data.results : [] }; },
                cache: true
            }
        }).on('select2:select', function (e) {
            var d = e.params.data || {};
            if (d.name) { $('#pledge_donor_name').val(d.name); }
            if (d.phone) { $('#pledge_donor_phone').val(d.phone); }
            if (d.email) { $('#pledge_donor_email').val(d.email); }
        });

        function goodRow() {
            return '<tr>'
                + '<td><input type="text" name="goods_name[]" class="form-control" placeholder="e.g., Cement"></td>'
                + '<td><input type="text" name="goods_unit[]" class="form-control" placeholder="unit"></td>'
                + '<td><input type="number" step="0.001" min="0" name="goods_qty[]" class="form-control" placeholder="0"></td>'
                + '<td><input type="number" step="0.01" min="0" name="goods_est_unit_value[]" class="form-control" placeholder="0.00"></td>'
                + '<td><button type="button" class="btn btn-xs btn-danger pledge_remove_good_line"><i class="fa fa-times"></i></button></td>'
                + '</tr>';
        }

        $('#pledge_add_good_line').on('click', function () {
            $('#pledge_goods_table tbody').append(goodRow());
        });
        $(document).on('click', '.pledge_remove_good_line', function () {
            $(this).closest('tr').remove();
        });
    })();
</script>
