<div class="modal-dialog" role="document">
    <div class="modal-content">
        {!! Form::open(['url' => route('mosque.pledges.fulfill.store', [$pledge->id]), 'method' => 'post', 'id' => 'mosque_pledge_fulfill_form']) !!}
        <div class="modal-header">
            <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
            <h4 class="modal-title">@lang('mosque::mosque.pledge_fulfill') - {{ $pledge->pledge_code }}</h4>
        </div>
        <div class="modal-body">
            <p>
                <strong>@lang('mosque::mosque.pledge_balance'):</strong>
                <span class="display_currency" data-currency_symbol="true" data-orig-value="{{ $calc['balance'] ?? 0 }}">{{ $calc['balance'] ?? 0 }}</span>
            </p>

            <div class="row">
                <div class="col-sm-6">
                    <div class="form-group">
                        <label>@lang('mosque::mosque.pledge_fulfill_date')*</label>
                        <input type="text" name="date" class="form-control datepicker" value="{{ date('Y-m-d') }}" autocomplete="off" required>
                    </div>
                </div>
                <div class="col-sm-6">
                    <div class="form-group">
                        <label>@lang('mosque::mosque.pledge_channel')*</label>
                        <select name="channel" id="pledge_channel" class="form-control" required>
                            <option value="cash">Cash</option>
                            <option value="bank">Bank</option>
                            <option value="card">Card</option>
                            <option value="online">Online</option>
                            <option value="mfs">MFS</option>
                            <option value="in_kind" @if($pledge->type==='zakat') disabled @endif>In-kind</option>
                        </select>
                        @if($pledge->type==='zakat')
                            <p class="help-block">Zakat pledges are cash only.</p>
                        @endif
                    </div>
                </div>
            </div>

            <div class="row pledge_cash_block">
                <div class="col-sm-12">
                    <div class="form-group">
                        <label>@lang('mosque::mosque.pledge_amount')*</label>
                        <input type="number" step="0.01" min="0" name="amount_cash" class="form-control" placeholder="0.00">
                    </div>
                </div>
            </div>

            <div class="row pledge_goods_block" style="display:none;">
                <div class="col-sm-6">
                    <div class="form-group">
                        <label>@lang('mosque::mosque.pledge_goods_name')*</label>
                        <input type="text" name="goods_name" class="form-control">
                    </div>
                </div>
                <div class="col-sm-3">
                    <div class="form-group">
                        <label>@lang('mosque::mosque.pledge_goods_unit')</label>
                        <input type="text" name="unit" class="form-control">
                    </div>
                </div>
                <div class="col-sm-3">
                    <div class="form-group">
                        <label>@lang('mosque::mosque.pledge_goods_qty')*</label>
                        <input type="number" step="0.001" min="0" name="qty" class="form-control">
                    </div>
                </div>
                <div class="col-sm-12">
                    <div class="form-group">
                        <label>@lang('mosque::mosque.pledge_goods_est_value')</label>
                        <input type="number" step="0.01" min="0" name="est_value" class="form-control" placeholder="0.00">
                        <p class="help-block">In-kind does not post to Finance (v1).</p>
                    </div>
                </div>
            </div>

            <div class="row">
                <div class="col-sm-12">
                    <div class="form-group">
                        <label>@lang('mosque::mosque.pledge_remarks')</label>
                        <textarea name="remarks" class="form-control" rows="2"></textarea>
                    </div>
                </div>
            </div>
        </div>
        <div class="modal-footer">
            <button type="submit" class="btn btn-primary">@lang('messages.save')</button>
            <button type="button" class="btn btn-default" data-dismiss="modal">@lang('messages.close')</button>
        </div>
        {!! Form::close() !!}
    </div>
</div>

<script>
    (function () {
        var $modal = $('.mosque_pledge_fulfill_modal');
        $modal.find('.datepicker').datepicker({ autoclose: true, format: 'yyyy-mm-dd' });

        function toggleBlocks() {
            var ch = $('#pledge_channel').val();
            var isInKind = ch === 'in_kind';
            $('.pledge_cash_block').toggle(!isInKind);
            $('.pledge_goods_block').toggle(isInKind);
        }

        $(document).on('change', '#pledge_channel', toggleBlocks);
        toggleBlocks();
    })();
</script>

