<div class="modal-dialog" role="document">
    <div class="modal-content">
        {!! Form::open(['url' => route('mosque.pledges.goods.update', [$good->id]), 'method' => 'post', 'id' => 'mosque_goods_form']) !!}
        {!! Form::hidden('_method', 'put') !!}
        <div class="modal-header">
            <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
            <h4 class="modal-title">@lang('mosque::mosque.pledge_goods_edit')</h4>
        </div>
        <div class="modal-body">
            <div class="form-group">
                <label>@lang('mosque::mosque.pledge_goods_name')*</label>
                <input type="text" name="name" class="form-control" value="{{ $good->name }}" required>
            </div>
            <div class="form-group">
                <label>@lang('mosque::mosque.pledge_goods_unit')</label>
                <input type="text" name="unit" class="form-control" value="{{ $good->unit }}" placeholder="bag/ton/roll">
            </div>
            <div class="form-group">
                <label>@lang('mosque::mosque.pledge_goods_est_value')</label>
                <input type="number" step="0.01" min="0" name="default_est_value" class="form-control" value="{{ $good->default_est_value }}" placeholder="0.00">
            </div>
            <div class="checkbox">
                <label>
                    <input type="checkbox" name="is_active" value="1" @checked(!empty($good->is_active))> @lang('lang_v1.active')
                </label>
            </div>
        </div>
        <div class="modal-footer">
            <button type="submit" class="btn btn-primary">@lang('messages.update')</button>
            <button type="button" class="btn btn-default" data-dismiss="modal">@lang('messages.close')</button>
        </div>
        {!! Form::close() !!}
    </div>
</div>

