@extends('mosque::layouts.app')
@section('title', __('mosque::mosque.mosque') . ' | ' . __('mosque::mosque.pledge_goods'))

@section('content')
<section class="content-header">
    <h1 class="tw-text-xl md:tw-text-3xl tw-font-bold tw-text-black">@lang('mosque::mosque.pledge_goods')</h1>
</section>

<section class="content">
    @component('components.widget', ['class' => 'box-primary'])
        <div class="text-right">
            <button type="button" class="btn btn-primary btn-modal" data-href="{{ route('mosque.pledges.goods.create') }}" data-container=".mosque_goods_modal">
                <i class="fa fa-plus"></i> @lang('lang_v1.add')
            </button>
            <a href="{{ route('mosque.pledges') }}" class="btn btn-default">@lang('mosque::mosque.menu_pledges')</a>
        </div>
    @endcomponent

    @component('components.widget', ['class' => 'box-primary'])
        <div class="table-responsive">
            <table class="table table-bordered table-striped" id="mosque_goods_table" style="width:100%;">
                <thead>
                    <tr>
                        <th>@lang('mosque::mosque.pledge_goods_name')</th>
                        <th>@lang('mosque::mosque.pledge_goods_unit')</th>
                        <th>@lang('mosque::mosque.pledge_goods_est_value')</th>
                        <th>@lang('lang_v1.status')</th>
                        <th>@lang('messages.action')</th>
                    </tr>
                </thead>
            </table>
        </div>
    @endcomponent

    <div class="modal fade mosque_goods_modal" tabindex="-1" role="dialog"></div>
</section>
@endsection

@section('javascript')
<script>
    $(document).ready(function () {
        var table = $('#mosque_goods_table').DataTable({
            processing: true,
            serverSide: true,
            ajax: '{{ route("mosque.pledges.goods.data") }}',
            dom: 'lBfrtip',
            buttons: [
                { extend: 'csv', text: '<i class="fas fa-file-csv"></i>', className: 'btn btn-success' },
                { extend: 'excel', text: '<i class="fas fa-file-excel"></i>', className: 'btn btn-info' },
                { extend: 'pdf', text: '<i class="fas fa-file-pdf"></i>', className: 'btn btn-danger' },
                { extend: 'print', text: '<i class="fas fa-print"></i>', className: 'btn btn-warning' },
                { extend: 'colvis', text: '<i class="fas fa-eye"></i>', className: 'btn btn-primary' }
            ],
            columns: [
                { data: 'name', name: 'name' },
                { data: 'unit', name: 'unit' },
                { data: 'default_est_value', name: 'default_est_value', orderable: false, searchable: false },
                { data: 'is_active', name: 'is_active', orderable: false, searchable: false },
                { data: 'action', name: 'action', orderable: false, searchable: false },
            ],
            drawCallback: function () {
                __currency_convert_recursively($('#mosque_goods_table'));
            }
        });

        $('#mosque_goods_table_wrapper .dt-buttons').addClass('justify-content-center flex-wrap mb-2');

        $(document).on('submit', 'form#mosque_goods_form', function (e) {
            e.preventDefault();
            var $form = $(this);
            $.ajax({
                method: $form.find('input[name=_method]').val() || $form.attr('method'),
                url: $form.attr('action'),
                data: $form.serialize(),
                success: function (result) {
                    if (result.success) {
                        $('.mosque_goods_modal').modal('hide');
                        toastr.success(result.msg);
                        table.ajax.reload();
                    } else {
                        toastr.error(result.msg);
                    }
                },
                error: function () {
                    toastr.error('@lang("messages.something_went_wrong")');
                }
            });
        });

        $(document).on('click', '.delete_mosque_good', function (e) {
            e.preventDefault();
            var href = $(this).data('href');
            swal({ title: LANG.sure, icon: 'warning', buttons: true, dangerMode: true })
            .then((willDelete) => {
                if (willDelete) {
                    $.ajax({
                        method: 'DELETE',
                        url: href,
                        data: { _token: '{{ csrf_token() }}' },
                        success: function (result) {
                            if (result.success) {
                                toastr.success(result.msg);
                                table.ajax.reload();
                            } else {
                                toastr.error(result.msg);
                            }
                        }
                    });
                }
            });
        });
    });
</script>
@endsection
