@extends('mosque::layouts.app')
@section('title', __('mosque::mosque.mosque') . ' | ' . __('mosque::mosque.menu_pledges'))

@section('content')
<section class="content-header">
    <h1 class="tw-text-xl md:tw-text-3xl tw-font-bold tw-text-black">@lang('mosque::mosque.menu_pledges')</h1>
</section>

<section class="content">
    @component('components.widget', ['class' => 'box-primary'])
        <div class="row">
            <div class="col-sm-3">
                <div class="form-group">
                    <label>@lang('mosque::mosque.pledge_donor')</label>
                    <input type="text" id="pledge_donor_q" class="form-control" placeholder="Name/phone/pledge code">
                </div>
            </div>
            <div class="col-sm-2">
                <div class="form-group">
                    <label>@lang('mosque::mosque.pledge_type')</label>
                    <select id="pledge_type" class="form-control" style="width:100%;">
                        <option value="">@lang('lang_v1.all')</option>
                        <option value="zakat">Zakat</option>
                        <option value="sadaqah">Sadaqah</option>
                        <option value="fitrah">Fitrah</option>
                        <option value="general">General</option>
                        <option value="event">Event</option>
                        <option value="waqf">Waqf</option>
                    </select>
                </div>
            </div>
            <div class="col-sm-2">
                <div class="form-group">
                    <label>@lang('mosque::mosque.pledge_status')</label>
                    <select id="pledge_status" class="form-control">
                        <option value="">@lang('lang_v1.all')</option>
                        <option value="draft">Draft</option>
                        <option value="active">Active</option>
                        <option value="due_soon">Due soon</option>
                        <option value="overdue">Overdue</option>
                        <option value="partially_fulfilled">Partial</option>
                        <option value="fulfilled">Fulfilled</option>
                        <option value="cancelled">Cancelled</option>
                    </select>
                </div>
            </div>
            <div class="col-sm-4">
                <div class="form-group">
                    <label>@lang('report.date_range')</label>
                    <input type="text" id="pledge_date_range" class="form-control" readonly autocomplete="off" placeholder="@lang('lang_v1.select_a_date_range')">
                    <input type="hidden" id="pledge_start_date">
                    <input type="hidden" id="pledge_end_date">
                </div>
            </div>
            <div class="col-sm-1 text-right" style="padding-top: 25px;">
                <button type="button" class="btn btn-primary btn-modal" data-href="{{ route('mosque.pledges.create') }}" data-container=".mosque_pledge_modal">
                    <i class="fa fa-plus"></i>
                </button>
            </div>
        </div>
        <div class="row">
            <div class="col-sm-12">
                <div class="btn-group">
                    <button type="button" class="btn btn-default pledge_chip" data-chip="">All</button>
                    <button type="button" class="btn btn-default pledge_chip" data-chip="due7">Due in 7d</button>
                    <button type="button" class="btn btn-default pledge_chip" data-chip="due30">Due in 30d</button>
                    <button type="button" class="btn btn-default pledge_chip" data-chip="overdue">Overdue</button>
                </div>
                <a href="{{ route('mosque.pledges.goods') }}" class="btn btn-default pull-right">
                    <i class="fa fa-cubes"></i> @lang('mosque::mosque.pledge_goods')
                </a>
                <a href="{{ route('mosque.pledges.reports') }}" class="btn btn-default pull-right" style="margin-right:6px;">
                    <i class="fa fa-chart-bar"></i> Reports
                </a>
            </div>
        </div>
    @endcomponent

    @component('components.widget', ['class' => 'box-primary'])
        <div class="table-responsive">
            <table class="table table-bordered table-striped" id="mosque_pledges_table" style="width:100%;">
                <thead>
                    <tr>
                        <th>@lang('mosque::mosque.pledge_code')</th>
                        <th>@lang('mosque::mosque.pledge_donor')</th>
                        <th>@lang('mosque::mosque.pledge_type')</th>
                        <th>@lang('mosque::mosque.pledge_commitment_date')</th>
                        <th>@lang('mosque::mosque.pledge_due_date')</th>
                        <th>@lang('mosque::mosque.pledge_est_value')</th>
                        <th>@lang('mosque::mosque.pledge_fulfilled')</th>
                        <th>@lang('mosque::mosque.pledge_balance')</th>
                        <th>@lang('mosque::mosque.pledge_status')</th>
                        <th>@lang('messages.action')</th>
                    </tr>
                </thead>
            </table>
        </div>
    @endcomponent

    <div class="modal fade mosque_pledge_modal" tabindex="-1" role="dialog"></div>
    <div class="modal fade mosque_pledge_fulfill_modal" tabindex="-1" role="dialog"></div>
    <div class="modal fade mosque_goods_modal" tabindex="-1" role="dialog"></div>

    <div class="modal fade" id="mosque_pledge_confirm_modal" tabindex="-1" role="dialog">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                    <h4 class="modal-title" id="mosque_pledge_confirm_title">Confirm</h4>
                </div>
                <div class="modal-body">
                    <p id="mosque_pledge_confirm_msg">Type <strong>CONFIRM</strong> to proceed.</p>
                    <div class="form-group">
                        <input type="text" class="form-control" id="mosque_pledge_confirm_input" placeholder="CONFIRM" autocomplete="off">
                    </div>
                    <input type="hidden" id="mosque_pledge_confirm_action" value="">
                    <input type="hidden" id="mosque_pledge_confirm_url" value="">
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-danger" id="mosque_pledge_confirm_btn">@lang('messages.confirm')</button>
                    <button type="button" class="btn btn-default" data-dismiss="modal">@lang('messages.close')</button>
                </div>
            </div>
        </div>
    </div>
</section>
@endsection

@section('javascript')
<script type="text/javascript">
    $(document).ready(function () {
        $('.datepicker').datepicker({ autoclose: true, format: 'yyyy-mm-dd' });

        var activeChip = '';

        function getDefaultPledgeRange() {
            return {
                start: moment().startOf('year'),
                end: moment().endOf('year')
            };
        }

        function applyPledgeRange(range) {
            $('#pledge_start_date').val(range.start.format('YYYY-MM-DD'));
            $('#pledge_end_date').val(range.end.format('YYYY-MM-DD'));
            if ($('#pledge_date_range').length && typeof moment_date_format !== 'undefined') {
                $('#pledge_date_range').val(range.start.format(moment_date_format) + ' ~ ' + range.end.format(moment_date_format));
            }
        }

        applyPledgeRange(getDefaultPledgeRange());

        var table = $('#mosque_pledges_table').DataTable({
            processing: true,
            serverSide: true,
            ajax: {
                url: '{{ route("mosque.pledges.data") }}',
                data: function (d) {
                    d.donor_q = $('#pledge_donor_q').val();
                    d.type = $('#pledge_type').val();
                    d.status = $('#pledge_status').val();
                    d.start_date = $('#pledge_start_date').val();
                    d.end_date = $('#pledge_end_date').val();
                    d.chip = activeChip;
                }
            },
            dom: 'lBfrtip',
            buttons: [
                { extend: 'csv', text: '<i class="fas fa-file-csv"></i>', className: 'btn btn-success' },
                { extend: 'excel', text: '<i class="fas fa-file-excel"></i>', className: 'btn btn-info' },
                { extend: 'pdf', text: '<i class="fas fa-file-pdf"></i>', className: 'btn btn-danger' },
                { extend: 'print', text: '<i class="fas fa-print"></i>', className: 'btn btn-warning' },
                { extend: 'colvis', text: '<i class="fas fa-eye"></i>', className: 'btn btn-primary' }
            ],
            columns: [
                { data: 'pledge_code', name: 'pledge_code' },
                { data: 'donor_name', name: 'donor_name' },
                { data: 'type', name: 'type' },
                { data: 'commitment_date', name: 'commitment_date' },
                { data: 'due_date', name: 'due_date' },
                { data: 'est_total_value', name: 'est_total_value', orderable: false, searchable: false },
                { data: 'fulfilled_value', name: 'fulfilled_value', orderable: false, searchable: false },
                { data: 'balance', name: 'balance', orderable: false, searchable: false },
                { data: 'status', name: 'status', orderable: false, searchable: false },
                { data: 'action', name: 'action', orderable: false, searchable: false },
            ],
            drawCallback: function () {
                __currency_convert_recursively($('#mosque_pledges_table'));
            }
        });

        if (typeof dateRangeSettings !== 'undefined' && $('#pledge_date_range').length) {
            var drStart = moment($('#pledge_start_date').val(), 'YYYY-MM-DD');
            var drEnd = moment($('#pledge_end_date').val(), 'YYYY-MM-DD');
            $('#pledge_date_range').daterangepicker(
                $.extend({}, dateRangeSettings, { startDate: drStart, endDate: drEnd }),
                function (start, end) {
                    applyPledgeRange({ start: start, end: end });
                    table.ajax.reload();
                }
            );
            $('#pledge_date_range').on('cancel.daterangepicker', function () {
                var defaultRange = getDefaultPledgeRange();
                applyPledgeRange(defaultRange);
                var dr = $('#pledge_date_range').data('daterangepicker');
                if (dr) {
                    dr.setStartDate(defaultRange.start);
                    dr.setEndDate(defaultRange.end);
                }
                table.ajax.reload();
            });
        }

        $('#mosque_pledges_table_wrapper .dt-buttons').addClass('justify-content-center flex-wrap mb-2');

        $(document).on('keyup change', '#pledge_donor_q, #pledge_type, #pledge_status, #pledge_start_date, #pledge_end_date', _.debounce(function () {
            table.ajax.reload();
        }, 250));

        $(document).on('click', '.pledge_chip', function () {
            activeChip = $(this).data('chip') || '';
            $('.pledge_chip').removeClass('btn-primary').addClass('btn-default');
            $(this).removeClass('btn-default').addClass('btn-primary');
            table.ajax.reload();
        });

        function openConfirmModal(kind, url) {
            $('#mosque_pledge_confirm_action').val(kind);
            $('#mosque_pledge_confirm_url').val(url);
            $('#mosque_pledge_confirm_input').val('');
            if (kind === 'delete') {
                $('#mosque_pledge_confirm_title').text('Delete pledge');
                $('#mosque_pledge_confirm_msg').html('This will permanently delete the pledge and clear its history. Type <strong>CONFIRM</strong> to delete.');
                $('#mosque_pledge_confirm_btn').removeClass('btn-warning').addClass('btn-danger').text('@lang("messages.delete")');
            } else if (kind === 'cancel') {
                $('#mosque_pledge_confirm_title').text('Cancel pledge');
                $('#mosque_pledge_confirm_msg').html('This will cancel the pledge and clear fulfillment history. Type <strong>CONFIRM</strong> to cancel.');
                $('#mosque_pledge_confirm_btn').removeClass('btn-danger').addClass('btn-warning').text('Cancel');
            }
            $('#mosque_pledge_confirm_modal').modal('show');
        }

        $(document).on('click', '.delete_mosque_pledge', function (e) {
            e.preventDefault();
            openConfirmModal('delete', $(this).data('href'));
        });

        $(document).on('click', '.cancel_mosque_pledge', function (e) {
            e.preventDefault();
            openConfirmModal('cancel', $(this).data('href'));
        });

        $('#mosque_pledge_confirm_btn').on('click', function () {
            var txt = ($('#mosque_pledge_confirm_input').val() || '').trim().toUpperCase();
            if (txt !== 'CONFIRM') {
                toastr.error('Please type CONFIRM to proceed.');
                return;
            }
            var kind = $('#mosque_pledge_confirm_action').val();
            var url = $('#mosque_pledge_confirm_url').val();
            var token = $('meta[name="csrf-token"]').attr('content');

            var method = (kind === 'delete') ? 'DELETE' : 'POST';
            $.ajax({
                method: method,
                url: url,
                data: { _token: token },
                success: function (result) {
                    if (result.success) {
                        $('#mosque_pledge_confirm_modal').modal('hide');
                        toastr.success(result.msg);
                        table.ajax.reload();
                    } else {
                        toastr.error(result.msg);
                    }
                },
                error: function () {
                    toastr.error('@lang("messages.something_went_wrong")');
                }
            });
        });

        $(document).on('submit', 'form#mosque_pledge_form', function (e) {
            e.preventDefault();
            var $form = $(this);
            $.ajax({
                method: $form.find('input[name=_method]').val() || $form.attr('method'),
                url: $form.attr('action'),
                data: $form.serialize(),
                success: function (result) {
                    if (result.success) {
                        $('.mosque_pledge_modal').modal('hide');
                        toastr.success(result.msg);
                        table.ajax.reload();
                    } else {
                        toastr.error(result.msg);
                    }
                },
                error: function (xhr) {
                    toastr.error((xhr.responseJSON && xhr.responseJSON.message) ? xhr.responseJSON.message : '@lang("messages.something_went_wrong")');
                }
            });
        });

        $(document).on('submit', 'form#mosque_pledge_fulfill_form', function (e) {
            e.preventDefault();
            var $form = $(this);
            $.ajax({
                method: $form.attr('method'),
                url: $form.attr('action'),
                data: $form.serialize(),
                success: function (result) {
                    if (result.success) {
                        $('.mosque_pledge_fulfill_modal').modal('hide');
                        toastr.success(result.msg);
                        table.ajax.reload();
                    } else {
                        toastr.error(result.msg);
                    }
                },
                error: function () {
                    toastr.error('@lang("messages.something_went_wrong")');
                }
            });
        });

        $(document).on('click', '.mosque_pledge_remind', function (e) {
            e.preventDefault();
            var href = $(this).data('href');
            $.ajax({
                method: 'POST',
                url: href,
                data: { _token: '{{ csrf_token() }}' },
                success: function (result) {
                    if (result.success) {
                        toastr.success(result.msg);
                        if (result.whatsapp_link) {
                            window.open(result.whatsapp_link, '_blank');
                        }
                    } else {
                        toastr.error(result.msg);
                    }
                },
                error: function () {
                    toastr.error('@lang("messages.something_went_wrong")');
                }
            });
        });
    });
</script>
@endsection
