<!DOCTYPE html>
<html lang="{{ app()->getLocale() }}">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>{{ $receiptTitle ?? 'Pledge Receipt' }} - {{ $pledge->pledge_code }}</title>
    <style>
        body { font-family: Arial, sans-serif; color: #111; margin: 22px; }
        .no-print { text-align: right; margin-bottom: 10px; }
        .header { border-bottom: 2px solid #111; padding-bottom: 10px; margin-bottom: 14px; }
        .header h1 { margin: 0; font-size: 20px; }
        .muted { color: #666; font-size: 12px; }
        .grid { width: 100%; border-collapse: collapse; margin-top: 10px; }
        .grid td { padding: 7px 6px; vertical-align: top; }
        .label { width: 180px; color: #333; font-weight: bold; }
        .pill { display: inline-block; padding: 3px 10px; border-radius: 999px; font-size: 11px; font-weight: bold; border: 1px solid #ddd; }
        .pill.success { background: #e8f7ee; color: #1b5e20; border-color: #b7e1c3; }
        .pill.warning { background: #fff8e1; color: #6d4c41; border-color: #ffe0b2; }
        .pill.danger { background: #ffebee; color: #b71c1c; border-color: #ffcdd2; }
        .pill.default { background: #f5f5f5; color: #444; border-color: #ddd; }
        .table { width: 100%; border-collapse: collapse; margin-top: 12px; font-size: 12px; }
        .table th, .table td { border: 1px solid #ddd; padding: 7px 8px; }
        .table th { background: #f8f8f8; text-align: left; }
        .num { text-align: right; white-space: nowrap; }
        .footer { margin-top: 16px; padding-top: 10px; border-top: 1px solid #111; font-size: 12px; }
        .sig { margin-top: 22px; display: flex; justify-content: flex-end; }
        .sig .line { width: 220px; border-top: 1px solid #111; text-align: center; padding-top: 6px; font-weight: bold; }
        @media print { .no-print { display:none !important; } body { margin: 0; } }
    </style>
</head>
<body>
    <div class="no-print">
        <button type="button" onclick="window.print();">Print</button>
    </div>

    @php
        $businessName = (string) request()->session()->get('business.name') ?: (string) request()->session()->get('business.business_name') ?: 'Business';
        $headerName = !empty($profile) && !empty($profile->name) ? $profile->name : $businessName;

        $money = function ($amount) use ($settings) {
            return \Modules\Mosque\Utils\MosqueDocumentUtil::formatMoney($amount, $settings ?? []);
        };

        $donorName = (string) ($pledge->donor_name ?? '');
        $donorPhone = (string) ($pledge->donor_phone ?? '');
        $donorEmail = (string) ($pledge->donor_email ?? '');
        $waDigits = preg_replace('/\\D+/', '', $donorPhone);
        $waUrl = $waDigits !== '' ? ('https://wa.me/'.$waDigits) : null;

        $typeLabel = strtoupper((string) ($pledge->type ?? ''));
        $commitmentDate = !empty($pledge->commitment_date) ? (string) $pledge->commitment_date : (!empty($pledge->created_at) ? \Carbon\Carbon::parse($pledge->created_at)->format('Y-m-d') : '');
        $dueDate = !empty($pledge->due_date) ? (string) $pledge->due_date : '';

        $estTotal = (float) ($calc['est_total'] ?? $pledge->est_total_value ?? 0);
        $fulfilled = (float) ($calc['fulfilled'] ?? 0);
        $balance = (float) ($calc['balance'] ?? max($estTotal - $fulfilled, 0));

        $mosquePhone = !empty($profile) ? (string) ($profile->phone ?? '') : '';
        $mosqueEmail = !empty($profile) ? (string) ($profile->email ?? '') : '';
        $mosqueAddr = !empty($profile) ? (string) ($profile->address ?? '') : '';
        $mosqueReg = !empty($profile) ? (string) ($profile->reg_no ?? '') : '';
    @endphp

    <div class="header">
        <div style="display:flex;justify-content:space-between;align-items:center;gap:12px;">
            <div>
                <h1 style="margin:0;">{{ $receiptTitle ?? 'Pledge Receipt' }}</h1>
                <div class="muted">
                    {{ $headerName }} &nbsp;|&nbsp; Pledge: {{ $pledge->pledge_code }}
                </div>
            </div>
            @if(!empty($logoDataUri))
                <div>
                    <img src="{{ $logoDataUri }}" alt="Logo" style="max-height:60px;">
                </div>
            @endif
        </div>
    </div>

    <table class="grid">
        <tr>
            <td class="label">Status</td>
            <td><span class="pill {{ $statusClass ?? 'default' }}">{{ $statusText ?? '' }}</span></td>
        </tr>
        <tr>
            <td class="label">Donor</td>
            <td>{{ $donorName !== '' ? $donorName : '-' }}</td>
        </tr>
        <tr>
            <td class="label">Contact</td>
            <td>
                @if($donorPhone !== '')
                    {{ $donorPhone }}
                    @if(!empty($waUrl))
                        &nbsp;|&nbsp; WhatsApp: <a href="{{ $waUrl }}" target="_blank" rel="noopener">{{ $donorPhone }}</a>
                    @endif
                @else
                    -
                @endif
                @if($donorEmail !== '')
                    &nbsp;|&nbsp; {{ $donorEmail }}
                @endif
            </td>
        </tr>
        <tr>
            <td class="label">Type</td>
            <td>{{ $typeLabel !== '' ? $typeLabel : '-' }}</td>
        </tr>
        <tr>
            <td class="label">Commitment date</td>
            <td>{{ $commitmentDate !== '' ? $commitmentDate : '-' }}</td>
        </tr>
        <tr>
            <td class="label">Due date</td>
            <td>{{ $dueDate !== '' ? $dueDate : '-' }}</td>
        </tr>
        <tr>
            <td class="label">Estimated total</td>
            <td><strong>{{ $money($estTotal) }}</strong></td>
        </tr>
        <tr>
            <td class="label">Fulfilled</td>
            <td>{{ $money($fulfilled) }}</td>
        </tr>
        <tr>
            <td class="label">Balance</td>
            <td>{{ $money($balance) }}</td>
        </tr>
    </table>

    <table class="table">
        <thead>
            <tr>
                <th style="width:55%;">Items</th>
                <th style="width:15%;">Kind</th>
                <th class="num" style="width:30%;">Estimated value</th>
            </tr>
        </thead>
        <tbody>
            @php($hasRows = false)
            @foreach($items as $it)
                @php($hasRows = true)
                <tr>
                    <td>
                        @if($it->kind === 'cash')
                            Cash pledge
                        @else
                            {{ $it->goods_name ?? 'Goods' }}
                            @if(!empty($it->qty))
                                ({{ rtrim(rtrim(number_format((float) $it->qty, 3, '.', ''), '0'), '.') }}{{ !empty($it->unit) ? ' '.$it->unit : '' }})
                            @endif
                        @endif
                    </td>
                    <td>{{ strtoupper((string) $it->kind) }}</td>
                    <td class="num">{{ $money((float) ($it->est_line_value ?? 0)) }}</td>
                </tr>
            @endforeach
            @if(!$hasRows)
                <tr><td colspan="3">-</td></tr>
            @endif
        </tbody>
    </table>

    @if(!empty($fulfillments) && count($fulfillments) > 0)
        <table class="table">
            <thead>
                <tr>
                    <th style="width:18%;">Date</th>
                    <th style="width:18%;">Channel</th>
                    <th style="width:44%;">Details</th>
                    <th class="num" style="width:20%;">Value</th>
                </tr>
            </thead>
            <tbody>
                @foreach($fulfillments as $f)
                    <tr>
                        <td>{{ $f->date }}</td>
                        <td>{{ strtoupper((string) $f->channel) }}</td>
                        <td>
                            @if(in_array((string) $f->channel, ['cash','bank','card','online','mfs'], true))
                                Cash payment
                            @else
                                {{ $f->goods_name ?? 'In-kind' }}
                                @if(!empty($f->qty))
                                    ({{ rtrim(rtrim(number_format((float) $f->qty, 3, '.', ''), '0'), '.') }}{{ !empty($f->unit) ? ' '.$f->unit : '' }})
                                @endif
                            @endif
                            @if(!empty($f->remarks))
                                <div class="muted">{{ $f->remarks }}</div>
                            @endif
                        </td>
                        <td class="num">
                            @if(in_array((string) $f->channel, ['cash','bank','card','online','mfs'], true))
                                {{ $money((float) ($f->amount_cash ?? 0)) }}
                            @else
                                {{ $money((float) ($f->est_value ?? 0)) }}
                            @endif
                        </td>
                    </tr>
                @endforeach
            </tbody>
        </table>
    @endif

    @if(!empty($profile) && !empty($profile->header_text))
        <div class="muted" style="margin-top:12px;">
            {!! nl2br(e($profile->header_text)) !!}
        </div>
    @endif

    <div class="footer">
        <div style="display:flex;justify-content:space-between;gap:12px;align-items:flex-start;">
            <div>
                @if($mosqueAddr !== '')
                    <div>{{ $mosqueAddr }}</div>
                @endif
                <div class="muted">
                    @if($mosquePhone !== '') Contact: {{ $mosquePhone }} @endif
                    @if($mosqueEmail !== '') @if($mosquePhone !== '') | @endif Email: {{ $mosqueEmail }} @endif
                    @if($mosqueReg !== '') @if($mosquePhone !== '' || $mosqueEmail !== '') | @endif Reg#: {{ $mosqueReg }} @endif
                </div>
                <div class="muted">Computer generated receipt.</div>
            </div>
            <div class="sig">
                <div class="line">Authorized Signature</div>
            </div>
        </div>
    </div>
</body>
</html>

