@extends('mosque::layouts.app')
@section('title', __('mosque::mosque.mosque') . ' | Pledge Reports')

@section('content')
<section class="content-header">
    <h1 class="tw-text-xl md:tw-text-3xl tw-font-bold tw-text-black">Pledge Reports</h1>
</section>

<section class="content">
    @component('components.widget', ['class' => 'box-primary'])
        <div class="row">
            <div class="col-sm-12">
                <h4>Pledge Aging</h4>
                <div class="table-responsive">
                    <table class="table table-bordered table-striped" id="mosque_pledge_aging_table" style="width:100%;">
                        <thead>
                            <tr>
                                <th>Pledge Code</th>
                                <th>Type</th>
                                <th>Due date</th>
                                <th>Days overdue</th>
                                <th>Bucket</th>
                                <th>Est</th>
                                <th>Fulfilled</th>
                                <th>Balance</th>
                            </tr>
                        </thead>
                    </table>
                </div>
            </div>
        </div>
        <div class="row">
            <div class="col-sm-12 text-right" style="margin-top:10px;">
                <a href="{{ route('mosque.pledges') }}" class="btn btn-default">@lang('mosque::mosque.menu_pledges')</a>
            </div>
        </div>
    @endcomponent
</section>
@endsection

@section('javascript')
<script>
    $(document).ready(function () {
        var aging = $('#mosque_pledge_aging_table').DataTable({
            processing: true,
            serverSide: true,
            ajax: '{{ route("mosque.pledges.reports.aging") }}',
            dom: 'lBfrtip',
            buttons: [
                { extend: 'csv', text: '<i class="fas fa-file-csv"></i>', className: 'btn btn-success' },
                { extend: 'excel', text: '<i class="fas fa-file-excel"></i>', className: 'btn btn-info' },
                { extend: 'pdf', text: '<i class="fas fa-file-pdf"></i>', className: 'btn btn-danger' },
                { extend: 'print', text: '<i class="fas fa-print"></i>', className: 'btn btn-warning' }
            ],
            columns: [
                { data: 'pledge_code', name: 'pledge_code' },
                { data: 'type', name: 'type' },
                { data: 'due_date', name: 'due_date' },
                { data: 'days_overdue', name: 'days_overdue' },
                { data: 'bucket', name: 'bucket', orderable: false, searchable: false },
                { data: 'est_total_value', name: 'est_total_value', orderable: false, searchable: false },
                { data: 'fulfilled_value', name: 'fulfilled_value', orderable: false, searchable: false },
                { data: 'balance', name: 'balance', orderable: false, searchable: false },
            ],
            drawCallback: function () { __currency_convert_recursively($('#mosque_pledge_aging_table')); }
        });
    });
</script>
@endsection
