@extends('mosque::layouts.app')
@section('title', __('mosque::mosque.mosque') . ' | ' . __('mosque::mosque.menu_reports'))

@section('content')
<section class="content-header">
    <h1 class="tw-text-xl md:tw-text-3xl tw-font-bold tw-text-black">@lang('mosque::mosque.menu_reports')</h1>
</section>

<section class="content">
    @component('components.widget', ['class' => 'box-primary'])
        <div class="row">
            <div class="col-sm-6">
                <div class="list-group">
                    <a class="list-group-item" href="{{ route('mosque.members') }}">Members</a>
                    <a class="list-group-item" href="{{ route('mosque.members.reports') }}">Members Reports</a>
                    <a class="list-group-item" href="{{ route('mosque.families') }}">Families</a>
                    <a class="list-group-item" href="{{ route('mosque.families.reports') }}">Families Reports</a>
                    <a class="list-group-item" href="{{ route('mosque.subscriptions.fees') }}">Membership Fees</a>
                    <a class="list-group-item" href="{{ route('mosque.subscriptions.payments') }}">Membership Payments</a>
                    <a class="list-group-item" href="{{ route('mosque.subscriptions.reports') }}">Membership Reports</a>
                    <a class="list-group-item" href="{{ route('mosque.donations') }}">Donations</a>
                    <a class="list-group-item" href="{{ route('mosque.donations.reports') }}">Donations Reports</a>
                    <a class="list-group-item" href="{{ route('mosque.donors') }}">Donors</a>
                    <a class="list-group-item" href="{{ route('mosque.marriage') }}">Marriage Register</a>
                    <a class="list-group-item" href="{{ route('mosque.marriage.reports') }}">Marriage Reports</a>
                    <a class="list-group-item" href="{{ route('mosque.death') }}">Death Register</a>
                    <a class="list-group-item" href="{{ route('mosque.death.reports') }}">Death Reports</a>
                </div>
            </div>
            <div class="col-sm-6">
                <div class="list-group">
                    <a class="list-group-item" href="{{ route('mosque.finance') }}">Finance (Unified)</a>
                    <a class="list-group-item" href="{{ route('mosque.finance.categories') }}">Finance Categories</a>
                    <a class="list-group-item" href="{{ route('mosque.committee') }}">Executive Committee</a>
                    <a class="list-group-item" href="{{ route('mosque.committee') }}#tab_reports">Committee Reports</a>
                    <a class="list-group-item" href="{{ route('mosque.staff') }}">Staff</a>
                    <a class="list-group-item" href="{{ route('mosque.staff') }}#tab_reports">Staff Reports</a>
                    <a class="list-group-item" href="{{ route('mosque.assets') }}">Assets & Property</a>
                    <a class="list-group-item" href="{{ route('mosque.assets') }}#tab_reports">Assets Reports</a>
                    <a class="list-group-item" href="{{ route('mosque.events') }}">Events</a>
                    <a class="list-group-item" href="{{ route('mosque.events') }}#tab_reports">Events Reports</a>
                    <a class="list-group-item" href="{{ route('mosque.audit') }}">Audit Logs</a>
                </div>
            </div>
        </div>
        <p class="text-muted">All lists are business-scoped; finance includes module + core sales/purchases (read-only).</p>
    @endcomponent
</section>
@endsection
