<div class="modal-dialog" role="document">
    <div class="modal-content">
        <style>
            .mosque-advance-modal .modal-header { background: linear-gradient(135deg,#7c3aed,#0ea5a0); color:#fff; }
            .mosque-advance-modal .modal-title { color:#fff; }
            .mosque-advance-modal .modal-body { background: linear-gradient(180deg,#eff8ff,#eef2ff); }
            .mosque-advance-modal .form-control { background:#eef2ff; border:1px solid #c7d2fe; border-radius:14px; box-shadow: 0 6px 16px rgba(2,6,23,0.06); }
            .mosque-advance-modal .form-control:focus { border-color:#60a5fa; box-shadow: 0 0 0 3px rgba(124,58,237,0.18); }
            .mosque-advance-modal .select2-container { width: 100% !important; }
            .mosque-advance-modal .select2-container--default .select2-selection--single { background:#eef2ff; border:1px solid #c7d2fe; border-radius:14px; height: 34px; }
            .mosque-advance-modal .select2-container--default .select2-selection--single .select2-selection__rendered { line-height: 32px; }
            .mosque-advance-modal .select2-container--default .select2-selection--single .select2-selection__arrow { height: 32px; }
        </style>
        {!! Form::open(['url' => route('mosque.staff.advances.store'), 'method' => 'post', 'id' => 'mosque_advance_form']) !!}
        <div class="modal-header mosque-advance-modal">
            <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
            <h4 class="modal-title">Add Advance Payment</h4>
        </div>
        <div class="modal-body mosque-advance-modal">
            <div class="row">
                <div class="col-sm-6">
                    <div class="form-group">
                        {!! Form::label('staff_id', 'Staff:*') !!}
                        {!! Form::select('staff_id', $staff, null, ['class' => 'form-control select2', 'required', 'placeholder' => __('lang_v1.none')]) !!}
                    </div>
                </div>
                <div class="col-sm-6">
                    <div class="form-group">
                        {!! Form::label('paid_on', 'Advance date:*') !!}
                        {!! Form::date('paid_on', now()->format('Y-m-d'), ['class' => 'form-control', 'required']) !!}
                    </div>
                </div>
                <div class="col-sm-6">
                    <div class="form-group">
                        {!! Form::label('amount', 'Amount:*') !!}
                        {!! Form::number('amount', null, ['class' => 'form-control', 'step' => '0.01', 'min' => '0.01', 'required']) !!}
                    </div>
                </div>
                <div class="col-sm-6">
                    <div class="form-group">
                        {!! Form::label('payment_method', 'Payment method:') !!}
                        <select name="payment_method" class="form-control">
                            <option value="">@lang('lang_v1.none')</option>
                            <option value="cash">Cash</option>
                            <option value="bank_transfer">Bank Transfer</option>
                            <option value="card">Card</option>
                            <option value="cheque">Cheque</option>
                            <option value="other">Other</option>
                        </select>
                    </div>
                </div>
                <div class="col-sm-6">
                    <div class="form-group">
                        {!! Form::label('payment_ref_no', 'Reference no:') !!}
                        {!! Form::text('payment_ref_no', null, ['class' => 'form-control']) !!}
                    </div>
                </div>
                <div class="col-sm-12">
                    <div class="form-group">
                        {!! Form::label('note', 'Note:') !!}
                        {!! Form::textarea('note', null, ['class' => 'form-control', 'rows' => 2]) !!}
                    </div>
                </div>
            </div>
        </div>
        <div class="modal-footer">
            <button type="submit" class="btn btn-primary">@lang('messages.save')</button>
            <button type="button" class="btn btn-default" data-dismiss="modal">@lang('messages.close')</button>
        </div>
        {!! Form::close() !!}
    </div>
</div>

<script>
    (function () {
        try {
            if ($.fn.select2) {
                $('#mosque_advance_form .select2').select2({ width: '100%', dropdownParent: $('#mosque_advance_form').closest('.modal') });
            }
        } catch (e) {}
    })();
</script>
