<div class="modal-dialog" role="document">
    <div class="modal-content">
        {!! Form::open(['url' => route('mosque.staff.attendance.store'), 'method' => 'post', 'id' => 'mosque_attendance_form', 'novalidate' => 'novalidate']) !!}
        <div class="modal-header">
            <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
            <h4 class="modal-title">@lang('messages.add')</h4>
        </div>
        <div class="modal-body">
            <div class="row">
                <div class="col-sm-12">
                    <div class="form-group">
                        {!! Form::label('staff_id', 'Staff:*') !!}
                        {!! Form::select('staff_id', $staff, null, ['class' => 'form-control', 'required', 'placeholder' => __('lang_v1.none')]) !!}
                    </div>
                </div>
                <div class="col-sm-6">
                    <div class="form-group">
                        {!! Form::label('in_at', 'In:*') !!}
                        {!! Form::text('in_at', \Carbon\Carbon::now()->format('Y-m-d H:i'), ['class' => 'form-control mosque-datetime', 'required', 'autocomplete' => 'off']) !!}
                    </div>
                </div>
                <div class="col-sm-6">
                    <div class="form-group">
                        {!! Form::label('out_at', 'Out:') !!}
                        {!! Form::text('out_at', \Carbon\Carbon::now()->format('Y-m-d H:i'), ['class' => 'form-control mosque-datetime', 'autocomplete' => 'off']) !!}
                    </div>
                </div>
                <div class="col-sm-12">
                    <p class="text-muted">Manual attendance entry (QR attendance can be added later).</p>
                </div>
            </div>
        </div>
        <div class="modal-footer">
            <button type="submit" class="btn btn-primary">@lang('messages.save')</button>
            <button type="button" class="btn btn-default" data-dismiss="modal">@lang('messages.close')</button>
        </div>
        {!! Form::close() !!}
    </div>
</div>

<script>
    $(function () {
        var $modal = $('.mosque_attendance_modal:visible');
        var $scope = $modal.length ? $modal : $(document);
        var $in = $scope.find('input[name="in_at"].mosque-datetime');
        var $out = $scope.find('input[name="out_at"].mosque-datetime');

        if ($.fn.datetimepicker) {
            var format = 'YYYY-MM-DD HH:mm';
            $in.datetimepicker({
                format: format,
                ignoreReadonly: true,
                useCurrent: true,
                showClear: true,
                showClose: true,
                stepping: 1
            });
            $out.datetimepicker({
                format: format,
                ignoreReadonly: true,
                useCurrent: true,
                showClear: true,
                showClose: true,
                stepping: 1
            });

            // Keep OUT >= IN (when both set)
            $in.on('dp.change', function (e) {
                if (e && e.date) {
                    $out.data('DateTimePicker').minDate(e.date);
                } else {
                    $out.data('DateTimePicker').minDate(false);
                }
            });
        }
    });
</script>
