<div class="modal-dialog" role="document">
    <div class="modal-content">
        {!! Form::open(['url' => route('mosque.staff.attendance.update', [$attendance->id]), 'method' => 'put', 'id' => 'mosque_attendance_form', 'novalidate' => 'novalidate']) !!}
        <div class="modal-header">
            <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
            <h4 class="modal-title">Clock Out</h4>
        </div>
        <div class="modal-body">
            <div class="row">
                <div class="col-sm-12">
                    <div class="form-group">
                        <label>Staff</label>
                        <input type="text" class="form-control" value="{{ $staff->name }} ({{ $staff->designation ?? '-' }})" readonly>
                    </div>
                </div>
                <div class="col-sm-6">
                    <div class="form-group">
                        <label>In</label>
                        <input type="text" class="form-control" value="{{ \Carbon\Carbon::parse($attendance->in_at)->format('Y-m-d H:i') }}" readonly>
                    </div>
                </div>
                <div class="col-sm-6">
                    <div class="form-group">
                        <label>Out:*</label>
                        {!! Form::text('out_at', \Carbon\Carbon::now()->format('Y-m-d H:i'), ['class' => 'form-control mosque-datetime', 'required', 'autocomplete' => 'off']) !!}
                    </div>
                </div>
            </div>
        </div>
        <div class="modal-footer">
            <button type="submit" class="btn btn-primary">@lang('messages.save')</button>
            <button type="button" class="btn btn-default" data-dismiss="modal">@lang('messages.close')</button>
        </div>
        {!! Form::close() !!}
    </div>
</div>

<script>
    $(function () {
        var $modal = $('.mosque_attendance_modal:visible');
        var $scope = $modal.length ? $modal : $(document);
        var $out = $scope.find('input[name="out_at"].mosque-datetime');
        if ($.fn.datetimepicker) {
            $out.datetimepicker({
                format: 'YYYY-MM-DD HH:mm',
                ignoreReadonly: true,
                useCurrent: true,
                showClear: true,
                showClose: true,
                stepping: 1
            });
        }
    });
</script>
