@extends('mosque::layouts.app')
@section('title', __('mosque::mosque.mosque') . ' | ' . __('mosque::mosque.menu_staff'))

@section('content')
<section class="content-header">
    <h1 class="tw-text-xl md:tw-text-3xl tw-font-bold tw-text-black">@lang('mosque::mosque.menu_staff')</h1>
</section>

<section class="content">
    @component('components.widget', ['class' => 'box-primary'])
        <ul class="nav nav-tabs">
            <li class="active"><a href="#tab_staff" data-toggle="tab">Staff</a></li>
            <li><a href="#tab_staff_roles" data-toggle="tab">Roles</a></li>
            <li><a href="#tab_attendance" data-toggle="tab">Attendance</a></li>
            <li><a href="#tab_leaves" data-toggle="tab">Leaves</a></li>
            <li><a href="#tab_leave_types" data-toggle="tab">Leave Types</a></li>
            <li><a href="#tab_advances" data-toggle="tab">Advances</a></li>
            <li><a href="#tab_payslips" data-toggle="tab">Payslips</a></li>
            <li><a href="#tab_reports" data-toggle="tab">@lang('mosque::mosque.menu_staff_reports')</a></li>
        </ul>

        <div class="tab-content" style="margin-top:15px;">
            <div class="tab-pane active" id="tab_staff">
                <div class="row">
                    <div class="col-sm-12 text-right">
                        <button type="button" class="btn btn-primary btn-modal" data-href="{{ route('mosque.staff.create') }}" data-container=".mosque_staff_modal">
                            <i class="fa fa-plus"></i> @lang('messages.add')
                        </button>
                    </div>
                </div>

                <div class="table-responsive" style="margin-top:10px;">
                    <table class="table table-bordered table-striped" id="mosque_staff_table" style="width:100%;">
                        <thead>
                            <tr>
                                <th>Picture</th>
                                <th>@lang('user.name')</th>
                                <th>Designation</th>
                                <th>@lang('contact.mobile')</th>
                                <th>WhatsApp</th>
                                <th>@lang('business.email')</th>
                                <th>Salary</th>
                                <th>Status</th>
                                <th>@lang('messages.action')</th>
                            </tr>
                        </thead>
                    </table>
                </div>
            </div>

            <div class="tab-pane" id="tab_staff_roles">
                <div class="row">
                    <div class="col-sm-12 text-right">
                        <button type="button" class="btn btn-primary btn-modal" data-href="{{ route('mosque.staff.roles.create') }}" data-container=".mosque_staff_role_modal">
                            <i class="fa fa-plus"></i> @lang('messages.add')
                        </button>
                    </div>
                </div>

                <div class="table-responsive" style="margin-top:10px;">
                    <table class="table table-bordered table-striped" id="mosque_staff_roles_table" style="width:100%;">
                        <thead>
                            <tr>
                                <th>Role/Designation</th>
                                <th>Active</th>
                                <th>Sort</th>
                                <th>@lang('messages.action')</th>
                            </tr>
                        </thead>
                    </table>
                </div>
            </div>

            <div class="tab-pane" id="tab_attendance">
                <div class="row" style="margin-bottom:10px;">
                    <div class="col-sm-4">
                        <div class="form-group">
                            <label>Filter staff</label>
                            <select id="mosque_att_staff_filter" class="form-control select2" style="width:100%;"></select>
                        </div>
                    </div>
                    <div class="col-sm-4">
                        <div class="form-group">
                            <label>@lang('lang_v1.start_date')</label>
                            <input type="date" id="mosque_att_start" class="form-control">
                        </div>
                    </div>
                    <div class="col-sm-4">
                        <div class="form-group">
                            <label>@lang('lang_v1.end_date')</label>
                            <input type="date" id="mosque_att_end" class="form-control">
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-sm-12 text-right">
                        <a href="{{ route('mosque.attendance.qr') }}" class="btn btn-default">
                            <i class="fa fa-qrcode"></i> QR Attendance
                        </a>
                        <button type="button" class="btn btn-primary btn-modal" data-href="{{ route('mosque.staff.attendance.create') }}" data-container=".mosque_attendance_modal">
                            <i class="fa fa-plus"></i> @lang('messages.add')
                        </button>
                    </div>
                </div>

                <div class="table-responsive" style="margin-top:10px;">
                            <table class="table table-bordered table-striped" id="mosque_staff_attendance_table" style="width:100%;">
                                <thead>
                                    <tr>
                                        <th>Staff</th>
                                        <th>Designation</th>
                                        <th>In</th>
                                        <th>Out</th>
                                        <th>Worked</th>
                                        <th>Source</th>
                                        <th>@lang('messages.action')</th>
                                    </tr>
                                </thead>
                            </table>
                </div>
            </div>

            <div class="tab-pane" id="tab_leaves">
                <div class="row" style="margin-bottom:10px;">
                    <div class="col-sm-3">
                        <div class="form-group">
                            <label>Filter staff</label>
                            <select id="mosque_leave_staff_filter" class="form-control select2" style="width:100%;"></select>
                        </div>
                    </div>
                    <div class="col-sm-2">
                        <div class="form-group">
                            <label>Status</label>
                            <select id="mosque_leave_status_filter" class="form-control">
                                <option value="">All</option>
                                <option value="pending">Pending</option>
                                <option value="approved">Approved</option>
                                <option value="rejected">Rejected</option>
                            </select>
                        </div>
                    </div>
                    <div class="col-sm-3">
                        <div class="form-group">
                            <label>Leave type</label>
                            <select id="mosque_leave_type_filter" class="form-control select2" style="width:100%;">
                                <option value="">All</option>
                                @if(!empty($leaveTypes))
                                    @foreach($leaveTypes as $ltId => $ltName)
                                        <option value="{{ $ltId }}">{{ $ltName }}</option>
                                    @endforeach
                                @endif
                            </select>
                        </div>
                    </div>
                    <div class="col-sm-2">
                        <div class="form-group">
                            <label>@lang('lang_v1.start_date')</label>
                            <input type="text" id="mosque_leave_start" class="form-control mosque_leave_datepicker" readonly placeholder="dd-mm-yyyy">
                        </div>
                    </div>
                    <div class="col-sm-2">
                        <div class="form-group">
                            <label>@lang('lang_v1.end_date')</label>
                            <input type="text" id="mosque_leave_end" class="form-control mosque_leave_datepicker" readonly placeholder="dd-mm-yyyy">
                        </div>
                    </div>
                </div>

                <div class="row">
                    <div class="col-sm-12 text-right">
                        <button type="button" class="btn btn-primary btn-modal" data-href="{{ route('mosque.staff.leaves.create') }}" data-container=".mosque_leave_modal">
                            <i class="fa fa-plus"></i> @lang('messages.add')
                        </button>
                    </div>
                </div>

                <div class="table-responsive" style="margin-top:10px;">
                    <table class="table table-bordered table-striped" id="mosque_staff_leaves_table" style="width:100%;">
                        <thead>
                            <tr>
                                <th>Staff</th>
                                <th>Designation</th>
                                <th>Type</th>
                                <th>From</th>
                                <th>To</th>
                                <th>Days</th>
                                <th>Status</th>
                                <th>Reason</th>
                                <th>@lang('messages.action')</th>
                            </tr>
                        </thead>
                    </table>
                </div>
            </div>

            <div class="tab-pane" id="tab_leave_types">
                <div class="row">
                    <div class="col-sm-12 text-right">
                        <button type="button" class="btn btn-primary btn-modal" data-href="{{ route('mosque.staff.leave_types.create') }}" data-container=".mosque_leave_type_modal">
                            <i class="fa fa-plus"></i> @lang('messages.add')
                        </button>
                    </div>
                </div>

                <div class="table-responsive" style="margin-top:10px;">
                    <table class="table table-bordered table-striped" id="mosque_leave_types_table" style="width:100%;">
                        <thead>
                            <tr>
                                <th>Name</th>
                                <th>Paid</th>
                                <th>Active</th>
                                <th>@lang('messages.action')</th>
                            </tr>
                        </thead>
                    </table>
                </div>
            </div>

            <div class="tab-pane" id="tab_advances">
                <div class="row">
                    <div class="col-sm-12 text-right">
                        <button type="button" class="btn btn-primary btn-modal" data-href="{{ route('mosque.staff.advances.create') }}" data-container=".mosque_advance_modal">
                            <i class="fa fa-plus"></i> @lang('messages.add')
                        </button>
                    </div>
                </div>

                <div class="row" style="margin-top:10px;">
                    <div class="col-sm-4">
                        <div class="form-group">
                            <label>Filter staff</label>
                            <select id="mosque_adv_staff_id" class="form-control select2" style="width:100%;"></select>
                        </div>
                    </div>
                    <div class="col-sm-4">
                        <div class="form-group">
                            <label>From date</label>
                            <input type="date" id="mosque_adv_start" class="form-control">
                        </div>
                    </div>
                    <div class="col-sm-4">
                        <div class="form-group">
                            <label>To date</label>
                            <input type="date" id="mosque_adv_end" class="form-control">
                        </div>
                    </div>
                </div>

                <div class="table-responsive" style="margin-top:10px;">
                    <table class="table table-bordered table-striped" id="mosque_staff_advances_table" style="width:100%;">
                        <thead>
                            <tr>
                                <th>Staff</th>
                                <th>Designation</th>
                                <th>Advance date</th>
                                <th>Amount</th>
                                <th>Adjusted</th>
                                <th>Balance</th>
                                <th>Adjusted in</th>
                                <th>Method</th>
                                <th>Ref</th>
                                <th>@lang('messages.action')</th>
                            </tr>
                        </thead>
                    </table>
                </div>
                <p class="help-block" style="margin-top:8px;">Advance payments will be auto-adjusted in upcoming payslips (deduction) when you create payroll.</p>
            </div>

            <div class="tab-pane" id="tab_payslips">
                <div class="row">
                    <div class="col-sm-12 text-right">
                        <button type="button" class="btn btn-primary btn-modal" data-href="{{ route('mosque.staff.payslips.create') }}" data-container=".mosque_payslip_modal">
                            <i class="fa fa-plus"></i> @lang('messages.add')
                        </button>
                    </div>
                </div>

                <div class="row" style="margin-top:10px;">
                    <div class="col-sm-6">
                        <div class="form-group">
                            <label>Filter staff</label>
                            <select id="mosque_payslip_staff_filter" class="form-control select2" style="width:100%;"></select>
                        </div>
                    </div>
                    <div class="col-sm-6">
                        <div class="form-group">
                            <label>Filter period (YYYY-MM)</label>
                            <input type="text" id="mosque_payslip_period_filter" class="form-control" placeholder="2025-12" autocomplete="off">
                        </div>
                    </div>
                </div>

                <div class="table-responsive" style="margin-top:10px;">
                    <table class="table table-bordered table-striped" id="mosque_payslips_table" style="width:100%;">
                        <thead>
                            <tr>
                                <th>Staff</th>
                                <th>Period</th>
                                <th>Gross</th>
                                <th>Net</th>
                                <th>Status</th>
                                <th>Paid On</th>
                                <th>@lang('messages.action')</th>
                            </tr>
                        </thead>
                    </table>
                </div>
            </div>

            <div class="tab-pane" id="tab_reports">
                <div class="row">
                    <div class="col-sm-3">
                        <div class="form-group">
                            <label>@lang('lang_v1.start_date')</label>
                            <input type="date" id="msr_start_date" class="form-control" value="{{ now()->startOfMonth()->format('Y-m-d') }}">
                        </div>
                    </div>
                    <div class="col-sm-3">
                        <div class="form-group">
                            <label>@lang('lang_v1.end_date')</label>
                            <input type="date" id="msr_end_date" class="form-control" value="{{ now()->endOfMonth()->format('Y-m-d') }}">
                        </div>
                    </div>
                    <div class="col-sm-3">
                        <div class="form-group">
                            <label>Source</label>
                            <select id="msr_source" class="form-control">
                                <option value="">@lang('lang_v1.all')</option>
                                <option value="manual">Manual</option>
                                <option value="qr">QR</option>
                            </select>
                            <p class="help-block">Used on Attendance Summary.</p>
                        </div>
                    </div>
                    <div class="col-sm-3">
                        <div class="form-group">
                            <label>Period (YYYY-MM)</label>
                            <input type="text" id="msr_period_ym" class="form-control" placeholder="2025-01">
                            <p class="help-block">Used on Salary Register.</p>
                        </div>
                    </div>
                </div>

                <ul class="nav nav-pills" style="margin-bottom:10px;">
                    <li class="active"><a href="#tab_reports_attendance" data-toggle="tab">Attendance Summary</a></li>
                    <li><a href="#tab_reports_salary" data-toggle="tab">Salary Register</a></li>
                </ul>

                <div class="tab-content">
                    <div class="tab-pane active" id="tab_reports_attendance">
                        <div class="table-responsive">
                            <table class="table table-bordered table-striped" id="mosque_staff_attendance_summary_table" style="width:100%;">
                                <thead>
                                    <tr>
                                        <th>Staff</th>
                                        <th>Designation</th>
                                        <th>Punches</th>
                                        <th>Days</th>
                                        <th>Worked Hours</th>
                                        <th>Last In</th>
                                    </tr>
                                </thead>
                            </table>
                        </div>
                    </div>

                    <div class="tab-pane" id="tab_reports_salary">
                        <div class="table-responsive">
                            <table class="table table-bordered table-striped" id="mosque_staff_salary_register_table" style="width:100%;">
                                <thead>
                                    <tr>
                                        <th>Period</th>
                                        <th>Staff</th>
                                        <th>Designation</th>
                                        <th>Payslips</th>
                                        <th>Paid Count</th>
                                        <th>Gross Total</th>
                                        <th>Net Total</th>
                                        <th>Paid Total</th>
                                    </tr>
                                </thead>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    @endcomponent

    <div class="modal fade mosque_staff_modal" tabindex="-1" role="dialog" aria-labelledby="gridSystemModalLabel"></div>
    <div class="modal fade mosque_staff_role_modal" tabindex="-1" role="dialog" aria-labelledby="gridSystemModalLabel"></div>
    <div class="modal fade mosque_attendance_modal" tabindex="-1" role="dialog" aria-labelledby="gridSystemModalLabel"></div>
    <div class="modal fade mosque_leave_modal" tabindex="-1" role="dialog" aria-labelledby="gridSystemModalLabel"></div>
    <div class="modal fade mosque_leave_type_modal" tabindex="-1" role="dialog" aria-labelledby="gridSystemModalLabel"></div>
    <div class="modal fade mosque_advance_modal" tabindex="-1" role="dialog" aria-labelledby="gridSystemModalLabel"></div>
    <div class="modal fade mosque_payslip_modal" tabindex="-1" role="dialog" aria-labelledby="gridSystemModalLabel"></div>
</section>
@endsection

@section('javascript')
<script type="text/javascript">
    $(document).ready(function () {
        var staff_table = $('#mosque_staff_table').DataTable({
            processing: true,
            serverSide: true,
            ajax: {
                url: '{{ route("mosque.staff.data") }}',
                error: function (xhr) {
                    var status = xhr && xhr.status ? xhr.status : '0';
                    var msg = '';
                    try {
                        if (xhr.responseJSON && (xhr.responseJSON.message || xhr.responseJSON.msg)) {
                            msg = xhr.responseJSON.message || xhr.responseJSON.msg;
                        }
                    } catch (e) {
                        msg = '';
                    }
                    toastr.error('Staff table load failed (HTTP ' + status + ')' + (msg ? (': ' + msg) : '') + '. Please refresh and try again.');
                    try { console.error('mosque_staff_table ajax error', xhr.responseText); } catch (e) {}
                }
            },
            dom: 'lBfrtip',
             buttons: [
                 { extend: 'csv', text: '<i class="fas fa-file-csv"></i>', className: 'btn btn-success' },
                 { extend: 'excel', text: '<i class="fas fa-file-excel"></i>', className: 'btn btn-info' },
                 { extend: 'print', text: '<i class="fas fa-print"></i>', className: 'btn btn-warning' },
                 { extend: 'colvis', text: '<i class="fas fa-eye"></i>', className: 'btn btn-primary' }
             ],
            columns: [
                { data: 'photo', name: 'photo', orderable: false, searchable: false },
                { data: 'name_with_id', name: 'name' },
                { data: 'designation', name: 'designation' },
                { data: 'phone', name: 'phone' },
                { data: 'whatsapp_number', name: 'whatsapp_number' },
                { data: 'email', name: 'email' },
                { data: 'salary', name: 'salary', orderable: false, searchable: false },
                { data: 'status', name: 'status' },
                { data: 'action', name: 'action', orderable: false, searchable: false },
            ],
            drawCallback: function () {
                __currency_convert_recursively($('#mosque_staff_table'));
            }
        });

        var attendance_table = $('#mosque_staff_attendance_table').DataTable({
            processing: true,
            serverSide: true,
            ajax: {
                url: '{{ route("mosque.staff.attendance.data") }}',
                data: function (d) {
                    d.staff_id = $('#mosque_att_staff_filter').val();
                    d.start_date = $('#mosque_att_start').val();
                    d.end_date = $('#mosque_att_end').val();
                }
            },
            dom: 'lBfrtip',
             buttons: [
                 { extend: 'csv', text: '<i class="fas fa-file-csv"></i>', className: 'btn btn-success' },
                 { extend: 'excel', text: '<i class="fas fa-file-excel"></i>', className: 'btn btn-info' },
                 { extend: 'print', text: '<i class="fas fa-print"></i>', className: 'btn btn-warning' },
                 { extend: 'colvis', text: '<i class="fas fa-eye"></i>', className: 'btn btn-primary' }
             ],
            columns: [
                { data: 'staff_name', name: 'staff_name' },
                { data: 'designation', name: 'designation' },
                { data: 'in_at', name: 'in_at' },
                { data: 'out_at', name: 'out_at' },
                { data: 'worked_hours', name: 'worked_hours', orderable: false, searchable: false },
                { data: 'source', name: 'source' },
                { data: 'action', name: 'action', orderable: false, searchable: false },
            ]
        });

        $(document).on('change', '#mosque_att_staff_filter, #mosque_att_start, #mosque_att_end', function () {
            try { attendance_table.ajax.reload(); } catch (e) {}
        });

        var leaves_table = $('#mosque_staff_leaves_table').DataTable({
            processing: true,
            serverSide: true,
            ajax: {
                url: '{{ route("mosque.staff.leaves.data") }}',
                data: function (d) {
                    d.staff_id = $('#mosque_leave_staff_filter').val();
                    d.status = $('#mosque_leave_status_filter').val();
                    d.leave_type_id = $('#mosque_leave_type_filter').val();
                    d.start_date = $('#mosque_leave_start').val();
                    d.end_date = $('#mosque_leave_end').val();
                }
            },
            dom: 'lBfrtip',
            buttons: [
                { extend: 'csv', text: '<i class="fas fa-file-csv"></i>', className: 'btn btn-success' },
                { extend: 'excel', text: '<i class="fas fa-file-excel"></i>', className: 'btn btn-info' },
                { extend: 'pdf', text: '<i class="fas fa-file-pdf"></i>', className: 'btn btn-danger' },
                { extend: 'print', text: '<i class="fas fa-print"></i>', className: 'btn btn-warning' },
                { extend: 'colvis', text: '<i class="fas fa-eye"></i>', className: 'btn btn-primary' }
            ],
            columns: [
                { data: 'staff_name', name: 'staff_name' },
                { data: 'designation', name: 'designation' },
                { data: 'type_name', name: 'type_name' },
                { data: 'start_date', name: 'start_date' },
                { data: 'end_date', name: 'end_date' },
                { data: 'days', name: 'days', searchable: false },
                { data: 'status', name: 'status', orderable: false, searchable: false },
                { data: 'reason', name: 'reason' },
                { data: 'action', name: 'action', orderable: false, searchable: false },
            ]
        });

        $(document).on('change', '#mosque_leave_staff_filter, #mosque_leave_status_filter, #mosque_leave_type_filter, #mosque_leave_start, #mosque_leave_end', function () {
            try { leaves_table.ajax.reload(); } catch (e) {}
        });

        var leave_types_table = $('#mosque_leave_types_table').DataTable({
            processing: true,
            serverSide: true,
            ajax: '{{ route("mosque.staff.leave_types.data") }}',
            dom: 'lBfrtip',
            buttons: [
                { extend: 'csv', text: '<i class="fas fa-file-csv"></i>', className: 'btn btn-success' },
                { extend: 'excel', text: '<i class="fas fa-file-excel"></i>', className: 'btn btn-info' },
                { extend: 'pdf', text: '<i class="fas fa-file-pdf"></i>', className: 'btn btn-danger' },
                { extend: 'print', text: '<i class="fas fa-print"></i>', className: 'btn btn-warning' },
                { extend: 'colvis', text: '<i class="fas fa-eye"></i>', className: 'btn btn-primary' }
            ],
            columns: [
                { data: 'name', name: 'name' },
                { data: 'is_paid', name: 'is_paid', orderable: false, searchable: false },
                { data: 'active', name: 'active', orderable: false, searchable: false },
                { data: 'action', name: 'action', orderable: false, searchable: false },
            ]
        });

        var roles_table = $('#mosque_staff_roles_table').DataTable({
            processing: true,
            serverSide: true,
            ajax: '{{ route("mosque.staff.roles.data") }}',
            dom: 'lBfrtip',
            buttons: [
                { extend: 'csv', text: '<i class="fas fa-file-csv"></i>', className: 'btn btn-success' },
                { extend: 'excel', text: '<i class="fas fa-file-excel"></i>', className: 'btn btn-info' },
                { extend: 'pdf', text: '<i class="fas fa-file-pdf"></i>', className: 'btn btn-danger' },
                { extend: 'print', text: '<i class="fas fa-print"></i>', className: 'btn btn-warning' },
                { extend: 'colvis', text: '<i class="fas fa-eye"></i>', className: 'btn btn-primary' }
            ],
            columns: [
                { data: 'name', name: 'name' },
                { data: 'active', name: 'active' },
                { data: 'sort_order', name: 'sort_order' },
                { data: 'action', name: 'action', orderable: false, searchable: false },
            ]
        });

        function staffFilterOptionsFromTable() {
            var map = {};
            try {
                var data = staff_table.rows({ search: 'applied' }).data();
                for (var i = 0; i < data.length; i++) {
                    var r = data[i];
                    var label = (r && (r.name_plain || r.name)) ? (r.name_plain || r.name) : '';
                    if (r && r.id && label) {
                        map[r.id] = label;
                    }
                }
            } catch (e) {}
            return map;
        }

        function initStaffFilters() {
            var $adv = $('#mosque_adv_staff_id');
            var $pay = $('#mosque_payslip_staff_filter');
            var $att = $('#mosque_att_staff_filter');
            var $leave = $('#mosque_leave_staff_filter');

            if ($.fn.select2) {
                [$adv, $pay, $att, $leave].forEach(function ($el) {
                    if (!$el || !$el.length) return;
                    $el.select2({
                        width: '100%',
                        allowClear: true,
                        placeholder: 'All',
                        ajax: {
                            url: '{{ route("mosque.staff.search") }}',
                            dataType: 'json',
                            delay: 150,
                            data: function (params) {
                                return { q: params.term || '', limit: 30 };
                            },
                            processResults: function (data) {
                                return data;
                            },
                            cache: true
                        }
                    });
                });
            }
        }

        var payslips_table = $('#mosque_payslips_table').DataTable({
            processing: true,
            serverSide: true,
            ajax: {
                url: '{{ route("mosque.staff.payslips.data") }}',
                data: function (d) {
                    d.staff_id = $('#mosque_payslip_staff_filter').val();
                    d.period_ym = ($('#mosque_payslip_period_filter').val() || '').toString().slice(0, 7);
                }
            },
            dom: 'lBfrtip',
            buttons: [
                { extend: 'csv', text: '<i class="fas fa-file-csv"></i>', className: 'btn btn-success' },
                { extend: 'excel', text: '<i class="fas fa-file-excel"></i>', className: 'btn btn-info' },
                { extend: 'pdf', text: '<i class="fas fa-file-pdf"></i>', className: 'btn btn-danger' },
                { extend: 'print', text: '<i class="fas fa-print"></i>', className: 'btn btn-warning' },
                { extend: 'colvis', text: '<i class="fas fa-eye"></i>', className: 'btn btn-primary' }
            ],
            columns: [
                { data: 'staff_name', name: 'staff_name' },
                { data: 'period_ym', name: 'period_ym' },
                { data: 'gross', name: 'gross', orderable: false, searchable: false },
                { data: 'net', name: 'net', orderable: false, searchable: false },
                { data: 'status', name: 'status', orderable: false, searchable: false },
                { data: 'paid_on', name: 'paid_on' },
                { data: 'action', name: 'action', orderable: false, searchable: false },
            ],
            drawCallback: function () {
                __currency_convert_recursively($('#mosque_payslips_table'));
            }
        });

        var advances_table = $('#mosque_staff_advances_table').DataTable({
            processing: true,
            serverSide: true,
            ajax: {
                url: '{{ route("mosque.staff.advances.data") }}',
                data: function (d) {
                    d.staff_id = $('#mosque_adv_staff_id').val();
                    d.start_date = $('#mosque_adv_start').val();
                    d.end_date = $('#mosque_adv_end').val();
                }
            },
            dom: 'lBfrtip',
            buttons: [
                { extend: 'csv', text: '<i class="fas fa-file-csv"></i>', className: 'btn btn-success' },
                { extend: 'excel', text: '<i class="fas fa-file-excel"></i>', className: 'btn btn-info' },
                { extend: 'pdf', text: '<i class="fas fa-file-pdf"></i>', className: 'btn btn-danger' },
                { extend: 'print', text: '<i class="fas fa-print"></i>', className: 'btn btn-warning' },
                { extend: 'colvis', text: '<i class="fas fa-eye"></i>', className: 'btn btn-primary' }
            ],
            columns: [
                { data: 'staff_name', name: 'staff_name' },
                { data: 'designation', name: 'designation' },
                { data: 'paid_on', name: 'paid_on' },
                { data: 'amount', name: 'amount', orderable: false, searchable: false },
                { data: 'adjusted_amount', name: 'adjusted_amount', orderable: false, searchable: false },
                { data: 'balance', name: 'balance', orderable: false, searchable: false },
                { data: 'adjusted_in', name: 'adjusted_in', orderable: false, searchable: false },
                { data: 'payment_method', name: 'payment_method' },
                { data: 'payment_ref_no', name: 'payment_ref_no' },
                { data: 'action', name: 'action', orderable: false, searchable: false },
            ],
            drawCallback: function () {
                __currency_convert_recursively($('#mosque_staff_advances_table'));
            }
        });

        $(document).on('change', '#mosque_adv_staff_id, #mosque_adv_start, #mosque_adv_end', function () {
            try { advances_table.ajax.reload(); } catch (e) {}
        });
        $(document).on('change', '#mosque_payslip_staff_filter, #mosque_payslip_period_filter', function () {
            try { payslips_table.ajax.reload(); } catch (e) {}
        });

        // Month picker fallback for browsers without <input type="month">
        if ($.fn.datepicker) {
            $('#mosque_payslip_period_filter').datepicker({
                autoclose: true,
                format: 'yyyy-mm',
                minViewMode: 1,
                todayHighlight: true
            });
        }

        function getStaffReportFilters() {
            return {
                start_date: $('#msr_start_date').val(),
                end_date: $('#msr_end_date').val(),
                source: $('#msr_source').val(),
                period_ym: $('#msr_period_ym').val(),
            };
        }

        var attendance_summary_table = $('#mosque_staff_attendance_summary_table').DataTable({
            processing: true,
            serverSide: true,
            ajax: {
                url: '{{ route("mosque.staff.reports.attendance") }}',
                data: function (d) {
                    return $.extend({}, d, getStaffReportFilters());
                }
            },
            dom: 'lBfrtip',
            buttons: [
                { extend: 'csv', text: '<i class="fas fa-file-csv"></i>', className: 'btn btn-success' },
                { extend: 'excel', text: '<i class="fas fa-file-excel"></i>', className: 'btn btn-info' },
                { extend: 'pdf', text: '<i class="fas fa-file-pdf"></i>', className: 'btn btn-danger' },
                { extend: 'print', text: '<i class="fas fa-print"></i>', className: 'btn btn-warning' },
                { extend: 'colvis', text: '<i class="fas fa-eye"></i>', className: 'btn btn-primary' }
            ],
            columns: [
                { data: 'staff_name', name: 'staff_name' },
                { data: 'designation', name: 'designation' },
                { data: 'punches_count', name: 'punches_count', searchable: false },
                { data: 'days_count', name: 'days_count', searchable: false },
                { data: 'worked_hours', name: 'worked_hours', orderable: false, searchable: false },
                { data: 'last_in_at', name: 'last_in_at', searchable: false },
            ]
        });

        var salary_register_table = $('#mosque_staff_salary_register_table').DataTable({
            processing: true,
            serverSide: true,
            ajax: {
                url: '{{ route("mosque.staff.reports.salary") }}',
                data: function (d) {
                    return $.extend({}, d, getStaffReportFilters());
                }
            },
            dom: 'lBfrtip',
            buttons: [
                { extend: 'csv', text: '<i class="fas fa-file-csv"></i>', className: 'btn btn-success' },
                { extend: 'excel', text: '<i class="fas fa-file-excel"></i>', className: 'btn btn-info' },
                { extend: 'pdf', text: '<i class="fas fa-file-pdf"></i>', className: 'btn btn-danger' },
                { extend: 'print', text: '<i class="fas fa-print"></i>', className: 'btn btn-warning' },
                { extend: 'colvis', text: '<i class="fas fa-eye"></i>', className: 'btn btn-primary' }
            ],
            columns: [
                { data: 'period_ym', name: 'period_ym' },
                { data: 'staff_name', name: 'staff_name' },
                { data: 'designation', name: 'designation' },
                { data: 'payslips_count', name: 'payslips_count', searchable: false },
                { data: 'paid_count', name: 'paid_count', searchable: false },
                { data: 'gross_total', name: 'gross_total', orderable: false, searchable: false },
                { data: 'net_total', name: 'net_total', orderable: false, searchable: false },
                { data: 'paid_total', name: 'paid_total', orderable: false, searchable: false },
            ],
            drawCallback: function () {
                __currency_convert_recursively($('#mosque_staff_salary_register_table'));
            }
        });

        function ajaxForm(selector, modalSelector, reloadTables) {
            $(document).on('submit', selector, function (e) {
                e.preventDefault();
                var $form = $(this);
                $.ajax({
                    // Always POST for multipart FormData; Laravel will respect `_method` field.
                    method: ($form.attr('method') || 'POST'),
                    url: $form.attr('action'),
                    data: new FormData(this),
                    processData: false,
                    contentType: false,
                    dataType: 'json',
                    success: function (result) {
                        if (result.success) {
                            $(modalSelector).modal('hide');
                            toastr.success(result.msg);
                            reloadTables.forEach(function (t) { t.ajax.reload(); });
                        } else {
                            toastr.error((result && result.msg) ? result.msg : '@lang("messages.something_went_wrong")');
                        }
                    },
                    error: function (xhr) {
                        if (xhr && xhr.status === 422 && xhr.responseJSON) {
                            var errors = xhr.responseJSON.errors || {};
                            var first = '';
                            try {
                                Object.keys(errors).some(function (k) {
                                    if (errors[k] && errors[k].length) {
                                        first = errors[k][0];
                                        return true;
                                    }
                                    return false;
                                });
                            } catch (e) {}
                            toastr.error(first || (xhr.responseJSON.message || '@lang("messages.something_went_wrong")'));
                            return;
                        }
                        if (xhr && (xhr.status === 419 || xhr.status === 401)) {
                            toastr.error('Session expired. Please refresh the page and try again.');
                            return;
                        }
                        toastr.error('@lang("messages.something_went_wrong")');
                    }
                });
            });
        }

        ajaxForm('form#mosque_staff_form', '.mosque_staff_modal', [staff_table]);
        ajaxForm('form#mosque_staff_role_form', '.mosque_staff_role_modal', [roles_table]);
        ajaxForm('form#mosque_attendance_form', '.mosque_attendance_modal', [attendance_table]);
        ajaxForm('form#mosque_leave_form', '.mosque_leave_modal', [leaves_table]);
        ajaxForm('form#mosque_leave_type_form', '.mosque_leave_type_modal', [leave_types_table]);
        ajaxForm('form#mosque_advance_form', '.mosque_advance_modal', [advances_table]);
        ajaxForm('form#mosque_payslip_form', '.mosque_payslip_modal', [payslips_table, advances_table]);
        ajaxForm('form#mosque_payslip_pay_form', '.mosque_payslip_modal', [payslips_table, advances_table]);

        // Typed CONFIRM delete modal (staff page safe fallback).
        function getCsrfToken() {
            var t = $('meta[name="csrf-token"]').attr('content');
            if (t) return t;
            t = $('input[name=_token]').first().val();
            if (t) return t;
            return '';
        }

        function ensureMosqueDeleteModal() {
            if ($('#mosque_delete_confirm_modal').length) {
                return;
            }
            var html = '' +
                '<div class="modal fade" id="mosque_delete_confirm_modal" tabindex="-1" role="dialog" aria-labelledby="mosqueDeleteConfirmLabel">' +
                '  <div class="modal-dialog" role="document">' +
                '    <div class="modal-content">' +
                '      <div class="modal-header">' +
                '        <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>' +
                '        <h4 class="modal-title" id="mosqueDeleteConfirmLabel">Confirm Delete</h4>' +
                '      </div>' +
                '      <div class="modal-body">' +
                '        <p>Type <strong>CONFIRM</strong> to delete.</p>' +
                '        <input type="text" class="form-control" id="mosque_delete_confirm_input" autocomplete="off" placeholder="Type CONFIRM">' +
                '        <input type="hidden" id="mosque_delete_confirm_url" value="">' +
                '        <button type="button" class="btn btn-danger" id="mosque_delete_confirm_btn" style="margin-top:10px;" disabled>Delete</button>' +
                '      </div>' +
                '    </div>' +
                '  </div>' +
                '</div>';
            $('body').append(html);
        }

        function openDeleteModal(url) {
            ensureMosqueDeleteModal();
            $('#mosque_delete_confirm_url').val(url || '');
            $('#mosque_delete_confirm_input').val('');
            $('#mosque_delete_confirm_btn').prop('disabled', true);
            $('#mosque_delete_confirm_modal').modal('show');
        }

        $(document).on('keyup change', '#mosque_delete_confirm_input', function () {
            var ok = ($(this).val() || '').toString().trim().toUpperCase() === 'CONFIRM';
            $('#mosque_delete_confirm_btn').prop('disabled', !ok);
        });

        $(document).on('click', '#mosque_delete_confirm_btn', function () {
            var url = $('#mosque_delete_confirm_url').val();
            if (!url) {
                $('#mosque_delete_confirm_modal').modal('hide');
                return;
            }
            var token = getCsrfToken();
            $.ajax({
                method: 'DELETE',
                url: url,
                dataType: 'json',
                headers: token ? { 'X-CSRF-TOKEN': token } : {},
                data: token ? { _token: token } : {},
                success: function (result) {
                    if (result && result.success) {
                        toastr.success(result.msg || LANG.success);
                        $('#mosque_delete_confirm_modal').modal('hide');
                        [staff_table, attendance_table, leaves_table, leave_types_table, advances_table, payslips_table, roles_table].forEach(function (t) {
                            try { t.ajax.reload(); } catch (e) {}
                        });
                    } else {
                        toastr.error((result && result.msg) ? result.msg : LANG.something_went_wrong);
                    }
                },
                error: function (xhr) {
                    var status = xhr && xhr.status ? xhr.status : 0;
                    toastr.error('Delete failed (HTTP ' + status + '). Please refresh and try again.');
                }
            });
        });

        // Always bind delete buttons on this page (some installs don't load module additional scripts).
        $(document).on('click', '.delete_mosque_staff, .delete_mosque_attendance, .delete_mosque_advance, .delete_mosque_payslip, .delete_mosque_staff_role, .delete_mosque_leave, .delete_mosque_leave_type', function (e) {
            e.preventDefault();
            e.stopImmediatePropagation();
            var url = $(this).data('href') || $(this).attr('href');
            if (!url) return;
            openDeleteModal(url);
        });

        function postQuickAction(url, tableToReload) {
            var token = getCsrfToken();
            return $.ajax({
                method: 'POST',
                url: url,
                dataType: 'json',
                headers: token ? { 'X-CSRF-TOKEN': token } : {},
                data: token ? { _token: token } : {}
            }).done(function (result) {
                if (result && result.success) {
                    toastr.success(result.msg || LANG.success);
                } else {
                    toastr.error((result && result.msg) ? result.msg : LANG.something_went_wrong);
                }
                if (tableToReload) {
                    try { tableToReload.ajax.reload(); } catch (e) {}
                }
            }).fail(function () {
                toastr.error(LANG.something_went_wrong);
            });
        }

        $(document).on('click', '.mosque_leave_approve, .mosque_leave_reject', function (e) {
            e.preventDefault();
            var url = $(this).data('href') || $(this).attr('href');
            if (!url) return;
            var actionText = $(this).hasClass('mosque_leave_approve') ? 'approve' : 'reject';

            if (typeof swal === 'function') {
                swal({
                    title: 'Are you sure?',
                    text: 'This will ' + actionText + ' the leave request.',
                    icon: 'warning',
                    buttons: true,
                    dangerMode: actionText === 'reject',
                }).then(function (will) {
                    if (will) postQuickAction(url, leaves_table);
                });
                return;
            }

            if (confirm('Are you sure you want to ' + actionText + ' this leave?')) {
                postQuickAction(url, leaves_table);
            }
        });

        function initStaffSelect2($el, placeholderText, $dropdownParent) {
            if (!$el || !$el.length || !$.fn.select2) return;
            if ($el.hasClass('select2-hidden-accessible')) return;
            $el.select2({
                width: '100%',
                allowClear: true,
                placeholder: placeholderText || 'Search staff',
                dropdownParent: ($dropdownParent && $dropdownParent.length) ? $dropdownParent : undefined,
                minimumInputLength: 0,
                minimumResultsForSearch: 0,
                ajax: {
                    url: '{{ route("mosque.staff.search") }}',
                    dataType: 'json',
                    delay: 150,
                    data: function (params) {
                        return { q: params.term || '', limit: 30 };
                    },
                    transport: function (params, success, failure) {
                        var request = $.ajax(params);
                        request.then(success);
                        request.fail(function (xhr) {
                            var status = xhr && xhr.status ? xhr.status : 0;
                            toastr.error('Staff search failed (HTTP ' + status + '). Please refresh and try again.');
                            failure();
                        });
                        return request;
                    },
                    processResults: function (data) {
                        if (data && data.results) return data;
                        if ($.isArray(data)) return { results: data };
                        return { results: [] };
                    },
                    cache: true
                }
            });
        }

        function initLeaveModal($modal) {
            if (!$modal || !$modal.length) return;
            if (!$.fn.select2) return;

            var $staffSelect = $modal.find('#mosque_leave_staff_id');
            var useLocal = ($staffSelect.data('select2-local') || '') === 1 || ($staffSelect.data('select2-local') || '') === '1';

            try {
                $modal.find('select.select2').each(function () {
                    var $el = $(this);
                    if ($el.hasClass('select2-hidden-accessible')) {
                        $el.select2('destroy');
                    }
                });
            } catch (e) {}

            if (useLocal) {
                $staffSelect.select2({
                    width: '100%',
                    allowClear: true,
                    dropdownParent: $modal,
                    minimumResultsForSearch: 0,
                    placeholder: $staffSelect.data('placeholder') || 'Select staff'
                });
            } else {
                initStaffSelect2($staffSelect, 'Select staff', $modal);
            }

            $modal.find('select.select2').each(function () {
                var $el = $(this);
                if ($el.is('#mosque_leave_staff_id')) return;
                $el.select2({
                    width: '100%',
                    allowClear: true,
                    dropdownParent: $modal,
                    minimumResultsForSearch: 0,
                    placeholder: $el.data('placeholder') || 'Select'
                });
            });

            $modal.off('select2:open.mosqueLeaveFix', '#mosque_leave_staff_id');
            $modal.on('select2:open.mosqueLeaveFix', '#mosque_leave_staff_id', function () {
                setTimeout(function () {
                    try {
                        var field = document.querySelector('.select2-container--open .select2-search__field');
                        if (field) field.focus();
                    } catch (e) {}
                }, 50);
            });
        }

        $(document).on('shown.bs.modal', '.mosque_leave_modal', function () {
            initLeaveModal($(this));
        });

        $(document).on('change', '#msr_start_date, #msr_end_date, #msr_source, #msr_period_ym', function () {
            attendance_summary_table.ajax.reload();
            salary_register_table.ajax.reload();
        });

        initStaffFilters();

        if ($.fn.datepicker) {
            $('.mosque_leave_datepicker').datepicker({
                autoclose: true,
                todayHighlight: true,
                format: 'dd-mm-yyyy',
            });
        }
    });
</script>
@endsection
