<div class="modal-dialog" role="document">
    <div class="modal-content">
        <style>
            .mosque_leave_modal .select2-container { width: 100% !important; }
            .mosque_leave_modal .select2-container--default .select2-selection--single { height: 34px; }
            .mosque_leave_modal .select2-container--default .select2-selection--single .select2-selection__rendered { line-height: 34px; }
            .mosque_leave_modal .select2-container--default .select2-selection--single .select2-selection__arrow { height: 32px; }
            .mosque_leave_modal .select2-container .select2-selection--single .select2-selection__rendered { margin-top: 0 !important; }
        </style>
        {!! Form::open(['url' => route('mosque.staff.leaves.store'), 'method' => 'post', 'id' => 'mosque_leave_form']) !!}
        <div class="modal-header">
            <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
            <h4 class="modal-title">Add Leave</h4>
        </div>
        <div class="modal-body">
            <div class="row">
                <div class="col-sm-12">
                    <div class="form-group">
                        <label>Staff:*</label>
                        {!! Form::select('staff_id', $staffOptions ?? [], null, ['id' => 'mosque_leave_staff_id', 'class' => 'form-control select2', 'required', 'placeholder' => __('lang_v1.none'), 'style' => 'width:100%;', 'data-select2-local' => '1', 'data-placeholder' => 'Select staff']) !!}
                    </div>
                </div>
                <div class="col-sm-6">
                    <div class="form-group">
                        <label>Leave type</label>
                        {!! Form::select('leave_type_id', $types, null, ['class' => 'form-control select2', 'placeholder' => __('lang_v1.none'), 'style' => 'width:100%;', 'data-select2-local' => '1', 'data-placeholder' => 'Select leave type']) !!}
                    </div>
                </div>
                <div class="col-sm-6">
                    <div class="form-group">
                        <label>Status</label>
                        <input type="text" class="form-control" value="Pending" readonly>
                    </div>
                </div>
                <div class="col-sm-6">
                    <div class="form-group">
                        <label>From:*</label>
                        {!! Form::text('start_date', \Carbon\Carbon::today()->format('d-m-Y'), ['class' => 'form-control mosque_leave_datepicker', 'required', 'readonly', 'placeholder' => 'dd-mm-yyyy']) !!}
                    </div>
                </div>
                <div class="col-sm-6">
                    <div class="form-group">
                        <label>To:*</label>
                        {!! Form::text('end_date', \Carbon\Carbon::today()->format('d-m-Y'), ['class' => 'form-control mosque_leave_datepicker', 'required', 'readonly', 'placeholder' => 'dd-mm-yyyy']) !!}
                    </div>
                </div>
                <div class="col-sm-12">
                    <div class="form-group">
                        <label>Reason</label>
                        {!! Form::textarea('reason', null, ['class' => 'form-control', 'rows' => 3]) !!}
                    </div>
                </div>
            </div>
        </div>
        <div class="modal-footer">
            <button type="submit" class="btn btn-primary">@lang('messages.save')</button>
            <button type="button" class="btn btn-default" data-dismiss="modal">@lang('messages.close')</button>
        </div>
        {!! Form::close() !!}
    </div>
</div>

<script>
    $(function () {
        if ($.fn.datepicker) {
            $('.mosque_leave_datepicker').datepicker({
                autoclose: true,
                todayHighlight: true,
                format: 'dd-mm-yyyy',
            });
        }
    });
</script>
