<div class="modal-dialog" role="document">
    <div class="modal-content">
        {!! Form::open(['url' => route('mosque.staff.leaves.update', [$leave->id]), 'method' => 'put', 'id' => 'mosque_leave_form']) !!}
        <div class="modal-header">
            <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
            <h4 class="modal-title">Edit Leave</h4>
        </div>
        <div class="modal-body">
            <div class="row">
                <div class="col-sm-12">
                    <div class="form-group">
                        <label>Staff</label>
                        <input type="text" class="form-control" value="{{ $staff->name }} ({{ $staff->designation ?? '-' }})" readonly>
                    </div>
                </div>
                <div class="col-sm-6">
                    <div class="form-group">
                        <label>Leave type</label>
                        {!! Form::select('leave_type_id', $types, $leave->leave_type_id, ['class' => 'form-control select2', 'placeholder' => __('lang_v1.none'), 'style' => 'width:100%;']) !!}
                    </div>
                </div>
                <div class="col-sm-6">
                    <div class="form-group">
                        <label>Status</label>
                        {!! Form::select('status', ['pending' => 'Pending', 'approved' => 'Approved', 'rejected' => 'Rejected'], $leave->status, ['class' => 'form-control']) !!}
                    </div>
                </div>
                <div class="col-sm-6">
                    <div class="form-group">
                        <label>From:*</label>
                        {!! Form::text('start_date', !empty($leave->start_date) ? \Carbon\Carbon::parse($leave->start_date)->format('d-m-Y') : null, ['class' => 'form-control mosque_leave_datepicker', 'required', 'readonly', 'placeholder' => 'dd-mm-yyyy']) !!}
                    </div>
                </div>
                <div class="col-sm-6">
                    <div class="form-group">
                        <label>To:*</label>
                        {!! Form::text('end_date', !empty($leave->end_date) ? \Carbon\Carbon::parse($leave->end_date)->format('d-m-Y') : null, ['class' => 'form-control mosque_leave_datepicker', 'required', 'readonly', 'placeholder' => 'dd-mm-yyyy']) !!}
                    </div>
                </div>
                <div class="col-sm-12">
                    <div class="form-group">
                        <label>Reason</label>
                        {!! Form::textarea('reason', $leave->reason, ['class' => 'form-control', 'rows' => 3]) !!}
                    </div>
                </div>
            </div>
        </div>
        <div class="modal-footer">
            <button type="submit" class="btn btn-primary">@lang('messages.save')</button>
            <button type="button" class="btn btn-default" data-dismiss="modal">@lang('messages.close')</button>
        </div>
        {!! Form::close() !!}
    </div>
</div>

<script>
    $(function () {
        if ($.fn.datepicker) {
            $('.mosque_leave_datepicker').datepicker({
                autoclose: true,
                todayHighlight: true,
                format: 'dd-mm-yyyy',
            });
        }
    });
</script>
