<div class="modal-dialog modal-lg" role="document">
    <div class="modal-content">
        <style>
            .mosque-payslip-modal .modal-header { background: linear-gradient(135deg,#0ea5a0,#2563eb); color:#fff; }
            .mosque-payslip-modal .modal-title { color:#fff; }
            .mosque-payslip-modal .modal-body { background: linear-gradient(180deg,#eff8ff,#eef2ff); }
            .mosque_payslip_modal .modal-dialog { width: 92%; max-width: 1180px; }
            .mosque-payslip-card { background: linear-gradient(180deg,#f8fbff,#eef6ff); border:1px solid #dbeafe; border-radius:14px; padding:10px; margin-bottom:10px; box-shadow: 0 10px 24px rgba(2,6,23,0.06); }
            .mosque-payslip-hint { color:#64748b; font-size:11px; margin-top:4px; }
            .mosque-payslip-modal .select2-container { width: 100% !important; }
            .mosque-payslip-mini { font-size: 12px; }
            .mosque-line-row { display:flex; gap:8px; align-items:center; margin-bottom:8px; }
            .mosque-line-row input[type=text] { flex: 1; min-width: 0; }
            .mosque-line-row input[type=number] { width: 140px; }
            .mosque-line-row .btn { padding: 4px 8px; }
            .mosque-inline-head { display:flex; justify-content:space-between; align-items:center; gap:10px; margin-bottom:10px; }
            .mosque-inline-head h5 { margin:0; font-weight:700; }
            .mosque-lines-box { max-height: 110px; overflow:auto; padding-right: 2px; background:#eef2ff; border:1px dashed #c7d2fe; border-radius:14px; padding:8px; }
            .mosque-payslip-modal .form-group { margin-bottom: 8px; }
            .mosque-payslip-modal .form-control { background:#eef2ff; border:1px solid #c7d2fe; border-radius:14px; box-shadow: 0 6px 16px rgba(2,6,23,0.06); }
            .mosque-payslip-modal .form-control:focus { border-color:#60a5fa; box-shadow: 0 0 0 3px rgba(37,99,235,0.15); }
            .mosque-field.has-feedback .form-control-feedback { color:#64748b; right: 10px; top: 31px; }
            .mosque-field label { color:#0f172a; }
            .mosque-payslip-modal .select2-container--default .select2-selection--single { background:#eef2ff; border:1px solid #c7d2fe; border-radius:14px; height: 34px; }
            .mosque-payslip-modal .select2-container--default .select2-selection--single .select2-selection__rendered { line-height: 32px; }
            .mosque-payslip-modal .select2-container--default .select2-selection--single .select2-selection__arrow { height: 32px; }
        </style>
        {!! Form::open(['url' => route('mosque.staff.payslips.store'), 'method' => 'post', 'id' => 'mosque_payslip_form']) !!}
        <div class="modal-header mosque-payslip-modal">
            <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
            <h4 class="modal-title">@lang('messages.add')</h4>
        </div>
        <div class="modal-body mosque-payslip-modal">
            <div class="row">
                <div class="col-sm-6">
                    <div class="form-group mosque-payslip-card mosque-field has-feedback">
                        {!! Form::label('staff_id', 'Staff:*') !!}
                        {!! Form::select('staff_id', $staff, null, ['class' => 'form-control select2', 'required', 'placeholder' => __('lang_v1.none'), 'id' => 'mosque_payslip_staff_id']) !!}
                        <span class="fa fa-user form-control-feedback"></span>
                        <div class="mosque-payslip-hint" id="mosque_payslip_staff_hint"></div>
                    </div>
                </div>
                <div class="col-sm-6">
                     <div class="form-group mosque-payslip-card mosque-field has-feedback">
                         {!! Form::label('period_ym', 'Period:*') !!}
                         <input type="text" id="mosque_payslip_period_display" class="form-control" autocomplete="off" placeholder="January 2025" value="{{ \Carbon\Carbon::now()->format('F Y') }}">
                         <input type="hidden" name="period_ym" id="mosque_payslip_period_ym" value="{{ \Carbon\Carbon::now()->format('Y-m') }}">
                         <span class="fa fa-calendar form-control-feedback"></span>
                     </div>
                 </div>

                <div class="col-sm-6">
                    <div class="form-group mosque-payslip-card mosque-field has-feedback">
                        {!! Form::label('gross', 'Basic salary:*') !!}
                        {!! Form::number('gross', null, ['class' => 'form-control', 'step' => '0.01', 'required', 'id' => 'mosque_payslip_gross']) !!}
                        <span class="fa fa-money form-control-feedback"></span>
                    </div>
                </div>
                <div class="col-sm-6">
                    <div class="mosque-payslip-card">
                        <div class="mosque-inline-head">
                            <h5>Bonus</h5>
                            <button type="button" class="btn btn-xs btn-primary mosque-payslip-mini" id="mosque_add_bonus"><i class="fa fa-plus"></i></button>
                        </div>
                        <div id="mosque_bonus_lines" class="mosque-lines-box"></div>
                        {!! Form::hidden('bonus_amount', 0, ['id' => 'mosque_payslip_bonus_total']) !!}
                        {!! Form::hidden('bonus_reason', null, ['id' => 'mosque_payslip_bonus_reason']) !!}
                        <div class="mosque-payslip-hint">Add multiple bonus items (reason + amount).</div>
                    </div>
                </div>
                <div class="col-sm-6">
                    <div class="mosque-payslip-card">
                        <div class="mosque-inline-head">
                            <h5>Deductions</h5>
                            <button type="button" class="btn btn-xs btn-danger mosque-payslip-mini" id="mosque_add_deduction"><i class="fa fa-plus"></i></button>
                        </div>
                        <div style="margin:-6px 0 8px 0;">
                            <label style="font-weight:600; margin:0;">
                                <input type="checkbox" name="apply_advances" id="mosque_apply_advances" value="1" checked>
                                Auto-adjust outstanding advances
                            </label>
                            <div class="mosque-payslip-hint" id="mosque_payslip_advance_hint"></div>
                        </div>
                        <div id="mosque_deduction_lines" class="mosque-lines-box"></div>
                        {!! Form::hidden('deduction_amount', 0, ['id' => 'mosque_payslip_deduction_total']) !!}
                        <div class="mosque-payslip-hint">Add multiple deduction items (label + amount).</div>
                    </div>
                </div>

                <div class="col-sm-6">
                    <div class="form-group mosque-payslip-card mosque-field has-feedback">
                        {!! Form::label('net', 'Net pay:*') !!}
                        {!! Form::number('net', null, ['class' => 'form-control', 'step' => '0.01', 'required', 'readonly', 'id' => 'mosque_payslip_net']) !!}
                        <span class="fa fa-calculator form-control-feedback"></span>
                        <div class="mosque-payslip-hint">Auto calculated: salary + bonus − deductions.</div>
                    </div>
                </div>

                <div class="col-sm-12">
                    <div class="mosque-payslip-card">
                        <h5 style="margin:0 0 10px; font-weight:700;">Payment Information</h5>
                        <div class="row">
                            <div class="col-sm-4">
                                <div class="form-group mosque-field has-feedback">
                                    {!! Form::label('paid_on', 'Payment date:') !!}
                                    {!! Form::date('paid_on', null, ['class' => 'form-control', 'id' => 'mosque_payslip_paid_on']) !!}
                                    <span class="fa fa-calendar form-control-feedback"></span>
                                </div>
                            </div>
                            <div class="col-sm-4">
                                <div class="form-group mosque-field has-feedback">
                                    {!! Form::label('payment_method', 'Payment method:') !!}
                                    <select name="payment_method" id="mosque_payslip_payment_method" class="form-control">
                                        <option value="">@lang('lang_v1.none')</option>
                                        <option value="cash">Cash</option>
                                        <option value="bank">Bank</option>
                                        <option value="card">Card</option>
                                        <option value="online">Online</option>
                                        <option value="other">Other</option>
                                    </select>
                                    <span class="fa fa-credit-card form-control-feedback"></span>
                                </div>
                            </div>
                            <div class="col-sm-4">
                                <div class="form-group mosque-field has-feedback">
                                    {!! Form::label('paid_amount', 'Paid amount:') !!}
                                    {!! Form::number('paid_amount', null, ['class' => 'form-control', 'step' => '0.01', 'id' => 'mosque_payslip_paid_amount']) !!}
                                    <span class="fa fa-money form-control-feedback"></span>
                                </div>
                            </div>
                            <div class="col-sm-6">
                                <div class="form-group mosque-field has-feedback">
                                    {!! Form::label('payment_ref_no', 'Reference no:') !!}
                                    {!! Form::text('payment_ref_no', null, ['class' => 'form-control']) !!}
                                    <span class="fa fa-tag form-control-feedback"></span>
                                </div>
                            </div>
                            <div class="col-sm-6">
                                <div class="form-group mosque-field has-feedback">
                                    {!! Form::label('payment_note', 'Payment note:') !!}
                                    {!! Form::text('payment_note', null, ['class' => 'form-control', 'placeholder' => 'Optional']) !!}
                                    <span class="fa fa-sticky-note-o form-control-feedback"></span>
                                </div>
                            </div>
                        </div>
                        <div class="mosque-payslip-hint">If you set Payment date, Payment method is required and it will mark the payslip as Paid.</div>
                    </div>
                </div>

                <div class="col-sm-12">
                    <div class="form-group mosque-payslip-card mosque-field has-feedback">
                        {!! Form::label('note', __('lang_v1.additional_notes') . ':') !!}
                        {!! Form::textarea('note', null, ['class' => 'form-control', 'rows' => 2]) !!}
                        <span class="fa fa-align-left form-control-feedback"></span>
                    </div>
                </div>
            </div>
        </div>
        <div class="modal-footer">
            <button type="submit" class="btn btn-primary">@lang('messages.save')</button>
            <button type="button" class="btn btn-default" data-dismiss="modal">@lang('messages.close')</button>
        </div>
        {!! Form::close() !!}
    </div>
</div>

<script>
    (function () {
        var staffDetails = @json($staffDetails ?? []);

        function num(v) {
            var n = parseFloat((v || '0').toString());
            return isNaN(n) ? 0 : n;
        }

        function recalcNet() {
            var gross = num($('#mosque_payslip_gross').val());
            var bonus = num($('#mosque_payslip_bonus_total').val());
            var deduction = num($('#mosque_payslip_deduction_total').val());
            var net = Math.max((gross + bonus - deduction), 0);
            $('#mosque_payslip_net').val(net.toFixed(2));

            var hasDate = ($('#mosque_payslip_paid_on').val() || '').toString().trim() !== '';
            if (hasDate) {
                var paidAmount = num($('#mosque_payslip_paid_amount').val());
                if (!paidAmount && net > 0) {
                    $('#mosque_payslip_paid_amount').val(net.toFixed(2));
                }
            }
        }

        function updateStaffHint() {
            var id = $('#mosque_payslip_staff_id').val();
            var d = staffDetails[id] || null;
            if (!d) {
                $('#mosque_payslip_staff_hint').text('');
                $('#mosque_payslip_advance_hint').text('');
                return;
            }
            var parts = [];
            if (d.designation) parts.push(d.designation);
            if (d.salary && d.salary > 0) parts.push('Default salary: ' + parseFloat(d.salary).toFixed(2));
            $('#mosque_payslip_staff_hint').text(parts.join(' | '));

            var adv = parseFloat(d.advance_balance || 0);
            if (!isNaN(adv) && adv > 0) {
                $('#mosque_payslip_advance_hint').text('Outstanding advances: ' + adv.toFixed(2) + ' (auto-deducted if enabled).');
            } else {
                $('#mosque_payslip_advance_hint').text('Outstanding advances: 0');
            }
        }

        function maybeAutoFillSalary() {
            var id = $('#mosque_payslip_staff_id').val();
            var d = staffDetails[id] || null;
            if (!d || !d.salary) return;
            var current = num($('#mosque_payslip_gross').val());
            if (!current || current === 0) {
                $('#mosque_payslip_gross').val(parseFloat(d.salary).toFixed(2));
            }
        }

        function togglePaymentRequired() {
            var hasDate = ($('#mosque_payslip_paid_on').val() || '').toString().trim() !== '';
            $('#mosque_payslip_payment_method').prop('required', hasDate);
            $('#mosque_payslip_paid_amount').prop('readonly', !hasDate);
            if (!hasDate) {
                $('#mosque_payslip_payment_method').val('');
                $('#mosque_payslip_paid_amount').val('');
            }
            recalcNet();
        }

        $('#mosque_payslip_staff_id').select2({ width: '100%', dropdownParent: $('#mosque_payslip_form').closest('.modal') });

        // Month picker for Period (display: "January 2025", submit: "YYYY-MM")
        function setPeriodFromDate(d) {
            try {
                var y = d.getFullYear();
                var m = (d.getMonth() + 1).toString().padStart(2, '0');
                $('#mosque_payslip_period_ym').val(y + '-' + m);
            } catch (e) {}
        }

        if ($.fn.datepicker) {
            $('#mosque_payslip_period_display').datepicker({
                format: 'MM yyyy',
                autoclose: true,
                minViewMode: 1,
                orientation: 'bottom'
            }).on('changeDate', function (e) {
                if (e && e.date) {
                    setPeriodFromDate(e.date);
                }
            });
        }

        try {
            var ym = ($('#mosque_payslip_period_ym').val() || '').toString().trim();
            var d = new Date();
            if (/^\d{4}-\d{2}$/.test(ym)) {
                var parts = ym.split('-');
                d = new Date(parseInt(parts[0], 10), parseInt(parts[1], 10) - 1, 1);
            } else {
                setPeriodFromDate(d);
            }

            if ($.fn.datepicker) {
                $('#mosque_payslip_period_display').datepicker('update', d);
            } else {
                $('#mosque_payslip_period_display').val(d.toLocaleString('en-US', { month: 'long', year: 'numeric' }));
            }
        } catch (e) {}

        function lineRow(type, label, amount) {
            var cls = type === 'bonus' ? 'mosque_bonus_line' : 'mosque_deduction_line';
            var labelPh = type === 'bonus' ? 'Reason' : 'Label';
            var btnCls = type === 'bonus' ? 'btn-default' : 'btn-default';
            var nameLabel = type === 'bonus' ? 'bonus_label[]' : 'deduction_label[]';
            var nameAmt = type === 'bonus' ? 'bonus_amount_line[]' : 'deduction_amount_line[]';
            return '' +
                '<div class="mosque-line-row '+cls+'">' +
                '  <input type="text" name="'+nameLabel+'" class="form-control mosque-line-label" placeholder="'+labelPh+'" value="'+(label || '')+'">' +
                '  <input type="number" name="'+nameAmt+'" class="form-control mosque-line-amount" step="0.01" min="0" placeholder="0.00" value="'+(amount || '')+'">' +
                '  <button type="button" class="btn '+btnCls+' btn-xs mosque_remove_line"><i class="fa fa-times"></i></button>' +
                '</div>';
        }

        function ensureAtLeastOneLine() {
            if (!$('#mosque_bonus_lines .mosque_bonus_line').length) {
                $('#mosque_bonus_lines').append(lineRow('bonus', '', ''));
            }
            if (!$('#mosque_deduction_lines .mosque_deduction_line').length) {
                $('#mosque_deduction_lines').append(lineRow('deduction', '', ''));
            }
        }

        function recalcLines() {
            var bonusTotal = 0;
            var bonusReasons = [];
            $('#mosque_bonus_lines .mosque_bonus_line').each(function () {
                var label = ($(this).find('.mosque-line-label').val() || '').toString().trim();
                var amt = num($(this).find('.mosque-line-amount').val());
                if (amt > 0) {
                    bonusTotal += amt;
                    if (label) bonusReasons.push(label);
                }
            });
            $('#mosque_payslip_bonus_total').val(bonusTotal.toFixed(2));
            $('#mosque_payslip_bonus_reason').val(bonusReasons.slice(0, 3).join(', '));

            var dedTotal = 0;
            $('#mosque_deduction_lines .mosque_deduction_line').each(function () {
                var amt = num($(this).find('.mosque-line-amount').val());
                if (amt > 0) {
                    dedTotal += amt;
                }
            });
            $('#mosque_payslip_deduction_total').val(dedTotal.toFixed(2));
            recalcNet();
        }

        $(document).on('click', '#mosque_add_bonus', function () {
            $('#mosque_bonus_lines').append(lineRow('bonus', '', ''));
        });
        $(document).on('click', '#mosque_add_deduction', function () {
            $('#mosque_deduction_lines').append(lineRow('deduction', '', ''));
        });
        $(document).on('click', '.mosque_remove_line', function () {
            var $row = $(this).closest('.mosque-line-row');
            $row.remove();
            ensureAtLeastOneLine();
            recalcLines();
        });
        $(document).on('keyup change', '#mosque_bonus_lines .mosque-line-label, #mosque_bonus_lines .mosque-line-amount, #mosque_deduction_lines .mosque-line-label, #mosque_deduction_lines .mosque-line-amount', recalcLines);

        $(document).on('change', '#mosque_payslip_staff_id', function () {
            updateStaffHint();
            maybeAutoFillSalary();
            recalcNet();
        });
        $(document).on('keyup change', '#mosque_payslip_gross', function () {
            recalcLines();
        });
        $(document).on('keyup change', '#mosque_payslip_paid_amount', recalcNet);
        $(document).on('change', '#mosque_payslip_paid_on', togglePaymentRequired);

        updateStaffHint();
        maybeAutoFillSalary();
        ensureAtLeastOneLine();
        recalcLines();
        togglePaymentRequired();
    })();
</script>
