<div class="modal-dialog" role="document">
    <div class="modal-content">
        <style>
            .mosque-pay-modal .modal-header { background: linear-gradient(135deg,#16a34a,#0ea5a0); color:#fff; }
            .mosque-pay-modal .modal-title { color:#fff; }
            .mosque-pay-modal .modal-body { background: linear-gradient(180deg,#eff8ff,#ecfeff); }
            .mosque-pay-modal .form-control { border-radius: 12px; }
            .mosque-pay-modal .help-block { margin: 4px 0 0; font-size: 11px; color:#64748b; }
        </style>

        {!! Form::open(['url' => route('mosque.staff.payslips.pay.store', [$payslip->id]), 'method' => 'post', 'id' => 'mosque_payslip_pay_form']) !!}
        <div class="modal-header mosque-pay-modal">
            <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
            <h4 class="modal-title">Mark Payslip as Paid</h4>
        </div>

        <div class="modal-body mosque-pay-modal">
            <div class="row">
                <div class="col-sm-6">
                    <div class="form-group">
                        <label>Staff</label>
                        <input type="text" class="form-control" value="{{ $staff->name }} ({{ $payslip->period_ym }})" readonly>
                        <p class="help-block">This payslip is currently DUE.</p>
                    </div>
                </div>
                <div class="col-sm-3">
                    <div class="form-group">
                        <label>Net Pay</label>
                        <input type="text" class="form-control" value="{{ (float) ($payslip->net ?? 0) }}" readonly>
                    </div>
                </div>
                <div class="col-sm-3">
                    <div class="form-group">
                        <label>Paid Amount</label>
                        {!! Form::number('paid_amount', (float) ($payslip->net ?? 0), ['class' => 'form-control', 'step' => '0.01']) !!}
                    </div>
                </div>

                <div class="col-sm-4">
                    <div class="form-group">
                        <label>Payment date:*</label>
                        {!! Form::text('paid_on', \Carbon\Carbon::today()->format('d-m-Y'), ['class' => 'form-control mosque_pay_datepicker', 'required', 'readonly', 'placeholder' => 'dd-mm-yyyy']) !!}
                    </div>
                </div>
                <div class="col-sm-4">
                    <div class="form-group">
                        <label>Payment method:*</label>
                        {!! Form::select('payment_method', $paymentMethods, null, ['class' => 'form-control', 'required', 'placeholder' => __('lang_v1.none')]) !!}
                    </div>
                </div>
                <div class="col-sm-4">
                    <div class="form-group">
                        <label>Reference no</label>
                        {!! Form::text('payment_ref_no', null, ['class' => 'form-control']) !!}
                    </div>
                </div>
                <div class="col-sm-12">
                    <div class="form-group">
                        <label>Payment note</label>
                        {!! Form::textarea('payment_note', null, ['class' => 'form-control', 'rows' => 2]) !!}
                    </div>
                </div>
            </div>
        </div>

        <div class="modal-footer">
            <button type="submit" class="btn btn-success">@lang('messages.save')</button>
            <button type="button" class="btn btn-default" data-dismiss="modal">@lang('messages.close')</button>
        </div>
        {!! Form::close() !!}
    </div>
</div>

<script>
    $(function () {
        if ($.fn.datepicker) {
            $('.mosque_pay_datepicker').datepicker({
                autoclose: true,
                todayHighlight: true,
                format: 'dd-mm-yyyy',
            });
        }
    });
</script>

