<!DOCTYPE html>
<html lang="{{ app()->getLocale() }}">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Payslip - {{ $staff->name }} - {{ $payslip->period_ym }}</title>
    @php
        $is_pdf = isset($is_pdf) ? (bool) $is_pdf : false;

        // Dompdf: embed a unicode font so currency signs like "৳" render correctly.
        // Using base64 data-uri avoids Dompdf file path/chroot/font-cache issues.
        // Use a static Bengali font (Hind Siliguri) because Dompdf does not reliably support variable fonts.
        $currencyFontSrc = null;
        if ($is_pdf) {
            $currencyFontPath = base_path('Modules/Mosque/Resources/fonts/HindSiliguri-Regular.ttf');
            if (is_string($currencyFontPath) && $currencyFontPath !== '' && file_exists($currencyFontPath)) {
                $fontBin = @file_get_contents($currencyFontPath);
                if ($fontBin !== false) {
                    $currencyFontSrc = 'data:font/ttf;base64,'.base64_encode($fontBin);
                }
            }
        }
    @endphp
    <style>
        @page { margin: 18px; }
        @if(!empty($currencyFontSrc))
        @font-face { font-family: 'MosqueCurrency'; src: url('{{ $currencyFontSrc }}') format('truetype'); font-weight: normal; font-style: normal; }
        @endif
        body { font-family: {{ $is_pdf ? (!empty($currencyFontSrc) ? "'DejaVu Sans','MosqueCurrency', sans-serif" : "'DejaVu Sans', sans-serif") : "Arial, sans-serif" }}; color: #111; margin: {{ $is_pdf ? '0' : '18px' }}; padding-bottom: 170px; }
        @if(!empty($is_pdf))
        .no-print { display:none !important; }
        @endif
        .no-print { display:flex; justify-content: flex-end; gap: 8px; margin-bottom: 10px; }
        .topline { display:flex; justify-content: space-between; gap: 14px; align-items: flex-start; }
        .title { font-size: 18px; margin: 0; font-weight: 700; }
        .muted { color: #667085; font-size: 12px; }
        .brand { text-align:right; max-width: 360px; }
        .brandRow { display:flex; justify-content:flex-end; align-items:flex-start; gap: 10px; }
        .brandName { font-size: 16px; font-weight: 800; line-height: 1.1; margin: 0; }
        .brandInfo { font-size: 11px; line-height: 1.35; margin-top: 2px; }
        .brandLogo { max-height:52px; margin-top: 2px; }
        .badge { display:inline-block; padding: 6px 12px; border-radius: 999px; color:#fff; font-weight:700; font-size: 11px; }
        .badge.paid { background:#16a34a; }
        .badge.due { background:#dc2626; }
        .card { border:1px solid #111; margin-top: 18px; }
        .card .head { padding: 10px; border-bottom:1px solid #111; text-align:center; font-size: 13px; }
        .twoCol { width:100%; border-collapse: collapse; }
        .twoCol td { border-right:1px solid #111; padding: 8px; vertical-align: top; font-size: 12px; }
        .twoCol td:last-child { border-right:none; }
        .kv { width:100%; border-collapse: collapse; }
        .kv td { padding: 2px 0; font-size: 12px; }
        .kv .k { color:#344054; font-weight:700; width: 170px; }
        .salary { width:100%; border-collapse: collapse; }
        .salary th, .salary td { border-top:1px solid #111; padding: 8px; font-size: 12px; }
        .salary th { text-align:left; background:#f8fafc; }
        .salary .num { text-align:right; white-space: nowrap; }
        .payinfo { width:100%; border-collapse: collapse; margin-top: 8px; }
        .payinfo th, .payinfo td { border-top:1px solid #111; padding: 8px; font-size: 12px; }
        .payinfo th { text-align:left; background:#22c55e; color:#fff; }
        .noteBox { padding: 10px; font-size: 12px; }
        .footer { padding-top: 10px; display:flex; justify-content: space-between; gap: 12px; align-items:flex-end; position: fixed; left: 18px; right: 18px; bottom: {{ $is_pdf ? '40px' : '60px' }}; }
        .footerLeft { font-size: 11px; color:#111; max-width: 60%; }
        .footerLeft .muted { font-size: 11px; }
        .signature { display:flex; justify-content:flex-end; }
        .sigBox { width: 260px; text-align: center; }
        .sigLine { border-top: 1px solid #111; margin-top: 10px; padding-top: 6px; font-size: 12px; }
        @media print { .no-print { display:none !important; } body { margin: 0; } }

        /* Dompdf compatibility: avoid flex in header/footer. */
        .pdf-header { width:100%; border-collapse: collapse; }
        .pdf-header td { vertical-align: top; }
        .pdf-header .right { text-align:right; }
        .pdf-header .badgeWrap { margin-bottom: 6px; }
        .pdf-brand { width:100%; border-collapse: collapse; }
        .pdf-brand td { vertical-align: top; }
        .pdf-brand .logo { width: 56px; text-align:right; }
        .pdf-footer { width:100%; border-collapse: collapse; }
        .pdf-footer td { vertical-align: bottom; }
    </style>
</head>
<body>
    <div class="no-print">
        <button type="button" onclick="window.print();">Print</button>
    </div>

    @php
        // Robust defaults (prevents Dompdf "Undefined variable" issues).
        $settings = $settings ?? [];

        $businessName = (string) (session('business.name') ?: session('business.business_name') ?: config('app.name', 'Business'));
        $headerName = !empty($profile) && !empty($profile->name) ? (string) $profile->name : $businessName;

        $logoFallbackUrl = null;
        if (!empty($profile) && !empty($profile->logo)) {
            try {
                $logoFallbackUrl = \Illuminate\Support\Facades\Storage::url('mosque_logos/'.$profile->logo);
            } catch (\Exception $e) {
                $logoFallbackUrl = null;
            }
        }
        $logoSrc = $logoDataUri ?? $logoFallbackUrl;

        $periodLabel = (string) ($payslip->period_ym ?? '');
        try {
            $periodLabel = \Carbon\Carbon::createFromFormat('Y-m', (string) $payslip->period_ym)->format('F Y');
        } catch (\Exception $e) {
        }

        $paid = !empty($payslip->paid_on);
        $badgeClass = $paid ? 'paid' : 'due';
        $badgeText = $paid ? 'PAID' : 'DUE';

        $money = function ($v) use ($settings) {
            return \Modules\Mosque\Utils\MosqueDocumentUtil::formatMoney($v, $settings);
        };

        $gross = (float) ($payslip->gross ?? 0);
        $bonusAmount = (float) ($payslip->bonus_amount ?? 0);
        $deductionAmount = (float) ($payslip->deduction_amount ?? 0);

        $bonusLines = [];
        if (!empty($payslip->bonus_lines) && is_array($payslip->bonus_lines)) {
            $bonusLines = $payslip->bonus_lines;
        } elseif ($bonusAmount > 0) {
            $bonusLines = [['label' => (string) ($payslip->bonus_reason ?? 'Bonus'), 'amount' => $bonusAmount]];
        }

        $deductionLines = [];
        if (!empty($payslip->deduction_lines) && is_array($payslip->deduction_lines)) {
            $deductionLines = $payslip->deduction_lines;
        } elseif ($deductionAmount > 0) {
            $deductionLines = [['label' => 'Deductions', 'amount' => $deductionAmount]];
        }

        $bonusAmount = array_sum(array_map(fn($x) => (float) ($x['amount'] ?? 0), $bonusLines));
        $deductionAmount = array_sum(array_map(fn($x) => (float) ($x['amount'] ?? 0), $deductionLines));
        $deduction = $deductionAmount;

        $totalEarn = $gross + $bonusAmount;
        $netPay = max($totalEarn - $deductionAmount, 0);
        $paidAmount = (float) ($payslip->paid_amount ?? 0);

        $authName = (string) ($settings['payslip_authority_name'] ?? '');
        $authTitle = (string) ($settings['payslip_authority_title'] ?? '');
        $sigFile = (string) ($settings['payslip_signature'] ?? '');
        $sigUrl = $sigFile !== '' ? url('uploads/mosque/signatures/'.$sigFile) : null;

        $mosquePhone = !empty($profile) ? (string) ($profile->phone ?? '') : '';
        $mosqueEmail = !empty($profile) ? (string) ($profile->email ?? '') : '';
        $mosqueAddr = !empty($profile) ? (string) ($profile->address ?? '') : '';
        $mosqueCountry = !empty($profile) ? (string) ($profile->country ?? '') : '';
        $mosqueReg = !empty($profile) ? (string) ($profile->reg_no ?? '') : '';
        $headerText = !empty($profile) ? (string) ($profile->header_text ?? '') : '';

        $infoLine1 = trim($mosqueAddr);
        if ($mosqueCountry !== '') {
            $infoLine1 = trim($infoLine1 !== '' ? ($infoLine1.', '.$mosqueCountry) : $mosqueCountry);
        }
        $infoLine2Parts = [];
        if ($mosquePhone !== '') { $infoLine2Parts[] = 'Contact: '.$mosquePhone; }
        if ($mosqueEmail !== '') { $infoLine2Parts[] = 'Email: '.$mosqueEmail; }
        if ($mosqueReg !== '') { $infoLine2Parts[] = 'Reg#: '.$mosqueReg; }
        $infoLine2 = implode(' | ', $infoLine2Parts);
    @endphp

    @php
        // Extra safety: ensure all header variables exist even if a previous block exits early.
        $settings = $settings ?? [];

        $paid = $paid ?? !empty($payslip->paid_on);
        $badgeClass = $badgeClass ?? ($paid ? 'paid' : 'due');
        $badgeText = $badgeText ?? ($paid ? 'PAID' : 'DUE');

        $headerName = $headerName ?? (!empty($profile) && !empty($profile->name)
            ? (string) $profile->name
            : (function () {
                try {
                    $name = session('business.name') ?: session('business.business_name');
                } catch (\Throwable $e) {
                    $name = null;
                }

                return (string) ($name ?: config('app.name', 'Business'));
            })());

        $periodLabel = $periodLabel ?? (string) ($payslip->period_ym ?? '');
        if (!empty($payslip->period_ym)) {
            try {
                $periodLabel = \Carbon\Carbon::createFromFormat('Y-m', (string) $payslip->period_ym)->format('F Y');
            } catch (\Exception $e) {
            }
        }

        $infoLine1 = $infoLine1 ?? '';
        $infoLine2 = $infoLine2 ?? '';

        $money = $money ?? function ($v) use ($settings) {
            return \Modules\Mosque\Utils\MosqueDocumentUtil::formatMoney($v, $settings);
        };
        $deduction = $deduction ?? (float) ($payslip->deduction_amount ?? 0);
    @endphp

    @if($is_pdf)
        <table class="pdf-header">
            <tr>
                <td style="width:58%;">
                    <div class="title">Payroll of {{ $staff->name }} for {{ $periodLabel ?? $payslip->period_ym }}</div>
                    <div class="muted">Payslip for the month of {{ $periodLabel ?? $payslip->period_ym }}</div>
                </td>
                <td class="right" style="width:42%;">
                    <div class="badgeWrap"><span class="badge {{ $badgeClass }}">{{ $badgeText }}</span></div>
                    <table class="pdf-brand">
                        <tr>
                            <td class="right">
                                <div class="brandName">{{ $headerName }}</div>
                                <div class="muted brandInfo">
                                    @if(($infoLine1 ?? '') !== ''){{ $infoLine1 }}@endif
                                    @if(($infoLine2 ?? '') !== '')<br>{{ $infoLine2 }}@endif
                                </div>
                            </td>
                            @if(!empty($logoSrc))
                                <td class="logo">
                                    <img class="brandLogo" src="{{ $logoSrc }}" alt="Logo">
                                </td>
                            @endif
                        </tr>
                    </table>
                </td>
            </tr>
        </table>
    @else
        <div class="topline">
            <div>
                <h1 class="title">Payroll of {{ $staff->name }} for {{ $periodLabel ?? $payslip->period_ym }}</h1>
                <div class="muted">Payslip for the month of {{ $periodLabel ?? $payslip->period_ym }}</div>
            </div>
            <div class="brand">
                <div class="brandRow" style="margin-bottom:6px;">
                    <span class="badge {{ $badgeClass }}">{{ $badgeText }}</span>
                </div>
                <div class="brandRow">
                    @if(!empty($logoSrc))
                        <img class="brandLogo" src="{{ $logoSrc }}" alt="Logo">
                    @endif
                    <div>
                        <div class="brandName">{{ $headerName }}</div>
                        <div class="muted brandInfo">
                            @if(($infoLine1 ?? '') !== ''){{ $infoLine1 }}@endif
                            @if(($infoLine2 ?? '') !== '')<br>{{ $infoLine2 }}@endif
                        </div>
                    </div>
                </div>
            </div>
        </div>
    @endif

    <div class="card">
        <div class="head">Payslip Details</div>
        <table class="twoCol">
            <tr>
                <td style="width:50%;">
                    <table class="kv">
                        <tr><td class="k">Employee:</td><td>{{ $staff->name }}</td></tr>
                        <tr><td class="k">Designation:</td><td>{{ $staff->designation ?? '-' }}</td></tr>
                        <tr><td class="k">Mobile:</td><td>{{ $staff->phone ?? '-' }}</td></tr>
                        <tr><td class="k">Email:</td><td>{{ $staff->email ?? '-' }}</td></tr>
                        <tr><td class="k">Period:</td><td>{{ $periodLabel ?? $payslip->period_ym }}</td></tr>
                    </table>
                </td>
                <td style="width:50%;">
                    <table class="kv">
                        <tr><td class="k">Payment date:</td><td>{{ ! empty($payslip->paid_on) ? \Carbon\Carbon::parse($payslip->paid_on)->format('Y-m-d') : '-' }}</td></tr>
                        <tr><td class="k">Payment method:</td><td>{{ !empty($payslip->payment_method) ? strtoupper($payslip->payment_method) : '-' }}</td></tr>
                        <tr><td class="k">Reference no:</td><td>{{ $payslip->payment_ref_no ?? '-' }}</td></tr>
                        <tr><td class="k">Paid amount:</td><td>{{ $paid ? $money($paidAmount) : '-' }}</td></tr>
                    </table>
                </td>
            </tr>
        </table>

        <table class="salary">
            <tr>
                <th style="width:50%;">Earnings</th>
                <th class="num" style="width:15%;">Amount</th>
                <th style="width:35%;">Deductions</th>
                <th class="num" style="width:15%;">Amount</th>
            </tr>
            <tr>
                <td>Basic salary</td>
                <td class="num">{{ $money($gross) }}</td>
                <td>{{ !empty($deductionLines) ? (string) ($deductionLines[0]['label'] ?? 'Deductions') : 'None' }}</td>
                <td class="num">{{ $money((float) (!empty($deductionLines) ? ($deductionLines[0]['amount'] ?? 0) : 0)) }}</td>
            </tr>
            @php($dedShown = !empty($deductionLines) ? 1 : 0)
            @foreach($bonusLines as $bl)
                @php($blLabel = (string) ($bl['label'] ?? 'Bonus'))
                @php($blAmt = (float) ($bl['amount'] ?? 0))
                @php($dlUsed = null)
                @if(!empty($deductionLines) && $dedShown < count($deductionLines))
                    @php($dlUsed = $deductionLines[$dedShown])
                    @php($dedShown++)
                @endif
                <tr>
                    <td>Bonus{{ $blLabel !== '' ? ' ('.$blLabel.')' : '' }}</td>
                    <td class="num">{{ $money($blAmt) }}</td>
                    <td>
                        {{ !empty($dlUsed) ? (string) ($dlUsed['label'] ?? 'Deduction') : '' }}
                    </td>
                    <td class="num">
                        {{ !empty($dlUsed) ? $money((float) ($dlUsed['amount'] ?? 0)) : '' }}
                    </td>
                </tr>
            @endforeach
            @if(!empty($deductionLines) && $dedShown < count($deductionLines))
                @for($i = $dedShown; $i < count($deductionLines); $i++)
                    @php($dl = $deductionLines[$i])
                    <tr>
                        <td></td><td class="num"></td>
                        <td>{{ (string) ($dl['label'] ?? 'Deduction') }}</td>
                        <td class="num">{{ $money((float) ($dl['amount'] ?? 0)) }}</td>
                    </tr>
                @endfor
            @endif
            <tr>
                <th>Total earnings</th>
                <th class="num">{{ $money($totalEarn) }}</th>
                <th>Total deductions</th>
                <th class="num">{{ $money($deduction) }}</th>
            </tr>
            <tr>
                <th colspan="3">Net pay</th>
                <th class="num">{{ $money($netPay) }}</th>
            </tr>
        </table>

        <div class="noteBox">
            <strong>Payment info:</strong>
            <table class="payinfo">
                <thead>
                    <tr>
                        <th style="width:16%;">Date</th>
                        <th style="width:20%;">Reference No</th>
                        <th style="width:16%;">Amount</th>
                        <th style="width:20%;">Payment mode</th>
                        <th>Payment note</th>
                    </tr>
                </thead>
                <tbody>
                    @if($paid)
                        <tr>
                            <td>{{ \Carbon\Carbon::parse($payslip->paid_on)->format('Y-m-d') }}</td>
                            <td>{{ $payslip->payment_ref_no ?? '-' }}</td>
                            <td>{{ $money($paidAmount > 0 ? $paidAmount : $netPay) }}</td>
                            <td>{{ !empty($payslip->payment_method) ? strtoupper($payslip->payment_method) : '-' }}</td>
                            <td>{{ $payslip->payment_note ?? '' }}</td>
                        </tr>
                    @else
                        <tr>
                            <td colspan="5" style="text-align:center;color:#667085;">No records found</td>
                        </tr>
                    @endif
                </tbody>
            </table>
        </div>
    </div>

    @if(!empty($payslip->note))
        <div class="card">
            <strong>Note</strong><br>
            <div class="noteBox">{!! nl2br(e($payslip->note)) !!}</div>
        </div>
    @endif

    <div class="footer">
        @if($is_pdf)
            <table class="pdf-footer">
                <tr>
                    <td style="width:62%;">
                        <div style="font-weight:700;">{{ $headerName }}</div>
                        @if(($infoLine1 ?? '') !== '')<div class="muted">{{ $infoLine1 }}</div>@endif
                        @if(($infoLine2 ?? '') !== '')<div class="muted">{{ $infoLine2 }}</div>@endif
                        @if($headerText !== '')<div class="muted">{!! nl2br(e($headerText)) !!}</div>@endif
                    </td>
                    <td style="width:38%; text-align:right;">
                        <div class="sigBox" style="margin-left:auto;">
                            @if(!empty($sigUrl))
                                <div><img src="{{ $sigUrl }}" alt="Signature" style="max-height:60px; max-width: 220px;"></div>
                            @endif
                            <div class="sigLine">
                                <div style="font-weight:700;">{{ $authName !== '' ? $authName : 'Authorized Signature' }}</div>
                                @if($authTitle !== '')<div class="muted">{{ $authTitle }}</div>@endif
                            </div>
                        </div>
                    </td>
                </tr>
            </table>
        @else
            <div class="footerLeft">
                <div style="font-weight:700;">{{ $headerName }}</div>
                @if($mosqueAddr !== '' || $mosqueCountry !== '')
                    <div class="muted">
                        {{ trim($mosqueAddr) }}
                        @if($mosqueCountry !== ''){{ $mosqueAddr !== '' ? ', ' : '' }}{{ $mosqueCountry }}@endif
                    </div>
                @endif
                @if($mosquePhone !== '' || $mosqueEmail !== '')
                    <div class="muted">
                        @if($mosquePhone !== '')Contact: {{ $mosquePhone }}@endif
                        @if($mosqueEmail !== ''){{ $mosquePhone !== '' ? ' | ' : '' }}Email: {{ $mosqueEmail }}@endif
                    </div>
                @endif
                @if($headerText !== '')
                    <div class="muted">{!! nl2br(e($headerText)) !!}</div>
                @endif
            </div>

            <div class="signature">
                <div class="sigBox">
                    @if(!empty($sigUrl))
                        <div><img src="{{ $sigUrl }}" alt="Signature" style="max-height:60px; max-width: 220px;"></div>
                    @endif
                    <div class="sigLine">
                        <div style="font-weight:700;">{{ $authName !== '' ? $authName : 'Authorized Signature' }}</div>
                        @if($authTitle !== '')<div class="muted">{{ $authTitle }}</div>@endif
                    </div>
                </div>
            </div>
        @endif
    </div>
</body>
</html>
