<div class="modal-dialog" role="document">
    <div class="modal-content">
        <style>
            .mosque-staff-modal .modal-header { background: linear-gradient(135deg,#0ea5a0,#2563eb); color:#fff; }
            .mosque-staff-modal .modal-title { color:#fff; }
            .mosque-staff-modal .modal-body { background: #f6fbff; }
            .mosque-staff-card { background:#fff; border:1px solid #e6eef7; border-radius:10px; padding:12px; margin-bottom:12px; }
            .mosque-photo-preview { width: 90px; height: 90px; border-radius: 12px; border: 1px solid #e6eef7; object-fit: cover; background: #fff; }
            .mosque-staff-modal .select2-container { width: 100% !important; }
            .mosque-staff-modal .select2-selection__rendered { white-space: nowrap; overflow: hidden; text-overflow: ellipsis; }
            .mosque-staff-modal .select2-container--default .select2-selection--single { height: 34px; padding: 2px 6px; }
            .mosque-staff-modal .select2-container--default .select2-selection--single .select2-selection__rendered { line-height: 28px; font-size: 12px; }
            .mosque-staff-modal .select2-container--default .select2-selection--single .select2-selection__arrow { height: 32px; }
            .select2-container--default .select2-results__option { font-size: 12px; }
        </style>
        {!! Form::open(['url' => route('mosque.staff.store'), 'method' => 'post', 'id' => 'mosque_staff_form', 'files' => true]) !!}
        <div class="modal-header">
            <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
            <h4 class="modal-title">@lang('messages.add')</h4>
        </div>
        <div class="modal-body mosque-staff-modal">
            <div class="row">
                <div class="col-sm-12">
                    <div class="mosque-staff-card">
                        <div class="row" style="display:flex; align-items:center; gap:12px;">
                            <div>
                                <img id="mosque_staff_photo_preview" class="mosque-photo-preview" src="{{ asset('img/default.png') }}" alt="Photo">
                            </div>
                            <div style="flex:1;">
                                <div class="form-group" style="margin-bottom:6px;">
                                    {!! Form::label('photo', 'Staff Photo:') !!}
                                    <input type="file" name="photo" id="mosque_staff_photo_file" class="form-control" accept="image/*">
                                </div>
                                <div class="form-group" style="margin-bottom:0;">
                                    <button type="button" class="btn btn-default" id="mosque_staff_open_camera">
                                        <i class="fa fa-camera"></i> Use Camera
                                    </button>
                                    {!! Form::hidden('photo_capture', null, ['id' => 'mosque_staff_photo_capture']) !!}
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="col-sm-6">
                    <div class="form-group mosque-staff-card">
                        {!! Form::label('name', __('user.name') . ':*') !!}
                        {!! Form::text('name', null, ['class' => 'form-control', 'required']) !!}
                    </div>
                </div>
                <div class="col-sm-6">
                    <div class="form-group mosque-staff-card">
                        {!! Form::label('designation_role_id', 'Designation:') !!}
                        @php($rolesList = !empty($roles) ? $roles : collect())
                        @if($rolesList->count())
                            {!! Form::select('designation_role_id', $rolesList, null, ['class' => 'form-control select2', 'placeholder' => __('lang_v1.none'), 'id' => 'mosque_staff_designation_role', 'required']) !!}
                            {!! Form::hidden('designation', null, ['id' => 'mosque_staff_designation_hidden']) !!}
                        @endif
                    </div>
                </div>

                <div class="col-sm-6">
                    <div class="form-group mosque-staff-card">
                        {!! Form::label('phone_national', 'Mobile:*') !!}
                        <div class="row" style="margin-top:0;">
                            <div class="col-xs-4">
                                <select name="country_iso2" id="mosque_staff_country" class="form-control select2" style="width:100%;" required>
                                    <option value="">@lang('lang_v1.none')</option>
                                    @php($defC = strtoupper((string) ($defaultCountry ?? '')))
                                    @foreach(($phoneCountries ?? []) as $c)
                                        @php($cc = strtoupper((string) ($c['country_iso2'] ?? '')))
                                        @php($dial = (string) ($c['dial_code'] ?? ''))
                                        @php($name = (string) ($c['name'] ?? ''))
                                        <option value="{{ $cc }}" data-dial="{{ $dial }}" data-name="{{ $name }}" {{ $defC === $cc ? 'selected' : '' }}>{{ $dial }}</option>
                                    @endforeach
                                </select>
                                {!! Form::hidden('dial_code', null, ['id' => 'mosque_staff_dial']) !!}
                            </div>
                            <div class="col-xs-8">
                                <input type="text" id="mosque_staff_phone_national" name="phone_national" class="form-control" required placeholder="017XXXXXXXX">
                                {!! Form::hidden('phone', null, ['id' => 'mosque_staff_phone_full']) !!}
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-sm-6">
                    <div class="form-group mosque-staff-card">
                        {!! Form::label('email', __('business.email') . ':') !!}
                        {!! Form::email('email', null, ['class' => 'form-control']) !!}
                    </div>
                </div>
                <div class="col-sm-6">
                    <div class="form-group mosque-staff-card">
                        {!! Form::label('salary', 'Salary:') !!}
                        {!! Form::number('salary', null, ['class' => 'form-control', 'step' => '0.01']) !!}
                    </div>
                </div>
                <div class="col-sm-6">
                    <div class="form-group mosque-staff-card">
                        {!! Form::label('status', 'Status:') !!}
                        {!! Form::text('status', 'active', ['class' => 'form-control']) !!}
                    </div>
                </div>
                <div class="col-sm-6">
                    <div class="form-group mosque-staff-card">
                        <div style="display:flex; align-items:center; justify-content:space-between; gap:10px;">
                            {!! Form::label('whatsapp_national', 'WhatsApp:', ['style' => 'margin:0;']) !!}
                            <label class="checkbox-inline" style="margin:0;">
                                <input type="checkbox" id="mosque_staff_whatsapp_same" name="whatsapp_same_as_phone" value="1" checked>
                                Same as mobile
                            </label>
                        </div>
                        <input type="text" id="mosque_staff_whatsapp_national" name="whatsapp_national" class="form-control" placeholder="017XXXXXXXX">
                        {!! Form::hidden('whatsapp_number', null, ['id' => 'mosque_staff_whatsapp_full']) !!}
                    </div>
                </div>
            </div>
        </div>
        <div class="modal-footer">
            <button type="submit" class="btn btn-primary">@lang('messages.save')</button>
            <button type="button" class="btn btn-default" data-dismiss="modal">@lang('messages.close')</button>
        </div>
        {!! Form::close() !!}
    </div>
</div>

<script type="text/javascript">
    $(function () {
        $('#mosque_staff_designation_role').select2({ width: '100%' });

        function ccToFlagEmoji(cc) {
            if (!cc || cc.length !== 2) return '';
            var A = 0x1F1E6, offset = 0x41;
            cc = cc.toUpperCase();
            return String.fromCodePoint(A + cc.charCodeAt(0) - offset) + String.fromCodePoint(A + cc.charCodeAt(1) - offset);
        }
        function formatCountry(option) {
            if (!option.id) return option.text;
            var flag = ccToFlagEmoji(option.id);
            var dial = '';
            var name = '';
            try {
                dial = option.element ? ($(option.element).data('dial') || option.text || '') : (option.text || '');
                name = option.element ? ($(option.element).data('name') || '') : '';
            } catch (e) {
                dial = option.text || '';
                name = '';
            }
            var label = dial;
            if (name) {
                label = dial + ' — ' + name;
            }
            return $('<span>' + flag + ' ' + label + '</span>');
        }
        function formatCountrySelection(option) {
            if (!option.id) return option.text;
            var flag = ccToFlagEmoji(option.id);
            var dial = '';
            try {
                dial = option.element ? ($(option.element).data('dial') || '') : '';
            } catch (e) {
                dial = '';
            }
            return $('<span>' + flag + ' ' + (dial || option.id) + '</span>');
        }

        function initCountrySelect() {
            var $el = $('#mosque_staff_country');
            if ($el.hasClass('select2-hidden-accessible')) {
                $el.select2('destroy');
            }
            $el.select2({
                width: '100%',
                dropdownAutoWidth: true,
                dropdownParent: $el.closest('.modal'),
                templateResult: formatCountry,
                templateSelection: formatCountrySelection,
                matcher: function (params, data) {
                    if ($.trim(params.term) === '') {
                        return data;
                    }
                    var term = (params.term || '').toString().toLowerCase();
                    var text = (data.text || '').toString().toLowerCase();
                    var name = '';
                    var dial = '';
                    try {
                        name = data.element ? ($(data.element).data('name') || '') : '';
                        dial = data.element ? ($(data.element).data('dial') || '') : '';
                    } catch (e) {
                        name = '';
                        dial = '';
                    }
                    name = name.toString().toLowerCase();
                    dial = dial.toString().toLowerCase();
                    if (text.indexOf(term) > -1 || name.indexOf(term) > -1 || dial.indexOf(term) > -1) {
                        return data;
                    }
                    return null;
                }
            });
        }
        initCountrySelect();

        function normalizeDigits(v) {
            return (v || '').toString().replace(/\D+/g, '');
        }

        function updateDialHidden() {
            var opt = $('#mosque_staff_country option:selected');
            var dial = (opt.data('dial') || '').toString();
            $('#mosque_staff_dial').val(dial);
            return dial;
        }

        function updateWhatsappLock() {
            var same = $('#mosque_staff_whatsapp_same').is(':checked');
            $('#mosque_staff_whatsapp_national').prop('readonly', same);
            if (same) {
                $('#mosque_staff_whatsapp_national').val($('#mosque_staff_phone_national').val());
            }
        }

        function updateFullNumbers() {
            var dial = updateDialHidden();
            var national = normalizeDigits($('#mosque_staff_phone_national').val());
            var dialDigits = normalizeDigits(dial);
            var full = (dialDigits ? ('+' + dialDigits + national) : '');
            $('#mosque_staff_phone_full').val(full);
            if ($('#mosque_staff_whatsapp_same').is(':checked')) {
                $('#mosque_staff_whatsapp_full').val(full);
            } else {
                var wa = normalizeDigits($('#mosque_staff_whatsapp_national').val());
                var waFull = (dialDigits && wa ? ('+' + dialDigits + wa) : '');
                $('#mosque_staff_whatsapp_full').val(waFull);
            }
        }

        $(document).on('change', '#mosque_staff_country', function () {
            updateFullNumbers();
        });
        $(document).on('keyup change', '#mosque_staff_phone_national', function () {
            if ($('#mosque_staff_whatsapp_same').is(':checked')) {
                $('#mosque_staff_whatsapp_national').val($(this).val());
            }
            updateFullNumbers();
        });
        $(document).on('keyup change', '#mosque_staff_whatsapp_national', updateFullNumbers);
        $(document).on('change', '#mosque_staff_whatsapp_same', function () {
            updateWhatsappLock();
            updateFullNumbers();
        });
        updateWhatsappLock();
        updateFullNumbers();

        $(document).on('change', '#mosque_staff_designation_role', function () {
            var text = $('#mosque_staff_designation_role option:selected').text() || '';
            if (text && text !== 'None') {
                $('#mosque_staff_designation_hidden').val(text);
            }
        });
        $(document).trigger('change', '#mosque_staff_designation_role');

        // Photo preview (upload)
        $('#mosque_staff_photo_file').on('change', function (e) {
            var f = e.target.files && e.target.files[0];
            if (!f) return;
            var reader = new FileReader();
            reader.onload = function (ev) {
                $('#mosque_staff_photo_preview').attr('src', ev.target.result);
            };
            reader.readAsDataURL(f);
        });

        // Camera capture modal
        var stream = null;
        function stopStream() {
            if (stream) {
                stream.getTracks().forEach(function (t) { t.stop(); });
                stream = null;
            }
        }

        $(document).on('click', '#mosque_staff_open_camera', async function () {
            if (!window.isSecureContext) {
                toastr.error('Camera requires HTTPS (or localhost). Please open the app on https:// and try again.');
                return;
            }
            if (!navigator.mediaDevices || !navigator.mediaDevices.getUserMedia) {
                toastr.error('Camera is not supported in this browser.');
                return;
            }
            try {
                $('#mosque_staff_camera_modal').modal('show');
                stream = await navigator.mediaDevices.getUserMedia({ video: true, audio: false });
                var v = document.getElementById('mosque_staff_camera_video');
                v.srcObject = stream;
                v.play();
            } catch (e) {
                var msg = 'Camera permission denied. Please allow camera access for this site.';
                if (e && e.name === 'NotFoundError') {
                    msg = 'No camera device found.';
                } else if (e && e.name === 'NotAllowedError') {
                    msg = 'Camera permission denied. Please allow camera access for this site.';
                } else if (e && e.name === 'NotReadableError') {
                    msg = 'Camera is busy or not readable. Close other apps using camera and try again.';
                }
                toastr.error(msg);
                stopStream();
                $('#mosque_staff_camera_modal').modal('hide');
            }
        });

        $(document).on('click', '#mosque_staff_camera_capture_btn', function () {
            var v = document.getElementById('mosque_staff_camera_video');
            var c = document.getElementById('mosque_staff_camera_canvas');
            var ctx = c.getContext('2d');
            c.width = v.videoWidth || 640;
            c.height = v.videoHeight || 480;
            ctx.drawImage(v, 0, 0, c.width, c.height);
            var dataUrl = c.toDataURL('image/jpeg', 0.9);
            $('#mosque_staff_photo_preview').attr('src', dataUrl);
            $('#mosque_staff_photo_capture').val(dataUrl);
            $('#mosque_staff_camera_modal').modal('hide');
            stopStream();
        });

        $('#mosque_staff_camera_modal').on('hidden.bs.modal', function () {
            stopStream();
        });
    });
</script>

<div class="modal fade" id="mosque_staff_camera_modal" tabindex="-1" role="dialog" aria-labelledby="mosqueStaffCameraLabel">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                <h4 class="modal-title" id="mosqueStaffCameraLabel">Capture Photo</h4>
            </div>
            <div class="modal-body">
                <video id="mosque_staff_camera_video" style="width:100%; border-radius:8px; background:#000;" playsinline></video>
                <canvas id="mosque_staff_camera_canvas" style="display:none;"></canvas>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-primary" id="mosque_staff_camera_capture_btn">Capture</button>
                <button type="button" class="btn btn-default" data-dismiss="modal">@lang('messages.close')</button>
            </div>
        </div>
    </div>
</div>
