﻿@extends('mosque::layouts.app')
@section('title', __('mosque::mosque.menu_tenancy') . ' | ' . __('mosque::mosque.tenancy_billing'))

@section('content')
<section class="content-header">
    <h1 class="tw-text-xl md:tw-text-3xl tw-font-bold tw-text-black">@lang('mosque::mosque.menu_tenancy')</h1>
</section>

<section class="content">
    @component('components.widget', ['class' => 'box-primary'])
        @include('mosque::tenancy.partials.nav')

        <div class="row" style="margin-top:15px;">
            <div class="col-sm-3">
                <div class="form-group">
                    <label>@lang('report.date_range')</label>
                    <input type="text" class="form-control" id="ten_bill_date_range" placeholder="@lang('report.date_range')">
                </div>
            </div>
            <div class="col-sm-3">
                <div class="form-group">
                    <label>@lang('mosque::mosque.tenancy_status')</label>
                    <select class="form-control" id="ten_bill_status">
                        <option value="">@lang('mosque::mosque.tenancy_all')</option>
                        <option value="unpaid">@lang('mosque::mosque.tenancy_unpaid')</option>
                        <option value="partially_paid">@lang('mosque::mosque.tenancy_partially_paid')</option>
                        <option value="paid">@lang('mosque::mosque.tenancy_paid')</option>
                    </select>
                </div>
            </div>
            <div class="col-sm-3">
                <div class="form-group">
                    <label>@lang('mosque::mosque.tenancy_cycle')</label>
                    <select class="form-control" id="ten_bill_cycle">
                        <option value="">@lang('mosque::mosque.tenancy_all')</option>
                        <option value="monthly">@lang('mosque::mosque.tenancy_cycle_monthly')</option>
                        <option value="yearly">@lang('mosque::mosque.tenancy_cycle_yearly')</option>
                    </select>
                </div>
            </div>
            <div class="col-sm-3 text-right" style="padding-top:24px;">
                @can('mosque.tenancy.billing.run')
                    <button type="button" class="btn btn-primary mosque_ajax_post" data-href="{{ route('mosque.tenancy.billing.generate', [], false) }}">
                        <i class="fa fa-bolt"></i> @lang('mosque::mosque.tenancy_generate_due_bills')
                    </button>
                @endcan
            </div>
        </div>

        <div class="table-responsive" style="margin-top:10px;">
            <table class="table table-bordered table-striped" id="ten_bills_table" style="width:100%;">
                <thead>
                    <tr>
                        <th>@lang('mosque::mosque.tenancy_period')</th>
                        <th>@lang('mosque::mosque.tenancy_tenant')</th>
                        <th>@lang('mosque::mosque.tenancy_seat')</th>
                        <th>@lang('mosque::mosque.tenancy_amount')</th>
                        <th>@lang('mosque::mosque.tenancy_status')</th>
                        <th>@lang('messages.action')</th>
                    </tr>
                </thead>
            </table>
        </div>
    @endcomponent
</section>
@endsection

@section('javascript')
<script>
    $(document).ready(function () {
        if ($.fn.daterangepicker && typeof dateRangeSettings !== 'undefined') {
            $('#ten_bill_date_range').daterangepicker(dateRangeSettings, function () {});
        }

        var table = $('#ten_bills_table').DataTable({
            processing: true,
            serverSide: true,
            ajax: {
                url: '{{ route("mosque.tenancy.billing.data", [], false) }}',
                data: function (d) {
                    d.date_range = $('#ten_bill_date_range').val();
                    d.status = $('#ten_bill_status').val();
                    d.cycle = $('#ten_bill_cycle').val();
                }
            },
            dom: 'lBfrtip',
            buttons: [
                { extend: 'csv', text: '<i class="fas fa-file-csv"></i>', className: 'btn btn-success' },
                { extend: 'excel', text: '<i class="fas fa-file-excel"></i>', className: 'btn btn-info' },
                { extend: 'pdf', text: '<i class="fas fa-file-pdf"></i>', className: 'btn btn-danger' },
                { extend: 'print', text: '<i class="fas fa-print"></i>', className: 'btn btn-warning' },
                { extend: 'colvis', text: '<i class="fas fa-eye"></i>', className: 'btn btn-primary' }
            ],
            columns: [
                { data: null, name: 'period_from', render: function (d, t, r) { return (r.period_from || '') + ' - ' + (r.period_to || ''); } },
                { data: 'tenant_name', name: 'tenant_name' },
                { data: 'seat_label', name: 'seat_label', orderable: false },
                { data: 'amount_display', name: 'amount', orderable: false, searchable: false },
                { data: 'status', name: 'status' },
                { data: 'action', name: 'action', orderable: false, searchable: false }
            ],
            drawCallback: function () { if (typeof __currency_convert_recursively === 'function') { __currency_convert_recursively($('#ten_bills_table')); } }
        });

        $('#ten_bill_date_range, #ten_bill_status, #ten_bill_cycle').on('change', function () { table.ajax.reload(); });

        $(document).on('click', '.mosque_ajax_post', function (e) {
            e.preventDefault();
            var url = $(this).data('href');
            if (!url) return;
            $.ajax({
                method: 'POST',
                url: url,
                data: { _token: '{{ csrf_token() }}' },
                dataType: 'json',
                success: function (resp) {
                    if (resp && resp.success) {
                        toastr.success(resp.msg || @json(__('mosque::mosque.tenancy_success')));
                        if (resp.whatsapp_links && resp.whatsapp_links.length && typeof openWhatsAppLinksModal === 'function') {
                            openWhatsAppLinksModal(resp.whatsapp_links);
                        }
                        table.ajax.reload();
                    } else {
                        toastr.error((resp && resp.msg) ? resp.msg : @json(__('messages.something_went_wrong')));
                    }
                },
                error: function () { toastr.error(@json(__('messages.something_went_wrong'))); }
            });
        });
    });
</script>
@endsection

