<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>Tenancy Receipt</title>
    <style>
        body{font-family:Arial, sans-serif;font-size:12px;color:#111827}
        .header{display:flex;align-items:center;justify-content:space-between;border-bottom:2px solid #111827;padding-bottom:10px;margin-bottom:10px}
        .title{font-size:18px;font-weight:700;margin:0}
        .muted{color:#6b7280}
        .box{border:1px solid #e5e7eb;border-radius:10px;padding:10px;margin-top:10px}
        table{width:100%;border-collapse:collapse}
        th,td{border:1px solid #e5e7eb;padding:8px;text-align:left}
        th{background:#f3f4f6}
        .right{text-align:right}
    </style>
</head>
<body>
    <div class="header">
        <div>
            <p class="title">{{ $profile->name ?? __('mosque::mosque.mosque') }}</p>
            <p class="muted" style="margin:2px 0;">@lang('mosque::mosque.tenancy_rent_receipt')</p>
        </div>
        <div>
            @if(!empty($logoDataUri))
                <img src="{{ $logoDataUri }}" style="height:55px;">
            @endif
        </div>
    </div>

    @php
        $alloc = $bill->allocation;
        $tenant = $alloc?->tenant;
        $seat = $alloc?->seat;
        $room = $seat?->room;
        $floor = $room?->floor;
        $building = $floor?->building;
        $seatLabel = trim(implode(' / ', array_filter([
            $building?->name,
            $floor?->name_or_number,
            $room?->code,
            $seat?->code,
        ])));
    @endphp

    <div class="box">
        <table>
            <tr>
                <th style="width:30%;">@lang('mosque::mosque.tenancy_bill_no')</th>
                <td>#{{ $bill->id }}</td>
                <th style="width:30%;">@lang('mosque::mosque.tenancy_date')</th>
                <td>{{ $bill->generated_on }}</td>
            </tr>
            <tr>
                <th>@lang('mosque::mosque.tenancy_tenant')</th>
                <td>{{ $tenant->full_name ?? '-' }}</td>
                <th>@lang('mosque::mosque.tenancy_phone')</th>
                <td>{{ $tenant->phone ?? '-' }}</td>
            </tr>
            <tr>
                <th>@lang('mosque::mosque.tenancy_seat')</th>
                <td colspan="3">{{ $seatLabel ?: '-' }}</td>
            </tr>
        </table>
    </div>

    <div class="box">
        <table>
            <thead>
                <tr>
                    <th>@lang('mosque::mosque.tenancy_period')</th>
                    <th class="right">@lang('mosque::mosque.tenancy_amount')</th>
                    <th>@lang('mosque::mosque.tenancy_status')</th>
                </tr>
            </thead>
            <tbody>
                <tr>
                    <td>{{ $bill->period_from }} → {{ $bill->period_to }}</td>
                    <td class="right">{{ number_format((float) $bill->amount, 2) }}</td>
                    <td>{{ $bill->status }}</td>
                </tr>
            </tbody>
        </table>
    </div>

    <p class="muted" style="margin-top:18px;">@lang('mosque::mosque.tenancy_receipt_footer')</p>
</body>
</html>

