@extends('mosque::layouts.app')
@section('title', __('mosque::mosque.menu_tenancy') . ' | ' . ($case ? __('messages.edit') : __('messages.add')))

@section('content')
<section class="content-header">
    <h1 class="tw-text-xl md:tw-text-3xl tw-font-bold tw-text-black">@lang('mosque::mosque.menu_tenancy')</h1>
</section>

<section class="content">
    @component('components.widget', ['class' => 'box-primary'])
        @include('mosque::tenancy.partials.nav')

        <form id="ten_case_form" enctype="multipart/form-data" style="margin-top:15px;">
            @csrf
            @if($case)
                @method('PUT')
            @endif

            @if(!$case)
                <div class="row">
                    <div class="col-sm-4">
                        <div class="form-group">
                            <label>@lang('mosque::mosque.tenancy_phone')</label>
                            <input type="text" name="phone" class="form-control input-sm">
                        </div>
                    </div>
                    <div class="col-sm-4">
                        <div class="form-group">
                            <label>@lang('mosque::mosque.tenancy_nid')</label>
                            <input type="text" name="nid_no" class="form-control input-sm">
                        </div>
                    </div>
                    <div class="col-sm-4">
                        <div class="form-group">
                            <label>@lang('mosque::mosque.tenancy_passport')</label>
                            <input type="text" name="passport_no" class="form-control input-sm">
                        </div>
                    </div>
                </div>
                <p class="help-block">@lang('mosque::mosque.tenancy_case_key_help')</p>
            @endif

            <div class="form-group">
                <label>@lang('mosque::mosque.tenancy_case_title') *</label>
                <input type="text" name="title" class="form-control input-sm" value="{{ $case->title ?? '' }}" required>
            </div>

            <div class="form-group">
                <label>@lang('mosque::mosque.tenancy_details') *</label>
                <textarea name="details" class="form-control input-sm" rows="4" required>{{ $case->details ?? '' }}</textarea>
            </div>

            <div class="row">
                <div class="col-sm-4">
                    <div class="form-group">
                        <label>@lang('mosque::mosque.tenancy_severity') *</label>
                        <select name="severity" class="form-control input-sm" required>
                            @foreach(['low','medium','high','critical'] as $sev)
                                <option value="{{ $sev }}" @if(($case->severity ?? '')===$sev) selected @endif>{{ ucfirst($sev) }}</option>
                            @endforeach
                        </select>
                    </div>
                </div>
                <div class="col-sm-8">
                    <div class="form-group">
                        <label>@lang('mosque::mosque.tenancy_attachments')</label>
                        <input type="file" name="attachments[]" class="form-control input-sm" multiple>
                    </div>
                </div>
            </div>

            <div class="text-right">
                <a href="{{ route('mosque.tenancy.cases') }}" class="btn btn-default">@lang('messages.back')</a>
                <button type="submit" class="btn btn-primary">@lang('messages.save')</button>
            </div>
        </form>
    @endcomponent
</section>
@endsection

@php
    $postUrl = $case
        ? route('mosque.tenancy.cases.update', [$case->id], false)
        : route('mosque.tenancy.cases.store', [], false);
@endphp

@section('javascript')
<script>
    $(function () {
        var url = @json($postUrl);
        $('#ten_case_form').on('submit', function (e) {
            e.preventDefault();
            var fd = new FormData(this);
            $.ajax({
                method: 'POST',
                url: url,
                data: fd,
                processData: false,
                contentType: false,
                dataType: 'json',
                success: function (resp) {
                    if (resp && resp.success) {
                        toastr.success(resp.msg || @json(__('mosque::mosque.tenancy_success')));
                        if (resp.redirect) { window.location.href = resp.redirect; }
                    } else {
                        toastr.error((resp && resp.msg) ? resp.msg : @json(__('messages.something_went_wrong')));
                    }
                },
                error: function (xhr) {
                    var msg = @json(__('messages.something_went_wrong'));
                    if (xhr && xhr.responseJSON) {
                        if (xhr.responseJSON.msg) {
                            msg = xhr.responseJSON.msg;
                        } else if (xhr.responseJSON.errors) {
                            var firstKey = Object.keys(xhr.responseJSON.errors)[0];
                            if (firstKey && xhr.responseJSON.errors[firstKey] && xhr.responseJSON.errors[firstKey][0]) {
                                msg = xhr.responseJSON.errors[firstKey][0];
                            }
                        }
                    }
                    toastr.error(msg);
                }
            });
        });
    });
</script>
@endsection
