@extends('mosque::layouts.app')
@section('title', __('mosque::mosque.menu_tenancy') . ' | ' . __('mosque::mosque.tenancy_cases'))

@section('content')
<section class="content-header">
    <h1 class="tw-text-xl md:tw-text-3xl tw-font-bold tw-text-black">@lang('mosque::mosque.menu_tenancy')</h1>
</section>

<section class="content">
    @component('components.widget', ['class' => 'box-primary'])
        @include('mosque::tenancy.partials.nav')

        <div class="row" style="margin-top:15px;">
            <div class="col-sm-12 text-right">
                @can('mosque.tenancy.edit')
                    <a href="{{ route('mosque.tenancy.cases.create') }}" class="btn btn-primary"><i class="fa fa-plus"></i> @lang('messages.add')</a>
                @endcan
            </div>
        </div>

        <div class="table-responsive" style="margin-top:10px;">
            <table class="table table-bordered table-striped" id="ten_cases_table" style="width:100%;">
                <thead>
                    <tr>
                        <th>ID</th>
                        <th>@lang('mosque::mosque.tenancy_case_title')</th>
                        <th>@lang('mosque::mosque.tenancy_severity')</th>
                        <th>@lang('mosque::mosque.tenancy_date')</th>
                        <th>@lang('messages.action')</th>
                    </tr>
                </thead>
            </table>
        </div>
    @endcomponent
</section>
@endsection

@section('javascript')
<script>
    $(document).ready(function () {
        $('#ten_cases_table').DataTable({
            processing: true,
            serverSide: true,
            ajax: '{{ route("mosque.tenancy.cases.data", [], false) }}',
            dom: 'lBfrtip',
            buttons: [
                { extend: 'csv', text: '<i class="fas fa-file-csv"></i>', className: 'btn btn-success' },
                { extend: 'excel', text: '<i class="fas fa-file-excel"></i>', className: 'btn btn-info' },
                { extend: 'pdf', text: '<i class="fas fa-file-pdf"></i>', className: 'btn btn-danger' },
                { extend: 'print', text: '<i class="fas fa-print"></i>', className: 'btn btn-warning' },
                { extend: 'colvis', text: '<i class="fas fa-eye"></i>', className: 'btn btn-primary' }
            ],
            columns: [
                { data: 'id', name: 'id' },
                { data: 'title', name: 'title' },
                { data: 'severity', name: 'severity' },
                { data: 'created_at', name: 'created_at' },
                { data: 'action', name: 'action', orderable: false, searchable: false }
            ]
        });
    });
</script>
@endsection

