<!doctype html>
<html>
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>{{ $qrTitle }}</title>
    <link rel="stylesheet" href="{{ asset('css/bootstrap.min.css') }}">
    <style>
        body{background:#f6f7fb}
        .card{max-width:720px;margin:30px auto;background:#fff;border-radius:14px;box-shadow:0 10px 40px rgba(0,0,0,.08);padding:18px}
        .title{font-weight:800;font-size:18px;margin:0}
        .subtitle{color:#6b7280;margin-top:6px}
        .btn-primary{background:{{ $primaryColor }};border-color:{{ $primaryColor }}}
        label{font-size:12px;color:#374151}
    </style>
</head>
<body>
    <div class="card">
        <p class="title">{{ $qrTitle }}</p>
        <p class="subtitle">@lang('mosque::mosque.tenancy_public_form_hint')</p>

        @if(session('status'))
            @php $st = session('status'); @endphp
            <div class="alert {{ !empty($st['success']) ? 'alert-success' : 'alert-danger' }}">{{ $st['msg'] ?? '' }}</div>
        @endif

        <form method="POST" action="{{ $signedUrl }}">
            @csrf
            <div class="form-group">
                <label>@lang('mosque::mosque.tenancy_name') *</label>
                <input type="text" class="form-control" name="requested_by_name" required>
            </div>
            <div class="form-group">
                <label>@lang('mosque::mosque.tenancy_phone') *</label>
                <input type="text" class="form-control" name="phone" required>
            </div>
            <div class="form-group">
                <label>@lang('mosque::mosque.tenancy_seat')</label>
                <select class="form-control" name="seat_id">
                    <option value="">@lang('mosque::mosque.tenancy_any_seat')</option>
                    @foreach(($seats ?? []) as $s)
                        <option value="{{ $s->seat_token }}">{{ $s->label }} @if($s->leaving_on) (@lang('mosque::mosque.tenancy_leaving_on') {{ $s->leaving_on }}) @endif</option>
                    @endforeach
                </select>
            </div>
            <div class="form-group">
                <label>@lang('mosque::mosque.tenancy_prefer_period')</label>
                <input type="text" class="form-control" name="prefer_period" placeholder="e.g. 3 months">
            </div>
            <div class="form-group">
                <label>@lang('mosque::mosque.tenancy_note')</label>
                <textarea class="form-control" name="notes" rows="3"></textarea>
            </div>
            <button type="submit" class="btn btn-primary btn-block">@lang('mosque::mosque.tenancy_submit_request')</button>
        </form>
    </div>
</body>
</html>
