@extends('mosque::layouts.app')
@section('title', __('mosque::mosque.menu_tenancy') . ' | ' . __('mosque::mosque.tenancy_reports'))

@section('content')
<section class="content-header">
    <h1 class="tw-text-xl md:tw-text-3xl tw-font-bold tw-text-black">@lang('mosque::mosque.menu_tenancy')</h1>
</section>

<section class="content">
    @component('components.widget', ['class' => 'box-primary'])
        @include('mosque::tenancy.partials.nav')

        <div class="row" style="margin-top:15px;">
            <div class="col-sm-3">
                <div class="form-group">
                    <label>@lang('mosque::mosque.tenancy_building')</label>
                    <select class="form-control input-sm" id="ten_rep_building_id">
                        <option value="">@lang('mosque::mosque.tenancy_all_buildings')</option>
                        @foreach(($buildings ?? []) as $id => $name)
                            <option value="{{ $id }}">{{ $name }}</option>
                        @endforeach
                    </select>
                </div>
            </div>
            <div class="col-sm-5">
                <div class="form-group">
                    <label>@lang('mosque::mosque.tenancy_date_range')</label>
                    <div style="display:flex;gap:5px;">
                        <input type="date" class="form-control input-sm" id="ten_rep_start_date" placeholder="{{ __('mosque::mosque.tenancy_start_date') }}">
                        <input type="date" class="form-control input-sm" id="ten_rep_end_date" placeholder="{{ __('mosque::mosque.tenancy_end_date') }}">
                    </div>
                </div>
            </div>
            <div class="col-sm-2">
                <div class="form-group">
                    <label>&nbsp;</label>
                    <button type="button" class="btn btn-primary btn-block btn-sm" id="ten_rep_apply">
                        <i class="fa fa-filter"></i> @lang('messages.apply')
                    </button>
                </div>
            </div>
            <div class="col-sm-2">
                <div class="form-group">
                    <label>&nbsp;</label>
                    <button type="button" class="btn btn-default btn-block btn-sm" id="ten_rep_clear">
                        <i class="fa fa-times"></i> @lang('messages.clear')
                    </button>
                </div>
            </div>
        </div>

        <!-- Summary Cards -->
        <div class="row" style="margin-top:15px;">
            <div class="col-sm-3">
                <div class="info-box bg-aqua" style="box-shadow:0 1px 3px rgba(0,0,0,0.12);">
                    <span class="info-box-icon"><i class="fa fa-building"></i></span>
                    <div class="info-box-content">
                        <span class="info-box-text">{{ __('mosque::mosque.tenancy_total_seats', ['count' => 0]) }}</span>
                        <span class="info-box-number" id="ten_stat_total_seats">0</span>
                    </div>
                </div>
            </div>
            <div class="col-sm-3">
                <div class="info-box bg-green" style="box-shadow:0 1px 3px rgba(0,0,0,0.12);">
                    <span class="info-box-icon"><i class="fa fa-check-circle"></i></span>
                    <div class="info-box-content">
                        <span class="info-box-text">{{ __('mosque::mosque.tenancy_seats_available') }}</span>
                        <span class="info-box-number" id="ten_stat_available">0</span>
                    </div>
                </div>
            </div>
            <div class="col-sm-3">
                <div class="info-box bg-red" style="box-shadow:0 1px 3px rgba(0,0,0,0.12);">
                    <span class="info-box-icon"><i class="fa fa-user"></i></span>
                    <div class="info-box-content">
                        <span class="info-box-text">{{ __('mosque::mosque.tenancy_seats_occupied') }}</span>
                        <span class="info-box-number" id="ten_stat_occupied">0</span>
                    </div>
                </div>
            </div>
            <div class="col-sm-3">
                <div class="info-box bg-yellow" style="box-shadow:0 1px 3px rgba(0,0,0,0.12);">
                    <span class="info-box-icon"><i class="fa fa-exclamation-circle"></i></span>
                    <div class="info-box-content">
                        <span class="info-box-text">{{ __('mosque::mosque.tenancy_seats_leaving_soon') }}</span>
                        <span class="info-box-number" id="ten_stat_leaving">0</span>
                    </div>
                </div>
            </div>
        </div>

        <!-- Revenue Summary Card -->
        <div class="row" style="margin-top:15px;">
            <div class="col-sm-12">
                <div class="box box-primary" style="box-shadow:0 1px 3px rgba(0,0,0,0.12);">
                    <div class="box-header with-border">
                        <h3 class="box-title">{{ __('mosque::mosque.tenancy_billing_revenue') }}</h3>
                    </div>
                    <div class="box-body">
                        <div class="row">
                            <div class="col-sm-3">
                                <div style="text-align:center;padding:15px;background:#f8f9fa9;border-radius:8px;margin-bottom:10px;">
                                    <div style="font-size:12px;color:#6c757d;">{{ __('mosque::mosque.tenancy_total_bills') }}</div>
                                    <div style="font-size:24px;font-weight:700;color:#3498db;" id="ten_stat_total_bills">0</div>
                                </div>
                            </div>
                            <div class="col-sm-3">
                                <div style="text-align:center;padding:15px;background:#f8f9fa9;border-radius:8px;margin-bottom:10px;">
                                    <div style="font-size:12px;color:#6c757d;">{{ __('mosque::mosque.tenancy_paid_amount') }}</div>
                                    <div style="font-size:24px;font-weight:700;color:#27ae60;" id="ten_stat_paid_amount">0</div>
                                </div>
                            </div>
                            <div class="col-sm-3">
                                <div style="text-align:center;padding:15px;background:#f8f9fa9;border-radius:8px;margin-bottom:10px;">
                                    <div style="font-size:12px;color:#6c757d;">{{ __('mosque::mosque.tenancy_unpaid_amount') }}</div>
                                    <div style="font-size:24px;font-weight:700;color:#e74c3c;" id="ten_stat_unpaid_amount">0</div>
                                </div>
                            </div>
                            <div class="col-sm-3">
                                <div style="text-align:center;padding:15px;background:#f8f9fa9;border-radius:8px;margin-bottom:10px;">
                                    <div style="font-size:12px;color:#6c757d;">{{ __('mosque::mosque.tenancy_collection_rate') }}</div>
                                    <div style="font-size:24px;font-weight:700;color:#f39c12;" id="ten_stat_collection_rate">0%</div>
                                </div>
                            </div>
                        </div>

                        <!-- Simple Revenue Chart -->
                        <div style="margin-top:20px;">
                            <div style="background:#f8f9fa9;padding:15px;border-radius:8px;">
                                <h4 style="margin:0 0 15px 0;font-size:14px;font-weight:600;">{{ __('mosque::mosque.tenancy_revenue_distribution') }}</h4>
                                <div id="revenue_chart" style="height:200px;display:flex;align-items:flex-end;gap:20px;padding:20px 0;">
                                    <div style="flex:1;text-align:center;">
                                        <div id="bar_paid" style="background:#27ae60;height:0%;border-radius:4px 4px 0 0;transition:height 0.5s ease;min-height:20px;"></div>
                                        <div style="font-size:12px;margin-top:8px;">{{ __('mosque::mosque.tenancy_paid') }}</div>
                                    </div>
                                    <div style="flex:1;text-align:center;">
                                        <div id="bar_unpaid" style="background:#e74c3c;height:0%;border-radius:4px 4px 0 0;transition:height 0.5s ease;min-height:20px;"></div>
                                        <div style="font-size:12px;margin-top:8px;">{{ __('mosque::mosque.tenancy_unpaid') }}</div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <ul class="nav nav-tabs">
            <li class="active"><a href="#ten_rep_tab_occupancy" data-toggle="tab">@lang('mosque::mosque.tenancy_report_occupancy')</a></li>
            <li><a href="#ten_rep_tab_leaving" data-toggle="tab">@lang('mosque::mosque.tenancy_report_leaving')</a></li>
            <li><a href="#ten_rep_tab_billing" data-toggle="tab">@lang('mosque::mosque.tenancy_report_billing_summary')</a></li>
        </ul>

        <div class="tab-content" style="padding-top:15px;">
            <div class="tab-pane active" id="ten_rep_tab_occupancy">
                <table class="table table-bordered table-striped" id="ten_occupancy_table" style="width:100%;">
                    <thead>
                    <tr>
                        <th>@lang('mosque::mosque.tenancy_building')</th>
                        <th>@lang('mosque::mosque.tenancy_floor')</th>
                        <th>@lang('mosque::mosque.tenancy_room')</th>
                        <th>@lang('mosque::mosque.tenancy_seats_total')</th>
                        <th>@lang('mosque::mosque.tenancy_seats_available')</th>
                        <th>@lang('mosque::mosque.tenancy_seats_occupied')</th>
                        <th>@lang('mosque::mosque.tenancy_seats_leaving_soon')</th>
                        <th>@lang('mosque::mosque.tenancy_seats_maintenance')</th>
                    </tr>
                    </thead>
                </table>
            </div>

            <div class="tab-pane" id="ten_rep_tab_leaving">
                <table class="table table-bordered table-striped" id="ten_leaving_table" style="width:100%;">
                    <thead>
                    <tr>
                        <th>@lang('mosque::mosque.tenancy_building')</th>
                        <th>@lang('mosque::mosque.tenancy_floor')</th>
                        <th>@lang('mosque::mosque.tenancy_room')</th>
                        <th>@lang('mosque::mosque.tenancy_seat')</th>
                        <th>@lang('mosque::mosque.tenancy_tenant')</th>
                        <th>@lang('mosque::mosque.tenancy_phone')</th>
                        <th>@lang('mosque::mosque.tenancy_leaving_on')</th>
                    </tr>
                    </thead>
                </table>
            </div>

            <div class="tab-pane" id="ten_rep_tab_billing">
                <table class="table table-bordered table-striped" id="ten_billing_summary_table" style="width:100%;">
                    <thead>
                    <tr>
                        <th>@lang('mosque::mosque.tenancy_building')</th>
                        <th>@lang('mosque::mosque.tenancy_period')</th>
                        <th>@lang('mosque::mosque.tenancy_bills')</th>
                        <th>@lang('mosque::mosque.tenancy_paid')</th>
                        <th>@lang('mosque::mosque.tenancy_unpaid')</th>
                        <th>@lang('mosque::mosque.tenancy_amount')</th>
                        <th>@lang('mosque::mosque.tenancy_paid_amount')</th>
                        <th>@lang('mosque::mosque.tenancy_unpaid_amount')</th>
                    </tr>
                    </thead>
                </table>
            </div>
        </div>
    @endcomponent
</section>
@endsection

@section('javascript')
<script>
    $(function () {
        var occUrl = @json(route('mosque.tenancy.reports.occupancy', [], false));
        var leavingUrl = @json(route('mosque.tenancy.reports.leaving_soon', [], false));
        var billingUrl = @json(route('mosque.tenancy.reports.billing_summary', [], false));
        var dashboardUrl = @json(route('mosque.tenancy.dashboard', [], false));

        function buttons() {
            return [
                { extend: 'csv', text: '<i class="fas fa-file-csv"></i>', className: 'btn btn-success' },
                { extend: 'excel', text: '<i class="fas fa-file-excel"></i>', className: 'btn btn-info' },
                { extend: 'pdf', text: '<i class="fas fa-file-pdf"></i>', className: 'btn btn-danger' },
                { extend: 'print', text: '<i class="fas fa-print"></i>', className: 'btn btn-warning' },
                { extend: 'colvis', text: '<i class="fas fa-eye"></i>', className: 'btn btn-primary' }
            ];
        }

        function getRange() {
            var start = $('#ten_rep_start_date').val();
            var end = $('#ten_rep_end_date').val();
            return { start_date: start || '', end_date: end || '' };
        }

        function updateStats() {
            $.get(dashboardUrl, function (resp) {
                var stats = resp.stats || {};
                $('#ten_stat_total_seats').text(stats.seats_total || 0);
                $('#ten_stat_available').text(stats.seats_available || 0);
                $('#ten_stat_occupied').text(stats.seats_occupied || 0);
                $('#ten_stat_leaving').text(stats.seats_leaving || 0);

                // Update billing stats
                var totalBills = 0;
                var paidAmount = 0;
                var unpaidAmount = 0;

                billingTable.ajax.json().data.forEach(function (row) {
                    totalBills += parseInt(row.bills) || 0;
                    paidAmount += parseFloat(row.paid_amount) || 0;
                    unpaidAmount += parseFloat(row.unpaid_amount) || 0;
                });

                var totalAmount = paidAmount + unpaidAmount;
                var collectionRate = totalAmount > 0 ? ((paidAmount / totalAmount) * 100).toFixed(1) : 0;

                $('#ten_stat_total_bills').text(totalBills);
                $('#ten_stat_paid_amount').text(paidAmount.toFixed(2));
                $('#ten_stat_unpaid_amount').text(unpaidAmount.toFixed(2));
                $('#ten_stat_collection_rate').text(collectionRate + '%');

                // Update chart
                var maxVal = Math.max(paidAmount, unpaidAmount, 1);
                var paidPercent = (paidAmount / maxVal) * 100;
                var unpaidPercent = (unpaidAmount / maxVal) * 100;

                $('#bar_paid').css('height', Math.min(paidPercent, 100) + '%');
                $('#bar_unpaid').css('height', Math.min(unpaidPercent, 100) + '%');
            });
        }

        var occTable = $('#ten_occupancy_table').DataTable({
            processing: true,
            serverSide: true,
            ajax: {
                url: occUrl,
                data: function (d) {
                    d.building_id = $('#ten_rep_building_id').val();
                }
            },
            dom: 'lBfrtip',
            buttons: buttons(),
            columns: [
                { data: 'building', name: 'building' },
                { data: 'floor', name: 'floor' },
                { data: 'room', name: 'room' },
                { data: 'total_seats', name: 'total_seats', orderable: false, searchable: false },
                { data: 'available_seats', name: 'available_seats', orderable: false, searchable: false },
                { data: 'occupied_seats', name: 'occupied_seats', orderable: false, searchable: false },
                { data: 'leaving_soon_seats', name: 'leaving_soon_seats', orderable: false, searchable: false },
                { data: 'maintenance_seats', name: 'maintenance_seats', orderable: false, searchable: false }
            ],
            drawCallback: updateStats
        });

        var leavingTable = $('#ten_leaving_table').DataTable({
            processing: true,
            serverSide: true,
            ajax: {
                url: leavingUrl,
                data: function (d) {
                    var r = getRange();
                    d.start_date = r.start_date;
                    d.end_date = r.end_date;
                    d.building_id = $('#ten_rep_building_id').val();
                }
            },
            dom: 'lBfrtip',
            buttons: buttons(),
            columns: [
                { data: 'building', name: 'building' },
                { data: 'floor', name: 'floor' },
                { data: 'room', name: 'room' },
                { data: 'seat', name: 'seat' },
                { data: 'tenant', name: 'tenant' },
                { data: 'phone', name: 'phone' },
                { data: 'leaving_on', name: 'leaving_on' }
            ]
        });

        var billingTable = $('#ten_billing_summary_table').DataTable({
            processing: true,
            serverSide: true,
            ajax: {
                url: billingUrl,
                data: function (d) {
                    var r = getRange();
                    d.start_date = r.start_date;
                    d.end_date = r.end_date;
                    d.building_id = $('#ten_rep_building_id').val();
                }
            },
            dom: 'lBfrtip',
            buttons: buttons(),
            columns: [
                { data: 'building', name: 'building' },
                { data: 'period', name: 'period' },
                { data: 'bills', name: 'bills', orderable: false, searchable: false },
                { data: 'paid_bills', name: 'paid_bills', orderable: false, searchable: false },
                { data: 'unpaid_bills', name: 'unpaid_bills', orderable: false, searchable: false },
                { data: 'total_amount', name: 'total_amount', orderable: false, searchable: false },
                { data: 'paid_amount', name: 'paid_amount', orderable: false, searchable: false },
                { data: 'unpaid_amount', name: 'unpaid_amount', orderable: false, searchable: false }
            ],
            drawCallback: function () {
                __currency_convert_recursively($('#ten_billing_summary_table'));
                updateStats();
            }
        });

        function reloadAll() {
            occTable.ajax.reload();
            leavingTable.ajax.reload();
            billingTable.ajax.reload();
        }

        $('#ten_rep_building_id').on('change', reloadAll);
        $('#ten_rep_apply').on('click', reloadAll);
        $('#ten_rep_clear').on('click', function () {
            $('#ten_rep_start_date').val('');
            $('#ten_rep_end_date').val('');
            $('#ten_rep_building_id').val('');
            reloadAll();
        });
    });
</script>
@endsection
