@extends('mosque::layouts.app')
@section('title', __('mosque::mosque.menu_tenancy') . ' | ' . __('mosque::mosque.tenancy_requests'))

@section('content')
<section class="content-header">
    <h1 class="tw-text-xl md:tw-text-3xl tw-font-bold tw-text-black">@lang('mosque::mosque.menu_tenancy')</h1>
</section>

<section class="content">
    @component('components.widget', ['class' => 'box-primary'])
        @include('mosque::tenancy.partials.nav')

        <div class="row" style="margin-top:15px;">
            <div class="col-sm-7">
                <p class="text-muted">@lang('mosque::mosque.tenancy_public_qr_hint')</p>
                <div style="word-break:break-all;">
                    <strong>@lang('mosque::mosque.tenancy_public_url'):</strong> <a href="{{ $publicUrl }}" target="_blank" rel="noopener">{{ $publicUrl }}</a>
                </div>
                <div style="margin-top:8px;">
                    <button class="btn btn-danger mosque_ajax_post" data-href="{{ route('mosque.tenancy.requests.regenerate', [], false) }}" {{ empty($canRegenerate) ? 'disabled' : '' }}><i class="fa fa-sync"></i> @lang('mosque::mosque.tenancy_regenerate_link')</button>
                    @if(empty($canRegenerate))
                        <p class="text-muted" style="margin-top:6px;margin-bottom:0;">@lang('mosque::mosque.tenancy_regenerate_once_only')</p>
                    @endif
                </div>
            </div>
            <div class="col-sm-5 text-center">
                <div style="display:inline-block;background:#fff;border:1px solid #e5e7eb;border-radius:10px;padding:12px;box-shadow:0 2px 8px rgba(0,0,0,0.08);min-width:280px;min-height:280px;">
                    <img id="qr-code-img" src="{{ $qrImageUrl }}" alt="QR Code" style="display:block;width:100%;height:auto;max-width:280px;object-fit:contain;" onerror="this.onerror=null;this.src='data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjAwIiBoZWlnaHQ9IjIwMCIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj48cmVjdCB3aWR0aD0iMjAwIiBoZWlnaHQ9IjIwMCIgZmlsbD0iI2ZmZiIvPjx0ZXh0IHg9IjUwJSIgeT0iNTAlIiBmaWxsPSIjNjY2IiB0ZXh0LWFuY2hvcj0ibWlkZGxlIiBmb250LXNpemU9IjE0IiBmb250LWZhbWlseT0iQXJpYWwiPkxvYWRpbmcuLi48L3RleHQ+PC9zdmc+';">
                </div>
                <div style="margin-top:12px;">
                    <a href="{{ $qrDownloadUrl }}" class="btn btn-success" target="_blank"><i class="fa fa-download"></i> @lang('mosque::mosque.tenancy_download')</a>
                </div>
            </div>
        </div>

        <hr>

        <div class="table-responsive">
            <table class="table table-bordered table-striped" id="ten_requests_table" style="width:100%;">
                <thead>
                    <tr>
                        <th>@lang('mosque::mosque.tenancy_date')</th>
                        <th>@lang('mosque::mosque.tenancy_name')</th>
                        <th>@lang('mosque::mosque.tenancy_phone')</th>
                        <th>@lang('mosque::mosque.tenancy_seat')</th>
                        <th>@lang('mosque::mosque.tenancy_status')</th>
                        <th>@lang('mosque::mosque.tenancy_tracking')</th>
                        <th>@lang('messages.action')</th>
                    </tr>
                </thead>
            </table>
        </div>
    @endcomponent
</section>
@endsection

@section('javascript')
<script>
    $(document).ready(function () {
        // Force reload QR image on page load to ensure fresh data
        $('#qr-code-img').on('load', function() {
            console.log('QR Code loaded successfully');
            console.log('Image dimensions:', this.naturalWidth, 'x', this.naturalHeight);
        }).on('error', function(e) {
            console.error('QR Code failed to load:', e);
            console.log('QR Image URL:', '{{ $qrImageUrl }}');
            console.log('Image element:', this);
            console.log('Natural dimensions:', this.naturalWidth, 'x', this.naturalHeight);
            
            // Try to fetch and show the actual error
            $.get('{{ $qrImageUrl }}', function(data, status, xhr) {
                console.log('QR Image fetch success:', status);
                console.log('Content-Type:', xhr.getResponseHeader('Content-Type'));
            }).fail(function(xhr, status, error) {
                console.error('QR Image fetch failed:');
                console.error('Status:', status);
                console.error('Error:', error);
                console.error('HTTP Status:', xhr.status);
                console.error('Response:', xhr.responseText);
                toastr.error('QR Code failed to load. Status: ' + xhr.status + ' - ' + xhr.statusText);
            });
            
            toastr.error('Failed to load QR code image. Please check the console for details.');
        });

        var table = $('#ten_requests_table').DataTable({
            processing: true,
            serverSide: true,
            ajax: '{{ route("mosque.tenancy.requests.data", [], false) }}',
            dom: 'lBfrtip',
            buttons: [
                { extend: 'csv', text: '<i class="fas fa-file-csv"></i>', className: 'btn btn-success' },
                { extend: 'excel', text: '<i class="fas fa-file-excel"></i>', className: 'btn btn-info' },
                { extend: 'pdf', text: '<i class="fas fa-file-pdf"></i>', className: 'btn btn-danger' },
                { extend: 'print', text: '<i class="fas fa-print"></i>', className: 'btn btn-warning' },
                { extend: 'colvis', text: '<i class="fas fa-eye"></i>', className: 'btn btn-primary' }
            ],
            columns: [
                { data: 'created_at', name: 'created_at' },
                { data: 'requested_by_name', name: 'requested_by_name' },
                { data: 'phone', name: 'phone' },
                { data: 'seat_label', name: 'seat_label', orderable: false },
                { data: 'status', name: 'status' },
                { data: 'token', name: 'token' },
                { data: 'action', name: 'action', orderable: false, searchable: false }
            ]
        });

        $(document).on('click', '.mosque_ajax_post', function (e) {
            e.preventDefault();
            var url = $(this).data('href');
            if (!url) return;
            $.ajax({
                method: 'POST',
                url: url,
                data: { _token: '{{ csrf_token() }}' },
                dataType: 'json',
                success: function (resp) {
                    if (resp && resp.success) {
                        toastr.success(resp.msg || @json(__('mosque::mosque.tenancy_success')));
                        if (resp.whatsapp_links && resp.whatsapp_links.length && typeof openWhatsAppLinksModal === 'function') {
                            openWhatsAppLinksModal(resp.whatsapp_links);
                        }
                        table.ajax.reload();
                    } else {
                        toastr.error((resp && resp.msg) ? resp.msg : @json(__('messages.something_went_wrong')));
                    }
                },
                error: function () { toastr.error(@json(__('messages.something_went_wrong'))); }
            });
        });
    });
</script>
@endsection
