@extends('mosque::layouts.app')
@section('title', __('mosque::mosque.menu_tenancy') . ' | ' . ($tenant ? __('messages.edit') : __('messages.add')))

@section('content')
<section class="content-header">
    <h1 class="tw-text-xl md:tw-text-3xl tw-font-bold tw-text-black">@lang('mosque::mosque.menu_tenancy')</h1>
</section>

<section class="content">
    @component('components.widget', ['class' => 'box-primary'])
        @include('mosque::tenancy.partials.nav')

        @php
            $fd = is_array($formData ?? null) ? $formData : [];
            $bdLocations = [];
            $postUrl = $tenant ? route('mosque.tenancy.tenants.update', [$tenant->id], false) : route('mosque.tenancy.tenants.store', [], false);
            try {
                $bdJson = file_get_contents(module_path('Mosque', 'Resources/tenancy/bd_locations.json'));
                $bdLocations = json_decode($bdJson, true) ?: [];
            } catch (\Throwable $e) {
                $bdLocations = [];
            }
        @endphp

        <style>
            #ten_tenant_form.ten-lang-en .ten-lbl-bn { display:none; }
            #ten_tenant_form.ten-lang-bn .ten-lbl-en { display:none; }
            #ten_tenant_form .ten-lbl-bn { color:#6b7280; font-weight:600; }
        </style>

        <form id="ten_tenant_form" enctype="multipart/form-data" style="margin-top:15px;">
            @csrf
            @if($tenant)
                @method('PUT')
            @endif

            <div class="row" style="margin-bottom:6px;">
                <div class="col-sm-12 text-right">
                    <div class="btn-group btn-group-xs" role="group" aria-label="Language toggle">
                        <button type="button" class="btn btn-default active" id="ten_lang_en">@lang('mosque::mosque.tenancy_lang_en')</button>
                        <button type="button" class="btn btn-default" id="ten_lang_bn">@lang('mosque::mosque.tenancy_lang_bn')</button>
                    </div>
                </div>
            </div>

            <div class="row">
                <div class="col-sm-4">
                    <div class="form-group">
                        <label>@lang('mosque::mosque.tenancy_name') *</label>
                        <input type="text" name="full_name" class="form-control input-sm" value="{{ $tenant->full_name ?? '' }}" required>
                    </div>
                </div>
                <div class="col-sm-4">
                    <div class="form-group">
                        <label>@lang('mosque::mosque.tenancy_phone') *</label>
                        <input type="text" name="phone" class="form-control input-sm" value="{{ $tenant->phone ?? '' }}" required>
                    </div>
                </div>
                <div class="col-sm-4">
                    <div class="form-group">
                        <label>@lang('mosque::mosque.tenancy_whatsapp')</label>
                        <input type="text" name="whatsapp" class="form-control input-sm" value="{{ $tenant->whatsapp ?? '' }}">
                    </div>
                </div>
            </div>

            <div class="row">
                <div class="col-sm-4">
                    <div class="form-group">
                        <label>@lang('mosque::mosque.tenancy_email')</label>
                        <input type="email" name="email" class="form-control input-sm" value="{{ $tenant->email ?? '' }}">
                    </div>
                </div>
                <div class="col-sm-4">
                    <div class="form-group">
                        <label>@lang('mosque::mosque.tenancy_nid')</label>
                        <input type="text" name="nid_no" class="form-control input-sm" value="{{ $tenant->nid_no ?? '' }}">
                    </div>
                </div>
                <div class="col-sm-4">
                    <div class="form-group">
                        <label>@lang('mosque::mosque.tenancy_passport')</label>
                        <input type="text" name="passport_no" class="form-control input-sm" value="{{ $tenant->passport_no ?? '' }}">
                    </div>
                </div>
            </div>

            <div class="row">
                <div class="col-sm-4">
                    <div class="form-group">
                        <label>@lang('mosque::mosque.tenancy_passport_issue_date')</label>
                        <input type="date" name="passport_issue_date" class="form-control input-sm" value="{{ !empty($tenant?->passport_issue_date) ? \Illuminate\Support\Carbon::parse($tenant->passport_issue_date)->format('Y-m-d') : '' }}">
                    </div>
                </div>
                <div class="col-sm-4">
                    <div class="form-group">
                        <label>@lang('mosque::mosque.tenancy_passport_expiry_date')</label>
                        <input type="date" name="passport_expiry_date" class="form-control input-sm" value="{{ !empty($tenant?->passport_expiry_date) ? \Illuminate\Support\Carbon::parse($tenant->passport_expiry_date)->format('Y-m-d') : '' }}">
                    </div>
                </div>
                <div class="col-sm-4"></div>
            </div>

            <div class="row" style="margin-top:6px;">
                <div class="col-sm-12">
                    <h4 style="margin:8px 0 6px 0;">
                        <span class="ten-lbl-en">@lang('mosque::mosque.tenancy_bd_location')</span>
                        <span class="ten-lbl-bn">@lang('mosque::mosque.tenancy_bd_location_bn')</span>
                    </h4>
                </div>
            </div>

            <div class="row">
                <div class="col-sm-3">
                    <div class="form-group">
                        <label>
                            <span class="ten-lbl-en">@lang('mosque::mosque.tenancy_division')</span>
                            <span class="ten-lbl-bn">@lang('mosque::mosque.tenancy_division_bn')</span>
                        </label>
                        <select class="form-control input-sm" name="form_data[division]" id="ten_division" data-selected="{{ $fd['division'] ?? '' }}">
                            <option value="">@lang('mosque::mosque.tenancy_please_select')</option>
                        </select>
                    </div>
                </div>
                <div class="col-sm-3">
                    <div class="form-group">
                        <label>
                            <span class="ten-lbl-en">@lang('mosque::mosque.tenancy_district')</span>
                            <span class="ten-lbl-bn">@lang('mosque::mosque.tenancy_district_bn')</span>
                        </label>
                        <select class="form-control input-sm" name="form_data[district]" id="ten_district" data-selected="{{ $fd['district'] ?? '' }}">
                            <option value="">@lang('mosque::mosque.tenancy_please_select')</option>
                        </select>
                    </div>
                </div>
                <div class="col-sm-3">
                    <div class="form-group">
                        <label>
                            <span class="ten-lbl-en">@lang('mosque::mosque.tenancy_thana_ps')</span>
                            <span class="ten-lbl-bn">@lang('mosque::mosque.tenancy_thana_ps_bn')</span>
                        </label>
                        <input type="text" class="form-control input-sm" name="form_data[thana_ps]" value="{{ $fd['thana_ps'] ?? '' }}">
                    </div>
                </div>
                <div class="col-sm-3">
                    <div class="form-group">
                        <label>
                            <span class="ten-lbl-en">@lang('mosque::mosque.tenancy_area_type')</span>
                            <span class="ten-lbl-bn">@lang('mosque::mosque.tenancy_area_type_bn')</span>
                        </label>
                        <select class="form-control input-sm" name="form_data[area_type]" id="ten_area_type" data-selected="{{ $fd['area_type'] ?? '' }}">
                            <option value="">@lang('mosque::mosque.tenancy_please_select')</option>
                            <option value="municipality">@lang('mosque::mosque.tenancy_area_municipality')</option>
                            <option value="city_corporation">@lang('mosque::mosque.tenancy_area_city_corporation')</option>
                            <option value="upazila">@lang('mosque::mosque.tenancy_area_upazila')</option>
                        </select>
                    </div>
                </div>
            </div>

            <div class="row">
                <div class="col-sm-4">
                    <div class="form-group" id="ten_muni_wrap" style="display:none;">
                        <label>
                            <span class="ten-lbl-en">@lang('mosque::mosque.tenancy_municipality')</span>
                            <span class="ten-lbl-bn">@lang('mosque::mosque.tenancy_municipality_bn')</span>
                        </label>
                        <select class="form-control input-sm" name="form_data[municipality_name]" id="ten_municipality" data-selected="{{ $fd['municipality_name'] ?? '' }}">
                            <option value="">@lang('mosque::mosque.tenancy_please_select')</option>
                        </select>
                    </div>
                    <div class="form-group" id="ten_upazila_wrap" style="display:none;">
                        <label>
                            <span class="ten-lbl-en">@lang('mosque::mosque.tenancy_upazila')</span>
                            <span class="ten-lbl-bn">@lang('mosque::mosque.tenancy_upazila_bn')</span>
                        </label>
                        <select class="form-control input-sm" name="form_data[upazila_name]" id="ten_upazila" data-selected="{{ $fd['upazila_name'] ?? '' }}">
                            <option value="">@lang('mosque::mosque.tenancy_please_select')</option>
                        </select>
                    </div>
                </div>
                <div class="col-sm-4">
                    <div class="form-group" id="ten_union_wrap" style="display:none;">
                        <label>
                            <span class="ten-lbl-en">@lang('mosque::mosque.tenancy_union')</span>
                            <span class="ten-lbl-bn">@lang('mosque::mosque.tenancy_union_bn')</span>
                        </label>
                        <select class="form-control input-sm" name="form_data[union_name]" id="ten_union" data-selected="{{ $fd['union_name'] ?? '' }}">
                            <option value="">@lang('mosque::mosque.tenancy_please_select')</option>
                        </select>
                    </div>
                    <div class="form-group" id="ten_ward_wrap" style="display:none;">
                        <label>
                            <span class="ten-lbl-en">@lang('mosque::mosque.tenancy_ward_no')</span>
                            <span class="ten-lbl-bn">@lang('mosque::mosque.tenancy_ward_no_bn')</span>
                        </label>
                        <select class="form-control input-sm" name="form_data[ward_no]" id="ten_ward_no" data-selected="{{ $fd['ward_no'] ?? '' }}" disabled>
                            <option value="">@lang('mosque::mosque.tenancy_please_select')</option>
                        </select>
                        <p class="help-block" id="ten_ward_hint" style="margin-top:4px;"></p>
                    </div>
                </div>
                <div class="col-sm-4">
                    <div class="form-group">
                        <label>
                            <span class="ten-lbl-en">@lang('mosque::mosque.tenancy_post_code')</span>
                            <span class="ten-lbl-bn">@lang('mosque::mosque.tenancy_post_code_bn')</span>
                        </label>
                        <input type="text" class="form-control input-sm" name="form_data[post_code]" value="{{ $fd['post_code'] ?? '' }}">
                    </div>
                </div>
            </div>

            <div class="row">
                <div class="col-sm-2">
                    <div class="form-group">
                        <label>
                            <span class="ten-lbl-en">@lang('mosque::mosque.tenancy_flat_unit')</span>
                            <span class="ten-lbl-bn">@lang('mosque::mosque.tenancy_flat_unit_bn')</span>
                        </label>
                        <input type="text" class="form-control input-sm" name="form_data[flat_unit]" value="{{ $fd['flat_unit'] ?? '' }}">
                    </div>
                </div>
                <div class="col-sm-2">
                    <div class="form-group">
                        <label>
                            <span class="ten-lbl-en">@lang('mosque::mosque.tenancy_holding_house_no')</span>
                            <span class="ten-lbl-bn">@lang('mosque::mosque.tenancy_holding_house_no_bn')</span>
                        </label>
                        <input type="text" class="form-control input-sm" name="form_data[holding_house_no]" value="{{ $fd['holding_house_no'] ?? '' }}">
                    </div>
                </div>
                <div class="col-sm-2">
                    <div class="form-group">
                        <label>
                            <span class="ten-lbl-en">@lang('mosque::mosque.tenancy_road')</span>
                            <span class="ten-lbl-bn">@lang('mosque::mosque.tenancy_road_bn')</span>
                        </label>
                        <input type="text" class="form-control input-sm" name="form_data[road]" value="{{ $fd['road'] ?? '' }}">
                    </div>
                </div>
                <div class="col-sm-2">
                    <div class="form-group">
                        <label>
                            <span class="ten-lbl-en">@lang('mosque::mosque.tenancy_block')</span>
                            <span class="ten-lbl-bn">@lang('mosque::mosque.tenancy_block_bn')</span>
                        </label>
                        <input type="text" class="form-control input-sm" name="form_data[block]" value="{{ $fd['block'] ?? '' }}">
                    </div>
                </div>
                <div class="col-sm-4">
                    <div class="form-group">
                        <label>
                            <span class="ten-lbl-en">@lang('mosque::mosque.tenancy_local_area')</span>
                            <span class="ten-lbl-bn">@lang('mosque::mosque.tenancy_local_area_bn')</span>
                        </label>
                        <input type="text" class="form-control input-sm" name="form_data[local_area]" value="{{ $fd['local_area'] ?? '' }}">
                    </div>
                </div>
            </div>

            <div class="row">
                <div class="col-sm-4">
                    <div class="form-group">
                        <label>@lang('mosque::mosque.tenancy_photo')</label>
                        <div class="btn-group btn-group-sm" style="margin-bottom:6px;">
                            <button type="button" class="btn btn-default" id="ten_photo_take_btn"><i class="fa fa-camera"></i> @lang('mosque::mosque.tenancy_take_photo')</button>
                            <button type="button" class="btn btn-default" id="ten_photo_stop_btn" style="display:none;">@lang('mosque::mosque.tenancy_close_camera')</button>
                            <button type="button" class="btn btn-default" id="ten_photo_capture_btn" style="display:none;">@lang('mosque::mosque.tenancy_capture')</button>
                        </div>
                        <div id="ten_photo_cam_wrap" style="display:none;margin-bottom:6px;">
                            <video id="ten_photo_video" style="width:100%;max-height:180px;border-radius:10px;background:#111" playsinline autoplay></video>
                            <canvas id="ten_photo_canvas" style="display:none;"></canvas>
                        </div>
                        <input type="file" name="photo" class="form-control input-sm" id="ten_photo_input" accept="image/*">
                        <p class="help-block" id="ten_photo_cam_hint" style="display:none;margin-top:6px;"></p>
                        @if(!empty($tenant?->photo_path))
                            <p class="help-block" style="margin-top:6px;">
                                <a href="{{ route('mosque.tenancy.tenants.file', ['id' => $tenant->id, 'path' => $tenant->photo_path], false) }}" target="_blank">@lang('messages.view')</a>
                            </p>
                        @endif
                    </div>
                </div>
                <div class="col-sm-8">
                    <div class="form-group">
                        <label>@lang('mosque::mosque.tenancy_present_address')</label>
                        <textarea name="present_address" class="form-control input-sm" rows="2">{{ $tenant->present_address ?? '' }}</textarea>
                    </div>
                </div>
            </div>

            <div class="form-group">
                <label>@lang('mosque::mosque.tenancy_permanent_address')</label>
                <textarea name="permanent_address" class="form-control input-sm" rows="2">{{ $tenant->permanent_address ?? '' }}</textarea>
            </div>

            <div class="row" style="margin-top:6px;">
                <div class="col-sm-12">
                    <h4 style="margin:8px 0 6px 0;">
                        <span class="ten-lbl-en">@lang('mosque::mosque.tenancy_more_details')</span>
                        <span class="ten-lbl-bn">@lang('mosque::mosque.tenancy_more_details_bn')</span>
                    </h4>
                </div>
            </div>

            <div class="row">
                <div class="col-sm-4">
                    <div class="form-group">
                        <label>
                            <span class="ten-lbl-en">@lang('mosque::mosque.tenancy_father_name')</span> *
                            <span class="ten-lbl-bn">@lang('mosque::mosque.tenancy_father_name_bn')</span>
                        </label>
                        <input type="text" name="form_data[father_name]" class="form-control input-sm" value="{{ $fd['father_name'] ?? '' }}" required>
                    </div>
                </div>
                <div class="col-sm-4">
                    <div class="form-group">
                        <label>
                            <span class="ten-lbl-en">@lang('mosque::mosque.tenancy_dob')</span>
                            <span class="ten-lbl-bn">@lang('mosque::mosque.tenancy_dob_bn')</span>
                        </label>
                        <input type="date" name="dob" class="form-control input-sm" value="{{ !empty($tenant?->dob) ? \Illuminate\Support\Carbon::parse($tenant->dob)->format('Y-m-d') : '' }}">
                    </div>
                </div>
                <div class="col-sm-4">
                    <div class="form-group">
                        <label>
                            <span class="ten-lbl-en">@lang('mosque::mosque.tenancy_marital_status')</span>
                            <span class="ten-lbl-bn">@lang('mosque::mosque.tenancy_marital_status_bn')</span>
                        </label>
                        <input type="text" name="marital_status" class="form-control input-sm" value="{{ $tenant->marital_status ?? '' }}">
                    </div>
                </div>
            </div>

            <div class="row">
                <div class="col-sm-4">
                    <div class="form-group">
                        <label>
                            <span class="ten-lbl-en">@lang('mosque::mosque.tenancy_occupation')</span>
                            <span class="ten-lbl-bn">@lang('mosque::mosque.tenancy_occupation_bn')</span>
                        </label>
                        <input type="text" name="form_data[occupation]" class="form-control input-sm" value="{{ $fd['occupation'] ?? '' }}">
                    </div>
                </div>
                <div class="col-sm-8">
                    <div class="form-group">
                        <label>
                            <span class="ten-lbl-en">@lang('mosque::mosque.tenancy_employer_office_address')</span>
                            <span class="ten-lbl-bn">@lang('mosque::mosque.tenancy_employer_office_address_bn')</span>
                        </label>
                        <input type="text" name="form_data[employer_office_address]" class="form-control input-sm" value="{{ $fd['employer_office_address'] ?? '' }}">
                    </div>
                </div>
            </div>

            <div class="row">
                <div class="col-sm-4">
                    <div class="form-group">
                        <label>
                            <span class="ten-lbl-en">@lang('mosque::mosque.tenancy_religion')</span>
                            <span class="ten-lbl-bn">@lang('mosque::mosque.tenancy_religion_bn')</span>
                        </label>
                        <input type="text" name="form_data[religion]" class="form-control input-sm" value="{{ $fd['religion'] ?? '' }}">
                    </div>
                </div>
                <div class="col-sm-4">
                    <div class="form-group">
                        <label>
                            <span class="ten-lbl-en">@lang('mosque::mosque.tenancy_education')</span>
                            <span class="ten-lbl-bn">@lang('mosque::mosque.tenancy_education_bn')</span>
                        </label>
                        <input type="text" name="form_data[education]" class="form-control input-sm" value="{{ $fd['education'] ?? '' }}">
                    </div>
                </div>
                <div class="col-sm-4">
                    <div class="form-group">
                        <label>
                            <span class="ten-lbl-en">@lang('mosque::mosque.tenancy_home_country')</span>
                            <span class="ten-lbl-bn">@lang('mosque::mosque.tenancy_home_country_bn')</span>
                        </label>
                        <input type="text" name="home_country" class="form-control input-sm" value="{{ $tenant->home_country ?? '' }}">
                    </div>
                </div>
            </div>

            <div class="row" style="margin-top:6px;">
                <div class="col-sm-12">
                    <h4 style="margin:8px 0 6px 0;">
                        <span class="ten-lbl-en">@lang('mosque::mosque.tenancy_emergency_contact')</span>
                        <span class="ten-lbl-bn">@lang('mosque::mosque.tenancy_emergency_contact_bn')</span>
                    </h4>
                </div>
            </div>

            <div class="row">
                <div class="col-sm-3">
                    <div class="form-group">
                        <label>
                            <span class="ten-lbl-en">@lang('mosque::mosque.tenancy_relation')</span>
                            <span class="ten-lbl-bn">@lang('mosque::mosque.tenancy_relation_bn')</span>
                        </label>
                        <input type="text" name="form_data[emergency_contact][relation]" class="form-control input-sm" value="{{ data_get($fd, 'emergency_contact.relation', '') }}">
                    </div>
                </div>
                <div class="col-sm-3">
                    <div class="form-group">
                        <label>
                            <span class="ten-lbl-en">@lang('mosque::mosque.tenancy_contact_name')</span>
                            <span class="ten-lbl-bn">@lang('mosque::mosque.tenancy_contact_name_bn')</span>
                        </label>
                        <input type="text" name="form_data[emergency_contact][name]" class="form-control input-sm" value="{{ data_get($fd, 'emergency_contact.name', '') }}">
                    </div>
                </div>
                <div class="col-sm-3">
                    <div class="form-group">
                        <label>
                            <span class="ten-lbl-en">@lang('mosque::mosque.tenancy_contact_phone')</span>
                            <span class="ten-lbl-bn">@lang('mosque::mosque.tenancy_contact_phone_bn')</span>
                        </label>
                        <input type="text" name="form_data[emergency_contact][phone]" class="form-control input-sm" value="{{ data_get($fd, 'emergency_contact.phone', '') }}">
                    </div>
                </div>
                <div class="col-sm-3">
                    <div class="form-group">
                        <label>
                            <span class="ten-lbl-en">@lang('mosque::mosque.tenancy_contact_address')</span>
                            <span class="ten-lbl-bn">@lang('mosque::mosque.tenancy_contact_address_bn')</span>
                        </label>
                        <input type="text" name="form_data[emergency_contact][address]" class="form-control input-sm" value="{{ data_get($fd, 'emergency_contact.address', '') }}">
                    </div>
                </div>
            </div>

            <div class="row" style="margin-top:6px;">
                <div class="col-sm-12">
                    <h4 style="margin:8px 0 6px 0;">
                        <span class="ten-lbl-en">@lang('mosque::mosque.tenancy_cohabitants')</span>
                        <span class="ten-lbl-bn">@lang('mosque::mosque.tenancy_cohabitants_bn')</span>
                    </h4>
                </div>
            </div>

            <div class="table-responsive">
                <table class="table table-bordered table-condensed" id="ten_cohabitants_table" style="margin-bottom:8px;">
                    <thead>
                        <tr>
                            <th style="width:70px;">@lang('mosque::mosque.tenancy_serial')</th>
                            <th>@lang('mosque::mosque.tenancy_name')</th>
                            <th style="width:80px;">@lang('mosque::mosque.tenancy_age')</th>
                            <th>@lang('mosque::mosque.tenancy_occupation')</th>
                            <th style="width:140px;">@lang('mosque::mosque.tenancy_phone')</th>
                            <th style="width:60px;"></th>
                        </tr>
                    </thead>
                    <tbody>
                        @php $cohabitants = is_array($fd['cohabitants'] ?? null) ? $fd['cohabitants'] : []; @endphp
                        @foreach($cohabitants as $i => $row)
                            <tr>
                                <td><input type="text" class="form-control input-sm" name="form_data[cohabitants][{{ $i }}][serial]" value="{{ $row['serial'] ?? '' }}"></td>
                                <td><input type="text" class="form-control input-sm" name="form_data[cohabitants][{{ $i }}][name]" value="{{ $row['name'] ?? '' }}"></td>
                                <td><input type="text" class="form-control input-sm" name="form_data[cohabitants][{{ $i }}][age]" value="{{ $row['age'] ?? '' }}"></td>
                                <td><input type="text" class="form-control input-sm" name="form_data[cohabitants][{{ $i }}][occupation]" value="{{ $row['occupation'] ?? '' }}"></td>
                                <td><input type="text" class="form-control input-sm" name="form_data[cohabitants][{{ $i }}][phone]" value="{{ $row['phone'] ?? '' }}"></td>
                                <td class="text-center"><button type="button" class="btn btn-xs btn-danger ten-row-del"><i class="fa fa-times"></i></button></td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
            <div class="text-right" style="margin-bottom:10px;">
                <button type="button" class="btn btn-xs btn-default" id="ten_add_cohabitant"><i class="fa fa-plus"></i> @lang('mosque::mosque.tenancy_add_row')</button>
            </div>

            <div class="row" style="margin-top:6px;">
                <div class="col-sm-12">
                    <h4 style="margin:8px 0 6px 0;">
                        <span class="ten-lbl-en">@lang('mosque::mosque.tenancy_guarantors')</span>
                        <span class="ten-lbl-bn">@lang('mosque::mosque.tenancy_guarantors_bn')</span>
                    </h4>
                </div>
            </div>

            <div class="table-responsive">
                <table class="table table-bordered table-condensed" id="ten_guarantors_table" style="margin-bottom:8px;">
                    <thead>
                        <tr>
                            <th>@lang('mosque::mosque.tenancy_name')</th>
                            <th style="width:140px;">@lang('mosque::mosque.tenancy_relation')</th>
                            <th style="width:160px;">@lang('mosque::mosque.tenancy_phone')</th>
                            <th>@lang('mosque::mosque.tenancy_address')</th>
                            <th style="width:60px;"></th>
                        </tr>
                    </thead>
                    <tbody>
                        @php $guarantors = is_array($fd['guarantors'] ?? null) ? $fd['guarantors'] : []; @endphp
                        @foreach($guarantors as $i => $row)
                            <tr>
                                <td><input type="text" class="form-control input-sm" name="form_data[guarantors][{{ $i }}][name]" value="{{ $row['name'] ?? '' }}"></td>
                                <td><input type="text" class="form-control input-sm" name="form_data[guarantors][{{ $i }}][relation]" value="{{ $row['relation'] ?? '' }}"></td>
                                <td><input type="text" class="form-control input-sm" name="form_data[guarantors][{{ $i }}][phone]" value="{{ $row['phone'] ?? '' }}"></td>
                                <td><input type="text" class="form-control input-sm" name="form_data[guarantors][{{ $i }}][address]" value="{{ $row['address'] ?? '' }}"></td>
                                <td class="text-center"><button type="button" class="btn btn-xs btn-danger ten-row-del"><i class="fa fa-times"></i></button></td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
            <div class="text-right" style="margin-bottom:10px;">
                <button type="button" class="btn btn-xs btn-default" id="ten_add_guarantor"><i class="fa fa-plus"></i> @lang('mosque::mosque.tenancy_add_row')</button>
            </div>

            <div class="row" style="margin-top:6px;">
                <div class="col-sm-12">
                    <h4 style="margin:8px 0 6px 0;">
                        <span class="ten-lbl-en">@lang('mosque::mosque.tenancy_landlord')</span>
                        <span class="ten-lbl-bn">@lang('mosque::mosque.tenancy_landlord_bn')</span>
                    </h4>
                </div>
            </div>

            <div class="row">
                <div class="col-sm-3">
                    <div class="form-group">
                        <label>@lang('mosque::mosque.tenancy_landlord_name')</label>
                        <input type="text" class="form-control input-sm" name="form_data[landlord_name]" value="{{ $fd['landlord_name'] ?? '' }}">
                    </div>
                </div>
                <div class="col-sm-3">
                    <div class="form-group">
                        <label>@lang('mosque::mosque.tenancy_landlord_nid')</label>
                        <input type="text" class="form-control input-sm" name="form_data[landlord_nid]" value="{{ $fd['landlord_nid'] ?? '' }}">
                    </div>
                </div>
                <div class="col-sm-3">
                    <div class="form-group">
                        <label>@lang('mosque::mosque.tenancy_landlord_phone')</label>
                        <input type="text" class="form-control input-sm" name="form_data[landlord_phone]" value="{{ $fd['landlord_phone'] ?? '' }}">
                    </div>
                </div>
                <div class="col-sm-3">
                    <div class="form-group">
                        <label>@lang('mosque::mosque.tenancy_landlord_address')</label>
                        <input type="text" class="form-control input-sm" name="form_data[landlord_address]" value="{{ $fd['landlord_address'] ?? '' }}">
                    </div>
                </div>
            </div>

            <div class="row">
                <div class="col-sm-4">
                    <div class="form-group">
                        <label>@lang('mosque::mosque.tenancy_local_reference')</label>
                        <input type="text" class="form-control input-sm" name="form_data[local_reference][name]" value="{{ data_get($fd, 'local_reference.name', '') }}" placeholder="@lang('mosque::mosque.tenancy_contact_name')">
                    </div>
                </div>
                <div class="col-sm-2">
                    <div class="form-group">
                        <label>&nbsp;</label>
                        <input type="text" class="form-control input-sm" name="form_data[local_reference][nid]" value="{{ data_get($fd, 'local_reference.nid', '') }}" placeholder="@lang('mosque::mosque.tenancy_nid')">
                    </div>
                </div>
                <div class="col-sm-3">
                    <div class="form-group">
                        <label>&nbsp;</label>
                        <input type="text" class="form-control input-sm" name="form_data[local_reference][phone]" value="{{ data_get($fd, 'local_reference.phone', '') }}" placeholder="@lang('mosque::mosque.tenancy_phone')">
                    </div>
                </div>
                <div class="col-sm-3">
                    <div class="form-group">
                        <label>&nbsp;</label>
                        <input type="text" class="form-control input-sm" name="form_data[local_reference][address]" value="{{ data_get($fd, 'local_reference.address', '') }}" placeholder="@lang('mosque::mosque.tenancy_address')">
                    </div>
                </div>
            </div>

            <div class="row">
                <div class="col-sm-3">
                    <div class="form-group">
                        <label>@lang('mosque::mosque.tenancy_prev_landlord_name')</label>
                        <input type="text" class="form-control input-sm" name="form_data[prev_landlord_name]" value="{{ $fd['prev_landlord_name'] ?? '' }}">
                    </div>
                </div>
                <div class="col-sm-3">
                    <div class="form-group">
                        <label>@lang('mosque::mosque.tenancy_prev_landlord_phone')</label>
                        <input type="text" class="form-control input-sm" name="form_data[prev_landlord_phone]" value="{{ $fd['prev_landlord_phone'] ?? '' }}">
                    </div>
                </div>
                <div class="col-sm-6">
                    <div class="form-group">
                        <label>@lang('mosque::mosque.tenancy_prev_landlord_address')</label>
                        <input type="text" class="form-control input-sm" name="form_data[prev_landlord_address]" value="{{ $fd['prev_landlord_address'] ?? '' }}">
                    </div>
                </div>
            </div>

            <div class="row">
                <div class="col-sm-6">
                    <div class="form-group">
                        <label>@lang('mosque::mosque.tenancy_reason_left_previous')</label>
                        <input type="text" class="form-control input-sm" name="form_data[reason_left_previous]" value="{{ $fd['reason_left_previous'] ?? '' }}">
                    </div>
                </div>
                <div class="col-sm-3">
                    <div class="form-group">
                        <label>@lang('mosque::mosque.tenancy_move_in_date')</label>
                        <input type="date" class="form-control input-sm" name="form_data[move_in_date]" value="{{ $fd['move_in_date'] ?? '' }}">
                    </div>
                </div>
                <div class="col-sm-3">
                    <div class="form-group">
                        <label>@lang('mosque::mosque.tenancy_form_date')</label>
                        <input type="date" class="form-control input-sm" name="form_data[form_date]" value="{{ $fd['form_date'] ?? '' }}">
                    </div>
                </div>
            </div>

            <div class="row">
                <div class="col-sm-12">
                    <div class="form-group">
                        <label>@lang('mosque::mosque.tenancy_tenant_signature')</label>
                        <input type="text" class="form-control input-sm" name="form_data[tenant_signature]" value="{{ $fd['tenant_signature'] ?? '' }}">
                        <p class="help-block">@lang('mosque::mosque.tenancy_signature_help')</p>
                    </div>
                </div>
            </div>

            <div class="form-group">
                <label>@lang('mosque::mosque.tenancy_attachments')</label>
                <div class="btn-group btn-group-sm" style="margin-bottom:6px;">
                    <button type="button" class="btn btn-default" id="ten_att_take_btn"><i class="fa fa-camera"></i> @lang('mosque::mosque.tenancy_take_id_photo')</button>
                    <button type="button" class="btn btn-default" id="ten_att_stop_btn" style="display:none;">@lang('mosque::mosque.tenancy_close_camera')</button>
                    <button type="button" class="btn btn-default" id="ten_att_capture_btn" style="display:none;">@lang('mosque::mosque.tenancy_capture')</button>
                </div>
                <div id="ten_att_cam_wrap" style="display:none;margin-bottom:6px;">
                    <video id="ten_att_video" style="width:100%;max-height:180px;border-radius:10px;background:#111" playsinline autoplay></video>
                    <canvas id="ten_att_canvas" style="display:none;"></canvas>
                </div>
                <input type="file" name="attachments[]" class="form-control input-sm" id="ten_att_input" multiple accept="image/*,application/pdf">
                <p class="help-block" id="ten_att_cam_hint" style="display:none;margin-top:6px;"></p>
                @if(!empty($tenant?->attachments))
                    <div style="margin-top:6px;">
                        @foreach(($tenant->attachments ?? []) as $att)
                            @if(is_array($att) && !empty($att['path']))
                                <div><a href="{{ route('mosque.tenancy.tenants.file', ['id' => $tenant->id, 'path' => $att['path']], false) }}" target="_blank">{{ $att['name'] ?? $att['path'] }}</a></div>
                            @endif
                        @endforeach
                    </div>
                @endif
            </div>

            <div class="alert alert-danger" id="ten_case_banner" style="display:none;"></div>
            <div class="checkbox">
                <label>
                    <input type="checkbox" name="ack_case_match" value="1"> @lang('mosque::mosque.tenancy_ack_cases')
                </label>
            </div>

            <div class="text-right">
                <a href="{{ route('mosque.tenancy.tenants') }}" class="btn btn-default">@lang('messages.back')</a>
                <button type="submit" class="btn btn-primary">@lang('messages.save')</button>
            </div>
        </form>
    @endcomponent
</section>
@endsection

@section('javascript')
<script>
    $(function () {
        var url = @json($postUrl);

        var $form = $('#ten_tenant_form');
        $form.addClass('ten-lang-en');

        $('#ten_lang_en').on('click', function () {
            $('#ten_lang_en').addClass('active');
            $('#ten_lang_bn').removeClass('active');
            $form.removeClass('ten-lang-bn').addClass('ten-lang-en');
        });
        $('#ten_lang_bn').on('click', function () {
            $('#ten_lang_bn').addClass('active');
            $('#ten_lang_en').removeClass('active');
            $form.removeClass('ten-lang-en').addClass('ten-lang-bn');
        });

        var bd = @json($bdLocations);

        function listDivisions() {
            if (!bd) return [];
            if (Array.isArray(bd.divisions)) return bd.divisions;
            if (Array.isArray(bd)) return bd;
            return [];
        }

        function findById(list, id) {
            id = (id || '').toString();
            for (var i = 0; i < list.length; i++) {
                if ((list[i].id || '').toString() === id) return list[i];
            }
            return null;
        }

        function optLabel(item) {
            if (!item) return '';
            var en = item.name_en || item.name || '';
            var bn = item.name_bn || '';
            if (bn) return en + ' (' + bn + ')';
            return en;
        }

        function fillSelect($sel, items, selectedId, placeholder) {
            $sel.empty();
            $sel.append($('<option>').attr('value', '').text(placeholder || @json(__('mosque::mosque.tenancy_please_select'))));
            (items || []).forEach(function (item) {
                var val = (item.id || item.name || '').toString();
                var $o = $('<option>').attr('value', val).text(optLabel(item));
                if (selectedId && val === selectedId.toString()) $o.prop('selected', true);
                $sel.append($o);
            });
        }

        function fillWardSelect($sel, wards, selectedVal) {
            $sel.empty();
            $sel.append($('<option>').attr('value', '').text(@json(__('mosque::mosque.tenancy_please_select'))));
            (wards || []).forEach(function (w) {
                var val = (w || '').toString();
                var $o = $('<option>').attr('value', val).text(val);
                if (selectedVal && val === selectedVal.toString()) $o.prop('selected', true);
                $sel.append($o);
            });
        }

        function range(from, to) {
            var out = [];
            for (var i = from; i <= to; i++) out.push(i);
            return out;
        }

        var $division = $('#ten_division');
        var $district = $('#ten_district');
        var $areaType = $('#ten_area_type');
        var $municipality = $('#ten_municipality');
        var $upazila = $('#ten_upazila');
        var $union = $('#ten_union');
        var $ward = $('#ten_ward_no');
        var $wardWrap = $('#ten_ward_wrap');
        var $wardHint = $('#ten_ward_hint');

        function refreshCascade() {
            var divisions = listDivisions();
            var selDivision = $division.val() || $division.data('selected') || '';
            fillSelect($division, divisions, selDivision);

            var divObj = findById(divisions, selDivision);
            var districts = divObj && Array.isArray(divObj.districts) ? divObj.districts : [];
            var selDistrict = $district.val() || $district.data('selected') || '';
            fillSelect($district, districts, selDistrict);

            var distObj = findById(districts, selDistrict);
            var areaType = ($areaType.val() || $areaType.data('selected') || '').toString();
            if (areaType) $areaType.val(areaType);

            $('#ten_muni_wrap').hide();
            $('#ten_upazila_wrap').hide();
            $('#ten_union_wrap').hide();
            $wardWrap.hide();
            $ward.prop('disabled', true);
            $wardHint.text('');

            if (!distObj || !areaType) {
                return;
            }

            if (areaType === 'municipality' || areaType === 'city_corporation') {
                $('#ten_muni_wrap').show();
                var munis = Array.isArray(distObj.municipalities) ? distObj.municipalities : [];
                var selMuni = $municipality.val() || $municipality.data('selected') || '';
                fillSelect($municipality, munis, selMuni);
                var muniObj = findById(munis, selMuni);
                var wards = muniObj && Array.isArray(muniObj.wards) ? muniObj.wards : range(1, 30);
                $wardWrap.show();
                $ward.prop('disabled', !muniObj);
                fillWardSelect($ward, wards, $ward.data('selected') || $ward.val() || '');
                $wardHint.text(@json(__('mosque::mosque.tenancy_ward_hint_municipality')));
            } else if (areaType === 'upazila') {
                $('#ten_upazila_wrap').show();
                var upazilas = Array.isArray(distObj.upazilas) ? distObj.upazilas : [];
                var selUpazila = $upazila.val() || $upazila.data('selected') || '';
                fillSelect($upazila, upazilas, selUpazila);
                var upObj = findById(upazilas, selUpazila);

                $('#ten_union_wrap').show();
                var unions = upObj && Array.isArray(upObj.unions) ? upObj.unions : [];
                var selUnion = $union.val() || $union.data('selected') || '';
                fillSelect($union, unions, selUnion);
                var uObj = findById(unions, selUnion);

                $wardWrap.show();
                $ward.prop('disabled', !uObj);
                var uWards = uObj && Array.isArray(uObj.wards) ? uObj.wards : range(1, 9);
                fillWardSelect($ward, uWards, $ward.data('selected') || $ward.val() || '');
                $wardHint.text(@json(__('mosque::mosque.tenancy_ward_hint_upazila')));
            }
        }

        refreshCascade();
        $division.on('change', function () { $division.data('selected', $division.val()); $district.data('selected', ''); refreshCascade(); });
        $district.on('change', function () { $district.data('selected', $district.val()); refreshCascade(); });
        $areaType.on('change', function () { $areaType.data('selected', $areaType.val()); $municipality.data('selected', ''); $upazila.data('selected', ''); $union.data('selected', ''); $ward.data('selected', ''); refreshCascade(); });
        $municipality.on('change', function () { $municipality.data('selected', $municipality.val()); $ward.data('selected', ''); refreshCascade(); });
        $upazila.on('change', function () { $upazila.data('selected', $upazila.val()); $union.data('selected', ''); $ward.data('selected', ''); refreshCascade(); });
        $union.on('change', function () { $union.data('selected', $union.val()); $ward.data('selected', ''); refreshCascade(); });

        var coIndex = $('#ten_cohabitants_table tbody tr').length;
        $('#ten_add_cohabitant').on('click', function () {
            var idx = coIndex++;
            var $tr = $('<tr>');
            $tr.append('<td><input type="text" class="form-control input-sm" name="form_data[cohabitants][' + idx + '][serial]"></td>');
            $tr.append('<td><input type="text" class="form-control input-sm" name="form_data[cohabitants][' + idx + '][name]"></td>');
            $tr.append('<td><input type="text" class="form-control input-sm" name="form_data[cohabitants][' + idx + '][age]"></td>');
            $tr.append('<td><input type="text" class="form-control input-sm" name="form_data[cohabitants][' + idx + '][occupation]"></td>');
            $tr.append('<td><input type="text" class="form-control input-sm" name="form_data[cohabitants][' + idx + '][phone]"></td>');
            $tr.append('<td class="text-center"><button type="button" class="btn btn-xs btn-danger ten-row-del"><i class="fa fa-times"></i></button></td>');
            $('#ten_cohabitants_table tbody').append($tr);
        });

        var guIndex = $('#ten_guarantors_table tbody tr').length;
        $('#ten_add_guarantor').on('click', function () {
            var idx = guIndex++;
            var $tr = $('<tr>');
            $tr.append('<td><input type="text" class="form-control input-sm" name="form_data[guarantors][' + idx + '][name]"></td>');
            $tr.append('<td><input type="text" class="form-control input-sm" name="form_data[guarantors][' + idx + '][relation]"></td>');
            $tr.append('<td><input type="text" class="form-control input-sm" name="form_data[guarantors][' + idx + '][phone]"></td>');
            $tr.append('<td><input type="text" class="form-control input-sm" name="form_data[guarantors][' + idx + '][address]"></td>');
            $tr.append('<td class="text-center"><button type="button" class="btn btn-xs btn-danger ten-row-del"><i class="fa fa-times"></i></button></td>');
            $('#ten_guarantors_table tbody').append($tr);
        });

        $(document).on('click', '.ten-row-del', function () {
            $(this).closest('tr').remove();
        });

        $('#ten_tenant_form').on('submit', function (e) {
            e.preventDefault();
            var fd = new FormData(this);
            $.ajax({
                method: 'POST',
                url: url,
                data: fd,
                processData: false,
                contentType: false,
                dataType: 'json',
                success: function (resp) {
                    if (resp && resp.success) {
                        toastr.success(resp.msg || @json(__('mosque::mosque.tenancy_success')));
                        if (resp.redirect) { window.location.href = resp.redirect; }
                    } else {
                        toastr.error((resp && resp.msg) ? resp.msg : @json(__('messages.something_went_wrong')));
                    }
                },
                error: function (xhr) {
                    var msg = @json(__('messages.something_went_wrong'));
                    if (xhr && xhr.responseJSON) {
                        if (xhr.responseJSON.msg) {
                            msg = xhr.responseJSON.msg;
                        } else if (xhr.responseJSON.errors) {
                            var firstKey = Object.keys(xhr.responseJSON.errors)[0];
                            if (firstKey && xhr.responseJSON.errors[firstKey] && xhr.responseJSON.errors[firstKey][0]) {
                                msg = xhr.responseJSON.errors[firstKey][0];
                            }
                        }
                        if (xhr.responseJSON.cases && xhr.responseJSON.cases.length) {
                            var list = '<ul style="margin:6px 0 0 18px;">' + xhr.responseJSON.cases.map(function (c) {
                                return '<li>' + $('<div>').text((c.title || '') + ' (' + (c.severity || '') + ')').html() + '</li>';
                            }).join('') + '</ul>';
                            $('#ten_case_banner').html('<strong>' + $('<div>').text(msg).html() + '</strong>' + list).show();
                        }
                    }
                    toastr.error(msg);
                }
            });
        });

        function setupCamera(opts) {
            var stream = null;
            var $take = $(opts.takeBtn);
            var $stop = $(opts.stopBtn);
            var $cap = $(opts.captureBtn);
            var $wrap = $(opts.wrap);
            var video = document.querySelector(opts.video);
            var canvas = document.querySelector(opts.canvas);
            var $input = $(opts.input);
            var $hint = $(opts.hint);

            function showHint(text) {
                $hint.text(text || '').toggle(!!text);
            }

            async function start() {
                showHint('');
                if (!navigator.mediaDevices || !navigator.mediaDevices.getUserMedia) {
                    showHint(@json(__('mosque::mosque.tenancy_camera_not_supported')));
                    return;
                }
                try {
                    stream = await navigator.mediaDevices.getUserMedia({ video: true, audio: false });
                    video.srcObject = stream;
                    $wrap.show();
                    $stop.show();
                    $cap.show();
                } catch (e) {
                    showHint(@json(__('mosque::mosque.tenancy_camera_requires_https')));
                }
            }

            function stop() {
                if (stream) {
                    stream.getTracks().forEach(function (t) { try { t.stop(); } catch (e) {} });
                    stream = null;
                }
                if (video) { try { video.srcObject = null; } catch (e) {} }
                $wrap.hide();
                $stop.hide();
                $cap.hide();
            }

            function capture() {
                if (!video || !canvas) return;
                var w = video.videoWidth || 640;
                var h = video.videoHeight || 480;
                canvas.width = w;
                canvas.height = h;
                var ctx = canvas.getContext('2d');
                ctx.drawImage(video, 0, 0, w, h);
                canvas.toBlob(function (blob) {
                    if (!blob) return;
                    var file = new File([blob], (opts.filenamePrefix || 'capture') + '_' + Date.now() + '.jpg', { type: 'image/jpeg' });
                    var dt = new DataTransfer();
                    if (opts.multiple) {
                        var existing = $input[0].files ? Array.from($input[0].files) : [];
                        existing.forEach(function (f) { dt.items.add(f); });
                    }
                    dt.items.add(file);
                    $input[0].files = dt.files;
                    stop();
                }, 'image/jpeg', 0.92);
            }

            $take.on('click', function () { start(); });
            $stop.on('click', function () { stop(); });
            $cap.on('click', function () { capture(); });
        }

        setupCamera({
            takeBtn: '#ten_photo_take_btn',
            stopBtn: '#ten_photo_stop_btn',
            captureBtn: '#ten_photo_capture_btn',
            wrap: '#ten_photo_cam_wrap',
            video: '#ten_photo_video',
            canvas: '#ten_photo_canvas',
            input: '#ten_photo_input',
            hint: '#ten_photo_cam_hint',
            filenamePrefix: 'tenant_photo',
            multiple: false
        });

        setupCamera({
            takeBtn: '#ten_att_take_btn',
            stopBtn: '#ten_att_stop_btn',
            captureBtn: '#ten_att_capture_btn',
            wrap: '#ten_att_cam_wrap',
            video: '#ten_att_video',
            canvas: '#ten_att_canvas',
            input: '#ten_att_input',
            hint: '#ten_att_cam_hint',
            filenamePrefix: 'tenant_id',
            multiple: true
        });
    });
</script>
@endsection
