@extends('mosque::layouts.app')
@section('title', __('mosque::mosque.menu_tenancy') . ' | ' . __('mosque::mosque.tenancy_tenants'))

@section('content')
<section class="content-header">
    <h1 class="tw-text-xl md:tw-text-3xl tw-font-bold tw-text-black">@lang('mosque::mosque.menu_tenancy')</h1>
</section>

<section class="content">
    @component('components.widget', ['class' => 'box-primary'])
        @include('mosque::tenancy.partials.nav')

        <div class="row" style="margin-top:15px;">
            <div class="col-sm-8">
                <div class="input-group" style="max-width:400px;">
                    <input type="text" class="form-control" id="tenant_search" placeholder="{{ __('mosque::mosque.tenancy_search_tenant_placeholder') }}">
                    <span class="input-group-btn">
                        <button type="button" class="btn btn-default" id="tenant_search_btn"><i class="fa fa-search"></i></button>
                        <button type="button" class="btn btn-default" id="tenant_clear_btn"><i class="fa fa-times"></i></button>
                    </span>
                </div>
            </div>
            <div class="col-sm-4 text-right">
                @can('mosque.tenancy.edit')
                    <a href="{{ route('mosque.tenancy.tenants.create') }}" class="btn btn-primary">
                        <i class="fa fa-plus"></i> @lang('mosque::mosque.tenancy_add_tenant')
                    </a>
                @endcan
            </div>
        </div>

        <div class="row" style="margin-top:10px;">
            <div class="col-sm-12">
                <div class="alert alert-info" style="margin:0;padding:8px 12px;font-size:13px;" id="duplicate_warning" style="display:none;">
                    <i class="fa fa-exclamation-triangle"></i> <strong>{{ __('mosque::mosque.tenancy_duplicates_found') }}</strong> <span id="duplicate_count">0</span> @lang('mosque::mosque.tenancy_duplicates_count')
                </div>
            </div>
        </div>

        <div class="table-responsive" style="margin-top:10px;">
            <table class="table table-bordered table-striped" id="ten_tenants_table" style="width:100%;">
                <thead>
                    <tr>
                        <th>@lang('mosque::mosque.tenancy_photo')</th>
                        <th>@lang('mosque::mosque.tenancy_name')</th>
                        <th>@lang('mosque::mosque.tenancy_phone')</th>
                        <th>@lang('mosque::mosque.tenancy_whatsapp')</th>
                        <th>@lang('mosque::mosque.tenancy_email')</th>
                        <th>@lang('mosque::mosque.tenancy_nid')</th>
                        <th>@lang('messages.action')</th>
                    </tr>
                </thead>
            </table>
        </div>
    @endcomponent
</section>
@endsection

@section('javascript')
<script>
    (function () {
        var table;
        var allTenants = [];
        var phoneSet = new Set();
        var nidSet = new Set();

        function findDuplicates() {
            var duplicates = 0;
            phoneSet.clear();
            nidSet.clear();

            allTenants.forEach(function (tenant) {
                var phone = (tenant.phone || '').trim().toLowerCase();
                var nid = (tenant.nid_no || '').trim().toLowerCase();

                if (phone) {
                    if (phoneSet.has(phone)) duplicates++;
                    phoneSet.add(phone);
                }

                if (nid) {
                    if (nidSet.has(nid)) duplicates++;
                    nidSet.add(nid);
                }
            });

            var warningDiv = $('#duplicate_warning');
            var countSpan = $('#duplicate_count');

            if (duplicates > 0) {
                countSpan.text(duplicates);
                warningDiv.show();
            } else {
                warningDiv.hide();
            }
        }

        $(document).ready(function () {
            table = $('#ten_tenants_table').DataTable({
                processing: true,
                serverSide: true,
                ajax: {
                    url: '{{ route("mosque.tenancy.tenants.data", [], false) }}',
                    dataSrc: function (json) {
                        allTenants = json.data || [];
                        findDuplicates();
                        return json.data;
                    }
                },
                dom: 'lBfrtip',
                buttons: [
                    { extend: 'csv', text: '<i class="fas fa-file-csv"></i>', className: 'btn btn-success' },
                    { extend: 'excel', text: '<i class="fas fa-file-excel"></i>', className: 'btn btn-info' },
                    { extend: 'pdf', text: '<i class="fas fa-file-pdf"></i>', className: 'btn btn-danger' },
                    { extend: 'print', text: '<i class="fas fa-print"></i>', className: 'btn btn-warning' },
                    { extend: 'colvis', text: '<i class="fas fa-eye"></i>', className: 'btn btn-primary' }
                ],
                columns: [
                    { data: 'photo', name: 'photo', orderable: false, searchable: false },
                    { data: 'full_name', name: 'full_name' },
                    { data: 'phone', name: 'phone' },
                    { data: 'whatsapp', name: 'whatsapp' },
                    { data: 'email', name: 'email' },
                    { data: 'nid_no', name: 'nid_no' },
                    { data: 'action', name: 'action', orderable: false, searchable: false }
                ]
            });

            $('#tenant_search_btn').on('click', function () {
                var searchTerm = $('#tenant_search').val().trim();
                table.column(1).search(searchTerm).draw();
                table.column(2).search(searchTerm).draw();
                table.column(5).search(searchTerm).draw();
            });

            $('#tenant_search').on('keypress', function (e) {
                if (e.which === 13) {
                    $('#tenant_search_btn').trigger('click');
                }
            });

            $('#tenant_clear_btn').on('click', function () {
                $('#tenant_search').val('');
                table.search('').columns().search('').draw();
            });
        });
    })();
</script>
@endsection
