<?php

use Illuminate\Support\Facades\Route;

Route::middleware(['web'])
    ->prefix('mosque/qr')
    ->group(function () {
        Route::get('/{token}', [Modules\Mosque\Http\Controllers\AttendanceQrController::class, 'showMobileForm'])->name('mosque.qr.mobile');
        Route::post('/{token}', [Modules\Mosque\Http\Controllers\AttendanceQrController::class, 'submitAttendance'])->middleware('throttle:30,1')->name('mosque.qr.submit');
    });

Route::middleware(['web'])
    ->prefix('mosque/donate')
    ->group(function () {
        Route::get('/{token}', [Modules\Mosque\Http\Controllers\DonationQrController::class, 'showPublic'])->name('mosque.donate.public');
        Route::post('/{token}', [Modules\Mosque\Http\Controllers\DonationQrController::class, 'submitPublic'])->middleware('throttle:60,1')->name('mosque.donate.public.submit');
    });

// Tenancy public QR (short token URL, throttled)
Route::middleware(['web'])
    ->prefix('mosque/t')
    ->group(function () {
        Route::get('/{token}', [Modules\Mosque\Http\Controllers\TenancyPublicController::class, 'showShort'])
            ->middleware('throttle:30,1')
            ->name('mosque.tenancy.public.short');
        Route::post('/{token}', [Modules\Mosque\Http\Controllers\TenancyPublicController::class, 'submitShort'])
            ->middleware('throttle:30,1')
            ->name('mosque.tenancy.public.short.submit');
    });

// Tenancy public QR (signed, throttled)
Route::middleware(['web', 'signed'])
    ->prefix('mosque/tenancy/public')
    ->group(function () {
        Route::get('/{token}', [Modules\Mosque\Http\Controllers\TenancyPublicController::class, 'show'])
            ->middleware('throttle:30,1')
            ->name('mosque.tenancy.public');
        Route::post('/{token}', [Modules\Mosque\Http\Controllers\TenancyPublicController::class, 'submit'])
            ->middleware('throttle:30,1')
            ->name('mosque.tenancy.public.submit');
    });

Route::middleware(['web', 'authh', 'auth', 'SetSessionData', \Modules\Mosque\Http\Middleware\RefreshBusinessCurrency::class, 'language', 'timezone', 'AdminSidebarMenu', \Modules\Mosque\Http\Middleware\CheckMosqueSubscription::class])
    ->prefix('mosque')
    ->group(function () {
        Route::get('/install', [Modules\Mosque\Http\Controllers\InstallController::class, 'index'])->name('mosque.install.index');
        Route::post('/install', [Modules\Mosque\Http\Controllers\InstallController::class, 'install'])->name('mosque.install');
        Route::get('/install/update', [Modules\Mosque\Http\Controllers\InstallController::class, 'update'])->name('mosque.install.update');
        Route::get('/install/uninstall', [Modules\Mosque\Http\Controllers\InstallController::class, 'uninstall'])->name('mosque.install.uninstall');

        Route::get('/activate', [Modules\Mosque\Http\Controllers\ActivationController::class, 'index'])->name('mosque.activate');
        Route::post('/activate', [Modules\Mosque\Http\Controllers\ActivationController::class, 'store'])->name('mosque.activate.store');

        Route::get('/', function () {
            return redirect()->route('mosque.dashboard');
        })->name('mosque.index');

        Route::middleware([Modules\Mosque\Http\Middleware\CheckMosqueLicense::class])->group(function () {
            Route::get('/dashboard', [Modules\Mosque\Http\Controllers\MosqueController::class, 'dashboard'])->name('mosque.dashboard');
            Route::get('/logo/{filename}', [Modules\Mosque\Http\Controllers\LogoController::class, 'show'])
                ->where('filename', '[A-Za-z0-9._-]+')
                ->name('mosque.logo');

            Route::get('/attendance/qr', [Modules\Mosque\Http\Controllers\AttendanceQrController::class, 'index'])->name('mosque.attendance.qr');
            Route::post('/attendance/qr/regenerate', [Modules\Mosque\Http\Controllers\AttendanceQrController::class, 'regenerate'])->name('mosque.attendance.qr.regenerate');

            Route::get('/members', [Modules\Mosque\Http\Controllers\MembersController::class, 'index'])->name('mosque.members');
            Route::get('/members/data', [Modules\Mosque\Http\Controllers\MembersController::class, 'data'])->name('mosque.members.data');
            Route::get('/members/search', [Modules\Mosque\Http\Controllers\MembersController::class, 'search'])->name('mosque.members.search');
            Route::get('/members/create', [Modules\Mosque\Http\Controllers\MembersController::class, 'create'])->name('mosque.members.create');
            Route::post('/members', [Modules\Mosque\Http\Controllers\MembersController::class, 'store'])->name('mosque.members.store');
            Route::get('/members/import', [Modules\Mosque\Http\Controllers\MembersController::class, 'importForm'])->name('mosque.members.import');
            Route::post('/members/import', [Modules\Mosque\Http\Controllers\MembersController::class, 'importStore'])->name('mosque.members.import.store');
            Route::get('/members/{id}/edit', [Modules\Mosque\Http\Controllers\MembersController::class, 'edit'])->name('mosque.members.edit');
            Route::get('/members/{id}/export', [Modules\Mosque\Http\Controllers\MembersController::class, 'export'])->name('mosque.members.export');
            Route::get('/members/{id}/card/print', [Modules\Mosque\Http\Controllers\MembersController::class, 'cardPrint'])->name('mosque.members.card.print');
            Route::get('/members/{id}/card/pdf', [Modules\Mosque\Http\Controllers\MembersController::class, 'cardPdf'])->name('mosque.members.card.pdf');
            Route::get('/members/reports', [Modules\Mosque\Http\Controllers\MembersReportsController::class, 'index'])->name('mosque.members.reports');
            Route::get('/members/reports/status', [Modules\Mosque\Http\Controllers\MembersReportsController::class, 'statusData'])->name('mosque.members.reports.status');
            Route::get('/members/reports/inactive', [Modules\Mosque\Http\Controllers\MembersReportsController::class, 'inactiveData'])->name('mosque.members.reports.inactive');
            Route::put('/members/{id}', [Modules\Mosque\Http\Controllers\MembersController::class, 'update'])->name('mosque.members.update');
            Route::delete('/members/{id}', [Modules\Mosque\Http\Controllers\MembersController::class, 'destroy'])->name('mosque.members.destroy');
            Route::get('/families', [Modules\Mosque\Http\Controllers\FamiliesController::class, 'index'])->name('mosque.families');
            Route::get('/families/data', [Modules\Mosque\Http\Controllers\FamiliesController::class, 'data'])->name('mosque.families.data');
            Route::get('/families/codes/search', [Modules\Mosque\Http\Controllers\FamiliesController::class, 'codesSearch'])->name('mosque.families.codes.search');
            Route::get('/families/codes', [Modules\Mosque\Http\Controllers\FamilyCodesController::class, 'index'])->name('mosque.families.codes');
            Route::get('/families/codes/data', [Modules\Mosque\Http\Controllers\FamilyCodesController::class, 'data'])->name('mosque.families.codes.data');
            Route::get('/families/codes/create', [Modules\Mosque\Http\Controllers\FamilyCodesController::class, 'create'])->name('mosque.families.codes.create');
            Route::post('/families/codes', [Modules\Mosque\Http\Controllers\FamilyCodesController::class, 'store'])->name('mosque.families.codes.store');
            Route::get('/families/codes/{id}/edit', [Modules\Mosque\Http\Controllers\FamilyCodesController::class, 'edit'])->name('mosque.families.codes.edit');
            Route::put('/families/codes/{id}', [Modules\Mosque\Http\Controllers\FamilyCodesController::class, 'update'])->name('mosque.families.codes.update');
            Route::delete('/families/codes/{id}', [Modules\Mosque\Http\Controllers\FamilyCodesController::class, 'destroy'])->name('mosque.families.codes.destroy');
            Route::get('/families/create', [Modules\Mosque\Http\Controllers\FamiliesController::class, 'create'])->name('mosque.families.create');
            Route::post('/families', [Modules\Mosque\Http\Controllers\FamiliesController::class, 'store'])->name('mosque.families.store');
            Route::get('/families/{id}/edit', [Modules\Mosque\Http\Controllers\FamiliesController::class, 'edit'])->name('mosque.families.edit');
            Route::get('/families/{id}/card/print', [Modules\Mosque\Http\Controllers\FamiliesController::class, 'cardPrint'])->name('mosque.families.card.print');
            Route::get('/families/{id}/card/pdf', [Modules\Mosque\Http\Controllers\FamiliesController::class, 'cardPdf'])->name('mosque.families.card.pdf');
            Route::get('/families/reports', [Modules\Mosque\Http\Controllers\FamiliesReportsController::class, 'index'])->name('mosque.families.reports');
            Route::get('/families/reports/data', [Modules\Mosque\Http\Controllers\FamiliesReportsController::class, 'familiesData'])->name('mosque.families.reports.data');
            Route::put('/families/{id}', [Modules\Mosque\Http\Controllers\FamiliesController::class, 'update'])->name('mosque.families.update');
            Route::delete('/families/{id}', [Modules\Mosque\Http\Controllers\FamiliesController::class, 'destroy'])->name('mosque.families.destroy');
            Route::get('/subscriptions', [Modules\Mosque\Http\Controllers\MembershipController::class, 'index'])->name('mosque.subscriptions');
            Route::get('/subscriptions/plans', [Modules\Mosque\Http\Controllers\MembershipController::class, 'plansIndex'])->name('mosque.subscriptions.plans');
            Route::get('/subscriptions/plans/data', [Modules\Mosque\Http\Controllers\MembershipController::class, 'plansData'])->name('mosque.subscriptions.plans.data');
            Route::get('/subscriptions/plans/create', [Modules\Mosque\Http\Controllers\MembershipController::class, 'plansCreate'])->name('mosque.subscriptions.plans.create');
            Route::post('/subscriptions/plans', [Modules\Mosque\Http\Controllers\MembershipController::class, 'plansStore'])->name('mosque.subscriptions.plans.store');
            Route::get('/subscriptions/plans/import', [Modules\Mosque\Http\Controllers\MembershipController::class, 'plansImportForm'])->name('mosque.subscriptions.plans.import');
            Route::post('/subscriptions/plans/import', [Modules\Mosque\Http\Controllers\MembershipController::class, 'plansImportStore'])->name('mosque.subscriptions.plans.import.store');
            Route::get('/subscriptions/plans/{id}/edit', [Modules\Mosque\Http\Controllers\MembershipController::class, 'plansEdit'])->name('mosque.subscriptions.plans.edit');
            Route::put('/subscriptions/plans/{id}', [Modules\Mosque\Http\Controllers\MembershipController::class, 'plansUpdate'])->name('mosque.subscriptions.plans.update');
            Route::delete('/subscriptions/plans/{id}', [Modules\Mosque\Http\Controllers\MembershipController::class, 'plansDestroy'])->name('mosque.subscriptions.plans.destroy');

            Route::get('/subscriptions/fees', [Modules\Mosque\Http\Controllers\MembershipController::class, 'feesIndex'])->name('mosque.subscriptions.fees');
            Route::get('/subscriptions/fees/cancel-history', [Modules\Mosque\Http\Controllers\MembershipController::class, 'feesCancelHistoryIndex'])->name('mosque.subscriptions.fees.cancel_history');
            Route::get('/subscriptions/fees/data', [Modules\Mosque\Http\Controllers\MembershipController::class, 'feesData'])->name('mosque.subscriptions.fees.data');
            Route::get('/subscriptions/fees/generate', [Modules\Mosque\Http\Controllers\MembershipController::class, 'feesGenerateForm'])->name('mosque.subscriptions.fees.generate.form');
            Route::post('/subscriptions/fees/generate', [Modules\Mosque\Http\Controllers\MembershipController::class, 'feesGenerate'])->name('mosque.subscriptions.fees.generate');
            Route::get('/subscriptions/fees/member-plan', [Modules\Mosque\Http\Controllers\MembershipController::class, 'feesMemberPlan'])->name('mosque.subscriptions.fees.member_plan');
            Route::get('/subscriptions/fees/members/search', [Modules\Mosque\Http\Controllers\MembershipController::class, 'feesMembersSearch'])->name('mosque.subscriptions.fees.members.search');
            Route::get('/subscriptions/fees/family-codes/search', [Modules\Mosque\Http\Controllers\MembershipController::class, 'feesFamilyCodesSearch'])->name('mosque.subscriptions.fees.family_codes.search');
            Route::post('/subscriptions/fees/{id}/pay-full', [Modules\Mosque\Http\Controllers\MembershipController::class, 'feesPayFull'])->name('mosque.subscriptions.fees.pay_full');
            Route::post('/subscriptions/fees/pay-bulk', [Modules\Mosque\Http\Controllers\MembershipController::class, 'feesPayBulk'])->name('mosque.subscriptions.fees.pay_bulk');
            Route::delete('/subscriptions/fees/{id}', [Modules\Mosque\Http\Controllers\MembershipController::class, 'feesDestroy'])->name('mosque.subscriptions.fees.destroy');

            Route::post('/membership-fees/{fee}/cancel', [Modules\Mosque\Http\Controllers\MemberFeeController::class, 'cancel'])->name('mosque.membership_fees.cancel');
            Route::post('/membership-fees/{fee}/reactivate', [Modules\Mosque\Http\Controllers\MemberFeeController::class, 'reactivate'])->name('mosque.membership_fees.reactivate');
            Route::delete('/membership-fees/{fee}', [Modules\Mosque\Http\Controllers\MemberFeeController::class, 'destroy'])->name('mosque.membership_fees.destroy');

            Route::get('/subscriptions/payments', [Modules\Mosque\Http\Controllers\MembershipController::class, 'paymentsIndex'])->name('mosque.subscriptions.payments');
            Route::get('/subscriptions/payments/data', [Modules\Mosque\Http\Controllers\MembershipController::class, 'paymentsData'])->name('mosque.subscriptions.payments.data');
            Route::get('/subscriptions/fees/{fee_id}/payments/create', [Modules\Mosque\Http\Controllers\MembershipController::class, 'paymentsCreate'])->name('mosque.subscriptions.payments.create');
            Route::post('/subscriptions/fees/{fee_id}/payments', [Modules\Mosque\Http\Controllers\MembershipController::class, 'paymentsStore'])->name('mosque.subscriptions.payments.store');
            Route::delete('/subscriptions/payments/{id}', [Modules\Mosque\Http\Controllers\MembershipController::class, 'paymentsDestroy'])->name('mosque.subscriptions.payments.destroy');
            Route::get('/subscriptions/payments/{id}/print', [Modules\Mosque\Http\Controllers\MembershipController::class, 'paymentPrint'])->name('mosque.subscriptions.payments.print');
            Route::get('/subscriptions/payments/{id}/pdf', [Modules\Mosque\Http\Controllers\MembershipController::class, 'paymentPdf'])->name('mosque.subscriptions.payments.pdf');

            Route::get('/subscriptions/reports', [Modules\Mosque\Http\Controllers\MembershipReportsController::class, 'index'])->name('mosque.subscriptions.reports');
            Route::get('/subscriptions/reports/monthly', [Modules\Mosque\Http\Controllers\MembershipReportsController::class, 'monthlyCollectionsData'])->name('mosque.subscriptions.reports.monthly');
            Route::get('/subscriptions/reports/outstanding', [Modules\Mosque\Http\Controllers\MembershipReportsController::class, 'outstandingDuesData'])->name('mosque.subscriptions.reports.outstanding');
            Route::get('/subscriptions/reports/history', [Modules\Mosque\Http\Controllers\MembershipReportsController::class, 'paymentHistoryData'])->name('mosque.subscriptions.reports.history');
            Route::get('/donations', [Modules\Mosque\Http\Controllers\DonationsController::class, 'index'])->name('mosque.donations');
            Route::get('/donations/data', [Modules\Mosque\Http\Controllers\DonationsController::class, 'data'])->name('mosque.donations.data');
            Route::get('/donations/create', [Modules\Mosque\Http\Controllers\DonationsController::class, 'create'])->name('mosque.donations.create');
            Route::post('/donations', [Modules\Mosque\Http\Controllers\DonationsController::class, 'store'])->name('mosque.donations.store');
            Route::get('/donations/qr', [Modules\Mosque\Http\Controllers\DonationQrController::class, 'adminIndex'])->name('mosque.donations.qr');
            Route::post('/donations/qr', [Modules\Mosque\Http\Controllers\DonationQrController::class, 'adminUpdate'])->name('mosque.donations.qr.update');
            Route::post('/donations/qr/regenerate', [Modules\Mosque\Http\Controllers\DonationQrController::class, 'adminRegenerate'])->name('mosque.donations.qr.regenerate');
            Route::get('/donations/qr/image', [Modules\Mosque\Http\Controllers\DonationQrController::class, 'adminQrImage'])->name('mosque.donations.qr.image');
            Route::get('/donations/qr/download', [Modules\Mosque\Http\Controllers\DonationQrController::class, 'adminQrDownload'])->name('mosque.donations.qr.download');
            Route::get('/donations/qr/requests/data', [Modules\Mosque\Http\Controllers\DonationQrController::class, 'adminRequestsData'])->name('mosque.donations.qr.requests.data');
            Route::get('/donations/qr/requests/{id}/image', [Modules\Mosque\Http\Controllers\DonationQrController::class, 'adminRequestImage'])->name('mosque.donations.qr.requests.image');
            Route::post('/donations/qr/requests/{id}/approve', [Modules\Mosque\Http\Controllers\DonationQrController::class, 'adminApprove'])->name('mosque.donations.qr.requests.approve');
            Route::post('/donations/qr/requests/{id}/reject', [Modules\Mosque\Http\Controllers\DonationQrController::class, 'adminReject'])->name('mosque.donations.qr.requests.reject');
            Route::get('/donations/reports', [Modules\Mosque\Http\Controllers\DonationsReportsController::class, 'index'])->name('mosque.donations.reports');
            Route::get('/donations/reports/donors', [Modules\Mosque\Http\Controllers\DonationsReportsController::class, 'donorsData'])->name('mosque.donations.reports.donors');
            Route::get('/donations/reports/types', [Modules\Mosque\Http\Controllers\DonationsReportsController::class, 'typesData'])->name('mosque.donations.reports.types');
            Route::get('/donations/reports/annual', [Modules\Mosque\Http\Controllers\DonationsReportsController::class, 'annualData'])->name('mosque.donations.reports.annual');
            Route::get('/donations/reports/receipts', [Modules\Mosque\Http\Controllers\DonationsReportsController::class, 'receiptsData'])->name('mosque.donations.reports.receipts');
            Route::get('/donations/reports/zakat', [Modules\Mosque\Http\Controllers\DonationsReportsController::class, 'zakatSummary'])->name('mosque.donations.reports.zakat');
            Route::get('/donations/{id}/edit', [Modules\Mosque\Http\Controllers\DonationsController::class, 'edit'])->name('mosque.donations.edit');
            Route::put('/donations/{id}', [Modules\Mosque\Http\Controllers\DonationsController::class, 'update'])->name('mosque.donations.update');
            Route::delete('/donations/{id}', [Modules\Mosque\Http\Controllers\DonationsController::class, 'destroy'])->name('mosque.donations.destroy');
            Route::get('/donations/{id}/print', [Modules\Mosque\Http\Controllers\DonationsController::class, 'print'])->name('mosque.donations.print');
            Route::get('/donations/{id}/pdf', [Modules\Mosque\Http\Controllers\DonationsController::class, 'pdf'])->name('mosque.donations.pdf');

            // Pledges / Commitments
            Route::get('/pledges', [Modules\Mosque\Http\Controllers\PledgesController::class, 'index'])->name('mosque.pledges');
            Route::get('/pledges/data', [Modules\Mosque\Http\Controllers\PledgesController::class, 'data'])->name('mosque.pledges.data');
            Route::get('/pledges/create', [Modules\Mosque\Http\Controllers\PledgesController::class, 'create'])->name('mosque.pledges.create');
            Route::post('/pledges', [Modules\Mosque\Http\Controllers\PledgesController::class, 'store'])->name('mosque.pledges.store');
            Route::get('/pledges/{id}/edit', [Modules\Mosque\Http\Controllers\PledgesController::class, 'edit'])->name('mosque.pledges.edit');
            Route::put('/pledges/{id}', [Modules\Mosque\Http\Controllers\PledgesController::class, 'update'])->name('mosque.pledges.update');
            Route::delete('/pledges/{id}', [Modules\Mosque\Http\Controllers\PledgesController::class, 'destroy'])->name('mosque.pledges.destroy');
            Route::post('/pledges/{id}/remind', [Modules\Mosque\Http\Controllers\PledgesController::class, 'remind'])->name('mosque.pledges.remind');
            Route::post('/pledges/{id}/cancel', [Modules\Mosque\Http\Controllers\PledgesController::class, 'cancel'])->name('mosque.pledges.cancel');
            Route::get('/pledges/{id}/receipt', [Modules\Mosque\Http\Controllers\PledgesController::class, 'receipt'])->name('mosque.pledges.receipt');
            Route::get('/pledges/contacts/search', [Modules\Mosque\Http\Controllers\PledgesController::class, 'contactsSearch'])->name('mosque.pledges.contacts.search');

            Route::get('/pledges/{id}/fulfill', [Modules\Mosque\Http\Controllers\PledgeFulfillmentController::class, 'form'])->name('mosque.pledges.fulfill.form');
            Route::post('/pledges/{id}/fulfill', [Modules\Mosque\Http\Controllers\PledgeFulfillmentController::class, 'store'])->name('mosque.pledges.fulfill.store');
            Route::delete('/pledges/fulfillments/{id}', [Modules\Mosque\Http\Controllers\PledgeFulfillmentController::class, 'destroy'])->name('mosque.pledges.fulfill.destroy');

            Route::get('/pledges/goods', [Modules\Mosque\Http\Controllers\PledgeGoodsController::class, 'index'])->name('mosque.pledges.goods');
            Route::get('/pledges/goods/data', [Modules\Mosque\Http\Controllers\PledgeGoodsController::class, 'data'])->name('mosque.pledges.goods.data');
            Route::get('/pledges/goods/create', [Modules\Mosque\Http\Controllers\PledgeGoodsController::class, 'create'])->name('mosque.pledges.goods.create');
            Route::post('/pledges/goods', [Modules\Mosque\Http\Controllers\PledgeGoodsController::class, 'store'])->name('mosque.pledges.goods.store');
            Route::get('/pledges/goods/{id}/edit', [Modules\Mosque\Http\Controllers\PledgeGoodsController::class, 'edit'])->name('mosque.pledges.goods.edit');
            Route::put('/pledges/goods/{id}', [Modules\Mosque\Http\Controllers\PledgeGoodsController::class, 'update'])->name('mosque.pledges.goods.update');
            Route::delete('/pledges/goods/{id}', [Modules\Mosque\Http\Controllers\PledgeGoodsController::class, 'destroy'])->name('mosque.pledges.goods.destroy');

            Route::get('/pledges/reports', [Modules\Mosque\Http\Controllers\PledgesReportsController::class, 'index'])->name('mosque.pledges.reports');
            Route::get('/pledges/reports/aging', [Modules\Mosque\Http\Controllers\PledgesReportsController::class, 'agingData'])->name('mosque.pledges.reports.aging');
            Route::get('/pledges/reports/donor', [Modules\Mosque\Http\Controllers\PledgesReportsController::class, 'donorStatementData'])->name('mosque.pledges.reports.donor');

            Route::get('/donors', [Modules\Mosque\Http\Controllers\DonorsController::class, 'index'])->name('mosque.donors');
            Route::get('/donors/data', [Modules\Mosque\Http\Controllers\DonorsController::class, 'data'])->name('mosque.donors.data');
            Route::get('/donors/create', [Modules\Mosque\Http\Controllers\DonorsController::class, 'create'])->name('mosque.donors.create');
            Route::post('/donors', [Modules\Mosque\Http\Controllers\DonorsController::class, 'store'])->name('mosque.donors.store');
            Route::get('/donors/import', [Modules\Mosque\Http\Controllers\DonorsController::class, 'importForm'])->name('mosque.donors.import');
            Route::post('/donors/import', [Modules\Mosque\Http\Controllers\DonorsController::class, 'importStore'])->name('mosque.donors.import.store');
            Route::get('/donors/{id}/edit', [Modules\Mosque\Http\Controllers\DonorsController::class, 'edit'])->name('mosque.donors.edit');
            Route::put('/donors/{id}', [Modules\Mosque\Http\Controllers\DonorsController::class, 'update'])->name('mosque.donors.update');
            Route::delete('/donors/{id}', [Modules\Mosque\Http\Controllers\DonorsController::class, 'destroy'])->name('mosque.donors.destroy');
            Route::get('/finance', [Modules\Mosque\Http\Controllers\FinanceController::class, 'index'])->name('mosque.finance');
            Route::get('/finance/data', [Modules\Mosque\Http\Controllers\FinanceController::class, 'entriesData'])->name('mosque.finance.data');
            Route::get('/finance/summary', [Modules\Mosque\Http\Controllers\FinanceController::class, 'summary'])->name('mosque.finance.summary');
            Route::get('/finance/reports', [Modules\Mosque\Http\Controllers\FinanceController::class, 'reportsIndex'])->name('mosque.finance.reports');
            Route::get('/finance/reports/categories', [Modules\Mosque\Http\Controllers\FinanceController::class, 'reportsCategoriesData'])->name('mosque.finance.reports.categories');
            Route::get('/finance/reports/monthly', [Modules\Mosque\Http\Controllers\FinanceController::class, 'reportsMonthlyData'])->name('mosque.finance.reports.monthly');
            Route::get('/finance/reports/weekly', [Modules\Mosque\Http\Controllers\FinanceController::class, 'reportsWeeklyData'])->name('mosque.finance.reports.weekly');
            Route::get('/finance/reports/zakat', [Modules\Mosque\Http\Controllers\FinanceController::class, 'reportsZakatSummary'])->name('mosque.finance.reports.zakat');
            Route::get('/finance/day-book', [Modules\Mosque\Http\Controllers\FinanceController::class, 'dayBookIndex'])->name('mosque.finance.day_book');
            Route::get('/finance/day-book/data', [Modules\Mosque\Http\Controllers\FinanceController::class, 'dayBookData'])->name('mosque.finance.day_book.data');
            Route::get('/finance/cash-book', [Modules\Mosque\Http\Controllers\FinanceController::class, 'cashBookIndex'])->name('mosque.finance.cash_book');
            Route::get('/finance/cash-book/data', [Modules\Mosque\Http\Controllers\FinanceController::class, 'cashBookData'])->name('mosque.finance.cash_book.data');

            // Bank wallets (Net balance -> Bank, Cashout workflow)
            Route::get('/finance/bank-management', [Modules\Mosque\Http\Controllers\BankManagementController::class, 'index'])->name('mosque.finance.bank_management');
            Route::get('/finance/banks', [Modules\Mosque\Http\Controllers\BankWalletController::class, 'index'])->name('mosque.finance.banks');
            Route::get('/finance/banks/data', [Modules\Mosque\Http\Controllers\BankWalletController::class, 'data'])->name('mosque.finance.banks.data');
            Route::get('/finance/banks/create', [Modules\Mosque\Http\Controllers\BankWalletController::class, 'create'])->name('mosque.finance.banks.create');
            Route::post('/finance/banks', [Modules\Mosque\Http\Controllers\BankWalletController::class, 'store'])->name('mosque.finance.banks.store');
            Route::get('/finance/banks/{id}/edit', [Modules\Mosque\Http\Controllers\BankWalletController::class, 'edit'])->name('mosque.finance.banks.edit');
            Route::put('/finance/banks/{id}', [Modules\Mosque\Http\Controllers\BankWalletController::class, 'update'])->name('mosque.finance.banks.update');
            Route::delete('/finance/banks/{id}', [Modules\Mosque\Http\Controllers\BankWalletController::class, 'destroy'])->name('mosque.finance.banks.destroy');
            Route::get('/finance/banks/summary', [Modules\Mosque\Http\Controllers\BankWalletController::class, 'summary'])->name('mosque.finance.banks.summary');

            Route::get('/finance/transfers', [Modules\Mosque\Http\Controllers\NetToBankTransferController::class, 'index'])->name('mosque.finance.transfers');
            Route::get('/finance/transfers/data', [Modules\Mosque\Http\Controllers\NetToBankTransferController::class, 'data'])->name('mosque.finance.transfers.data');
            Route::post('/finance/transfers', [Modules\Mosque\Http\Controllers\NetToBankTransferController::class, 'store'])->name('mosque.finance.transfers.store');
            Route::delete('/finance/transfers/{id}', [Modules\Mosque\Http\Controllers\NetToBankTransferController::class, 'void'])->name('mosque.finance.transfers.void');
            Route::delete('/finance/transfers/{id}/permanent', [Modules\Mosque\Http\Controllers\NetToBankTransferController::class, 'destroy'])->name('mosque.finance.transfers.destroy');

            Route::get('/finance/cashouts', [Modules\Mosque\Http\Controllers\BankCashoutController::class, 'index'])->name('mosque.finance.cashouts');
            Route::get('/finance/cashouts/data', [Modules\Mosque\Http\Controllers\BankCashoutController::class, 'data'])->name('mosque.finance.cashouts.data');
            Route::get('/finance/cashouts/create', [Modules\Mosque\Http\Controllers\BankCashoutController::class, 'create'])->name('mosque.finance.cashouts.create');
            Route::post('/finance/cashouts', [Modules\Mosque\Http\Controllers\BankCashoutController::class, 'store'])->name('mosque.finance.cashouts.store');
            Route::post('/finance/cashouts/{id}/approve', [Modules\Mosque\Http\Controllers\BankCashoutController::class, 'approve'])->name('mosque.finance.cashouts.approve');
            Route::post('/finance/cashouts/{id}/reject', [Modules\Mosque\Http\Controllers\BankCashoutController::class, 'reject'])->name('mosque.finance.cashouts.reject');
            Route::get('/finance/cashouts/{id}/receipt', [Modules\Mosque\Http\Controllers\BankCashoutController::class, 'receipt'])->name('mosque.finance.cashouts.receipt');
            Route::get('/finance/cashouts/{id}/receipt/pdf', [Modules\Mosque\Http\Controllers\BankCashoutController::class, 'receiptPdf'])->name('mosque.finance.cashouts.receipt_pdf');
            Route::get('/finance/cashouts/{id}/final', [Modules\Mosque\Http\Controllers\BankCashoutController::class, 'finalReceipt'])->name('mosque.finance.cashouts.final_receipt');
            Route::get('/finance/cashouts/{id}/final/pdf', [Modules\Mosque\Http\Controllers\BankCashoutController::class, 'finalReceiptPdf'])->name('mosque.finance.cashouts.final_receipt_pdf');
            Route::get('/finance/cashouts/{id}/attachment', [Modules\Mosque\Http\Controllers\BankCashoutController::class, 'attachment'])->name('mosque.finance.cashouts.attachment');

            Route::get('/finance/entries/create/{type}', [Modules\Mosque\Http\Controllers\FinanceController::class, 'entriesCreate'])->name('mosque.finance.entries.create');
            Route::post('/finance/entries', [Modules\Mosque\Http\Controllers\FinanceController::class, 'entriesStore'])->name('mosque.finance.entries.store');
            Route::get('/finance/entries/{id}/edit', [Modules\Mosque\Http\Controllers\FinanceController::class, 'entriesEdit'])->name('mosque.finance.entries.edit');
            Route::put('/finance/entries/{id}', [Modules\Mosque\Http\Controllers\FinanceController::class, 'entriesUpdate'])->name('mosque.finance.entries.update');
            Route::delete('/finance/entries/{id}', [Modules\Mosque\Http\Controllers\FinanceController::class, 'entriesDestroy'])->name('mosque.finance.entries.destroy');
            Route::get('/finance/opening-balance/create', [Modules\Mosque\Http\Controllers\FinanceController::class, 'openingBalanceCreate'])->name('mosque.finance.opening_balance.create');
            Route::post('/finance/opening-balance', [Modules\Mosque\Http\Controllers\FinanceController::class, 'openingBalanceStore'])->name('mosque.finance.opening_balance.store');
            Route::get('/finance/opening-balance/history', [Modules\Mosque\Http\Controllers\FinanceController::class, 'openingBalanceHistory'])->name('mosque.finance.opening_balance.history');
            Route::get('/finance/opening-balance/data', [Modules\Mosque\Http\Controllers\FinanceController::class, 'openingBalanceData'])->name('mosque.finance.opening_balance.data');

            Route::get('/finance/categories', [Modules\Mosque\Http\Controllers\FinanceController::class, 'categoriesIndex'])->name('mosque.finance.categories');
            Route::get('/finance/categories/data', [Modules\Mosque\Http\Controllers\FinanceController::class, 'categoriesData'])->name('mosque.finance.categories.data');
            Route::get('/finance/categories/create', [Modules\Mosque\Http\Controllers\FinanceController::class, 'categoriesCreate'])->name('mosque.finance.categories.create');
            Route::post('/finance/categories', [Modules\Mosque\Http\Controllers\FinanceController::class, 'categoriesStore'])->name('mosque.finance.categories.store');
            Route::get('/finance/categories/{id}/edit', [Modules\Mosque\Http\Controllers\FinanceController::class, 'categoriesEdit'])->name('mosque.finance.categories.edit');
            Route::put('/finance/categories/{id}', [Modules\Mosque\Http\Controllers\FinanceController::class, 'categoriesUpdate'])->name('mosque.finance.categories.update');
            Route::delete('/finance/categories/{id}', [Modules\Mosque\Http\Controllers\FinanceController::class, 'categoriesDestroy'])->name('mosque.finance.categories.destroy');
            Route::get('/committee', [Modules\Mosque\Http\Controllers\CommitteeController::class, 'index'])->name('mosque.committee');
            Route::get('/committee/{id}/invite', [Modules\Mosque\Http\Controllers\CommitteeController::class, 'invite'])->name('mosque.committee.invite');
            Route::post('/committee/{id}/invite/email', [Modules\Mosque\Http\Controllers\CommitteeController::class, 'inviteEmail'])->name('mosque.committee.invite.email');
            Route::get('/committee/{id}/invite/pdf', [Modules\Mosque\Http\Controllers\CommitteeController::class, 'invitePdf'])->name('mosque.committee.invite.pdf');
            Route::get('/committee/{committee_id}/invite/whatsapp/{member_id}', [Modules\Mosque\Http\Controllers\CommitteeController::class, 'inviteWhatsapp'])->name('mosque.committee.invite.whatsapp');
            Route::get('/committee/committees/data', [Modules\Mosque\Http\Controllers\CommitteeController::class, 'committeesData'])->name('mosque.committee.committees.data');
            Route::get('/committee/committees/create', [Modules\Mosque\Http\Controllers\CommitteeController::class, 'committeesCreate'])->name('mosque.committee.committees.create');
            Route::post('/committee/committees', [Modules\Mosque\Http\Controllers\CommitteeController::class, 'committeesStore'])->name('mosque.committee.committees.store');
            Route::get('/committee/committees/{id}/edit', [Modules\Mosque\Http\Controllers\CommitteeController::class, 'committeesEdit'])->name('mosque.committee.committees.edit');
            Route::put('/committee/committees/{id}', [Modules\Mosque\Http\Controllers\CommitteeController::class, 'committeesUpdate'])->name('mosque.committee.committees.update');
            Route::delete('/committee/committees/{id}', [Modules\Mosque\Http\Controllers\CommitteeController::class, 'committeesDestroy'])->name('mosque.committee.committees.destroy');
            Route::post('/committee/committees/{id}/restore', [Modules\Mosque\Http\Controllers\CommitteeController::class, 'committeesRestore'])->name('mosque.committee.committees.restore');

            Route::get('/committee/members/data', [Modules\Mosque\Http\Controllers\CommitteeController::class, 'membersData'])->name('mosque.committee.members.data');
            Route::get('/committee/members/create', [Modules\Mosque\Http\Controllers\CommitteeController::class, 'membersCreate'])->name('mosque.committee.members.create');
            Route::post('/committee/members', [Modules\Mosque\Http\Controllers\CommitteeController::class, 'membersStore'])->name('mosque.committee.members.store');
            Route::get('/committee/members/{id}/edit', [Modules\Mosque\Http\Controllers\CommitteeController::class, 'membersEdit'])->name('mosque.committee.members.edit');
            Route::put('/committee/members/{id}', [Modules\Mosque\Http\Controllers\CommitteeController::class, 'membersUpdate'])->name('mosque.committee.members.update');
            Route::delete('/committee/members/{id}', [Modules\Mosque\Http\Controllers\CommitteeController::class, 'membersDestroy'])->name('mosque.committee.members.destroy');
            Route::get('/committee/members/{id}/card', [Modules\Mosque\Http\Controllers\CommitteeController::class, 'memberCard'])->name('mosque.committee.members.card');

            // Committee Roles (dynamic)
            Route::get('/committee/roles/data', [Modules\Mosque\Http\Controllers\CommitteeRoleController::class, 'data'])->name('mosque.committee.roles.data');
            Route::get('/committee/roles/create', [Modules\Mosque\Http\Controllers\CommitteeRoleController::class, 'create'])->name('mosque.committee.roles.create');
            Route::post('/committee/roles', [Modules\Mosque\Http\Controllers\CommitteeRoleController::class, 'store'])->name('mosque.committee.roles.store');
            Route::get('/committee/roles/{id}/edit', [Modules\Mosque\Http\Controllers\CommitteeRoleController::class, 'edit'])->name('mosque.committee.roles.edit');
            Route::put('/committee/roles/{id}', [Modules\Mosque\Http\Controllers\CommitteeRoleController::class, 'update'])->name('mosque.committee.roles.update');
            Route::delete('/committee/roles/{id}', [Modules\Mosque\Http\Controllers\CommitteeRoleController::class, 'destroy'])->name('mosque.committee.roles.destroy');

            Route::get('/committee/minutes/data', [Modules\Mosque\Http\Controllers\CommitteeController::class, 'minutesData'])->name('mosque.committee.minutes.data');
            Route::get('/committee/minutes/create', [Modules\Mosque\Http\Controllers\CommitteeController::class, 'minutesCreate'])->name('mosque.committee.minutes.create');
            Route::post('/committee/minutes', [Modules\Mosque\Http\Controllers\CommitteeController::class, 'minutesStore'])->name('mosque.committee.minutes.store');
            Route::get('/committee/minutes/{id}/edit', [Modules\Mosque\Http\Controllers\CommitteeController::class, 'minutesEdit'])->name('mosque.committee.minutes.edit');
            Route::get('/committee/minutes/{id}/print', [Modules\Mosque\Http\Controllers\CommitteeController::class, 'minutesPrint'])->name('mosque.committee.minutes.print');
            Route::get('/committee/minutes/{id}/pdf', [Modules\Mosque\Http\Controllers\CommitteeController::class, 'minutesPdf'])->name('mosque.committee.minutes.pdf');
            Route::put('/committee/minutes/{id}', [Modules\Mosque\Http\Controllers\CommitteeController::class, 'minutesUpdate'])->name('mosque.committee.minutes.update');
            Route::delete('/committee/minutes/{id}', [Modules\Mosque\Http\Controllers\CommitteeController::class, 'minutesDestroy'])->name('mosque.committee.minutes.destroy');

            Route::get('/committee/reports/committees', [Modules\Mosque\Http\Controllers\CommitteeReportsController::class, 'committeesSummaryData'])->name('mosque.committee.reports.committees');
            Route::get('/committee/reports/roles', [Modules\Mosque\Http\Controllers\CommitteeReportsController::class, 'rolesSummaryData'])->name('mosque.committee.reports.roles');
            Route::get('/committee/reports/minutes', [Modules\Mosque\Http\Controllers\CommitteeReportsController::class, 'minutesArchiveData'])->name('mosque.committee.reports.minutes');
            Route::get('/staff', [Modules\Mosque\Http\Controllers\StaffController::class, 'index'])->name('mosque.staff');
            Route::get('/staff/data', [Modules\Mosque\Http\Controllers\StaffController::class, 'staffData'])->name('mosque.staff.data');
            Route::get('/staff/search', [Modules\Mosque\Http\Controllers\StaffController::class, 'staffSearch'])->name('mosque.staff.search');
            Route::get('/staff/create', [Modules\Mosque\Http\Controllers\StaffController::class, 'staffCreate'])->name('mosque.staff.create');
            Route::post('/staff', [Modules\Mosque\Http\Controllers\StaffController::class, 'staffStore'])->name('mosque.staff.store');
            Route::get('/staff/{id}/edit', [Modules\Mosque\Http\Controllers\StaffController::class, 'staffEdit'])->name('mosque.staff.edit');
            Route::put('/staff/{id}', [Modules\Mosque\Http\Controllers\StaffController::class, 'staffUpdate'])->name('mosque.staff.update');
            Route::delete('/staff/{id}', [Modules\Mosque\Http\Controllers\StaffController::class, 'staffDestroy'])->name('mosque.staff.destroy');

            // Staff Roles (Designation)
            Route::get('/staff/roles/data', [Modules\Mosque\Http\Controllers\StaffController::class, 'rolesData'])->name('mosque.staff.roles.data');
            Route::get('/staff/roles/create', [Modules\Mosque\Http\Controllers\StaffController::class, 'rolesCreate'])->name('mosque.staff.roles.create');
            Route::post('/staff/roles', [Modules\Mosque\Http\Controllers\StaffController::class, 'rolesStore'])->name('mosque.staff.roles.store');
            Route::get('/staff/roles/{id}/edit', [Modules\Mosque\Http\Controllers\StaffController::class, 'rolesEdit'])->name('mosque.staff.roles.edit');
            Route::put('/staff/roles/{id}', [Modules\Mosque\Http\Controllers\StaffController::class, 'rolesUpdate'])->name('mosque.staff.roles.update');
            Route::delete('/staff/roles/{id}', [Modules\Mosque\Http\Controllers\StaffController::class, 'rolesDestroy'])->name('mosque.staff.roles.destroy');

            Route::get('/staff/attendance/data', [Modules\Mosque\Http\Controllers\StaffController::class, 'attendanceData'])->name('mosque.staff.attendance.data');
            Route::get('/staff/attendance/create', [Modules\Mosque\Http\Controllers\StaffController::class, 'attendanceCreate'])->name('mosque.staff.attendance.create');
            Route::post('/staff/attendance', [Modules\Mosque\Http\Controllers\StaffController::class, 'attendanceStore'])->name('mosque.staff.attendance.store');
            Route::get('/staff/attendance/{id}/edit', [Modules\Mosque\Http\Controllers\StaffController::class, 'attendanceEdit'])->name('mosque.staff.attendance.edit');
            Route::put('/staff/attendance/{id}', [Modules\Mosque\Http\Controllers\StaffController::class, 'attendanceUpdate'])->name('mosque.staff.attendance.update');
            Route::delete('/staff/attendance/{id}', [Modules\Mosque\Http\Controllers\StaffController::class, 'attendanceDestroy'])->name('mosque.staff.attendance.destroy');

            // Staff Leaves
            Route::get('/staff/leaves/data', [Modules\Mosque\Http\Controllers\StaffController::class, 'leavesData'])->name('mosque.staff.leaves.data');
            Route::get('/staff/leaves/create', [Modules\Mosque\Http\Controllers\StaffController::class, 'leavesCreate'])->name('mosque.staff.leaves.create');
            Route::post('/staff/leaves', [Modules\Mosque\Http\Controllers\StaffController::class, 'leavesStore'])->name('mosque.staff.leaves.store');
            Route::get('/staff/leaves/{id}/edit', [Modules\Mosque\Http\Controllers\StaffController::class, 'leavesEdit'])->name('mosque.staff.leaves.edit');
            Route::put('/staff/leaves/{id}', [Modules\Mosque\Http\Controllers\StaffController::class, 'leavesUpdate'])->name('mosque.staff.leaves.update');
            Route::post('/staff/leaves/{id}/approve', [Modules\Mosque\Http\Controllers\StaffController::class, 'leavesApprove'])->name('mosque.staff.leaves.approve');
            Route::post('/staff/leaves/{id}/reject', [Modules\Mosque\Http\Controllers\StaffController::class, 'leavesReject'])->name('mosque.staff.leaves.reject');
            Route::delete('/staff/leaves/{id}', [Modules\Mosque\Http\Controllers\StaffController::class, 'leavesDestroy'])->name('mosque.staff.leaves.destroy');

            // Leave Types
            Route::get('/staff/leave-types/data', [Modules\Mosque\Http\Controllers\StaffController::class, 'leaveTypesData'])->name('mosque.staff.leave_types.data');
            Route::get('/staff/leave-types/create', [Modules\Mosque\Http\Controllers\StaffController::class, 'leaveTypesCreate'])->name('mosque.staff.leave_types.create');
            Route::post('/staff/leave-types', [Modules\Mosque\Http\Controllers\StaffController::class, 'leaveTypesStore'])->name('mosque.staff.leave_types.store');
            Route::get('/staff/leave-types/{id}/edit', [Modules\Mosque\Http\Controllers\StaffController::class, 'leaveTypesEdit'])->name('mosque.staff.leave_types.edit');
            Route::put('/staff/leave-types/{id}', [Modules\Mosque\Http\Controllers\StaffController::class, 'leaveTypesUpdate'])->name('mosque.staff.leave_types.update');
            Route::delete('/staff/leave-types/{id}', [Modules\Mosque\Http\Controllers\StaffController::class, 'leaveTypesDestroy'])->name('mosque.staff.leave_types.destroy');

            Route::get('/staff/advances/data', [Modules\Mosque\Http\Controllers\StaffController::class, 'advancesData'])->name('mosque.staff.advances.data');
            Route::get('/staff/advances/create', [Modules\Mosque\Http\Controllers\StaffController::class, 'advancesCreate'])->name('mosque.staff.advances.create');
            Route::post('/staff/advances', [Modules\Mosque\Http\Controllers\StaffController::class, 'advancesStore'])->name('mosque.staff.advances.store');
            Route::delete('/staff/advances/{id}', [Modules\Mosque\Http\Controllers\StaffController::class, 'advancesDestroy'])->name('mosque.staff.advances.destroy');

            Route::get('/staff/payslips/data', [Modules\Mosque\Http\Controllers\StaffController::class, 'payslipsData'])->name('mosque.staff.payslips.data');
            Route::get('/staff/payslips/create', [Modules\Mosque\Http\Controllers\StaffController::class, 'payslipsCreate'])->name('mosque.staff.payslips.create');
            Route::post('/staff/payslips', [Modules\Mosque\Http\Controllers\StaffController::class, 'payslipsStore'])->name('mosque.staff.payslips.store');
            Route::get('/staff/payslips/{id}/pay', [Modules\Mosque\Http\Controllers\StaffController::class, 'payslipsPay'])->name('mosque.staff.payslips.pay');
            Route::post('/staff/payslips/{id}/pay', [Modules\Mosque\Http\Controllers\StaffController::class, 'payslipsPayStore'])->name('mosque.staff.payslips.pay.store');
            Route::get('/staff/payslips/{id}/print', [Modules\Mosque\Http\Controllers\StaffController::class, 'payslipsPrint'])->name('mosque.staff.payslips.print');
            Route::get('/staff/payslips/{id}/pdf', [Modules\Mosque\Http\Controllers\StaffController::class, 'payslipsPdf'])->name('mosque.staff.payslips.pdf');
            Route::delete('/staff/payslips/{id}', [Modules\Mosque\Http\Controllers\StaffController::class, 'payslipsDestroy'])->name('mosque.staff.payslips.destroy');

            Route::get('/staff/reports/attendance', [Modules\Mosque\Http\Controllers\StaffReportsController::class, 'attendanceSummaryData'])->name('mosque.staff.reports.attendance');
            Route::get('/staff/reports/salary', [Modules\Mosque\Http\Controllers\StaffReportsController::class, 'salaryRegisterData'])->name('mosque.staff.reports.salary');
            Route::get('/marriage', [Modules\Mosque\Http\Controllers\MarriageController::class, 'index'])->name('mosque.marriage');
            Route::get('/marriage/data', [Modules\Mosque\Http\Controllers\MarriageController::class, 'data'])->name('mosque.marriage.data');
            Route::get('/marriage/reports', [Modules\Mosque\Http\Controllers\MarriageReportsController::class, 'index'])->name('mosque.marriage.reports');
            Route::get('/marriage/reports/yearly', [Modules\Mosque\Http\Controllers\MarriageReportsController::class, 'yearlyData'])->name('mosque.marriage.reports.yearly');
            Route::get('/marriage/create', [Modules\Mosque\Http\Controllers\MarriageController::class, 'create'])->name('mosque.marriage.create');
            Route::post('/marriage', [Modules\Mosque\Http\Controllers\MarriageController::class, 'store'])->name('mosque.marriage.store');
            Route::get('/marriage/{id}/edit', [Modules\Mosque\Http\Controllers\MarriageController::class, 'edit'])->name('mosque.marriage.edit');
            Route::put('/marriage/{id}', [Modules\Mosque\Http\Controllers\MarriageController::class, 'update'])->name('mosque.marriage.update');
            Route::delete('/marriage/{id}', [Modules\Mosque\Http\Controllers\MarriageController::class, 'destroy'])->name('mosque.marriage.destroy');
            Route::get('/marriage/{id}/print', [Modules\Mosque\Http\Controllers\MarriageController::class, 'print'])->name('mosque.marriage.print');
            Route::get('/marriage/{id}/pdf', [Modules\Mosque\Http\Controllers\MarriageController::class, 'pdf'])->name('mosque.marriage.pdf');

            Route::get('/death', [Modules\Mosque\Http\Controllers\DeathController::class, 'index'])->name('mosque.death');
            Route::get('/death/data', [Modules\Mosque\Http\Controllers\DeathController::class, 'data'])->name('mosque.death.data');
            Route::get('/death/reports', [Modules\Mosque\Http\Controllers\DeathReportsController::class, 'index'])->name('mosque.death.reports');
            Route::get('/death/reports/yearly', [Modules\Mosque\Http\Controllers\DeathReportsController::class, 'yearlyData'])->name('mosque.death.reports.yearly');
            Route::get('/death/create', [Modules\Mosque\Http\Controllers\DeathController::class, 'create'])->name('mosque.death.create');
            Route::post('/death', [Modules\Mosque\Http\Controllers\DeathController::class, 'store'])->name('mosque.death.store');
            Route::get('/death/{id}/edit', [Modules\Mosque\Http\Controllers\DeathController::class, 'edit'])->name('mosque.death.edit');
            Route::put('/death/{id}', [Modules\Mosque\Http\Controllers\DeathController::class, 'update'])->name('mosque.death.update');
            Route::delete('/death/{id}', [Modules\Mosque\Http\Controllers\DeathController::class, 'destroy'])->name('mosque.death.destroy');
            Route::get('/death/{id}/print', [Modules\Mosque\Http\Controllers\DeathController::class, 'print'])->name('mosque.death.print');
            Route::get('/death/{id}/pdf', [Modules\Mosque\Http\Controllers\DeathController::class, 'pdf'])->name('mosque.death.pdf');
            Route::get('/assets', [Modules\Mosque\Http\Controllers\AssetsController::class, 'index'])->name('mosque.assets');
            Route::get('/assets/assets/data', [Modules\Mosque\Http\Controllers\AssetsController::class, 'assetsData'])->name('mosque.assets.assets.data');
            Route::get('/assets/assets/create', [Modules\Mosque\Http\Controllers\AssetsController::class, 'assetsCreate'])->name('mosque.assets.assets.create');
            Route::post('/assets/assets', [Modules\Mosque\Http\Controllers\AssetsController::class, 'assetsStore'])->name('mosque.assets.assets.store');
            Route::get('/assets/assets/{id}/edit', [Modules\Mosque\Http\Controllers\AssetsController::class, 'assetsEdit'])->name('mosque.assets.assets.edit');
            Route::put('/assets/assets/{id}', [Modules\Mosque\Http\Controllers\AssetsController::class, 'assetsUpdate'])->name('mosque.assets.assets.update');
            Route::delete('/assets/assets/{id}', [Modules\Mosque\Http\Controllers\AssetsController::class, 'assetsDestroy'])->name('mosque.assets.assets.destroy');

            Route::get('/assets/maintenance/data', [Modules\Mosque\Http\Controllers\AssetsController::class, 'maintenanceData'])->name('mosque.assets.maintenance.data');
            Route::get('/assets/maintenance/create', [Modules\Mosque\Http\Controllers\AssetsController::class, 'maintenanceCreate'])->name('mosque.assets.maintenance.create');
            Route::post('/assets/maintenance', [Modules\Mosque\Http\Controllers\AssetsController::class, 'maintenanceStore'])->name('mosque.assets.maintenance.store');
            Route::delete('/assets/maintenance/{id}', [Modules\Mosque\Http\Controllers\AssetsController::class, 'maintenanceDestroy'])->name('mosque.assets.maintenance.destroy');

            Route::get('/assets/properties/data', [Modules\Mosque\Http\Controllers\AssetsController::class, 'propertiesData'])->name('mosque.assets.properties.data');
            Route::get('/assets/properties/create', [Modules\Mosque\Http\Controllers\AssetsController::class, 'propertiesCreate'])->name('mosque.assets.properties.create');
            Route::post('/assets/properties', [Modules\Mosque\Http\Controllers\AssetsController::class, 'propertiesStore'])->name('mosque.assets.properties.store');
            Route::get('/assets/properties/{id}/edit', [Modules\Mosque\Http\Controllers\AssetsController::class, 'propertiesEdit'])->name('mosque.assets.properties.edit');
            Route::put('/assets/properties/{id}', [Modules\Mosque\Http\Controllers\AssetsController::class, 'propertiesUpdate'])->name('mosque.assets.properties.update');
            Route::delete('/assets/properties/{id}', [Modules\Mosque\Http\Controllers\AssetsController::class, 'propertiesDestroy'])->name('mosque.assets.properties.destroy');

            Route::get('/assets/rentals/data', [Modules\Mosque\Http\Controllers\AssetsController::class, 'rentalsData'])->name('mosque.assets.rentals.data');
            Route::get('/assets/rentals/create', [Modules\Mosque\Http\Controllers\AssetsController::class, 'rentalsCreate'])->name('mosque.assets.rentals.create');
            Route::post('/assets/rentals', [Modules\Mosque\Http\Controllers\AssetsController::class, 'rentalsStore'])->name('mosque.assets.rentals.store');
            Route::get('/assets/rentals/{id}/edit', [Modules\Mosque\Http\Controllers\AssetsController::class, 'rentalsEdit'])->name('mosque.assets.rentals.edit');
            Route::get('/assets/rentals/{id}/print', [Modules\Mosque\Http\Controllers\AssetsController::class, 'rentalsPrint'])->name('mosque.assets.rentals.print');
            Route::get('/assets/rentals/{id}/pdf', [Modules\Mosque\Http\Controllers\AssetsController::class, 'rentalsPdf'])->name('mosque.assets.rentals.pdf');
            Route::put('/assets/rentals/{id}', [Modules\Mosque\Http\Controllers\AssetsController::class, 'rentalsUpdate'])->name('mosque.assets.rentals.update');
            Route::delete('/assets/rentals/{id}', [Modules\Mosque\Http\Controllers\AssetsController::class, 'rentalsDestroy'])->name('mosque.assets.rentals.destroy');

            Route::get('/assets/reports/status', [Modules\Mosque\Http\Controllers\AssetsReportsController::class, 'assetsStatusData'])->name('mosque.assets.reports.status');
            Route::get('/assets/reports/maintenance', [Modules\Mosque\Http\Controllers\AssetsReportsController::class, 'maintenanceSummaryData'])->name('mosque.assets.reports.maintenance');
            Route::get('/assets/reports/rentals', [Modules\Mosque\Http\Controllers\AssetsReportsController::class, 'rentalsIncomeData'])->name('mosque.assets.reports.rentals');

                // Tenancy management (Seat/Cabin/Bed)
            Route::middleware([\Modules\Mosque\Http\Middleware\TenancyAutoBill::class])
                ->prefix('tenancy')
                ->group(function () {
                    Route::get('/', [Modules\Mosque\Http\Controllers\TenancyDashboardController::class, 'index'])->name('mosque.tenancy.dashboard');
                    Route::get('/reports', [Modules\Mosque\Http\Controllers\TenancyReportsController::class, 'index'])->name('mosque.tenancy.reports');
                    Route::get('/reports/occupancy', [Modules\Mosque\Http\Controllers\TenancyReportsController::class, 'occupancyData'])->name('mosque.tenancy.reports.occupancy');
                    Route::get('/reports/leaving-soon', [Modules\Mosque\Http\Controllers\TenancyReportsController::class, 'leavingSoonData'])->name('mosque.tenancy.reports.leaving_soon');
                    Route::get('/reports/billing-summary', [Modules\Mosque\Http\Controllers\TenancyReportsController::class, 'billingSummaryData'])->name('mosque.tenancy.reports.billing_summary');
                    Route::get('/seat-board', [Modules\Mosque\Http\Controllers\TenancySeatBoardController::class, 'index'])->name('mosque.tenancy.seat_board');
                    Route::get('/seat-board/floors', [Modules\Mosque\Http\Controllers\TenancySeatBoardController::class, 'floors'])->name('mosque.tenancy.seat_board.floors');
                    Route::get('/seat-board/floor', [Modules\Mosque\Http\Controllers\TenancySeatBoardController::class, 'floorData'])->name('mosque.tenancy.seat_board.floor');
                    Route::post('/seats/{id}/status', [Modules\Mosque\Http\Controllers\TenancySeatBoardController::class, 'seatStatus'])->name('mosque.tenancy.seats.status');

                    // Tenants
                    Route::get('/tenants', [Modules\Mosque\Http\Controllers\TenancyTenantsController::class, 'index'])->name('mosque.tenancy.tenants');
                    Route::get('/tenants/data', [Modules\Mosque\Http\Controllers\TenancyTenantsController::class, 'data'])->name('mosque.tenancy.tenants.data');
                    Route::get('/tenants/create', [Modules\Mosque\Http\Controllers\TenancyTenantsController::class, 'create'])->name('mosque.tenancy.tenants.create');
                    Route::post('/tenants', [Modules\Mosque\Http\Controllers\TenancyTenantsController::class, 'store'])->name('mosque.tenancy.tenants.store');
                    Route::get('/tenants/{id}/edit', [Modules\Mosque\Http\Controllers\TenancyTenantsController::class, 'edit'])->name('mosque.tenancy.tenants.edit');
                    Route::put('/tenants/{id}', [Modules\Mosque\Http\Controllers\TenancyTenantsController::class, 'update'])->name('mosque.tenancy.tenants.update');
                    Route::delete('/tenants/{id}', [Modules\Mosque\Http\Controllers\TenancyTenantsController::class, 'destroy'])->name('mosque.tenancy.tenants.destroy');
                    Route::get('/tenants/{id}/file', [Modules\Mosque\Http\Controllers\TenancyTenantsController::class, 'file'])->name('mosque.tenancy.tenants.file');

                    // Allocations
                    Route::post('/allocations', [Modules\Mosque\Http\Controllers\TenancyAllocationsController::class, 'store'])->name('mosque.tenancy.allocations.store');
                    Route::post('/allocations/{id}/move', [Modules\Mosque\Http\Controllers\TenancyAllocationsController::class, 'move'])->name('mosque.tenancy.allocations.move');
                    Route::post('/allocations/{id}/end', [Modules\Mosque\Http\Controllers\TenancyAllocationsController::class, 'end'])->name('mosque.tenancy.allocations.end');
                    Route::post('/seats/{id}/leaving', [Modules\Mosque\Http\Controllers\TenancyAllocationsController::class, 'markLeaving'])->name('mosque.tenancy.seats.leaving');

                    // Billing
                    Route::get('/billing', [Modules\Mosque\Http\Controllers\TenancyBillingController::class, 'index'])->name('mosque.tenancy.billing');
                    Route::get('/billing/data', [Modules\Mosque\Http\Controllers\TenancyBillingController::class, 'data'])->name('mosque.tenancy.billing.data');
                    Route::post('/billing/generate', [Modules\Mosque\Http\Controllers\TenancyBillingController::class, 'generate'])->name('mosque.tenancy.billing.generate');
                    Route::get('/billing/{id}/receipt/print', [Modules\Mosque\Http\Controllers\TenancyBillingController::class, 'receiptPrint'])->name('mosque.tenancy.billing.receipt.print');
                    Route::get('/billing/{id}/receipt/pdf', [Modules\Mosque\Http\Controllers\TenancyBillingController::class, 'receiptPdf'])->name('mosque.tenancy.billing.receipt.pdf');
                    Route::post('/billing/{id}/invoice', [Modules\Mosque\Http\Controllers\TenancyBillingController::class, 'createInvoice'])->name('mosque.tenancy.billing.invoice');

                    // Requests (QR)
                    Route::get('/requests', [Modules\Mosque\Http\Controllers\TenancyRequestsController::class, 'index'])->name('mosque.tenancy.requests');
                    Route::post('/requests/regenerate', [Modules\Mosque\Http\Controllers\TenancyRequestsController::class, 'regenerateLink'])->name('mosque.tenancy.requests.regenerate');
                    Route::get('/requests/data', [Modules\Mosque\Http\Controllers\TenancyRequestsController::class, 'data'])->name('mosque.tenancy.requests.data');
                    Route::post('/requests/{id}/approve', [Modules\Mosque\Http\Controllers\TenancyRequestsController::class, 'approve'])->name('mosque.tenancy.requests.approve');
                    Route::post('/requests/{id}/decline', [Modules\Mosque\Http\Controllers\TenancyRequestsController::class, 'decline'])->name('mosque.tenancy.requests.decline');
                    
                    // QR Image routes
                    Route::get('/requests/qr/image', [Modules\Mosque\Http\Controllers\TenancyRequestsController::class, 'qrImage'])->name('mosque.tenancy.requests.qr.image');
                    Route::get('/requests/qr/download', [Modules\Mosque\Http\Controllers\TenancyRequestsController::class, 'qrDownload'])->name('mosque.tenancy.requests.qr.download');

                    // Case registry
                    Route::get('/cases', [Modules\Mosque\Http\Controllers\TenancyCasesController::class, 'index'])->name('mosque.tenancy.cases');
                    Route::get('/cases/data', [Modules\Mosque\Http\Controllers\TenancyCasesController::class, 'data'])->name('mosque.tenancy.cases.data');
                    Route::get('/cases/create', [Modules\Mosque\Http\Controllers\TenancyCasesController::class, 'create'])->name('mosque.tenancy.cases.create');
                    Route::post('/cases', [Modules\Mosque\Http\Controllers\TenancyCasesController::class, 'store'])->name('mosque.tenancy.cases.store');
                    Route::get('/cases/{id}/edit', [Modules\Mosque\Http\Controllers\TenancyCasesController::class, 'edit'])->name('mosque.tenancy.cases.edit');
                    Route::put('/cases/{id}', [Modules\Mosque\Http\Controllers\TenancyCasesController::class, 'update'])->name('mosque.tenancy.cases.update');
                    Route::delete('/cases/{id}', [Modules\Mosque\Http\Controllers\TenancyCasesController::class, 'destroy'])->name('mosque.tenancy.cases.destroy');

                    // Settings
                    Route::get('/settings', [Modules\Mosque\Http\Controllers\TenancySettingsController::class, 'index'])->name('mosque.tenancy.settings');
                    Route::post('/settings', [Modules\Mosque\Http\Controllers\TenancySettingsController::class, 'update'])->name('mosque.tenancy.settings.update');

                    // Structure management (Buildings/Floors/Rooms/Seats) - used by Tenancy Settings
                    Route::get('/structure/meta/buildings', [Modules\Mosque\Http\Controllers\TenancyStructureController::class, 'buildingsList'])->name('mosque.tenancy.structure.meta.buildings');
                    Route::get('/structure/meta/floors', [Modules\Mosque\Http\Controllers\TenancyStructureController::class, 'floorsList'])->name('mosque.tenancy.structure.meta.floors');
                    Route::get('/structure/meta/rooms', [Modules\Mosque\Http\Controllers\TenancyStructureController::class, 'roomsList'])->name('mosque.tenancy.structure.meta.rooms');

                    Route::get('/structure/buildings/data', [Modules\Mosque\Http\Controllers\TenancyStructureController::class, 'buildingsData'])->name('mosque.tenancy.structure.buildings.data');
                    Route::get('/structure/buildings/{id}', [Modules\Mosque\Http\Controllers\TenancyStructureController::class, 'buildingsShow'])->name('mosque.tenancy.structure.buildings.show');
                    Route::post('/structure/buildings', [Modules\Mosque\Http\Controllers\TenancyStructureController::class, 'buildingsStore'])->name('mosque.tenancy.structure.buildings.store');
                    Route::put('/structure/buildings/{id}', [Modules\Mosque\Http\Controllers\TenancyStructureController::class, 'buildingsUpdate'])->name('mosque.tenancy.structure.buildings.update');
                    Route::delete('/structure/buildings/{id}', [Modules\Mosque\Http\Controllers\TenancyStructureController::class, 'buildingsDestroy'])->name('mosque.tenancy.structure.buildings.destroy');

                    Route::get('/structure/floors/data', [Modules\Mosque\Http\Controllers\TenancyStructureController::class, 'floorsData'])->name('mosque.tenancy.structure.floors.data');
                    Route::get('/structure/floors/{id}', [Modules\Mosque\Http\Controllers\TenancyStructureController::class, 'floorsShow'])->name('mosque.tenancy.structure.floors.show');
                    Route::post('/structure/floors', [Modules\Mosque\Http\Controllers\TenancyStructureController::class, 'floorsStore'])->name('mosque.tenancy.structure.floors.store');
                    Route::put('/structure/floors/{id}', [Modules\Mosque\Http\Controllers\TenancyStructureController::class, 'floorsUpdate'])->name('mosque.tenancy.structure.floors.update');
                    Route::delete('/structure/floors/{id}', [Modules\Mosque\Http\Controllers\TenancyStructureController::class, 'floorsDestroy'])->name('mosque.tenancy.structure.floors.destroy');

                    Route::get('/structure/rooms/data', [Modules\Mosque\Http\Controllers\TenancyStructureController::class, 'roomsData'])->name('mosque.tenancy.structure.rooms.data');
                    Route::get('/structure/rooms/{id}', [Modules\Mosque\Http\Controllers\TenancyStructureController::class, 'roomsShow'])->name('mosque.tenancy.structure.rooms.show');
                    Route::post('/structure/rooms', [Modules\Mosque\Http\Controllers\TenancyStructureController::class, 'roomsStore'])->name('mosque.tenancy.structure.rooms.store');
                    Route::put('/structure/rooms/{id}', [Modules\Mosque\Http\Controllers\TenancyStructureController::class, 'roomsUpdate'])->name('mosque.tenancy.structure.rooms.update');
                    Route::delete('/structure/rooms/{id}', [Modules\Mosque\Http\Controllers\TenancyStructureController::class, 'roomsDestroy'])->name('mosque.tenancy.structure.rooms.destroy');

                    Route::get('/structure/seats/data', [Modules\Mosque\Http\Controllers\TenancyStructureController::class, 'seatsData'])->name('mosque.tenancy.structure.seats.data');
                    Route::get('/structure/seats/{id}', [Modules\Mosque\Http\Controllers\TenancyStructureController::class, 'seatsShow'])->name('mosque.tenancy.structure.seats.show');
                    Route::post('/structure/seats', [Modules\Mosque\Http\Controllers\TenancyStructureController::class, 'seatsStore'])->name('mosque.tenancy.structure.seats.store');
                    Route::put('/structure/seats/{id}', [Modules\Mosque\Http\Controllers\TenancyStructureController::class, 'seatsUpdate'])->name('mosque.tenancy.structure.seats.update');
                    Route::delete('/structure/seats/{id}', [Modules\Mosque\Http\Controllers\TenancyStructureController::class, 'seatsDestroy'])->name('mosque.tenancy.structure.seats.destroy');
                });

            Route::get('/events', [Modules\Mosque\Http\Controllers\EventsController::class, 'index'])->name('mosque.events');
            Route::get('/events/{id}/summary/print', [Modules\Mosque\Http\Controllers\EventsController::class, 'summaryPrint'])->name('mosque.events.summary.print');
            Route::get('/events/{id}/summary/pdf', [Modules\Mosque\Http\Controllers\EventsController::class, 'summaryPdf'])->name('mosque.events.summary.pdf');
            Route::get('/events/events/data', [Modules\Mosque\Http\Controllers\EventsController::class, 'eventsData'])->name('mosque.events.events.data');
            Route::get('/events/events/create', [Modules\Mosque\Http\Controllers\EventsController::class, 'eventsCreate'])->name('mosque.events.events.create');
            Route::post('/events/events', [Modules\Mosque\Http\Controllers\EventsController::class, 'eventsStore'])->name('mosque.events.events.store');
            Route::get('/events/events/{id}/edit', [Modules\Mosque\Http\Controllers\EventsController::class, 'eventsEdit'])->name('mosque.events.events.edit');
            Route::put('/events/events/{id}', [Modules\Mosque\Http\Controllers\EventsController::class, 'eventsUpdate'])->name('mosque.events.events.update');
            Route::delete('/events/events/{id}', [Modules\Mosque\Http\Controllers\EventsController::class, 'eventsDestroy'])->name('mosque.events.events.destroy');

            Route::get('/events/entries/data', [Modules\Mosque\Http\Controllers\EventsController::class, 'entriesData'])->name('mosque.events.entries.data');
            Route::get('/events/entries/create', [Modules\Mosque\Http\Controllers\EventsController::class, 'entriesCreate'])->name('mosque.events.entries.create');
            Route::post('/events/entries', [Modules\Mosque\Http\Controllers\EventsController::class, 'entriesStore'])->name('mosque.events.entries.store');
            Route::get('/events/entries/{id}/edit', [Modules\Mosque\Http\Controllers\EventsController::class, 'entriesEdit'])->name('mosque.events.entries.edit');
            Route::put('/events/entries/{id}', [Modules\Mosque\Http\Controllers\EventsController::class, 'entriesUpdate'])->name('mosque.events.entries.update');
            Route::delete('/events/entries/{id}', [Modules\Mosque\Http\Controllers\EventsController::class, 'entriesDestroy'])->name('mosque.events.entries.destroy');

            Route::get('/events/reports/events', [Modules\Mosque\Http\Controllers\EventsReportsController::class, 'eventsSummaryData'])->name('mosque.events.reports.events');
            Route::get('/events/reports/monthly', [Modules\Mosque\Http\Controllers\EventsReportsController::class, 'monthlyProfitLossData'])->name('mosque.events.reports.monthly');
            Route::get('/reports', [Modules\Mosque\Http\Controllers\ReportsController::class, 'index'])->name('mosque.reports');

            Route::get('/audit', [Modules\Mosque\Http\Controllers\AuditController::class, 'index'])->name('mosque.audit');
            Route::get('/audit/data', [Modules\Mosque\Http\Controllers\AuditController::class, 'data'])->name('mosque.audit.data');

            Route::get('/automation/reminders', [Modules\Mosque\Http\Controllers\AutomationController::class, 'remindersIndex'])->name('mosque.automation.reminders');
            Route::post('/automation/reminders/membership', [Modules\Mosque\Http\Controllers\AutomationController::class, 'sendMembershipDue'])->name('mosque.automation.reminders.membership.send');
            Route::post('/automation/reminders/donations', [Modules\Mosque\Http\Controllers\AutomationController::class, 'sendDonationReminder'])->name('mosque.automation.reminders.donations.send');

            Route::get('/settings', [Modules\Mosque\Http\Controllers\SettingsController::class, 'index'])->name('mosque.settings');
            Route::post('/settings', [Modules\Mosque\Http\Controllers\SettingsController::class, 'update'])->name('mosque.settings.update');
            Route::post('/settings/profile', [Modules\Mosque\Http\Controllers\SettingsController::class, 'updateProfile'])->name('mosque.settings.profile.update');
            Route::post('/settings/deactivate', [Modules\Mosque\Http\Controllers\SettingsController::class, 'deactivate'])->name('mosque.settings.deactivate');
        });
    });
