<?php

namespace Modules\Mosque\Services;

use Modules\Mosque\Entities\MosqueFinanceCategory;
use Modules\Mosque\Entities\MosqueFinanceEntry;

class FinancePostingService
{
    public static function postCashFulfillment(int $businessId, int $fulfillmentId, float $amount, string $type, string $date, ?int $locationId = null, ?int $createdBy = null, ?string $pledgeCode = null): void
    {
        $categoryName = ($type === 'event') ? 'Event income' : 'Donations';
        $category = MosqueFinanceCategory::query()->firstOrCreate(
            ['business_id' => $businessId, 'type' => 'income', 'name' => $categoryName],
            ['active' => true, 'sort_order' => 1]
        );

        $fundTag = $type !== '' ? $type : null;

        MosqueFinanceEntry::query()->create([
            'business_id' => $businessId,
            'location_id' => $locationId,
            'type' => 'income',
            'category_id' => $category->id,
            'amount' => $amount,
            'entry_date' => $date,
            'ref_module' => 'pledge',
            'ref_id' => $fulfillmentId,
            'fund_tag' => $fundTag,
            'note' => $pledgeCode ? ('Pledge '.$pledgeCode) : 'Pledge fulfillment',
            'created_by' => $createdBy,
        ]);
    }
}
