<?php

namespace Modules\Mosque\Services;

use Illuminate\Support\Facades\DB;

class PledgeNumberService
{
    public static function nextCode(int $businessId): string
    {
        $prefix = 'PLG-';

        return DB::transaction(function () use ($businessId, $prefix) {
            $last = DB::table('mosq_pledges')
                ->where('business_id', $businessId)
                ->max('id');

            $next = ((int) $last) + 1;

            return $prefix . str_pad((string) $next, 6, '0', STR_PAD_LEFT);
        });
    }
}

