<?php

namespace Modules\Mosque\Services;

use App\Business;
use App\Utils\Util;
use Illuminate\Support\Facades\Mail;

class ReminderService
{
    public static function send(int $businessId, array $pledge, array $settings): array
    {
        $business = Business::findOrFail($businessId);
        $util = new Util();

        $tokens = [
            '{{business_name}}' => (string) ($business->name ?? ''),
            '{{donor_name}}' => (string) ($pledge['donor_name'] ?? ''),
            '{{pledge_code}}' => (string) ($pledge['pledge_code'] ?? ''),
            '{{type}}' => strtoupper((string) ($pledge['type'] ?? '')),
            '{{due_date}}' => (string) ($pledge['due_date'] ?? ''),
            '{{balance}}' => (string) ($pledge['balance'] ?? ''),
            '{{pay_link}}' => (string) ($pledge['pay_link'] ?? ''),
        ];

        $whatsappText = strtr((string) ($settings['template_pledge_reminder_whatsapp'] ?? ''), $tokens);
        $smsText = strtr((string) ($settings['template_pledge_reminder_sms'] ?? ''), $tokens);
        $emailSubject = strtr((string) ($settings['template_pledge_reminder_email_subject'] ?? ''), $tokens);
        $emailBody = strtr((string) ($settings['template_pledge_reminder_email'] ?? ''), $tokens);

        $whatsappLink = '';
        if (! empty($pledge['donor_phone']) && $whatsappText !== '') {
            $data = [
                'business_id' => $businessId,
                'sms_settings' => $business->sms_settings,
                'email_settings' => $business->email_settings,
                'mobile_number' => $pledge['donor_phone'],
                'whatsapp_text' => $whatsappText,
            ];
            $whatsappLink = $util->getWhatsappNotificationAPI($data);
        }

        $smsSent = false;
        if (! empty($pledge['donor_phone']) && $smsText !== '') {
            try {
                $util->sendSms([
                    'sms_settings' => $business->sms_settings,
                    'mobile_number' => $pledge['donor_phone'],
                    'sms_body' => $smsText,
                ]);
                $smsSent = true;
            } catch (\Exception $e) {
                \Log::emergency('File:'.$e->getFile().'Line:'.$e->getLine().'Message:'.$e->getMessage());
            }
        }

        $emailSent = false;
        if (! empty($pledge['donor_email']) && $emailBody !== '') {
            try {
                Mail::raw($emailBody, function ($message) use ($pledge, $emailSubject) {
                    $message->to($pledge['donor_email'])
                        ->subject($emailSubject ?: 'Pledge Reminder');
                });
                $emailSent = true;
            } catch (\Exception $e) {
                \Log::emergency('File:'.$e->getFile().'Line:'.$e->getLine().'Message:'.$e->getMessage());
            }
        }

        return [
            'whatsapp_link' => $whatsappLink,
            'sms_sent' => $smsSent,
            'email_sent' => $emailSent,
        ];
    }
}

