<?php

namespace Modules\Mosque\Utils;

use Illuminate\Support\Facades\Schema;
use Modules\Mosque\Entities\MosqueAuditLog;

class MosqueAuditUtil
{
    public static function log(int $businessId, string $action, string $entity, ?int $entityId = null, $diff = null): void
    {
        try {
            if ($businessId <= 0 || ! Schema::hasTable('mosque_audit_logs')) {
                return;
            }

            MosqueAuditLog::query()->create([
                'business_id' => $businessId,
                'actor_id' => auth()->check() ? auth()->id() : null,
                'action' => $action,
                'entity' => $entity,
                'entity_id' => $entityId,
                'diff' => $diff,
                'ip' => request()->ip(),
                'ua' => (string) request()->userAgent(),
                'created_at' => now(),
            ]);
        } catch (\Exception $e) {
            // Non-blocking audit logging.
        }
    }
}

