<?php

namespace Modules\Mosque\Utils;

use Illuminate\Database\Query\Builder;
use Illuminate\Support\Facades\Schema;

class MosqueQueryUtil
{
    /**
     * Applies `WHERE <alias>.deleted_at IS NULL` if the table has soft deletes.
     *
     * @param  Builder  $query
     */
    public static function whereNotDeleted(Builder $query, string $table, ?string $alias = null): Builder
    {
        if (! Schema::hasTable($table) || ! Schema::hasColumn($table, 'deleted_at')) {
            return $query;
        }

        $prefix = $alias ?: $table;

        return $query->whereNull($prefix.'.deleted_at');
    }
}

