<?php

namespace Modules\Mosque\Utils;

final class QrPngUtil
{
    /**
     * Normalize different barcode lib outputs into raw PNG binary.
     * Some environments return base64, others return raw PNG bytes, or a data-uri.
     */
    public static function barcodeOutputToPng(string $output): string
    {
        $output = (string) $output;
        if ($output === '') {
            return '';
        }

        // Raw PNG bytes
        if (str_starts_with($output, "\x89PNG")) {
            return $output;
        }

        $trimmed = trim($output);
        if (str_starts_with($trimmed, 'data:image')) {
            $commaPos = strpos($trimmed, ',');
            if ($commaPos !== false) {
                $trimmed = substr($trimmed, $commaPos + 1);
            }
        }

        $decoded = base64_decode($trimmed, false);
        if (is_string($decoded) && str_starts_with($decoded, "\x89PNG")) {
            return $decoded;
        }

        return '';
    }
}

