<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateSupportTicketsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('support_tickets', function (Blueprint $table) {
            $table->id();
            $table->string('ticket_number')->unique();
            $table->unsignedInteger('business_id');
            $table->unsignedInteger('created_by'); // User who created the ticket
            $table->string('subject');
            $table->text('description');
            $table->enum('priority', ['low', 'medium', 'high', 'urgent'])->default('medium');
            $table->enum('category', [
                'billing', 
                'technical_support', 
                'feature_request', 
                'bug_report', 
                'account_issue',
                'payment_issue',
                'general_inquiry',
                'other'
            ])->default('general_inquiry');
            $table->enum('status', [
                'open', 
                'in_progress', 
                'waiting_customer', 
                'waiting_admin',
                'resolved', 
                'closed'
            ])->default('open');
            $table->string('external_reference')->nullable(); // POS-ORDER-123, SUBSCRIPTION-456, etc.
            $table->string('whatsapp_ticket_number')->nullable(); // Ticket number from NearBuyMarts API
            $table->unsignedInteger('assigned_to')->nullable(); // Superadmin user assigned to ticket
            $table->timestamp('last_response_at')->nullable();
            $table->timestamp('resolved_at')->nullable();
            $table->unsignedInteger('resolved_by')->nullable();
            $table->text('resolution_note')->nullable();
            $table->timestamps();
            $table->softDeletes();

            // Indexes
            $table->foreign('business_id')->references('id')->on('business')->onDelete('cascade');
            $table->foreign('created_by')->references('id')->on('users')->onDelete('cascade');
            $table->index('status');
            $table->index('priority');
            $table->index('category');
            $table->index('created_at');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('support_tickets');
    }
}
