<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class AddProofOfPaymentToSubscriptionsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('subscriptions', function (Blueprint $table) {
            $table->string('proof_of_payment')->nullable()->after('paid_via');
            $table->text('payment_details')->nullable()->after('proof_of_payment');
            $table->timestamp('proof_submitted_at')->nullable()->after('payment_details');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('subscriptions', function (Blueprint $table) {
            $table->dropColumn(['proof_of_payment', 'payment_details', 'proof_submitted_at']);
        });
    }
}
