<?php

namespace Modules\Superadmin\Entities;

use App\User;
use Illuminate\Database\Eloquent\Model;

class SupportTicketMessage extends Model
{
    protected $fillable = [
        'ticket_id',
        'user_id',
        'message',
        'is_internal_note',
        'is_system_message',
        'sender_type',
        'read_at',
    ];

    protected $casts = [
        'is_internal_note' => 'boolean',
        'is_system_message' => 'boolean',
        'read_at' => 'datetime',
        'created_at' => 'datetime',
        'updated_at' => 'datetime',
    ];

    /**
     * Get the ticket that owns the message
     */
    public function ticket()
    {
        return $this->belongsTo(SupportTicket::class, 'ticket_id');
    }

    /**
     * Get the user who sent the message
     */
    public function user()
    {
        return $this->belongsTo(User::class, 'user_id');
    }

    /**
     * Get attachments for this message
     */
    public function attachments()
    {
        return $this->hasMany(SupportTicketAttachment::class, 'message_id');
    }

    /**
     * Mark message as read
     */
    public function markAsRead()
    {
        if (!$this->read_at) {
            $this->update(['read_at' => now()]);
        }
    }

    /**
     * Check if message is unread
     */
    public function isUnread()
    {
        return $this->read_at === null;
    }
}
