<?php

namespace Modules\Superadmin\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use App\Business;

class EnsureBusinessIsVerified
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure  $next
     * @return mixed
     */
    public function handle(Request $request, Closure $next)
    {
        $user = $request->user();

        // Skip for superadmin
        if ($user && $user->can('superadmin')) {
            return $next($request);
        }

        // Skip if user has no business (shouldn't happen)
        if (!$user || !$user->business_id) {
            return $next($request);
        }

        // Get business
        $business = Business::find($user->business_id);

        if (!$business) {
            return $next($request);
        }

        // Check if business is verified
        if (!$business->is_verified) {
            // Allow access to verification routes
            $allowedRoutes = [
                'superadmin.business.verification',
                'superadmin.business.verify-email',
                'superadmin.business.resend-email',
                'superadmin.business.send-whatsapp-code',
                'superadmin.business.verify-whatsapp-code',
                'superadmin.business.update-email',
                'superadmin.business.update-whatsapp',
                'logout',
                'my-profile',
                'user.update-profile',
            ];

            if (!$request->routeIs($allowedRoutes)) {
                // Redirect to verification page
                return redirect()
                    ->route('superadmin.business.verification')
                    ->with('warning', __('superadmin::lang.please_verify_account'));
            }
        }

        return $next($request);
    }
}
