<?php

namespace Modules\Superadmin\Notifications;

use Illuminate\Bus\Queueable;
use Illuminate\Notifications\Messages\MailMessage;
use Illuminate\Notifications\Notification;

class BusinessEmailVerificationNotification extends Notification
{
    use Queueable;

    protected $business;
    protected $verification_url;

    /**
     * Create a new notification instance.
     *
     * @return void
     */
    public function __construct($business, $verification_url)
    {
        $this->business = $business;
        $this->verification_url = $verification_url;
    }

    /**
     * Get the notification's delivery channels.
     *
     * @param  mixed  $notifiable
     * @return array
     */
    public function via($notifiable)
    {
        return ['mail'];
    }

    /**
     * Get the mail representation of the notification.
     *
     * @param  mixed  $notifiable
     * @return \Illuminate\Notifications\Messages\MailMessage
     */
    public function toMail($notifiable)
    {
        $business_name = $this->business->name;
        $app_name = config('app.name', 'POS System');

        return (new MailMessage)
            ->subject('🔐 Verify Your Email Address - ' . $business_name)
            ->greeting('Hello ' . $notifiable->user_full_name . '! 👋')
            ->line('Thank you for registering **' . $business_name . '** with ' . $app_name . '.')
            ->line('To activate your business account and start using our platform, please verify your email address by clicking the button below:')
            ->action('✅ Verify Email Address', $this->verification_url)
            ->line('This verification link will expire in **24 hours**.')
            ->line('**Important:** You will also need to verify your WhatsApp number to complete the account setup and gain full access.')
            ->line('If you did not create this account, please ignore this email.')
            ->salutation('Best regards,  
' . $app_name . ' Team');
    }

    /**
     * Get the array representation of the notification.
     *
     * @param  mixed  $notifiable
     * @return array
     */
    public function toArray($notifiable)
    {
        return [
            'business_id' => $this->business->id,
            'business_name' => $this->business->name,
            'verification_url' => $this->verification_url,
        ];
    }
}
