<?php

namespace Modules\Superadmin\Notifications;

use Illuminate\Bus\Queueable;
use Illuminate\Notifications\Messages\MailMessage;
use Illuminate\Notifications\Notification;
use Modules\Superadmin\Notifications\Channels\WhatsAppChannel;

class NewBusinessNotification extends Notification
{
    use Queueable;

    protected $business;

    /**
     * Create a new notification instance.
     *
     * @return void
     */
    public function __construct($business)
    {
        $this->business = $business;
    }

    /**
     * Get the notification's delivery channels.
     *
     * @param  mixed  $notifiable
     * @return array
     */
    public function via($notifiable)
    {
        $channels = ['mail'];
        
        if (config('services.whatsapp.enabled', false)) {
            $channels[] = WhatsAppChannel::class;
        }
        
        return $channels;
    }

    /**
     * Get the mail representation of the notification.
     *
     * @param  mixed  $notifiable
     * @return \Illuminate\Notifications\Messages\MailMessage
     */
    public function toMail($notifiable)
    {
        $details = 'Business: '.$this->business->name.', Business Owner: '.$this->business->owner->user_full_name.', Email: '.$this->business->owner->email.
        ', Business contact number: '.$this->business->locations->first()->mobile;

        return (new MailMessage)
                ->subject('New Business Registration')
                ->greeting('Hello!')
                ->line('New business registered successfully')
                ->line($details);
    }

    /**
     * Get the array representation of the notification.
     *
     * @param  mixed  $notifiable
     * @return array
     */
    public function toArray($notifiable)
    {
        return [
            //
        ];
    }

    /**
     * Get the WhatsApp representation of the notification.
     *
     * @param  mixed  $notifiable
     * @return string
     */
    public function toWhatsApp($notifiable)
    {
        $mobileNumber = $this->business->locations->isNotEmpty() ? $this->business->locations->first()->mobile : 'N/A';
        
        $message = "🏢 *New Business Registration - Admin Alert*\n\n";
        $message .= "A new business has been registered.\n\n";
        $message .= "*Business Details:*\n";
        $message .= "• Name: {$this->business->name}\n";
        $message .= "• Owner: {$this->business->owner->user_full_name}\n";
        $message .= "• Email: {$this->business->owner->email}\n";
        $message .= "• Contact: {$mobileNumber}\n";
        $message .= "• Date: " . $this->business->created_at->format('M d, Y h:i A') . "\n\n";
        $message .= "_" . config('app.name') . " Admin Panel_";
        
        return $message;
    }
}
