<?php

namespace Modules\Superadmin\Notifications;

use Illuminate\Bus\Queueable;
use Illuminate\Notifications\Messages\MailMessage;
use Illuminate\Notifications\Notification;
use Modules\Superadmin\Notifications\Channels\WhatsAppChannel;

class NewBusinessWelcomNotification extends Notification
{
    use Queueable;

    protected $email_data;

    /**
     * Create a new notification instance.
     *
     * @return void
     */
    public function __construct($email_data)
    {
        $this->email_data = $email_data;
    }

    /**
     * Get the notification's delivery channels.
     *
     * @param  mixed  $notifiable
     * @return array
     */
    public function via($notifiable)
    {
        $channels = ['mail'];
        
        if (config('services.whatsapp.enabled', false)) {
            $channels[] = WhatsAppChannel::class;
        }
        
        return $channels;
    }

    /**
     * Get the mail representation of the notification.
     *
     * @param  mixed  $notifiable
     * @return \Illuminate\Notifications\Messages\MailMessage
     */
    public function toMail($notifiable)
    {
        $mail_data = $this->email_data;

        return (new MailMessage)
                    ->subject($mail_data['subject'])
                    ->view(
                        'emails.plain_html',
                        ['content' => $mail_data['body']]
                    );
    }

    /**
     * Get the array representation of the notification.
     *
     * @param  mixed  $notifiable
     * @return array
     */
    public function toArray($notifiable)
    {
        return [
            //
        ];
    }

    /**
     * Get the WhatsApp representation of the notification.
     *
     * @param  mixed  $notifiable
     * @return string
     */
    public function toWhatsApp($notifiable)
    {
        $message = "👋 *Welcome to " . config('app.name') . "!*\n\n";
        $message .= "Hello {$notifiable->user_full_name},\n\n";
        $message .= strip_tags($this->email_data['body']) . "\n\n";
        $message .= "We're here to help you succeed! 🎉\n\n";
        $message .= "_" . config('app.name') . " Team_";
        
        return $message;
    }
}
