<?php

namespace Modules\Superadmin\Notifications;

use Illuminate\Bus\Queueable;
use Illuminate\Notifications\Messages\MailMessage;
use Illuminate\Notifications\Notification;
use Modules\Superadmin\Notifications\Channels\WhatsAppChannel;

class NewSubscriptionNotification extends Notification
{
    use Queueable;

    protected $subscription;

    /**
     * Create a new notification instance.
     *
     * @return void
     */
    public function __construct($subscription)
    {
        $this->subscription = $subscription;
    }

    /**
     * Get the notification's delivery channels.
     *
     * @param  mixed  $notifiable
     * @return array
     */
    public function via($notifiable)
    {
        $channels = ['mail'];
        
        if (config('services.whatsapp.enabled', false)) {
            $channels[] = WhatsAppChannel::class;
        }
        
        return $channels;
    }

    /**
     * Get the mail representation of the notification.
     *
     * @param  mixed  $notifiable
     * @return \Illuminate\Notifications\Messages\MailMessage
     */
    public function toMail($notifiable)
    {
        $paid_via = ! empty($this->subscription->paid_via) ? $this->subscription->paid_via : 'Free';

        $details = 'Package: '.$this->subscription->package->name.', Transaction ID: '.$this->subscription->payment_transaction_id.', Paid Via: '.$paid_via;

        return (new MailMessage)
                ->subject('New Subscription')
                ->greeting('Hello!')
                ->line('New package has been subscribed by '.$this->subscription->business->name)
                ->line($details);
    }

    /**
     * Get the array representation of the notification.
     *
     * @param  mixed  $notifiable
     * @return array
     */
    public function toArray($notifiable)
    {
        return [
            //
        ];
    }

    /**
     * Get the WhatsApp representation of the notification.
     *
     * @param  mixed  $notifiable
     * @return string
     */
    public function toWhatsApp($notifiable)
    {
        $paidVia = !empty($this->subscription->paid_via) ? $this->subscription->paid_via : 'Free';
        
        $message = "💰 *New Subscription - Admin Alert*\n\n";
        $message .= "A new subscription has been created.\n\n";
        $message .= "*Subscription Details:*\n";
        $message .= "• Business: {$this->subscription->business->name}\n";
        $message .= "• Package: {$this->subscription->package->name}\n";
        $message .= "• Transaction ID: {$this->subscription->payment_transaction_id}\n";
        $message .= "• Paid Via: {$paidVia}\n";
        $message .= "• Date: " . $this->subscription->created_at->format('M d, Y h:i A') . "\n\n";
        $message .= "_" . config('app.name') . " Admin Panel_";
        
        return $message;
    }
}
